/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Brand;
import com.floreantpos.model.dao.BrandDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class BrandForm
extends BeanEditor<Brand> {
    private FixedLengthTextField a;

    public BrandForm() {
        this.a();
        this.setBean(new Brand());
    }

    public BrandForm(Brand brand) {
        this.a();
        this.setBean(brand);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("", "[][]20px[]", ""));
        this.setPreferredSize(new Dimension(500, 100));
        JLabel jLabel = new JLabel(Messages.getString("BrandForm.0"));
        this.a = new FixedLengthTextField(80);
        this.add((Component)jLabel, "left, center");
        this.add((Component)this.a, "growx");
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10 && BrandForm.this.save()) {
                    BrandForm.this.getEditorDialog().setCancel(false);
                    BrandForm.this.getEditorDialog().dispose();
                }
            }
        };
        this.a.addKeyListener(keyListener);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Brand brand = (Brand)this.getBean();
            BrandDAO.getInstance().saveOrUpdate(brand);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Brand brand = (Brand)this.getBean();
        if (brand != null) {
            this.a.setText(brand.getName());
        }
    }

    @Override
    protected boolean updateModel() {
        Brand brand = (Brand)this.getBean();
        if (brand == null) {
            return false;
        }
        String string = this.a.getText();
        GenericDAO.getInstance().checkIdOrNameExists(brand.getId(), string, Brand.class);
        brand.setName(string);
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("BrandForm.1");
    }
}

