/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.model.ComboItem;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ComboItemExplorerTableModel
extends AbstractTableModel {
    String[] a = new String[]{Messages.getString("ComboItemExplorer.9"), Messages.getString("ComboItemExplorer.10"), Messages.getString("ComboItemExplorer.11") + " (" + CurrencyUtil.getCurrencySymbol() + ")"};
    List<ComboItem> b = new ArrayList<ComboItem>();

    public void setItems(List<ComboItem> list) {
        if (list == null) {
            return;
        }
        this.b.addAll(list);
    }

    public List<ComboItem> getItems() {
        return this.b;
    }

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.b == null) {
            return "";
        }
        ComboItem comboItem = this.b.get(n);
        if (comboItem == null) {
            return "";
        }
        switch (n2) {
            case 0: {
                return comboItem.getName();
            }
            case 1: {
                return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
            }
            case 2: {
                return comboItem.getPrice() * comboItem.getQuantity();
            }
        }
        return null;
    }

    public void addComboItem(ComboItem comboItem) {
        int n = this.b.size();
        this.b.add(comboItem);
        this.fireTableRowsInserted(n, n);
    }

    public void deleteItem(ComboItem comboItem, int n) {
        Iterator<ComboItem> iterator = this.b.iterator();
        while (iterator.hasNext()) {
            ComboItem comboItem2 = iterator.next();
            if (comboItem.getMenuItem() != comboItem2.getMenuItem()) continue;
            iterator.remove();
        }
        this.fireTableRowsDeleted(n, n);
    }

    public ComboItem getComboItem(int n) {
        return this.b.get(n);
    }

    public void moveRow(int n, int n2) {
        if (n == n2) {
            return;
        }
        ComboItem comboItem = this.b.remove(n);
        this.b.add(n2, comboItem);
    }
}

