/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.ext.DiscountCondition;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXDatePicker;

public class CouponForm
extends BeanEditor<Discount>
implements RefreshableView,
ItemListener {
    private JPanel a;
    private JPanel b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private JComboBox e;
    private JComboBox f;
    private JComboBox g;
    private DoubleTextField h;
    private JCheckBox i;
    private JCheckBox j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JXDatePicker n;
    private JLabel o;
    private DoubleTextField p;
    private IntegerTextField q = new IntegerTextField();
    private JScrollPane r;
    private List<MenuItem> s = new ArrayList<MenuItem>();
    private JTextField t;
    private JPanel u;
    private BeanTableModel v;
    private JLabel w;
    private JTable x;
    private JButton y;

    public CouponForm() {
        this(new Discount());
    }

    public CouponForm(Discount discount) {
        this.a();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(Discount.COUPON_TYPE_NAMES);
        defaultComboBoxModel.removeElementAt(3);
        this.f.setModel(defaultComboBoxModel);
        this.f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                if (CouponForm.this.f.getSelectedItem() == Discount.COUPON_TYPE_NAMES[2]) {
                    CouponForm.this.e.setSelectedItem(Discount.COUPON_QUALIFICATION_NAMES[1]);
                    CouponForm.this.e.setEnabled(false);
                    CouponForm.this.p.setEnabled(false);
                    CouponForm.this.q.setEnabled(false);
                } else {
                    CouponForm.this.e.setEnabled(true);
                    CouponForm.this.p.setEnabled(true);
                    CouponForm.this.q.setEnabled(true);
                }
                boolean bl2 = bl = CouponForm.this.f.getSelectedItem() == Discount.COUPON_TYPE_NAMES[3];
                if (bl) {
                    CouponForm.this.e.setSelectedItem(Discount.COUPON_QUALIFICATION_NAMES[1]);
                    CouponForm.this.e.setEnabled(false);
                }
                CouponForm.this.a(!bl);
            }
        });
        this.e.setModel(new DefaultComboBoxModel<String>(Discount.COUPON_QUALIFICATION_NAMES));
        this.e.addItemListener(this);
        this.f.addItemListener(this);
        this.g.addItem(null);
        for (DiscountCondition discountCondition : DiscountCondition.values()) {
            this.g.addItem(discountCondition);
        }
        this.g.addItemListener(itemEvent -> {
            this.e.setEnabled(this.g.getSelectedItem() == null);
            if (this.g.getSelectedItem() != null) {
                this.e.setSelectedIndex(1);
            }
        });
        this.setBean(discount);
    }

    private void a(boolean bl) {
        this.w.setVisible(bl);
        this.h.setVisible(bl);
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.a = new JPanel();
        this.a.setLayout((LayoutManager)new MigLayout("hidemode 3"));
        JLabel jLabel = new JLabel(Messages.getString("CouponForm.0") + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("ExpirationDate") + ":");
        JLabel jLabel3 = new JLabel(Messages.getString("CouponForm.11") + ":");
        this.w = new JLabel(Messages.getString("CouponForm.13") + ":");
        JLabel jLabel4 = new JLabel(Messages.getString("CouponForm.12"));
        JLabel jLabel5 = new JLabel(Messages.getString("CouponForm.7"));
        this.o = new JLabel(Messages.getString("CouponForm.5"));
        this.c = new FixedLengthTextField(25, 120);
        this.d = new FixedLengthTextField(20, 120);
        this.f = new JComboBox();
        this.e = new JComboBox();
        this.g = new JComboBox();
        this.n = UiUtil.getDeafultDate();
        Calendar calendar = this.n.getMonthView().getCalendar();
        calendar.setTime(new Date());
        this.n.getMonthView().setLowerBound(calendar.getTime());
        this.h = new DoubleTextField();
        this.p = new DoubleTextField();
        this.i = new JCheckBox(POSConstants.ENABLED);
        this.j = new JCheckBox("Modifiable Amount");
        this.k = new JCheckBox(Messages.getString("CouponForm.6"));
        this.l = new JCheckBox(Messages.getString("CouponForm.16"));
        this.m = new JCheckBox("<html>" + Messages.getString("CouponForm.24") + "</html>");
        this.m.setVisible(Boolean.FALSE);
        this.l.addItemListener(itemEvent -> {
            if (this.l.isSelected()) {
                jLabel2.setEnabled(false);
                this.n.setEnabled(false);
            } else {
                jLabel2.setEnabled(true);
                this.n.setEnabled(true);
            }
        });
        this.a.add(jLabel);
        this.a.add((Component)this.c, "wrap");
        this.a.add(jLabel2);
        this.a.add((Component)this.n, "wrap");
        this.a.add(jLabel4);
        this.a.add((Component)this.d, "wrap");
        this.a.add(jLabel5);
        this.a.add((Component)this.e, "wrap");
        this.a.add(new JLabel(Messages.getString("DiscountCondition")));
        this.a.add((Component)this.g, "wrap");
        this.a.add(this.o);
        this.a.add((Component)this.p, "wrap");
        this.a.add(new JLabel("Maximum Unit:"));
        this.a.add((Component)this.q, "wrap");
        this.a.add(jLabel3);
        this.a.add((Component)this.f, "wrap");
        this.a.add(this.w);
        this.a.add((Component)this.h, "wrap");
        this.a.add((Component)this.i, "skip 1,wrap");
        this.a.add((Component)this.k, "skip 1,wrap");
        this.a.add((Component)this.l, "skip 1,wrap");
        this.a.add((Component)this.j, "skip 1,wrap");
        this.a.add((Component)this.m, "skip 1,wrap");
        this.b();
        this.b = new JPanel(new BorderLayout(10, 10));
        this.b.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Apply to items"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.t = new FixedLengthTextField(255);
        this.t.addActionListener(actionEvent -> this.e());
        this.y = new JButton(Messages.getString("Search"));
        this.y.addActionListener(actionEvent -> this.e());
        this.x = new JTable();
        this.x.setRowHeight(PosUIManager.getSize((int)30));
        this.v = new BeanTableModel(MenuItem.class, 2);
        this.v.addColumn(Messages.getString("CouponForm.17"), MenuItem.PROP_NAME);
        this.v.addColumn(Messages.getString("CouponForm.18"), MenuItem.PROP_PRICE);
        this.x.setModel(this.v);
        this.r = new JScrollPane(this.x);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)new JLabel(Messages.getString("CouponForm.19")), "West");
        jPanel.add(this.t);
        jPanel.add((Component)this.y, "East");
        this.b.add((Component)jPanel, "North");
        this.b.add(this.r);
        this.b.add((Component)this.u, "South");
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setBorder(null);
        this.add((Component)jScrollPane, "West");
        this.add((Component)this.b, "Center");
        this.setPreferredSize(new Dimension(700, 350));
    }

    private void b() {
        this.u = new JPanel();
        this.u.setLayout((LayoutManager)new MigLayout("ins 0, center"));
        JButton jButton = new JButton(Messages.getString("CouponForm.21"));
        jButton.addActionListener(actionEvent -> this.f());
        this.u.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("CouponForm.22"));
        jButton2.addActionListener(actionEvent -> this.g());
        this.u.add(jButton2);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == Discount.COUPON_QUALIFICATION_NAMES[0]) {
            this.o.setText(Messages.getString("CouponForm.5"));
            this.b.setVisible(true);
            this.k.setEnabled(true);
        } else if (itemEvent.getItem() == Discount.COUPON_QUALIFICATION_NAMES[1]) {
            this.o.setText(Messages.getString("CouponForm.14") + CurrencyUtil.getCurrencySymbolWithBracket() + " :");
            this.b.setVisible(false);
            this.k.setSelected(false);
            this.k.setEnabled(false);
        } else if (itemEvent.getItem() == Discount.COUPON_TYPE_NAMES[0]) {
            this.j.setVisible(true);
        } else if (itemEvent.getItem() == Discount.COUPON_TYPE_NAMES[1] || itemEvent.getItem() == Discount.COUPON_TYPE_NAMES[3]) {
            this.j.setSelected(false);
            this.j.setVisible(false);
        } else {
            this.b.setVisible(false);
        }
        this.c();
    }

    private void c() {
        if (this.e.getSelectedIndex() == 0 && this.f.getSelectedIndex() == 1) {
            this.m.setVisible(true);
        } else {
            this.m.setSelected(false);
            this.m.setVisible(false);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Discount discount = (Discount)this.getBean();
            DiscountDAO.getInstance().saveOrUpdate(discount);
            OroMqttClient.getInstance().sendUpdateNotification();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
        return false;
    }

    @Override
    protected void updateView() {
        Discount discount = (Discount)this.getBean();
        if (discount.getId() == null) {
            this.i.setSelected(true);
            this.p.setText("0");
            this.q.setText("0");
            this.f.setSelectedIndex(1);
            return;
        }
        this.c.setText(discount.getName());
        this.p.setText(discount.getMinimumBuy().toString());
        this.q.setText(NumberUtil.formatNumberIfNeeded(discount.getMaximumOff()));
        this.h.setText(String.valueOf(discount.getValue()));
        this.f.setSelectedIndex(discount.getType());
        this.e.setSelectedIndex(discount.getQualificationType());
        this.g.setSelectedItem((Object)discount.getDiscountCondition());
        this.n.setDate(discount.getExpiryDate());
        this.d.setText(discount.getBarcode());
        this.i.setSelected(discount.isEnabled());
        this.j.setSelected(discount.isModifiable());
        this.k.setSelected(discount.isAutoApply());
        this.l.setSelected(discount.isNeverExpire());
        this.m.setSelected(discount.isApplyIfDivisible());
        if (this.l.isSelected()) {
            this.n.setEnabled(false);
        }
        if (discount.getQualificationType() == 0) {
            List<MenuItem> list = discount.getMenuItems();
            if (discount.getMenuItems() != null) {
                list.sort(Comparator.comparing(BaseMenuItem::getName));
                this.v.setRows(list);
                this.s.addAll(this.v.getRows());
            }
        }
        if (discount.getQualificationType() == 1) {
            this.k.setEnabled(false);
        }
    }

    @Override
    protected boolean updateModel() {
        String string = this.c.getText();
        String string2 = this.d.getText();
        double d = 0.0;
        d = this.h.getDoubleOrZero();
        double d2 = this.p.getDoubleOrZero();
        int n = this.q.getInteger();
        int n2 = this.f.getSelectedIndex();
        Date date = this.n.getDate();
        date = DateUtil.endOfDay(date);
        boolean bl = this.i.isSelected();
        boolean bl2 = this.j.isSelected();
        boolean bl3 = this.k.isSelected();
        boolean bl4 = this.l.isSelected();
        boolean bl5 = this.m.isSelected();
        int n3 = this.e.getSelectedIndex();
        if (string == null || string.trim().equals("")) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.1"));
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(((Discount)this.bean).getId(), string, Discount.class);
        if (StringUtils.isNotBlank((String)string2)) {
            try {
                GenericDAO.getInstance().checkDifferentObjectExists(((Discount)this.bean).getId(), string2, Discount.class, Discount.PROP_BARCODE);
            }
            catch (PosException posException) {
                throw new PosException(Messages.getString("CouponForm.9") + " " + string2 + " " + Messages.getString("GenericDAO.22"));
            }
        }
        if (d <= 0.0 && n2 != 3) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.2"));
            this.h.requestFocus();
            return false;
        }
        if (n2 == 1 && d > 100.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.15"));
            this.h.requestFocus();
            return false;
        }
        if (d2 < 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
            this.p.requestFocus();
            return false;
        }
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
            this.q.requestFocus();
            return false;
        }
        if (n2 == 1 && d > 9999.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.8"));
            return false;
        }
        if (n3 == 0 && this.d()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.10"));
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.containsWhitespace((CharSequence)string2)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("CouponForm.20"));
            return false;
        }
        Discount discount = (Discount)this.getBean();
        discount.setName(string);
        discount.setMinimumBuy(d2);
        discount.setMaximumOff(Double.valueOf(n));
        discount.setValue(d);
        discount.setExpiryDate(date);
        discount.setBarcode(string2);
        discount.setType(n2);
        discount.setQualificationType(n3);
        discount.setDiscountCondition((DiscountCondition)((Object)this.g.getSelectedItem()));
        discount.setEnabled(bl);
        discount.setModifiable(bl2);
        discount.setAutoApply(bl3);
        discount.setNeverExpire(bl4);
        discount.setApplyIfDivisible(bl5);
        if (n3 == 0) {
            this.t.setText("");
            this.e();
            if (this.v.getRows() != null && this.v.getRows().size() > 0) {
                discount.setMenuItems(this.v.getRows());
                discount.setApplyToAll(false);
            } else {
                discount.setMenuItems(null);
                discount.setApplyToAll(true);
            }
        }
        return true;
    }

    private boolean d() {
        double d;
        List list = this.v.getRows();
        double d2 = this.h.getDoubleOrZero();
        if (this.f.getSelectedIndex() == 1) {
            d2 /= 100.0;
        }
        if ((d = this.p.getDouble()) > 0.0) {
            for (MenuItem menuItem : list) {
                if (!(d2 > menuItem.getPrice() * d)) continue;
                return true;
            }
        } else {
            for (MenuItem menuItem : list) {
                if (!(d2 > menuItem.getPrice())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDisplayText() {
        Discount discount = (Discount)this.getBean();
        if (discount.getId() == null) {
            return Messages.getString("CouponForm.3");
        }
        return Messages.getString("CouponForm.4");
    }

    private void e() {
        try {
            String string = this.t.getText();
            if (StringUtils.isEmpty((String)string)) {
                this.v.setRows(this.s);
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (MenuItem menuItem : this.s) {
                String string2 = menuItem.getName();
                if (!string2.contains(string) && !string2.toLowerCase().contains(string) && !string2.toLowerCase().contains(string.toLowerCase())) continue;
                arrayList.add(menuItem);
            }
            this.v.setRows(arrayList);
            this.v.fireTableDataChanged();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void f() {
        try {
            this.t.setText("");
            this.e();
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(this.v.getRows());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setSize(PosUIManager.getSize((int)750, (int)515));
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            this.v.setRows(list);
            this.s.clear();
            this.s.addAll(list);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void g() {
        int n = this.x.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.23"));
            return;
        }
        MenuItem menuItem = (MenuItem)this.v.getRow(this.x.convertRowIndexToModel(n));
        String string = menuItem.getId();
        this.v.removeRow(n);
        Iterator<MenuItem> iterator = this.s.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem2 = iterator.next();
            if (!menuItem2.getId().equals(string)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void refresh() {
        Discount discount = (Discount)this.getBean();
        Discount discount2 = DiscountDAO.getInstance().get(discount.getId());
        this.setBean(discount2);
    }
}

