/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CourseForm
extends BeanEditor<Course> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private IntegerTextField c;
    private JLabel d;
    private ImageResource e;
    private List<Course> f;

    public CourseForm() {
        this(new Course());
    }

    public CourseForm(Course course) {
        this.a();
        this.setBean(course);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[134px][204px,grow]", ""));
        this.c = new IntegerTextField();
        this.a = new FixedLengthTextField();
        this.a.setLength(120);
        this.b = new FixedLengthTextField();
        this.b.setLength(3);
        this.d = new JLabel("");
        this.d.setText(Messages.getString("CourseForm.0"));
        this.d.setForeground(Color.gray);
        this.add((Component)new JLabel(Messages.getString("NAME")), "alignx trailing,aligny center");
        this.add((Component)this.a, "growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("CourseForm.2")), "alignx trailing,aligny center");
        this.add((Component)this.b, "growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("CourseForm.3")), "alignx trailing,aligny center");
        this.add((Component)this.c, "w 100!,aligny center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", "", ""));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center"));
        this.d.setHorizontalAlignment(0);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 2, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jPanel2.setPreferredSize(new Dimension(70, 50));
        jPanel2.add((Component)this.d, "w 24!,h 24!,aligny center");
        this.add((Component)jPanel, "skip 1");
    }

    @Override
    public String getDisplayText() {
        if (((Course)this.getBean()).getId() == null) {
            return Messages.getString("CourseForm.4");
        }
        return Messages.getString("CourseForm.5");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Course course = (Course)this.getBean();
            CourseDAO courseDAO = CourseDAO.getInstance();
            courseDAO.saveOrUpdate(course);
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("MessageDialog.0"), exception);
            PosLog.error(this.getClass(), exception);
        }
        return false;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Course course = (Course)this.getBean();
        if (course == null) {
            return false;
        }
        String string = this.a.getText().trim();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.9"));
            this.a.requestFocus();
            return false;
        }
        String string2 = this.b.getText().trim();
        if (StringUtils.isBlank((String)string2)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.10"));
            this.b.requestFocus();
            return false;
        }
        int n = this.c.getInteger();
        if (n <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.11"));
            this.c.requestFocus();
            return false;
        }
        if (this.f != null) {
            for (Course course2 : this.f) {
                if (course2.getSortOrder() != n) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseForm.12"));
                return false;
            }
        }
        GenericDAO.getInstance().checkIdOrNameExists(course.getId(), string, Course.class);
        try {
            GenericDAO.getInstance().checkDifferentObjectExists(course.getId(), string2, Course.class, Course.PROP_SHORT_NAME);
        }
        catch (PosException posException) {
            throw new PosException(Messages.getString("ShortName") + " " + string2 + " " + Messages.getString("GenericDAO.22"));
        }
        course.setName(string);
        course.setShortName(string2);
        course.setSortOrder(n);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof Course)) {
            return;
        }
        Course course = (Course)this.getBean();
        this.a(course);
    }

    private void a(Course course) {
        this.c.setText(String.valueOf(course.getSortOrder()));
        this.a.setText(course.getName());
        this.b.setText(course.getShortName());
        this.e = ImageResourceDAO.getInstance().findById(course.getIconId());
        if (this.e != null) {
            this.d.setIcon(this.e.getScaledImage(16, 16));
            this.d.setText("");
        } else {
            this.d.setText(Messages.getString("CourseForm.14"));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle(VersionInfo.getAppName());
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.openFullScreen();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.e = imageGalleryDialog.getImageResource();
        if (this.e != null) {
            this.d.setIcon(this.e.getScaledImage(16, 16));
            this.d.setText("");
        } else {
            this.d.setText(Messages.getString("CourseForm.17"));
        }
    }

    protected void doClearImage() {
        this.d.setIcon(null);
        this.e = null;
    }

    public List<Course> getExistingCourses() {
        return this.f;
    }

    public void setExistingCourses(List<Course> list) {
        this.f = new ArrayList<Course>();
        Course course = (Course)this.getBean();
        int n = 1;
        for (Course course2 : list) {
            if (course.getId() != null && course2.getId().equals(course.getId())) continue;
            if (course2.getSortOrder() > n) {
                n = course2.getSortOrder();
            }
            this.f.add(course2);
        }
        if (this.c.getInteger() == 0) {
            this.c.setText(String.valueOf(n + 1));
        }
    }
}

