/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.StaleStateException;

public class MenuGroupForm
extends BeanEditor
implements RefreshableView {
    private JButton a;
    private JComboBox b;
    private JCheckBox c;
    private JLabel d;
    private JLabel e;
    private FixedLengthTextField f;
    private JLabel g;
    private FixedLengthTextField h;
    private JLabel i;
    private JLabel j;
    private IntegerTextField k;
    private JButton l;
    private JLabel m;
    private JButton n;

    public MenuGroupForm() {
        this(new MenuGroup());
    }

    public MenuGroupForm(MenuGroup menuGroup) {
        this.a();
        this.setBean(menuGroup);
    }

    public MenuGroupForm(MenuGroup menuGroup, Object object) {
        this.a();
        this.b.setEditable(true);
        this.setBean(menuGroup);
        this.b.setSelectedItem(object);
        this.b.setEnabled(false);
        this.a.setVisible(false);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("", "[70px][289px,grow][6px][49px]", "[19px][][25px][][][][15px]"));
        this.setPreferredSize(new Dimension(600, 250));
        this.d = new JLabel();
        this.f = new FixedLengthTextField(120);
        this.e = new JLabel();
        this.b = new JComboBox();
        this.c = new JCheckBox();
        this.a = new JButton();
        this.d.setText(POSConstants.NAME + ":");
        this.e.setText(POSConstants.CATEGORY + ":");
        this.c.setText(POSConstants.VISIBLE);
        this.c.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.c.setMargin(new Insets(0, 0, 0, 0));
        this.c.setSelected(true);
        this.a.setText("...");
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupForm.this.a(actionEvent);
            }
        });
        this.g = new JLabel(Messages.getString("MenuGroupForm.6"));
        this.add((Component)this.g, "cell 0 1,alignx trailing");
        this.h = new FixedLengthTextField(120);
        this.add((Component)this.h, "cell 1 1,growx");
        this.add((Component)this.e, "cell 0 2,alignx left,aligny center");
        this.add((Component)this.d, "cell 0 0,alignx left,aligny center");
        this.add((Component)this.f, "cell 1 0,growx");
        this.i = new JLabel(Messages.getString("MenuGroupForm.12"));
        this.k = new IntegerTextField();
        this.k.setColumns(10);
        this.j = new JLabel(Messages.getString("MenuGroupForm.15"));
        this.add((Component)this.j, "cell 0 4");
        this.l = new JButton(Messages.getString("MenuGroupForm.15"));
        this.add((Component)this.l, "cell 1 4,grow");
        this.m = new JLabel(Messages.getString("MenuGroupForm.19"));
        this.add((Component)this.m, "cell 0 5");
        this.n = new JButton(Messages.getString("MenuGroupForm.19"));
        this.add((Component)this.n, "cell 1 5, grow");
        this.add((Component)this.c, "cell 1 6,alignx left,aligny top");
        this.add((Component)this.b, String.format("width %s!,cell 1 2,growx,aligny top", PosUIManager.getSize((int)200)));
        this.add((Component)this.a, "cell 1 2,alignx left,aligny top");
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuGroupForm.26"), MenuGroupForm.this.l.getBackground());
                if (color != null) {
                    MenuGroupForm.this.l.setBackground(color);
                    MenuGroupForm.this.n.setBackground(color);
                }
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuGroupForm.27"), MenuGroupForm.this.n.getForeground());
                if (color != null) {
                    MenuGroupForm.this.n.setForeground(color);
                }
            }
        });
        MenuCategoryDAO menuCategoryDAO = new MenuCategoryDAO();
        List<MenuCategory> list = menuCategoryDAO.findAll();
        this.b.setModel(new ComboBoxModel(list));
    }

    private void a(ActionEvent actionEvent) {
        try {
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.openWithScale(800, 600);
            if (!beanEditorDialog.isCanceled()) {
                MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
                ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
                comboBoxModel.addElement(menuCategory);
                comboBoxModel.setSelectedItem(menuCategory);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    @Override
    public boolean save() {
        if (!this.updateModel()) {
            return false;
        }
        MenuGroup menuGroup = (MenuGroup)this.getBean();
        try {
            MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
            menuGroupDAO.saveOrUpdate(menuGroup);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuGroup menuGroup = (MenuGroup)this.getBean();
        if (menuGroup == null || StringUtils.isBlank((CharSequence)menuGroup.getId())) {
            this.f.setText("");
            this.b.setSelectedItem(null);
            return;
        }
        this.f.setText(menuGroup.getName());
        this.h.setText(menuGroup.getTranslatedName());
        if (menuGroup.getSortOrder() != null) {
            this.k.setText(menuGroup.getSortOrder().toString());
        }
        if ((color = menuGroup.getButtonColor()) != null) {
            this.l.setBackground(color);
            this.n.setBackground(color);
        }
        if (menuGroup.getTextColor() != null) {
            this.n.setForeground(menuGroup.getTextColor());
        }
        this.c.setSelected(menuGroup.isVisible());
        for (int i = 0; i < this.b.getItemCount(); ++i) {
            MenuCategory menuCategory;
            Object e = this.b.getItemAt(i);
            if (!(e instanceof MenuCategory) || (menuCategory = (MenuCategory)e) == null || menuCategory.getId() == null || !menuCategory.getId().equals(menuGroup.getMenuCategoryId())) continue;
            this.b.setSelectedIndex(i);
            break;
        }
        if (Objects.equals("default_group", menuGroup.getId())) {
            this.b.setEnabled(false);
            this.a.setEnabled(false);
        }
    }

    @Override
    protected boolean updateModel() {
        Object object;
        MenuGroup menuGroup;
        block6: {
            menuGroup = (MenuGroup)this.getBean();
            if (menuGroup == null) {
                return false;
            }
            String string = this.f.getText();
            if (POSUtil.isBlankOrNull(string)) {
                MessageDialog.showError(Messages.getString("MenuGroupForm.29"));
                return false;
            }
            try {
                GenericDAO.getInstance().checkIdOrNameExists(menuGroup.getId(), string, MenuGroup.class);
            }
            catch (DuplicateDataException duplicateDataException) {
                object = String.format(Messages.getString("SAME_NAME_WARRING"), Messages.getString("DataImportAction.8"));
                String string2 = Messages.getString("WARNING");
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), (String)object, string2, Messages.getString("YES"), Messages.getString("NO"));
                if (n == 0) break block6;
                return false;
            }
        }
        Object object2 = this.b.getSelectedItem();
        if (object2 == null) {
            MessageDialog.showError(Messages.getString("MenuGroupForm.30"));
            return false;
        }
        if (object2 instanceof MenuCategory && (object = (MenuCategory)object2) != null) {
            menuGroup.setMenuCategory((MenuCategory)object);
        }
        menuGroup.setName(this.f.getText());
        menuGroup.setTranslatedName(this.h.getText());
        menuGroup.setButtonColor(this.l.getBackground());
        menuGroup.setTextColor(this.n.getForeground());
        menuGroup.setButtonColorCode(this.l.getBackground().getRGB());
        menuGroup.setTextColorCode(this.n.getForeground().getRGB());
        menuGroup.setVisible(this.c.isSelected());
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuGroup menuGroup = (MenuGroup)this.getBean();
        if (menuGroup.getId() == null) {
            return Messages.getString("MenuGroupForm.31");
        }
        return Messages.getString("MenuGroupForm.32");
    }

    @Override
    public void refresh() {
        MenuGroup menuGroup = (MenuGroup)this.getBean();
        MenuGroup menuGroup2 = MenuGroupDAO.getInstance().get(menuGroup.getId());
        this.setBean(menuGroup2);
    }
}

