/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.MenuSearchCriteria;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.MenuSearcher;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class MenuItemSelectionView
extends JPanel {
    private JComboBox a;
    private PosTable b;
    private MenuItemTableModel c;
    private POSTextField d;
    private MenuItem e;
    private JButton f;
    private JButton g;
    private MenuGroup h;
    private JLabel i = new JLabel();
    private JLabel j;
    private JButton k;
    private Map<String, MenuItem> l = new HashMap<String, MenuItem>();
    private JCheckBox m;
    private JCheckBox n;
    private JLabel o;
    private boolean p;
    private boolean q = true;
    private boolean r = true;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private MenuItemSelectionDialog s;
    private boolean t = true;
    private boolean u = true;
    private MenuSearcher v;
    private JPanel w;
    private OverflowCombobox x;

    public MenuItemSelectionView(List<MenuItem> list, boolean bl) {
        this(list, bl, null);
    }

    public MenuItemSelectionView(List<MenuItem> list, boolean bl, MenuItemSelectionDialog menuItemSelectionDialog) {
        this(list, bl, menuItemSelectionDialog, null);
    }

    public MenuItemSelectionView(List<MenuItem> list, boolean bl, MenuItemSelectionDialog menuItemSelectionDialog, MenuSearcher menuSearcher) {
        this.p = bl;
        this.s = menuItemSelectionDialog;
        this.v = menuSearcher;
        this.a();
        this.c.setCurrentRowIndex(0);
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuItemSelectionView.this.c.setCurrentRowIndex(0);
                MenuItemSelectionView.this.setSelectedMenuGroup(MenuItemSelectionView.this.a.getSelectedItem());
            }
        });
        this.setSelectedItems(list);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new MenuItemTableModel();
        this.c.setColumnNames(new String[]{"-", Messages.getString("MenuItemSelectionView.1")});
        this.c.setPageSize(50);
        this.c.setCurrentRowIndex(0);
        this.b = new PosTable();
        this.b.setModel(this.c);
        this.b.setRowHeight(PosUIManager.getSize((int)40));
        this.b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemSelectionView.this.j();
                } else {
                    MenuItemSelectionView.this.m();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.b));
        jScrollPane.setPreferredSize(PosUIManager.getSize((int)500, (int)250));
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.c(), "North");
        this.add(jPanel);
        this.resizeColumnWidth((JTable)((Object)this.b));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        jPanel2.add((Component)this.g(), "left,split 2");
        this.m = new JCheckBox(Messages.getString("MenuItemSelectionView.7"));
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.b();
            }
        });
        jPanel2.add(this.m);
        jPanel2.add((Component)this.i, "split 3,center");
        this.g = new JButton(Messages.getString("MenuItemSelectionView.8"));
        jPanel2.add((Component)this.g, "center");
        PosButton posButton = new PosButton();
        posButton.setBorder(null);
        posButton.setOpaque(false);
        posButton.setContentAreaFilled(false);
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.f = new JButton(Messages.getString("MenuItemSelectionView.11"));
        jPanel2.add(this.f);
        jPanel2.add((Component)new JSeparator(), "newline,span,grow");
        jPanel.add((Component)jPanel2, "South");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object == MenuItemSelectionView.this.g) {
                        MenuItemSelectionView.this.l();
                    } else if (object == MenuItemSelectionView.this.f) {
                        MenuItemSelectionView.this.k();
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.g.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        this.f.setEnabled(false);
        this.g.setEnabled(false);
    }

    private void b() {
        if (this.m.isSelected()) {
            this.c.setRows(new ArrayList<MenuItem>(this.l.values()));
            this.m.setText(Messages.getString("MenuItemSelectionView.13") + "(" + this.l.values().size() + ")");
            this.i.setText("");
            this.g.setEnabled(false);
            this.f.setEnabled(false);
            this.a.setEnabled(false);
            this.b.repaint();
        } else {
            if (this.a.getSelectedItem() != null) {
                this.searchItem();
            }
            this.a.setEnabled(true);
        }
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        this.j = new JLabel(POSConstants.NAME + "/" + Messages.getString("MenuItemSelectionView.16"));
        this.d = new POSTextField(15);
        this.k = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.w = new JPanel((LayoutManager)new MigLayout("inset 0 0 5 0,fillx,hidemode 3"));
        this.w.add((Component)this.j, "align label,split 3");
        this.w.add((Component)this.d, "growx");
        this.w.add((Component)this.k, "wrap");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.w, "North");
        this.n = new JCheckBox(Messages.getString("MenuItemSelectionView.18"));
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.e();
            }
        });
        this.a = new OverflowCombobox();
        this.updateGroupList();
        this.a.setSelectedItem(Messages.getString("MenuItemSelectionView.19"));
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        JLabel jLabel = new JLabel(Messages.getString("MenuItemSelectionView.4"));
        Object[] objectArray = new String[]{Messages.getString("MenuItemSelectionView.5"), Messages.getString("MenuItemSelectionView.6"), Messages.getString("MenuItemSelectionView.9"), Messages.getString("MenuItemSelectionView.10"), Messages.getString("MenuItemSelectionView.12")};
        this.x = new OverflowCombobox(objectArray);
        String string = DataProvider.get().getStore().getMenuItemSelectorPageSize();
        this.x.setSelectedItem(string);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("inset 0 0 5 0,fillx,hidemode 3"));
        jPanel2.add((Component)this.n, "left");
        this.o = new JLabel(Messages.getString("MenuItemSelectionView.21"));
        jPanel2.add((Component)this.o, "split 4,right");
        jPanel2.add((Component)this.a, String.format("width %s!", PosUIManager.getSize((int)150)));
        jPanel2.add(jLabel);
        jPanel2.add(this.x);
        jPanel.add((Component)jPanel2, "South");
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.x.addActionListener(actionEvent -> this.d());
        return jPanel;
    }

    private void d() {
        Store store = DataProvider.get().getStore();
        String string = (String)this.x.getSelectedItem();
        store.putMenuItemSelectorPageSize(string);
        StoreDAO.getInstance().saveOrUpdate(store);
        DataProvider.get().refreshStore();
        this.searchItem();
    }

    public void updateGroupList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Messages.getString("MenuItemSelectionView.19"));
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        arrayList.addAll(list);
        ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList);
        this.a.setModel(comboBoxModel);
    }

    public void searchItem() {
        this.searchItem(null);
    }

    public void searchItem(String string) {
        try {
            this.h = this.a.getSelectedItem() instanceof MenuGroup ? (MenuGroup)this.a.getSelectedItem() : null;
            string = StringUtils.isEmpty((String)string) ? this.d.getText() : string;
            this.d.setText(string);
            String string2 = DataProvider.get().getStore().getMenuItemSelectorPageSize();
            if (string2.equalsIgnoreCase("All")) {
                this.c.setPageSize(this.c.getNumRows());
            } else {
                int n = Integer.valueOf(string2);
                this.c.setPageSize(n);
            }
            if (this.v != null) {
                MenuSearchCriteria menuSearchCriteria = new MenuSearchCriteria(string, this.q, this.hidePizzaItem() ? Boolean.valueOf(false) : null, this.t, this.u);
                this.v.search(this.c, menuSearchCriteria);
            } else {
                MenuSearchCriteria menuSearchCriteria = new MenuSearchCriteria(this.isInventoryItemOnly(), this.h, string, this.q, this.hidePizzaItem() ? Boolean.valueOf(false) : null, false, this.t, this.u, this.s != null ? this.s.getCurrentMenuItem() : null);
                MenuItemDAO.getInstance().findByBarcodeOrName(this.c, menuSearchCriteria);
            }
            this.f();
            this.c.fireTableDataChanged();
            this.b.repaint();
            this.m.setSelected(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() {
        try {
            List list = this.c.getRows();
            if (list == null) {
                return;
            }
            for (MenuItem menuItem : list) {
                if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuItem.getId())) continue;
                if (this.n.isSelected()) {
                    if (!this.l.containsKey(menuItem.getId())) {
                        this.l.put(menuItem.getId(), menuItem);
                    }
                } else {
                    this.l.remove(menuItem.getId());
                }
                this.m.setText(Messages.getString("MenuItemSelectionView.25") + "(" + this.l.values().size() + ")");
                this.b.repaint();
            }
            this.b.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void f() {
        int n;
        int n2 = this.c.getCurrentRowIndex() + 1;
        int n3 = this.c.getNextRowIndex();
        if (n3 > (n = this.c.getNumRows())) {
            n3 = n;
        }
        this.i.setText(String.format(Messages.getString("MenuItemSelectionView.27"), n2, n3, n));
        this.g.setEnabled(this.c.hasPrevious());
        this.f.setEnabled(this.c.hasNext());
        if (this.c.getRowCount() > 0) {
            this.b.setRowSelectionInterval(0, 0);
        }
        this.n.setSelected(false);
        this.m.setText(Messages.getString("MenuItemSelectionView.28") + "(" + this.l.values().size() + ")");
    }

    private TransparentPanel g() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        jButton2.setText(POSConstants.ADD);
        jButton.setText(POSConstants.EDIT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.i();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.n();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.h().get(i));
        }
    }

    private List h() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(70);
        arrayList.add(500);
        arrayList.add(70);
        return arrayList;
    }

    private void i() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuItem menuItem = (MenuItem)this.c.getRowData(n);
            MenuItemDAO.getInstance().initialize(menuItem);
            BeanEditor beanEditor = null;
            beanEditor = menuItem.isPizzaType() != false ? new PizzaItemForm(menuItem) : new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), beanEditor);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void j() {
        try {
            if (this.s != null) {
                if (this.b.getSelectedRow() < 0) {
                    return;
                }
                this.s.setCanceled(false);
                this.s.dispose();
            }
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    public List<MenuItem> getSelectedMenuItemList() {
        int n = this.b.getSelectionModel().getSelectionMode();
        if (n == 0) {
            int n2 = this.b.getSelectedRow();
            if (n2 < 0) {
                return null;
            }
            MenuItem menuItem = (MenuItem)this.c.getRowData(n2 = this.b.convertRowIndexToModel(n2));
            return menuItem == null ? null : Arrays.asList(menuItem);
        }
        return new ArrayList<MenuItem>(this.l.values());
    }

    public void setSelectedItems(List<MenuItem> list) {
        if (list != null) {
            for (MenuItem menuItem : list) {
                this.l.put(menuItem.getId(), menuItem);
            }
        }
    }

    public void addCreatedMenuItem(MenuItem menuItem) {
        int n = this.b.getSelectionModel().getSelectionMode();
        if (n == 0) {
            List<MenuItem> list = this.c.getRows();
            list.add(0, menuItem);
            this.c.setRows(list);
            this.b.setRowSelectionInterval(0, 0);
        } else {
            if (menuItem.isHasVariant().booleanValue()) {
                List<MenuItem> list = menuItem.getVariants();
                for (MenuItem menuItem2 : list) {
                    this.l.put(menuItem2.getId(), menuItem2);
                }
            } else {
                this.l.put(menuItem.getId(), menuItem);
            }
            this.m.setSelected(true);
            this.b();
        }
    }

    public void setParentMenuItem(MenuItem menuItem, boolean bl) {
        this.e = menuItem;
        if (bl) {
            this.m.setSelected(true);
            this.b();
        } else {
            this.searchItem();
        }
    }

    private void k() {
        this.c.setCurrentRowIndex(this.c.getNextRowIndex());
        this.searchItem();
    }

    private void l() {
        this.c.setCurrentRowIndex(this.c.getPreviousRowIndex());
        this.searchItem();
    }

    public void setSelectedMenuGroup(Object object) {
        this.h = object instanceof MenuGroup ? (MenuGroup)object : null;
        this.searchItem();
    }

    private void m() {
        int n = this.b.getSelectionModel().getSelectionMode();
        if (n == 0) {
            return;
        }
        if (this.b.getSelectedRow() < 0) {
            return;
        }
        int n2 = this.b.getSelectedRow();
        n2 = this.b.convertRowIndexToModel(n2);
        MenuItem menuItem = (MenuItem)this.c.getRowData(n2);
        if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuItem.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemSelectionView.33"));
            return;
        }
        if (this.l.containsKey(menuItem.getId())) {
            this.l.remove(menuItem.getId());
        } else {
            this.l.put(menuItem.getId(), menuItem);
        }
        this.m.setText(Messages.getString("MenuItemSelectionView.34") + "(" + this.l.values().size() + ")");
        this.b.repaint();
    }

    public int getSelectedRow() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.b.convertRowIndexToModel(n);
    }

    public void repaintTable() {
        this.b.repaint();
    }

    public void setSelectionMode(int n) {
        this.m.setVisible(n == 1);
        this.n.setVisible(n == 1);
        this.b.getSelectionModel().setSelectionMode(n);
        if (n == 0) {
            this.a(false);
        } else {
            this.a(true);
        }
    }

    private void a(boolean bl) {
        DefaultTableColumnModelExt defaultTableColumnModelExt = (DefaultTableColumnModelExt)this.b.getColumnModel();
        List list = defaultTableColumnModelExt.getColumns(true);
        TableColumnExt tableColumnExt = (TableColumnExt)list.get(0);
        tableColumnExt.setVisible(bl);
    }

    public void setSelectedGroup(MenuGroup menuGroup) {
        if (this.h != null && this.h.getId().equals(menuGroup.getId())) {
            return;
        }
        this.h = menuGroup;
        this.a.setSelectedItem(menuGroup);
        this.searchItem();
    }

    public void setEnableSearch(boolean bl) {
        this.w.setVisible(bl);
    }

    public boolean isInventoryItemOnly() {
        return this.p;
    }

    public void setInventoryItemOnly(boolean bl) {
        this.p = bl;
    }

    public MenuItemTableModel getModel() {
        return this.c;
    }

    private void n() {
        try {
            MenuItem menuItem = new MenuItem();
            MenuItemForm menuItemForm = new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem2 = (MenuItem)menuItemForm.getBean();
            this.c.addItem(menuItem2);
            this.c.setNumRows(this.c.getNumRows() + 1);
            this.f();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    public void setShowVariantParent(boolean bl) {
        this.q = bl;
    }

    public void setShowVariant(boolean bl) {
        this.t = bl;
    }

    public void setShowComboItem(boolean bl) {
        this.u = bl;
    }

    public boolean hidePizzaItem() {
        return this.r;
    }

    public void setHidePizzaItem(boolean bl) {
        this.r = bl;
    }

    public void clearAddedMenuItemMap() {
        this.l.clear();
    }

    public class MenuItemTableModel
    extends PaginatedTableModel<MenuItem> {
        @Override
        public Object getValueAt(int n, int n2) {
            MenuItem menuItem = (MenuItem)this.getRowData(n);
            MenuItem menuItem2 = (MenuItem)MenuItemSelectionView.this.l.get(menuItem.getId());
            switch (n2) {
                case 0: {
                    return menuItem2 != null;
                }
                case 1: {
                    return menuItem.getName();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            throw new InternalError();
        }
    }
}

