/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuItemSizeForm
extends BeanEditor<MenuItemSize> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private IntegerTextField d;
    private DoubleTextField e;

    public MenuItemSizeForm() {
        this(new MenuItemSize());
    }

    public MenuItemSizeForm(MenuItemSize menuItemSize) {
        this.a();
        this.setBean(menuItemSize);
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][]", ""));
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuItemSizeForm.4"));
        JLabel jLabel3 = new JLabel(Messages.getString("MenuItemSizeForm.5"));
        JLabel jLabel4 = new JLabel(Messages.getString("MenuItemSizeForm.6"));
        JLabel jLabel5 = new JLabel(Messages.getString("MenuItemSizeForm.7"));
        this.a = new FixedLengthTextField(60);
        this.a.setColumns(30);
        this.b = new FixedLengthTextField(120);
        this.b.setColumns(30);
        this.c = new FixedLengthTextField(60);
        this.c.setColumns(30);
        this.d = new IntegerTextField();
        this.d.setColumns(10);
        this.e = new DoubleTextField();
        this.e.setColumns(10);
        jPanel.add((Component)jLabel, "");
        jPanel.add((Component)this.a, "");
        jPanel.add((Component)jLabel3, "newline");
        jPanel.add((Component)this.c, "");
        jPanel.add((Component)jLabel2, "newline");
        jPanel.add((Component)this.b, "");
        jPanel.add((Component)jLabel5, "newline");
        jPanel.add((Component)this.e, "");
        jPanel.add((Component)jLabel4, "newline");
        jPanel.add((Component)this.d, "");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItemSize menuItemSize = (MenuItemSize)this.getBean();
            MenuItemSizeDAO menuItemSizeDAO = new MenuItemSizeDAO();
            menuItemSizeDAO.saveOrUpdate(menuItemSize);
            OroMqttClient.getInstance().sendUpdateNotification();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        MenuItemSize menuItemSize = (MenuItemSize)this.getBean();
        if (menuItemSize == null) {
            return;
        }
        this.a.setText(menuItemSize.getName());
        this.b.setText(menuItemSize.getDescription());
        this.c.setText(menuItemSize.getTranslatedName());
        this.d.setText(String.valueOf(menuItemSize.getSortOrder()));
        this.e.setText(NumberUtil.trimDecilamIfNotNeeded(menuItemSize.getSizeInInch()));
    }

    @Override
    protected boolean updateModel() {
        MenuItemSize menuItemSize = (MenuItemSize)this.getBean();
        if (menuItemSize == null) {
            return false;
        }
        String string = this.a.getText();
        String string2 = this.b.getText();
        String string3 = this.c.getText();
        int n = this.d.getInteger();
        double d = this.e.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemSizeForm.0"));
            this.e.requestFocus();
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(menuItemSize.getId(), string, MenuItemSize.class);
        menuItemSize.setName(string);
        menuItemSize.setDescription(string2);
        menuItemSize.setTranslatedName(string3);
        menuItemSize.setSortOrder(n);
        menuItemSize.setSizeInInch(d);
        MenuItemSizeDAO menuItemSizeDAO = new MenuItemSizeDAO();
        menuItemSizeDAO.saveOrUpdate(menuItemSize);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItemSize menuItemSize = (MenuItemSize)this.getBean();
        if (menuItemSize.getId() == null) {
            return Messages.getString("MenuItemSizeForm.19");
        }
        return Messages.getString("MenuItemSizeForm.20");
    }
}

