/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.model.util.MenuSearchCriteria;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.ui.model.MenuSearcher;
import com.floreantpos.ui.model.PriceShiftForm;
import com.floreantpos.ui.model.PriceTableItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceTableForm
extends BeanEditor<PriceTable>
implements MenuSearcher,
FocusListener {
    private PriceTableItemSelectionView c;
    private FixedLengthTextField d = new FixedLengthTextField();
    private FixedLengthTextField e = new FixedLengthTextField();
    private IntegerTextField f = new IntegerTextField();
    private JComboBox g = new JComboBox();
    private JComboBox h = new JComboBox();
    private JComboBox i = new JComboBox();
    private JComboBox j = new JComboBox();
    private JComboBox k = new JComboBox();
    private JCheckBox l = new JCheckBox(Messages.getString("ACTIVE"));
    private JCheckBox m = new JCheckBox("Customer is member");
    protected PosBlinkButton btnSave = new PosBlinkButton(Messages.getString("ModelBrowser.2"));
    private PriceRule n;
    private boolean o;
    ActionListener a = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PriceTableForm.this.o) {
                if (this.a(PriceTableForm.this.g, PriceTableForm.this.n.getDepartment())) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                if (this.a(PriceTableForm.this.h, PriceTableForm.this.n.getSalesArea())) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                if (this.a(PriceTableForm.this.i, PriceTableForm.this.n.getOrderType())) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                if (this.a(PriceTableForm.this.j, PriceTableForm.this.n.getCustomerGroup())) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                if (this.a(PriceTableForm.this.k, PriceTableForm.this.n.getPriceShift())) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                if (PriceTableForm.this.l.isSelected() != PriceTableForm.this.n.isActive().booleanValue()) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
                boolean bl = PriceTableForm.this.n.isCustomerIsMember() == null ? Boolean.FALSE : PriceTableForm.this.n.isCustomerIsMember();
                if (PriceTableForm.this.m.isSelected() != bl) {
                    PriceTableForm.this.btnSave.setBlinking(true);
                }
            }
        }

        private boolean a(JComboBox jComboBox, Object object) {
            boolean bl = !Objects.equals(jComboBox.getSelectedItem(), object);
            return object != null && bl || jComboBox.getSelectedIndex() != 0 && bl;
        }
    };
    KeyAdapter b = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                PriceTableForm.this.chkTextFiledValueUpatedOrNot();
            }
        }
    };

    public PriceTableForm() {
        this.a();
    }

    public PriceTableForm(PriceTable priceTable) {
        this.setBean(priceTable);
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(10, 10, 0, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("ins 0", "[][]", "[][]"));
        this.d.setLength(30);
        jPanel.add((Component)new JLabel(Messages.getString("NAME")), "right");
        jPanel.add((Component)this.d, "growx,wrap");
        this.e.setLength(255);
        jPanel.add((Component)new JLabel(Messages.getString("PriceTableForm.6")), "growx,aligny top");
        jPanel.add((Component)this.e, "growx,wrap");
        jPanel.add((Component)new JLabel(Messages.getString("PriceShiftExplorer.1")), "right");
        jPanel.add((Component)this.f, "grow,wrap");
        jPanel.add((Component)this.l, "skip 1,wrap");
        this.btnSave.addActionListener(actionEvent -> this.btnSave.setBlinking(!this.save()));
        jPanel.add((Component)this.btnSave, "span 2,right, bottom,push, gapbottom 0");
        JButton jButton = new JButton("...");
        jButton.addActionListener(actionEvent -> this.c());
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx"));
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Apply when");
        titledBorder.setTitleJustification(1);
        jPanel3.setBorder(titledBorder);
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.13")), "right");
        jPanel3.add((Component)this.g, " growx,spanx,pushx,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.15")), "right");
        jPanel3.add((Component)this.h, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.17")), "right");
        jPanel3.add((Component)this.i, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.19")), "right");
        jPanel3.add((Component)this.j, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.21")), "right");
        jPanel3.add((Component)this.k, "grow,split 2");
        jPanel3.add((Component)jButton, "wrap");
        jPanel3.add((Component)this.m, "skip 1");
        jPanel2.add((Component)jPanel, "grow");
        jPanel2.add((Component)jPanel3, "growx,spanx,pushx");
        this.add((Component)jPanel2, "North");
        this.g.addActionListener(this.a);
        this.h.addActionListener(this.a);
        this.i.addActionListener(this.a);
        this.j.addActionListener(this.a);
        this.k.addActionListener(this.a);
        this.d.addFocusListener(this);
        this.e.addFocusListener(this);
        this.f.addFocusListener(this);
        this.d.addKeyListener(this.b);
        this.e.addKeyListener(this.b);
        this.f.addKeyListener(this.b);
        this.l.addActionListener(this.a);
        this.m.addActionListener(this.a);
        this.c = new PriceTableItemSelectionView(this);
        this.b();
        this.c.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("PriceTableForm.0"), 1, 2));
        this.add((Component)this.c, "Center");
        this.setFieldsEnable(false);
    }

    private void b() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.c.setPriceTable(priceTable);
    }

    private void c() {
        try {
            PriceShiftForm priceShiftForm = new PriceShiftForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)priceShiftForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            PriceShift priceShift = (PriceShift)priceShiftForm.getBean();
            this.k.addItem(priceShift);
            this.k.setSelectedItem(priceShift);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PriceTable priceTable = (PriceTable)this.getBean();
            if (StringUtils.isNotBlank((String)priceTable.getId())) {
                this.n = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable.getId());
            }
            if (this.n == null) {
                this.n = new PriceRule();
            }
            this.n.setOutlet(DataProvider.get().getOutlet());
            this.n.setActive(this.l.isSelected());
            boolean bl = this.m.isSelected();
            if (bl) {
                this.n.setCustomerIsMember(bl);
            } else {
                this.n.setCustomerIsMember(null);
            }
            this.n.setDepartment((Department)this.a(this.g.getSelectedItem()));
            this.n.setSalesArea((SalesArea)this.a(this.h.getSelectedItem()));
            this.n.setCustomerGroup((CustomerGroup)this.a(this.j.getSelectedItem()));
            this.n.setPriceShift((PriceShift)this.a(this.k.getSelectedItem()));
            this.n.setOrderType((OrderType)this.a(this.i.getSelectedItem()));
            this.n.setPriority(this.f.getInteger());
            List<PriceTableItem> list = this.c.getSelectedMenuItemList();
            PriceRuleDAO.getInstance().saveOrUpdate(priceTable, this.n, list);
            POSMessageDialog.showMessage(Messages.getString("BeanEditorDialog.0"));
            return true;
        }
        catch (DuplicateDataException duplicateDataException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), duplicateDataException.getMessage());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    protected void updateView() {
        this.o = false;
        PriceTable priceTable = (PriceTable)this.getBean();
        this.d.setText(priceTable.getName());
        this.e.setText(priceTable.getDescription());
        this.d();
        if (priceTable.getId() == null) {
            this.l.setSelected(true);
            this.m.setSelected(false);
            if (this.c != null) {
                this.c.initData();
            }
            return;
        }
        this.n = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable.getId());
        if (this.n != null) {
            String string = Messages.getString("PriceRuleForm.28");
            this.g.setSelectedItem(this.n.getDepartment() == null ? string : this.n.getDepartment());
            this.h.setSelectedItem(this.n.getSalesArea() == null ? string : this.n.getSalesArea());
            this.i.setSelectedItem(this.n.getOrderType() == null ? string : this.n.getOrderType());
            this.j.setSelectedItem(this.n.getCustomerGroup() == null ? string : this.n.getCustomerGroup());
            this.k.setSelectedItem(this.n.getPriceShift() == null ? string : this.n.getPriceShift());
            this.f.setText(String.valueOf(this.n.getPriority()));
            this.l.setSelected(this.n.isActive());
            this.m.setSelected(this.n.isCustomerIsMember() == null ? false : this.n.isCustomerIsMember());
        }
        this.b();
        this.setFieldsEnable(true);
        this.o = true;
        this.btnSave.setBlinking(false);
    }

    private void d() {
        this.g.setModel(this.a(DepartmentDAO.getInstance().findAll()));
        this.h.setModel(this.a(SalesAreaDAO.getInstance().findAll()));
        this.i.setModel(this.a(OrderTypeDAO.getInstance().findAll()));
        this.j.setModel(this.a(CustomerGroupDAO.getInstance().findAll()));
        this.k.setModel(this.a(PriceShiftDAO.getInstance().findAll()));
    }

    private ComboBoxModel a(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Messages.getString("PriceRuleForm.1"));
        arrayList.addAll(list);
        return new ComboBoxModel(arrayList);
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceTable priceTable = (PriceTable)this.getBean();
        String string = this.d.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableForm.28"));
            return false;
        }
        string = string.trim();
        GenericDAO.getInstance().checkIdOrNameExists(priceTable.getId(), string, PriceTable.class);
        boolean bl = false;
        if ((Department)this.a(this.g.getSelectedItem()) != null) {
            bl = true;
        } else if ((SalesArea)this.a(this.h.getSelectedItem()) != null) {
            bl = true;
        } else if ((CustomerGroup)this.a(this.j.getSelectedItem()) != null) {
            bl = true;
        } else if ((PriceShift)this.a(this.k.getSelectedItem()) != null) {
            bl = true;
        } else if ((OrderType)this.a(this.i.getSelectedItem()) != null) {
            bl = true;
        } else if (this.m.isSelected()) {
            bl = true;
        }
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NewPriceRuleForm.3"));
            return false;
        }
        priceTable.setName(string);
        priceTable.setDescription(this.e.getText());
        priceTable.setLastUpdateTime(new Date());
        priceTable.setLastUpdatedBy(Application.getCurrentUser().getId());
        priceTable.setOutletId(DataProvider.get().getCurrentOutletId());
        return true;
    }

    private Object a(Object object) {
        if (object instanceof String) {
            return null;
        }
        return object;
    }

    @Override
    public String getDisplayText() {
        if (((PriceTable)this.getBean()).getId() == null) {
            return Messages.getString("PriceTableForm.30");
        }
        return Messages.getString("PriceTableForm.31");
    }

    public void setEditable(boolean bl) {
        this.e.setEditable(bl);
        this.d.setEditable(bl);
    }

    @Override
    public void createNew() {
        try {
            PriceTable priceTable = (PriceTable)this.getBean();
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(this);
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(true);
            menuItemSelectionDialog.setShowVariant(false);
            menuItemSelectionDialog.setShowComboItem(true);
            menuItemSelectionDialog.setIncludePizzaItem(true);
            menuItemSelectionDialog.setSize(PosUIManager.getSize((int)600, (int)515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<PriceTableItem> list = this.convertToPriceTableItem(menuItemSelectionDialog.getSelectedItems());
            PriceTableItemSelectionView.PriceTableItemTableModel priceTableItemTableModel = this.c.getTableModel();
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, list);
            ArrayList arrayList = new ArrayList();
            arrayList.clear();
            List list2 = priceTableItemTableModel.getRows();
            arrayList.addAll(list2);
            arrayList.addAll(list);
            priceTableItemTableModel.setRows(arrayList);
            priceTableItemTableModel.fireTableDataChanged();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public List<PriceTableItem> convertToPriceTableItem(List<MenuItem> list) {
        ArrayList<PriceTableItem> arrayList = new ArrayList<PriceTableItem>();
        for (MenuItem menuItem : list) {
            if (menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection()) {
                List<IUnit> list2;
                MenuItemDAO.getInstance().initializeUnits(menuItem);
                if (menuItem.isVariant().booleanValue() && menuItem.getParentMenuItem() != null) {
                    MenuItemDAO.getInstance().initializeUnits(menuItem.getParentMenuItem());
                }
                if ((list2 = menuItem.getUnits()) != null && list2.size() > 0) {
                    for (IUnit iUnit : list2) {
                        if (!(iUnit instanceof InventoryUnit)) continue;
                        InventoryUnit inventoryUnit = (InventoryUnit)iUnit;
                        arrayList.add(this.a(menuItem, inventoryUnit));
                    }
                    continue;
                }
            }
            arrayList.add(this.a(menuItem, menuItem.getUnit() == null ? null : menuItem.getUnit()));
        }
        return arrayList;
    }

    private PriceTableItem a(MenuItem menuItem, InventoryUnit inventoryUnit) {
        PriceTableItem priceTableItem = new PriceTableItem();
        priceTableItem.setMenuItem(menuItem);
        priceTableItem.setMenuItemId(menuItem.getId());
        priceTableItem.setItemName(menuItem.getName());
        priceTableItem.setItemBarcode(menuItem.getBarcode());
        if (inventoryUnit != null) {
            priceTableItem.setUnitId(inventoryUnit.getId());
            priceTableItem.setUnitType(inventoryUnit.getUnitType());
        }
        Double d = menuItem.getVariantPrice();
        double d2 = 0.0;
        d2 = menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection() ? menuItem.getDestinationUnitPrice(menuItem, inventoryUnit, d, menuItem.getUnitQuantity(menuItem.getUnit(), inventoryUnit)) : InventoryUnitConvertionUtil.calculatePrice(d, menuItem.getUnit(), inventoryUnit, menuItem);
        priceTableItem.setRegularPrice(d2);
        priceTableItem.setPrice(menuItem.isVariant() != false ? menuItem.getPrice() : d2);
        return priceTableItem;
    }

    @Override
    public boolean delete() {
        try {
            return this.c.delete();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void cancel() {
        this.updateView();
    }

    @Override
    public void clearFields() {
        String string = Messages.getString("PriceRuleForm.28");
        this.g.setSelectedItem(string);
        this.h.setSelectedItem(string);
        this.i.setSelectedItem(string);
        this.j.setSelectedItem(string);
        this.k.setSelectedItem(string);
        this.l.setSelected(false);
        this.m.setSelected(false);
        this.d.setText("");
        this.e.setText("");
        this.c.setPriceTable(null);
    }

    @Override
    public void search(MenuItemSelectionView.MenuItemTableModel menuItemTableModel, MenuSearchCriteria menuSearchCriteria) {
        menuSearchCriteria.setShowVariant(false);
        menuSearchCriteria.setIncludeVariantParent(true);
        MenuItemDAO.getInstance().loadMenuItems((PriceTable)this.getBean(), menuItemTableModel, menuSearchCriteria);
    }

    public void chkTextFiledValueUpatedOrNot() {
        PriceTable priceTable = (PriceTable)this.getBean();
        if (priceTable != null) {
            if (!Objects.equals(this.d.getText(), priceTable.getName())) {
                this.btnSave.setBlinking(true);
            }
            if (!Objects.equals(this.e.getText(), priceTable.getDescription())) {
                this.btnSave.setBlinking(true);
            }
        }
        if (!Objects.equals(this.f.getText(), this.n.getPriority().toString())) {
            this.btnSave.setBlinking(true);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.chkTextFiledValueUpatedOrNot();
    }
}

