/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.NumberBound;
import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class TaxForm
extends BeanEditor<Tax> {
    private FixedLengthTextField a = new FixedLengthTextField();
    private DoubleTextField b;

    public TaxForm() {
        this(new Tax());
    }

    public TaxForm(Tax tax) {
        this.a();
        this.setBean(tax);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(POSConstants.NAME + ":"));
        this.add((Component)this.a, "grow, wrap");
        this.b = new DoubleTextField(10, 6, DataProvider.get().getStore().getDecimalPlace());
        this.add(new JLabel(POSConstants.RATE + ":"));
        this.b.setHorizontalAlignment(4);
        this.add((Component)this.b, "split 2,grow");
        this.add((Component)new JLabel("%"), "wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Tax tax = (Tax)this.getBean();
            TaxDAO.getInstance().saveOrUpdate(tax);
            OroMqttClient.getInstance().sendUpdateNotification();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            return false;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new Tax());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
    }

    @Override
    public void clearFields() {
        this.a.setText("");
        this.b.setText("");
    }

    @Override
    protected void updateView() {
        Tax tax = (Tax)this.getBean();
        if (tax == null) {
            return;
        }
        this.a.setText(tax.getName());
        this.b.setText(NumberUtil.toString(tax.getRate()));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Tax tax = (Tax)this.getBean();
        if (tax == null) {
            return false;
        }
        String string = this.a.getText();
        Double d = this.b.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxForm.0"));
            return false;
        }
        Pattern pattern = NumberUtil.getPattern(new NumberBound(6, 4));
        Matcher matcher = pattern.matcher(this.b.getText());
        if (!matcher.matches()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TaxRateIsTooBig"));
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(tax.getId(), string, Tax.class);
        tax.setName(string);
        tax.setRate(d);
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Tax tax = (Tax)this.getBean();
            if (tax == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("TaxForm.9"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return false;
            }
            TaxDAO.getInstance().delete(tax);
            this.clearFields();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        Tax tax = (Tax)this.getBean();
        if (tax.getId() == null) {
            return POSConstants.NEW_TAX_RATE;
        }
        return POSConstants.EDIT_TAX_RATE;
    }
}

