/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model.combo;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.combo.ComboGroups;
import com.floreantpos.ui.model.combo.ComboItems;
import com.floreantpos.ui.model.combo.ComboOtherInfo;
import com.floreantpos.ui.model.combo.ComboPricing;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.ui.setup.TitledPageTemplate;
import com.floreantpos.util.POSUtil;
import com.github.cjwizard.PageFactory;
import com.github.cjwizard.StackWizardSettings;
import com.github.cjwizard.WizardContainer;
import com.github.cjwizard.WizardListener;
import com.github.cjwizard.WizardPage;
import com.github.cjwizard.WizardSettings;
import com.github.cjwizard.pagetemplates.PageTemplate;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;

public class ComboItemWizard
extends POSDialog
implements PageFactory,
WizardListener {
    List<PosWizardPage> a = new ArrayList<PosWizardPage>();
    private WizardContainer b;
    private MenuItem c;

    public ComboItemWizard() {
        this(new MenuItem());
    }

    public ComboItemWizard(MenuItem menuItem) {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("ComboItemWizard.0"));
        if (menuItem == null) {
            this.c = new MenuItem();
        }
        this.c = menuItem;
        this.c.setComboItem(true);
        ComboGroups comboGroups = new ComboGroups(menuItem);
        this.a.add(new ComboPricing(menuItem, comboGroups));
        this.a.add(new ComboItems(menuItem));
        this.a.add(comboGroups);
        this.a.add(new ComboOtherInfo(menuItem));
        this.b = new WizardContainer((PageFactory)this, (PageTemplate)new TitledPageTemplate(), (WizardSettings)new StackWizardSettings());
        this.b.addWizardListener((WizardListener)this);
        this.add((Component)this.b);
        this.setSize(PosUIManager.getSize((int)800, (int)600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ComboItemWizard.this.onCanceled(null, null);
            }
        });
    }

    public void onPageChanged(WizardPage wizardPage, List<WizardPage> list) {
        if (wizardPage instanceof ComboOtherInfo) {
            wizardPage.getController().setNextEnabled(false);
            wizardPage.getController().setFinishEnabled(true);
        } else {
            wizardPage.getController().setNextEnabled(true);
            wizardPage.getController().setFinishEnabled(false);
        }
    }

    public void onFinished(List<WizardPage> list, WizardSettings wizardSettings) {
        Object object;
        WizardPage wizardPage = list.get(list.size() - 1);
        if (wizardPage instanceof ComboOtherInfo && !((ComboOtherInfo)((Object)(object = (ComboOtherInfo)wizardPage))).updateModel()) {
            return;
        }
        object = MenuItemDAO.getInstance();
        boolean bl = ((MenuItemDAO)object).isNameExist(this.c.getId(), this.c.getName());
        if (bl) {
            String string = Messages.getString("MenuItemForm.0");
            String string2 = Messages.getString("MenuItemForm.1");
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, string2, Messages.getString("MenuItemForm.3"), Messages.getString("MenuItemForm.5"));
            if (n != 0) {
                return;
            }
        }
        ((MenuItemDAO)object).saveOrUpdate(this.c);
        this.setCanceled(false);
        this.dispose();
    }

    public void onCanceled(List<WizardPage> list, WizardSettings wizardSettings) {
        this.dispose();
    }

    public WizardPage createPage(List<WizardPage> list, WizardSettings wizardSettings) {
        PosWizardPage posWizardPage = null;
        if (list.isEmpty()) {
            posWizardPage = this.a.get(0);
        } else {
            WizardPage wizardPage = list.get(list.size() - 1);
            if (wizardPage instanceof ComboPricing) {
                posWizardPage = this.a.get(1);
            } else if (wizardPage instanceof ComboItems) {
                posWizardPage = this.a.get(2);
            } else if (wizardPage instanceof ComboGroups) {
                posWizardPage = this.a.get(3);
            }
        }
        try {
            posWizardPage.initialize();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
        return posWizardPage;
    }

    public boolean isTransient(List<WizardPage> list, WizardSettings wizardSettings) {
        return false;
    }
}

