/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model.combo;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.ui.model.ComboItemExplorerTableModel;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.github.cjwizard.WizardSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class ComboItems
extends PosWizardPage
implements ActionListener {
    private JTable a;
    private ComboItemExplorerTableModel b;
    private MenuItem c;
    private boolean d;

    public ComboItems(MenuItem menuItem) {
        super("Page 2", Messages.getString("ComboItems.0"));
        this.c = menuItem;
    }

    @Override
    public void initialize() throws Exception {
        if (!this.d) {
            this.a();
        }
    }

    private void a() {
        this.a = new JTable();
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(PosUIManager.getSize((int)30));
        this.b = new ComboItemExplorerTableModel();
        this.a.setModel(this.b);
        JButton jButton = new JButton(Messages.getString("MenuItemForm.9"));
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton();
        jButton4.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        JButton jButton5 = new JButton();
        jButton5.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        jButton5.addActionListener(actionEvent -> this.d());
        jButton4.addActionListener(actionEvent -> this.c());
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout(""));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add((Component)jButton3, "push");
        transparentPanel.add(jButton5);
        transparentPanel.add(jButton4);
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(PosUIManager.getSize((int)10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jScrollPane);
        jPanel.add((Component)transparentPanel, "South");
        this.add(jPanel);
        this.d = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.b();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(Messages.getString("ComboItemExplorer.8"));
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void b() {
        try {
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setShowComboItem(false);
            menuItemSelectionDialog.setIncludePizzaItem(false);
            menuItemSelectionDialog.setSize(PosUIManager.getSize((int)600, (int)515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            for (MenuItem object : list) {
                if (!this.c.equals(object)) continue;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CannotAddParentItem"));
                return;
            }
            List<ComboItem> list2 = this.b.getItems();
            for (MenuItem menuItem : list) {
                boolean bl = list2.stream().anyMatch(comboItem -> comboItem.getItemId().equals(menuItem.getId()));
                if (!bl) {
                    ComboItem comboItem2 = new ComboItem();
                    comboItem2.setMenuItem(menuItem);
                    comboItem2.setQuantity(1.0);
                    comboItem2.setCost(menuItem.getCost());
                    Double d = menuItem.getPrice();
                    if (menuItem.isVariant().booleanValue()) {
                        d = d + menuItem.getParentMenuItem().getPrice();
                    }
                    comboItem2.setPrice(d);
                    this.b.addComboItem(comboItem2);
                    continue;
                }
                POSMessageDialog.showMessage(Messages.getString("ComboItemExplorer.3"));
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog();
            comboItemEntryDialog.setComboItemTitle(comboItem.getName());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            Double d = comboItemEntryDialog.getQuantity();
            boolean bl = MenuItemDAO.getInstance().isFractionalUnit(comboItem.getItemId());
            if (NumberUtil.isFractional(d).booleanValue() && !bl) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FractionalQuantityNotAllowed"));
                return;
            }
            comboItem.setQuantity(d);
            this.b.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage((Component)((Object)this), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        int n = this.a.getSelectedRow();
        if (n == -1) {
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        int n2 = this.b.getRowCount() - 1 == n ? n : n + 1;
        this.b.moveRow(n, n2);
        this.a.setRowSelectionInterval(n2, n2);
    }

    private void d() {
        int n = this.a.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = (n = this.a.convertRowIndexToModel(n)) == 0 ? 0 : n - 1;
        this.b.moveRow(n, n2);
        this.a.setRowSelectionInterval(n2, n2);
    }

    public List<ComboItem> getSelectedComboItems() {
        List<ComboItem> list = this.b.getItems();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).putSortOrder(i);
        }
        return list;
    }

    public boolean onNext(WizardSettings wizardSettings) {
        return this.e();
    }

    private boolean e() {
        this.c.setComboItems(this.getSelectedComboItems());
        return true;
    }

    @Override
    public void finish() throws Exception {
    }
}

