/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.ui.setup.TitledPageTemplate;
import com.floreantpos.ui.setup.pages.AdminUserConfigPage;
import com.floreantpos.ui.setup.pages.BusinessNameConfigPage;
import com.floreantpos.ui.setup.pages.BusinessTypeConfigPage;
import com.floreantpos.ui.setup.pages.CurrencyConfigPage;
import com.floreantpos.ui.setup.pages.KitchenDisplayConfigPage;
import com.floreantpos.ui.setup.pages.MenuConfigPage;
import com.floreantpos.ui.setup.pages.PaymentTypeConfigPage;
import com.floreantpos.ui.setup.pages.StoreConfigPage;
import com.floreantpos.ui.setup.pages.StoreOpeningHoursConfigPage;
import com.floreantpos.ui.setup.pages.TaxConfigPage;
import com.floreantpos.ui.views.order.DemoOrderViewDialog;
import com.github.cjwizard.PageFactory;
import com.github.cjwizard.StackWizardSettings;
import com.github.cjwizard.WizardContainer;
import com.github.cjwizard.WizardListener;
import com.github.cjwizard.WizardPage;
import com.github.cjwizard.WizardSettings;
import com.github.cjwizard.pagetemplates.PageTemplate;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;

public class SetupWizard
extends POSDialog
implements PageFactory,
WizardListener {
    List<PosWizardPage> a = new ArrayList<PosWizardPage>();
    private WizardContainer b;
    private JList<PosWizardPage> c;
    private boolean d = true;
    private JButton e;
    private PaymentTypeConfigPage f;
    private Store g;

    public SetupWizard() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("SetupWizard.0"));
        this.g = StoreDAO.getRestaurant();
        this.a.add(new BusinessNameConfigPage(this.g));
        this.a.add(new StoreConfigPage(this.g));
        BusinessTypeConfigPage businessTypeConfigPage = new BusinessTypeConfigPage();
        this.a.add(businessTypeConfigPage);
        this.a.add(new CurrencyConfigPage());
        this.a.add(new TaxConfigPage());
        this.f = new PaymentTypeConfigPage();
        this.a.add(this.f);
        this.a.add(new StoreOpeningHoursConfigPage(this.g));
        this.a.add(new KitchenDisplayConfigPage(this.g));
        MenuConfigPage menuConfigPage = new MenuConfigPage(businessTypeConfigPage);
        this.a.add(menuConfigPage);
        this.a.add(new AdminUserConfigPage());
        DefaultListModel<PosWizardPage> defaultListModel = new DefaultListModel<PosWizardPage>();
        for (PosWizardPage posWizardPage : this.a) {
            defaultListModel.addElement(posWizardPage);
        }
        this.c = new JList(defaultListModel);
        this.c.setPreferredSize(PosUIManager.getSize((int)200, (int)100));
        this.c.setEnabled(false);
        this.b = new WizardContainer((PageFactory)this, (PageTemplate)new TitledPageTemplate(this.c), (WizardSettings)new StackWizardSettings());
        this.b.addWizardListener((WizardListener)this);
        Component component2 = Stream.of(((JPanel)this.b.getComponents()[1]).getComponents()).filter(component -> component instanceof JButton && ((JButton)component).getText().startsWith("<")).findFirst().orElse(null);
        if (component2 != null) {
            component2.setVisible(false);
        }
        this.b.setFinishEnabled(true);
        this.e = new JButton(Messages.getString("Preview"));
        this.e.addActionListener(actionEvent -> {
            DemoOrderViewDialog demoOrderViewDialog = new DemoOrderViewDialog();
            demoOrderViewDialog.setMenuItems(menuConfigPage.getMenuItemEntryExplorer().getQuickMenuItemEntryView().getAllMenuItem());
            demoOrderViewDialog.openFullScreen();
        });
        this.e.setVisible(false);
        this.b.setButtons(new JButton[]{this.e});
        this.add((Component)this.b);
        this.setSize(PosUIManager.getSize((int)900, (int)700));
    }

    public WizardPage createPage(List<WizardPage> list, WizardSettings wizardSettings) {
        int n = list.size();
        PosWizardPage posWizardPage = this.a.get(n);
        try {
            posWizardPage.initialize();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
        return posWizardPage;
    }

    public boolean isTransient(List<WizardPage> list, WizardSettings wizardSettings) {
        return false;
    }

    public void onPageChanged(WizardPage wizardPage, List<WizardPage> list) {
        PosWizardPage posWizardPage;
        StoreDAO.getInstance().refresh(this.g);
        int n = list.size();
        wizardPage.getController().setNextEnabled(n < this.a.size());
        int n2 = list.indexOf(wizardPage);
        if (n2 >= 0) {
            this.c.setSelectedIndex(n2);
        }
        if (wizardPage instanceof MenuConfigPage) {
            posWizardPage = (MenuConfigPage)wizardPage;
            ((MenuConfigPage)posWizardPage).refreshData();
            if (this.e != null) {
                this.e.setVisible(true);
            }
        } else if (this.e != null) {
            this.e.setVisible(false);
        }
        if (n > 1) {
            posWizardPage = (PosWizardPage)list.get(n - 2);
            try {
                posWizardPage.finish();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage());
            }
        }
    }

    public void onFinished(List<WizardPage> list, WizardSettings wizardSettings) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("setup_complete", "true");
            StoreDAO.getInstance().update(store);
            if (this.f.isOroPay()) {
                this.f.doSendMail();
            }
            if (this.isRestartOnFinish()) {
                POSMessageDialog.showMessage(Messages.getString("SetupWizard.2"));
                Main.restart();
            } else {
                this.dispose();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void onCanceled(List<WizardPage> list, WizardSettings wizardSettings) {
        this.dispose();
    }

    public boolean isRestartOnFinish() {
        return this.d;
    }

    public void setRestartOnFinish(boolean bl) {
        this.d = bl;
    }
}

