/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.actions.DataImportAction;
import com.floreantpos.bo.ui.explorer.QuickMenuItemEntryExplorer;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.ui.setup.pages.BusinessTypeConfigPage;
import com.floreantpos.util.AESencrp;
import com.floreantpos.webservice.CloudDataDownloader;
import com.floreantpos.webservice.PosWebService;
import com.github.cjwizard.WizardController;
import com.github.cjwizard.WizardSettings;
import com.sun.jersey.api.client.ClientHandlerException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;

public class MenuConfigPage
extends PosWizardPage {
    private JProgressBar a;
    private BusinessTypeConfigPage b;
    private QuickMenuItemEntryExplorer c;

    public MenuConfigPage(BusinessTypeConfigPage businessTypeConfigPage) {
        super(Messages.getString("MenuConfigPage.0"), Messages.getString("MenuConfigPage.1"));
        this.b = businessTypeConfigPage;
    }

    @Override
    public void initialize() throws Exception {
        this.setLayout((LayoutManager)new MigLayout());
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("ins 0"));
        JLabel jLabel = new JLabel(String.format(Messages.getString("MenuConfigPage.5"), this.b.getSelectedOrderType().getName()));
        final JButton jButton = new JButton(Messages.getString("MenuConfigPage.6"));
        final JButton jButton2 = new JButton(Messages.getString("MenuConfigPage.7"));
        transparentPanel.add((Component)jLabel, "wrap");
        transparentPanel.add((Component)jButton, "split 2");
        transparentPanel.add(jButton2);
        this.a = new JProgressBar();
        this.a.setValue(0);
        this.a.setMaximum(100);
        this.a.setStringPainted(true);
        this.a.setPreferredSize(PosUIManager.getSize((int)0, (int)30));
        this.add(transparentPanel);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("MenuConfigPage.2"));
        this.c = new QuickMenuItemEntryExplorer();
        jButton2.addActionListener(actionEvent -> {
            this.removeAll();
            this.add(titlePanel, "North");
            this.add(this.c, "grow, push");
            this.repaint();
            this.revalidate();
        });
        jButton.addActionListener(actionEvent -> {
            this.removeAll();
            this.add(transparentPanel);
            jButton2.setEnabled(false);
            final TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new MigLayout("ins 0, fill"));
            transparentPanel2.add((Component)new JLabel(Messages.getString("MenuConfigPage.9")), "wrap");
            transparentPanel2.add((Component)this.a, "top, growx, wrap, w " + PosUIManager.getSize((int)300) + "!");
            this.add(transparentPanel2, "newline");
            this.repaint();
            this.revalidate();
            new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    jButton.setEnabled(false);
                    WizardController wizardController = MenuConfigPage.this.getController();
                    wizardController.setCancelEnabled(false);
                    wizardController.setFinishEnabled(false);
                    wizardController.setNextEnabled(false);
                    wizardController.setPrevEnabled(false);
                    try {
                        MenuConfigPage.this.a();
                        Date date = PosWebService.get().getCurrentServerTime();
                        Date date2 = StoreDAO.getServerTimestamp();
                        CloudDataDownloader cloudDataDownloader = new CloudDataDownloader(new ProgressObserver(){

                            @Override
                            public void progress(int n) {
                            }

                            @Override
                            public void progress(String string) {
                            }

                            @Override
                            public void progress(int n, String string) throws Exception {
                                MenuConfigPage.this.a.setValue(n);
                            }

                            @Override
                            public Component getParentComponent() {
                                return null;
                            }
                        }, date, date2);
                        cloudDataDownloader.downloadStore(false);
                        cloudDataDownloader.setDownloadSampleDataForNewStore(true);
                        cloudDataDownloader.downloadAllData(0);
                        MenuConfigPage.this.a.setValue(100);
                        POSMessageDialog.showMessage(Messages.getString("MenuConfigPage.10"));
                    }
                    catch (ClientHandlerException clientHandlerException) {
                        jButton.setEnabled(true);
                        jButton2.setEnabled(true);
                        transparentPanel2.setVisible(false);
                        POSMessageDialog.showError(Messages.getString("MenuConfigPage.11"));
                    }
                    catch (Exception exception) {
                        jButton.setEnabled(true);
                        jButton2.setEnabled(true);
                        transparentPanel2.setVisible(false);
                        PosLog.error(this.getClass(), exception);
                    }
                    finally {
                        MenuConfigPage.this.b();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    WizardController wizardController = MenuConfigPage.this.getController();
                    wizardController.setCancelEnabled(true);
                    wizardController.setFinishEnabled(true);
                    wizardController.setNextEnabled(true);
                    wizardController.setPrevEnabled(true);
                    MenuConfigPage.this.repaint();
                    MenuConfigPage.this.revalidate();
                }
            }.execute();
        });
    }

    private void a() {
        try {
            Store store = StoreDAO.getRestaurant();
            store.addProperty("web.service.url", "https://backoffice.p-os.com");
            if (this.b.getSelectedOrderType().isDineIn()) {
                store.addProperty("web.service.username", "template_dinein@orotab.com");
                store.addProperty("web.service.password", AESencrp.encrypt("dinein"));
                store.addProperty("web.service.schema", "template_store_dinein");
            } else if (this.b.getSelectedOrderType().isTakeOut()) {
                store.addProperty("web.service.username", "template_takeout@orotab.com");
                store.addProperty("web.service.password", AESencrp.encrypt("takeout"));
                store.addProperty("web.service.schema", "template_store_takeout");
            } else if (this.b.getSelectedOrderType().isRetailOrder().booleanValue()) {
                store.addProperty("web.service.username", "template_retail@orotab.com");
                store.addProperty("web.service.password", AESencrp.encrypt("retail"));
                store.addProperty("web.service.schema", "template_store_retail");
            }
            StoreDAO.getInstance().saveOrUpdate(store);
            Application.getInstance().refreshStore();
        }
        catch (Exception exception) {
            PosLog.error(((Object)((Object)this)).getClass(), exception);
        }
    }

    private void b() {
        Store store = StoreDAO.getRestaurant();
        store.addProperty("web.service.url", null);
        store.addProperty("web.service.username", null);
        store.addProperty("web.service.password", null);
        store.addProperty("web.service.schema", null);
        StoreDAO.getInstance().saveOrUpdate(store);
        Application.getInstance().refreshStore();
    }

    public boolean onNext(WizardSettings wizardSettings) {
        try {
            boolean bl = this.c.doSaveMenuItems();
            if (!bl) {
                return false;
            }
            DataImportAction.generateAutoMenuPages();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void finish() throws Exception {
    }

    public void refreshData() {
        this.c.getQuickMenuItemEntryView().refreshTaxGroup();
    }

    public QuickMenuItemEntryExplorer getMenuItemEntryExplorer() {
        return this.c;
    }
}

