/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.versioning.VersionInfo;
import com.github.cjwizard.WizardSettings;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.derby.client.am.DisconnectException;

public class StandardModeSetupPage
extends PosWizardPage
implements ActionListener {
    private static final String a = "install_db_service.bat";
    private static final String b = "start_db_service.bat";
    private static final String c = "uninstall_db_service.bat";
    private JRadioButton d;
    private JRadioButton e;
    private boolean f;
    private boolean g;

    public StandardModeSetupPage() {
        super("", String.format(Messages.getString("StandardModeSetupPage.1"), VersionInfo.getAppName()));
    }

    @Override
    public void initialize() throws Exception {
        if (this.f) {
            return;
        }
        this.a();
        this.f = true;
    }

    private void a() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.d = new JRadioButton(String.format(Messages.getString("StandardModeSetupPage.2"), VersionInfo.getAppName()));
        this.e = new JRadioButton(String.format(Messages.getString("StandardModeSetupPage.3"), VersionInfo.getAppName()));
        this.d.addActionListener(this);
        this.e.addActionListener(this);
        this.d.setSelected(true);
        buttonGroup.add(this.d);
        buttonGroup.add(this.e);
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        this.add(this.d, "newline");
        this.add(this.e, "newline");
    }

    @Override
    public void finish() throws Exception {
    }

    public boolean onNext(WizardSettings wizardSettings) {
        if (this.d.isSelected()) {
            if (this.a(0)) {
                POSMessageDialog.showError("The database server is already running on your machine. Please choose the second option.");
                return false;
            }
            if (this.b()) {
                if (this.g) {
                    return true;
                }
                boolean bl = this.a(3);
                if (!bl) {
                    POSMessageDialog.showError("Sorry, the server failed to run. Please delete the service and try again or try in advanced mode. Thank you");
                }
                return bl;
            }
        } else if (this.e.isSelected()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            PosLog.debug(this.getClass(), "DB Connection checking...");
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string = Database.DERBY_SERVER.getConnectString("localhost", "51527", "test");
            DatabaseUtil.checkConnectionForDerby(string, Database.DERBY_SERVER.getHibernateDialect(), Database.DERBY_SERVER.getHibernateConnectionDriverClass(), "app", "sa");
            PosLog.debug(this.getClass(), "DB connected successfully");
            boolean bl = true;
            return bl;
        }
        catch (DatabaseConnectionException databaseConnectionException) {
            Throwable throwable = databaseConnectionException.getCause();
            if (throwable instanceof DisconnectException) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b() {
        this.g = false;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Messages.getString("StandardModeSetupPage.0"));
        jFileChooser.setCurrentDirectory(new File(File.separator));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            if (!Paths.get(string, new String[0]).equals(Paths.get(string, new String[0]).getRoot())) {
                POSMessageDialog.showError(Messages.getString("StandardModeSetupPage.4"));
                return this.b();
            }
            String string2 = DataProvider.get().getAppConfigFileLocation().getAbsolutePath();
            Path path = Paths.get(string2 + File.separator + "database" + File.separator + "derby-server", new String[0]);
            Path path2 = Paths.get(string2 + File.separator + "jre", new String[0]);
            Path path3 = Paths.get(string, new String[0]).resolve("OROCUBE").resolve("POS").resolve("database").resolve("derby-server");
            File file = path3.toFile();
            try {
                File[] fileArray;
                POSMessageDialog.showMessage(Messages.getString("StandardModeSetupPage.5"));
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (File file2 : fileArray = path.toFile().listFiles()) {
                    if (file2.getName().startsWith("posdb")) continue;
                    if (file2.isFile()) {
                        FileUtils.copyFileToDirectory((File)file2, (File)path3.toFile());
                        continue;
                    }
                    if (!file2.isDirectory()) continue;
                    String string3 = file2.getName();
                    FileUtils.copyDirectory((File)file2, (File)path3.resolve(string3).toFile());
                }
                FileUtils.copyDirectory((File)path2.toFile(), (File)path3.resolve("jre").toFile());
                bl = this.runCommand(a, file) && this.runCommand(b, file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileNotFoundException.getMessage().contains("The process cannot access the file because it is being used by another process")) {
                    this.runCommand(c, file);
                    bl = this.runCommand(a, file) && this.runCommand(b, file);
                }
            }
            catch (IOException iOException) {
                PosLog.error(this.getClass(), iOException);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (bl) {
            POSMessageDialog.showMessage("Database server installed successfully.");
        }
        return bl;
    }

    public boolean runCommand(String string, File file) {
        if (this.g) {
            return true;
        }
        try {
            PosLog.debug(this.getClass(), "cmd -> " + string);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cmd /c " + string, null, file);
            int n = process.waitFor();
            PosLog.debug(this.getClass(), "processResult -> " + n);
            if (n != 0) {
                if (n == 8) {
                    return this.runCommand(c, file) && this.runCommand(string, file);
                }
                String string2 = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset());
                PosLog.error(this.getClass(), string2);
                int n2 = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("StandardModeSetupPage.6"));
                if (n2 == 0) {
                    return this.runCommand(string, file);
                }
                if (this.g) {
                    return true;
                }
                POSMessageDialog.showMessage(Messages.getString("StandardModeSetupPage.7"));
                this.g = true;
                return this.g;
            }
        }
        catch (IOException | InterruptedException exception) {
            PosLog.error(this.getClass(), exception);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getController().setFinishEnabled(false);
        this.getController().setNextEnabled(true);
    }

    public boolean isNewOroDbServer() {
        return this.d.isSelected();
    }

    public boolean isSendInAdvanncedMode() {
        return this.g;
    }
}

