/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.util;

import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.DateTimePicker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class UiUtil {
    public static JXDatePicker getCurrentMonthStart() {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(5, 1);
        JXDatePicker jXDatePicker = new JXDatePicker(calendar.getTime(), locale);
        jXDatePicker.getEditor().setEditable(false);
        return jXDatePicker;
    }

    public static JXDatePicker getPreviousMonthStart() {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.add(2, -1);
        calendar.set(5, 1);
        JXDatePicker jXDatePicker = new JXDatePicker(calendar.getTime(), locale);
        jXDatePicker.getEditor().setEditable(false);
        return jXDatePicker;
    }

    public static JXDatePicker getPreviousMonthEnd() {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        JXDatePicker jXDatePicker = new JXDatePicker(calendar.getTime(), locale);
        jXDatePicker.getEditor().setEditable(false);
        return jXDatePicker;
    }

    public static DateTimePicker createCurrentMonthAndTimeStart(boolean bl) {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(5, 1);
        DateTimePicker dateTimePicker = new DateTimePicker(calendar.getTime(), bl);
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormatWithTime();
        dateTimePicker.setFormats(new DateFormat[]{simpleDateFormat});
        dateTimePicker.getEditor().setEditable(false);
        return dateTimePicker;
    }

    public static DateTimePicker createCurrentMonthAndTimeEnd(boolean bl) {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(5, calendar.getActualMaximum(5));
        DateTimePicker dateTimePicker = new DateTimePicker(calendar.getTime(), bl);
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormatWithTime();
        dateTimePicker.setFormats(new DateFormat[]{simpleDateFormat});
        dateTimePicker.getEditor().setEditable(false);
        return dateTimePicker;
    }

    public static JXDatePicker getCurrentMonthEnd() {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        calendar.set(5, calendar.getActualMaximum(5));
        JXDatePicker jXDatePicker = new JXDatePicker(calendar.getTime(), locale);
        jXDatePicker.getEditor().setEditable(false);
        return jXDatePicker;
    }

    public static JXDatePicker getDeafultDate() {
        JXDatePicker jXDatePicker = new JXDatePicker();
        jXDatePicker.getEditor().setEditable(false);
        return jXDatePicker;
    }

    public static JXTable createJXTable(BeanTableModel<?> beanTableModel) {
        return UiUtil.createJXTable(beanTableModel, null);
    }

    public static JXTable createJXTable(BeanTableModel<?> beanTableModel, DefaultTableCellRenderer defaultTableCellRenderer) {
        JXTable jXTable = new JXTable(beanTableModel);
        jXTable.setRowHeight(PosUIManager.getSize((int)30));
        jXTable.setSelectionMode(0);
        if (defaultTableCellRenderer == null) {
            beanTableModel.initTableRenderer((JTable)jXTable);
        } else {
            jXTable.setDefaultRenderer(Object.class, (TableCellRenderer)defaultTableCellRenderer);
        }
        return jXTable;
    }

    public void setLowerBound(Date date, JXDatePicker jXDatePicker) {
        Calendar calendar = jXDatePicker.getMonthView().getCalendar();
        calendar.setTime(date);
        jXDatePicker.getMonthView().setLowerBound(calendar.getTime());
    }

    public static void setButtonColorGreen(JButton jButton) {
        UiUtil.setButtonColor(jButton, Color.GREEN);
    }

    public static void setButtonColor(JButton jButton, Color color) {
        if (color != null) {
            jButton.setBackground(color);
        }
    }

    public static Dimension calculateModifierPrefSize(AbstractButton abstractButton) {
        return UiUtil.calculateModifierPrefSize(abstractButton, false, false);
    }

    public static Dimension calculateModifierPrefSize(AbstractButton abstractButton, boolean bl, boolean bl2) {
        Dimension dimension = abstractButton.getPreferredSize();
        dimension.width += PosUIManager.getSize((int)20);
        if (bl2 && dimension.width < PosUIManager.getSize((int)200)) {
            dimension.width = PosUIManager.getSize((int)200);
        }
        JLabel jLabel = new JLabel("1");
        Font font = DataProvider.get().getMenuFont();
        if (font != null) {
            jLabel.setFont(font);
        }
        int n = jLabel.getPreferredSize().height;
        dimension.height = dimension.height + (DataProvider.get().getStore().isEnablePriceOnMenuBtn() && !bl ? PosUIManager.getSize((int)(n * 3)) : PosUIManager.getSize((int)(n * 2)));
        return dimension;
    }

    public static Dimension setMaxSize(Dimension dimension, Dimension dimension2) {
        if (dimension2.height < PosUIManager.getSize((int)80)) {
            dimension2.height = PosUIManager.getSize((int)80);
        }
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }
}

