/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CookingInstructionSelectionDialog
extends OkCancelOptionDialog {
    private JTable a;
    private List<TicketItemCookingInstruction> b;
    private JTextField c = new FixedLengthTextField(512);
    private List<CookingInstruction> d;

    public CookingInstructionSelectionDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.a();
        this.updateView();
    }

    private void a() {
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("CookingInstructionSelectionView.1"));
        this.getContentPanel().setBorder(new EmptyBorder(10, 20, 0, 20));
        JScrollPane jScrollPane = new JScrollPane();
        this.a = new JTable();
        this.a.setRowHeight(PosUIManager.getSize((int)30));
        this.a.setFocusable(false);
        jScrollPane.setViewportView(this.a);
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CookingInstructionSelectionDialog.this.a.getSelectedRow();
                if (n < 0) {
                    return;
                }
                CookingInstructionTableModel cookingInstructionTableModel = (CookingInstructionTableModel)CookingInstructionSelectionDialog.this.a.getModel();
                CookingInstruction cookingInstruction = (CookingInstruction)cookingInstructionTableModel.c.get(n);
                CookingInstructionSelectionDialog.this.c.setText(cookingInstruction.getDescription());
            }
        });
        this.c.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CookingInstructionSelectionDialog.this.b();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CookingInstructionSelectionDialog.this.b();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        PosButton posButton = new PosButton(IconFactory.getIcon("save.png"));
        posButton.setText(POSConstants.SAVE.toUpperCase());
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = CookingInstructionSelectionDialog.this.c.getText().trim();
                if (StringUtils.isBlank((String)string)) {
                    POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CookingInstructionSelectionView.5"));
                    return;
                }
                if (string.length() > 60) {
                    POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CookingInstructionSelectionView.6"));
                    return;
                }
                CookingInstruction cookingInstruction = new CookingInstruction();
                cookingInstruction.setDescription(string);
                CookingInstructionDAO.getInstance().save(cookingInstruction);
                CookingInstructionSelectionDialog.this.updateView();
                CookingInstructionTableModel cookingInstructionTableModel = (CookingInstructionTableModel)CookingInstructionSelectionDialog.this.a.getModel();
                CookingInstructionSelectionDialog.this.a.getSelectionModel().addSelectionInterval(cookingInstructionTableModel.getRowCount() - 1, cookingInstructionTableModel.getRowCount() - 1);
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 1,inset 0"));
        jPanel.add((Component)jScrollPane, "grow");
        jPanel.add((Component)this.c, "h 35!,split 2,grow");
        jPanel.add((Component)posButton, "h 35!,w " + PosUIManager.getSize((int)90) + "!");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jPanel.add((Component)((Object)qwertyKeyPad), "grow");
        this.getContentPanel().add(jPanel);
        this.c.requestFocus();
    }

    private void b() {
        String string = this.c.getText().toLowerCase();
        ArrayList<CookingInstruction> arrayList = new ArrayList<CookingInstruction>();
        for (CookingInstruction cookingInstruction : this.d) {
            String string2 = cookingInstruction.getDescription().toLowerCase();
            if (!string2.contains(string)) continue;
            arrayList.add(cookingInstruction);
        }
        CookingInstructionTableModel cookingInstructionTableModel = (CookingInstructionTableModel)this.a.getModel();
        cookingInstructionTableModel.c = arrayList;
        cookingInstructionTableModel.fireTableDataChanged();
    }

    @Override
    public void doOk() {
        int[] nArray = this.a.getSelectedRows();
        if (this.b == null) {
            this.b = new ArrayList<TicketItemCookingInstruction>(nArray.length);
        }
        CookingInstructionTableModel cookingInstructionTableModel = (CookingInstructionTableModel)this.a.getModel();
        String string = this.c.getText().trim();
        if (nArray.length == 1) {
            if (StringUtils.isBlank((String)string)) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CookingInstructionSelectionView.12"));
                return;
            }
            CookingInstruction cookingInstruction = (CookingInstruction)cookingInstructionTableModel.c.get(nArray[0]);
            if (!string.equals(cookingInstruction.getDescription())) {
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(string);
                this.b.add(ticketItemCookingInstruction);
            } else {
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(cookingInstruction.getDescription());
                this.b.add(ticketItemCookingInstruction);
            }
        } else if (nArray.length == 0) {
            if (StringUtils.isBlank((String)string)) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CookingInstructionSelectionView.12"));
                return;
            }
            if (string.length() > 60) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("CookingInstructionSelectionView.14"));
                return;
            }
            TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
            ticketItemCookingInstruction.setDescription(string);
            this.b.add(ticketItemCookingInstruction);
        } else {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                CookingInstruction cookingInstruction = (CookingInstruction)cookingInstructionTableModel.c.get(nArray[i]);
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(cookingInstruction.getDescription());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)string) && !cookingInstruction.getDescription().equals(string)) {
                    bl = true;
                }
                this.b.add(ticketItemCookingInstruction);
            }
            if (bl) {
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(string);
                this.b.add(ticketItemCookingInstruction);
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    protected void updateView() {
        this.d = CookingInstructionDAO.getInstance().findAll();
        this.a.setModel(new CookingInstructionTableModel(this.d));
    }

    public List<TicketItemCookingInstruction> getTicketItemCookingInstructions() {
        return this.b;
    }

    class CookingInstructionTableModel
    extends AbstractTableModel {
        private final String[] b = new String[]{Messages.getString("CookingInstructionSelectionView.2")};
        private List<CookingInstruction> c;

        public CookingInstructionTableModel() {
        }

        public CookingInstructionTableModel(List<CookingInstruction> list) {
            this.c = list;
        }

        @Override
        public int getRowCount() {
            if (this.c == null) {
                return 0;
            }
            return this.c.size();
        }

        @Override
        public int getColumnCount() {
            return this.b.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.b[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.c == null) {
                return null;
            }
            CookingInstruction cookingInstruction = this.c.get(n);
            switch (n2) {
                case 0: {
                    return cookingInstruction.getDescription();
                }
            }
            return null;
        }
    }
}

