/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.StoreConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.EmailReportJobPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.ReportFrequency;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CronJobSchedulerDialog
extends POSDialog {
    private JLabel a;
    private JLabel b;
    private JLabel c;
    private JComboBox d;
    private JComboBox<ReportFrequency> e;
    private JComboBox f;
    private JComboBox g;
    private PosButton h;
    private PosButton i;
    private JPanel j = new JPanel(new BorderLayout());
    private IntegerTextField k;
    private JCheckBox l;
    private JComboBox m;
    private boolean n;
    private boolean o;
    private boolean p;
    private CronJob q;
    private String r;
    private JLabel s;

    public CronJobSchedulerDialog() throws Exception {
        this.initUI();
        this.c();
    }

    @Override
    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(Messages.getString("CronJobSchedulerDialog.0"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow]", ""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CronJobSchedulerDialog.4")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.a = new JLabel(Messages.getString("CronJobSchedulerDialog.5"));
        this.d = new JComboBox();
        this.d.addActionListener(this.e());
        jPanel.add(this.a);
        jPanel.add(this.d);
        this.a(jPanel);
        this.b = new JLabel(Messages.getString("CronJobSchedulerDialog.11"));
        this.e = new JComboBox<ReportFrequency>(ReportFrequency.values());
        this.e.addActionListener(this.a());
        this.s = new JLabel("");
        this.s.setVisible(false);
        jPanel.add(this.b);
        jPanel.add(this.e);
        jPanel.add(this.s);
        String[] stringArray = new String[]{"MINUTE", "HOUR"};
        this.c = new JLabel(Messages.getString("CronJobSchedulerDialog.99"));
        this.f = new JComboBox<String>(POSUtil.getHoursOfDay());
        this.f.setVisible(false);
        this.g = new JComboBox<String>(POSUtil.getMinutesOfHour());
        this.g.setVisible(false);
        this.k = new IntegerTextField();
        this.k.setVisible(true);
        this.k.setPreferredSize(PosUIManager.getSize((int)60, (int)0));
        this.m = new JComboBox<String>(stringArray);
        this.m.setVisible(true);
        this.l = new JCheckBox(Messages.getString("ACTIVE"));
        jPanel.add((Component)this.c, "newline");
        jPanel.add((Component)this.f, "split 2");
        jPanel.add(this.g);
        jPanel.add((Component)this.k, "split 2");
        jPanel.add(this.m);
        jPanel.add((Component)this.l, "newline,skip 1");
        JPanel jPanel3 = new JPanel();
        this.h = new PosButton("");
        this.h.addActionListener(this.f());
        this.i = new PosButton(POSConstants.CANCEL);
        this.i.addActionListener(this.g());
        jPanel3.add(this.h);
        jPanel3.add(this.i);
        jPanel2.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.setSize(PosUIManager.getSize((int)600, (int)480));
    }

    private ActionListener a() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportFrequency reportFrequency = (ReportFrequency)((Object)CronJobSchedulerDialog.this.e.getSelectedItem());
                if (reportFrequency != null && reportFrequency.equals((Object)ReportFrequency.EVERY)) {
                    CronJobSchedulerDialog.this.f.setVisible(false);
                    CronJobSchedulerDialog.this.g.setVisible(false);
                    CronJobSchedulerDialog.this.k.setVisible(true);
                    CronJobSchedulerDialog.this.m.setVisible(true);
                } else {
                    CronJobSchedulerDialog.this.k.setVisible(false);
                    CronJobSchedulerDialog.this.m.setVisible(false);
                    CronJobSchedulerDialog.this.f.setVisible(true);
                    CronJobSchedulerDialog.this.g.setVisible(true);
                }
                CronJobSchedulerDialog.this.s.setVisible(false);
                if (reportFrequency.equals((Object)ReportFrequency.WEEKLY)) {
                    int n = StoreUtil.getStartDayOfWeek(DataProvider.get().getStore());
                    String string = Messages.getString("CronJobSchedulerDialog.3") + (Object)((Object)DayOfWeek.getDayOfWeek(n)) + Messages.getString("CronJobSchedulerDialog.6");
                    CronJobSchedulerDialog.this.s.setText(string);
                    CronJobSchedulerDialog.this.s.setVisible(true);
                } else if (reportFrequency.equals((Object)ReportFrequency.MONTHLY)) {
                    String string = Messages.getString("CronJobSchedulerDialog.3") + Messages.getString("CronJobSchedulerDialog.8");
                    CronJobSchedulerDialog.this.s.setText(string);
                    CronJobSchedulerDialog.this.s.setVisible(true);
                }
            }
        };
    }

    public void setOperationButtonText(String string) {
        this.r = string;
        if (string.equalsIgnoreCase(POSConstants.ADD) || string.equalsIgnoreCase(POSConstants.EDIT)) {
            this.h.setText(POSConstants.SAVE);
        } else {
            this.h.setText(string);
        }
    }

    private void a(JPanel jPanel) {
        if (this.j != null) {
            jPanel.add((Component)this.j, "newline,span,wrap,growx");
        }
    }

    public void renderCronJobPlugins(CronJob cronJob) {
        this.q = cronJob;
        this.b();
    }

    private void b() {
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        List<FloreantPlugin> list = ExtensionManager.getPlugins(CronJobPlugin.class);
        Comparator<FloreantPlugin> comparator = Comparator.comparing(FloreantPlugin::getProductName, Comparator.nullsLast(Comparator.reverseOrder()));
        list.sort(comparator);
        if (this.q == null) {
            list.forEach(floreantPlugin -> {
                CronJobPlugin cronJobPlugin;
                if (floreantPlugin instanceof CronJobPlugin && (cronJobPlugin = (CronJobPlugin)floreantPlugin).isExplorable()) {
                    cronJobPlugin.setCronJob(this.q);
                    defaultComboBoxModel.addElement((CronJobPlugin)floreantPlugin);
                }
            });
        } else {
            list.forEach(floreantPlugin -> {
                if (floreantPlugin instanceof CronJobPlugin && floreantPlugin.getId().trim().equals(this.q.getJobId().trim())) {
                    ((CronJobPlugin)floreantPlugin).setCronJob(this.q);
                    defaultComboBoxModel.addElement((CronJobPlugin)floreantPlugin);
                    this.l.setSelected(this.q.isActive());
                    this.e.setSelectedItem((Object)ReportFrequency.fromKey(this.q.getFrequency()));
                    if (this.e.getSelectedItem().equals((Object)ReportFrequency.EVERY)) {
                        String[] stringArray = new String[]{"MINUTE", "HOUR"};
                        if (this.q.isExecutionTimeValid()) {
                            if (Integer.parseInt((String)this.b(this.q.getExecutionTime())) == -1) {
                                this.m.setSelectedIndex(Arrays.asList(stringArray).indexOf("MINUTE"));
                                this.k.setText(this.a(this.q.getExecutionTime()).toString());
                            } else if (Integer.parseInt((String)this.a(this.q.getExecutionTime())) == -1) {
                                this.m.setSelectedIndex(Arrays.asList(stringArray).indexOf("HOUR"));
                                this.k.setText(this.b(this.q.getExecutionTime()).toString());
                            }
                        } else {
                            this.m.setSelectedIndex(Arrays.asList(stringArray).indexOf("MINUTE"));
                        }
                    } else {
                        this.f.setSelectedItem(this.b(this.q.getExecutionTime()));
                        this.g.setSelectedItem(this.a(this.q.getExecutionTime()));
                    }
                }
            });
        }
        this.d.setModel(defaultComboBoxModel);
        this.d.setSelectedItem(defaultComboBoxModel.getElementAt(0));
    }

    private void c() throws Exception {
        int n;
        Store store;
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin instanceof EmailReportJobPlugin && !StoreUtil.isStoreOpeningHourConfigured(store = DataProvider.get().getStore()) && (n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("CronJobSchedulerDialog.9"), POSConstants.CONFIRM)) == 0) {
            StoreConfigurationDialog storeConfigurationDialog = new StoreConfigurationDialog(true);
            storeConfigurationDialog.setSize(PosUIManager.getSize((int)666, (int)600));
            storeConfigurationDialog.setCanceledButtonVisible(false);
            storeConfigurationDialog.open();
            if (!storeConfigurationDialog.isCanceled()) {
                int n2 = StoreUtil.getStartDayOfWeek(DataProvider.get().getStore());
                String string = Messages.getString("CronJobSchedulerDialog.3") + (Object)((Object)DayOfWeek.getDayOfWeek(n2)) + Messages.getString("CronJobSchedulerDialog.6");
                this.s.setText(string);
            }
        }
        this.j.removeAll();
        if (cronJobPlugin == null) {
            return;
        }
        if (cronJobPlugin.getConfigurationPane() != null) {
            this.j.add(cronJobPlugin.getConfigurationPane());
        }
        cronJobPlugin.initializeConfigurationPaneByProperties();
        this.revalidate();
        this.repaint();
    }

    private void d() throws PosException {
        Object object;
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin != null) {
            cronJobPlugin.validateRequireFields();
        }
        if (!(object = this.e.getSelectedItem()).equals((Object)ReportFrequency.EVERY)) {
            return;
        }
        if (StringUtils.isBlank((String)this.k.getText())) {
            throw new PosException(Messages.getString("CronJobSchedulerDialog.1"));
        }
        int n = Integer.valueOf(this.k.getText());
        if (n <= 0) {
            throw new PosException(Messages.getString("CronJobSchedulerDialog.2"));
        }
    }

    private ActionListener e() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CronJobSchedulerDialog.this.c();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        };
    }

    private ActionListener f() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CronJobSchedulerDialog.this.d();
                    int n = -1;
                    if (CronJobSchedulerDialog.this.r.equals(POSConstants.ADD)) {
                        n = 0;
                    } else if (CronJobSchedulerDialog.this.r.equals(POSConstants.EDIT)) {
                        n = 1;
                    } else if (CronJobSchedulerDialog.this.r.equals(POSConstants.DELETE)) {
                        n = 2;
                    }
                    switch (n) {
                        case 0: {
                            CronJobSchedulerDialog.this.j();
                            break;
                        }
                        case 1: {
                            CronJobSchedulerDialog.this.i();
                            break;
                        }
                        case 2: {
                            CronJobSchedulerDialog.this.h();
                            break;
                        }
                        default: {
                            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CronJobSchedulerDialog.117"));
                            return;
                        }
                    }
                    CronJobSchedulerDialog.this.setCanceled(false);
                    CronJobSchedulerDialog.this.dispose();
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        };
    }

    private ActionListener g() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CronJobSchedulerDialog.this.setCanceled(true);
                    CronJobSchedulerDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        };
    }

    private void h() {
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin != null && ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
            try {
                this.p = false;
                this.p = OroCronJobManager.getInstance().deleteJob(cronJobPlugin.convertToActualCronJob());
                if (this.p) {
                    this.setCanceled(true);
                    this.dispose();
                }
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private void i() {
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin == null) {
            return;
        }
        try {
            cronJobPlugin.getCronJob().setExecutionTime(this.k());
            ReportFrequency reportFrequency = (ReportFrequency)((Object)this.e.getSelectedItem());
            cronJobPlugin.getCronJob().setFrequency(reportFrequency.getKey().toUpperCase());
            cronJobPlugin.getCronJob().setLastUpdateTime(new Date());
            cronJobPlugin.getCronJob().setActive(this.l.isSelected());
            cronJobPlugin.updatePropertiesFromConfigurationPane();
            this.o = false;
            this.o = OroCronJobManager.getInstance().reScheduleJob(cronJobPlugin.convertToActualCronJob());
            if (this.o) {
                this.q = cronJobPlugin.getCronJob();
                this.setCanceled(true);
                this.dispose();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void j() {
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin == null) {
            return;
        }
        try {
            cronJobPlugin.setCronJob(this.getCronJob());
            cronJobPlugin.updatePropertiesFromConfigurationPane();
            this.n = false;
            this.n = OroCronJobManager.getInstance().scheduleJob(cronJobPlugin.convertToActualCronJob());
            if (this.n) {
                this.setCanceled(true);
                this.dispose();
            }
            this.q = cronJobPlugin.getCronJob();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public CronJob getScheduledCronJob() {
        return this.q;
    }

    public CronJob getReScheduledCronJob() {
        return this.q;
    }

    public boolean isDeleted() {
        return this.p;
    }

    public boolean isReScheduled() {
        return this.o;
    }

    public boolean isScheduled() {
        return this.n;
    }

    public CronJob getCronJob() throws Exception {
        CronJob cronJob = null;
        CronJobPlugin cronJobPlugin = (CronJobPlugin)this.d.getSelectedItem();
        if (cronJobPlugin != null) {
            cronJob = new CronJob();
            cronJob.setId(GlobalIdGenerator.generateGlobalId());
            ReportFrequency reportFrequency = (ReportFrequency)((Object)this.e.getSelectedItem());
            cronJob.setFrequency(reportFrequency.getKey());
            cronJob.setExecutionTime(this.k());
            cronJob.setJobName(cronJobPlugin.getProductName());
            cronJob.setJobId(cronJobPlugin.getId());
            cronJob.setLastUpdateTime(new Date());
            cronJob.setLastSyncTime(cronJob.getLastUpdateTime());
            cronJob.setActive(this.l.isSelected());
        }
        return cronJob;
    }

    private Object a(String string) {
        return string.split(":")[1];
    }

    private Object b(String string) {
        return string.split(":")[0];
    }

    private String k() {
        String string = "0:0";
        if (this.e.getSelectedItem().equals((Object)ReportFrequency.EVERY)) {
            if (this.m.getSelectedItem().toString().equalsIgnoreCase("MINUTE")) {
                string = "-1:" + this.k.getText().trim();
            } else if (this.m.getSelectedItem().toString().equalsIgnoreCase("HOUR")) {
                string = this.k.getText().trim() + ":-1";
            }
        } else {
            string = this.f.getSelectedItem() + ":" + this.g.getSelectedItem();
        }
        return string;
    }
}

