/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardGeneratorView
extends OkCancelOptionDialog {
    private IntegerTextField a;
    private DoubleTextField b;
    private IntegerTextField c;
    private JComboBox d;
    private FixedLengthTextField e;
    private List<GiftCard> f;
    private FixedLengthTextField g;
    private boolean h;
    private POSTextField i;
    private JLabel j;
    private JLabel k;

    public GiftCardGeneratorView() {
        this(false);
    }

    public GiftCardGeneratorView(boolean bl) {
        super((Window)POSUtil.getBackOfficeWindow(), "");
        this.h = bl;
        this.a();
    }

    public GiftCardGeneratorView(JFrame jFrame) {
        this.initUI();
    }

    private void a() {
        this.setSize(PosUIManager.getSize((int)830, (int)550));
        this.setCaption(Messages.getString("GiftCardGeneratorView.1"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.b();
        jPanel.add(jPanel2);
        this.setOkButtonText(Messages.getString("Generate"));
        this.setCancelButtonText(POSConstants.CLOSE);
        this.c();
    }

    @Override
    public Boolean isShowKeybord() {
        return true;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,aligny center", "[][]", ""));
        this.j = new JLabel(Messages.getString("GiftCardGeneratorView.0"));
        this.i = new POSTextField();
        this.k = new JLabel(Messages.getString("GiftCardGeneratorView.4"));
        this.a = new IntegerTextField();
        JLabel jLabel = new JLabel(Messages.getString("GiftCardGeneratorView.5"));
        this.b = new DoubleTextField();
        JLabel jLabel2 = new JLabel(Messages.getString("GiftCardGeneratorView.6"));
        this.c = new IntegerTextField(0, 3);
        this.d = new JComboBox();
        this.d.addItem("DAY");
        this.d.addItem("MONTH");
        this.d.addItem("YEAR");
        this.d.setSelectedItem("YEAR");
        this.e = new FixedLengthTextField(10);
        this.e.setLength(8);
        this.g = new FixedLengthTextField();
        this.g.setLength(32);
        this.c.setText("5");
        this.b.setText("0.00");
        String string = GiftCardGeneratorView.generateBatchNumber();
        this.g.setText("" + string);
        jPanel.add((Component)this.j, "alignx right");
        jPanel.add((Component)this.i, "growx,wrap");
        jPanel.add((Component)this.k, "alignx right");
        jPanel.add((Component)this.a, "growx,wrap");
        jPanel.add((Component)jLabel, "alignx right");
        jPanel.add((Component)this.b, "growx,wrap");
        jPanel.add((Component)new JLabel(Messages.getString("PinNumber")), "alignx right");
        jPanel.add((Component)this.e, "growx,wrap");
        jPanel.add((Component)new JLabel(Messages.getString("BatchNumber")), "alignx right");
        jPanel.add((Component)this.g, "growx,wrap");
        jPanel.add((Component)jLabel2, "alignx right");
        jPanel.add((Component)this.c, "growx");
        jPanel.add((Component)this.d, ",wrap");
        return jPanel;
    }

    private void c() {
        this.j.setVisible(this.h);
        this.i.setVisible(this.h);
        this.k.setVisible(!this.h);
        this.a.setVisible(!this.h);
    }

    public static String generateBatchNumber() {
        String string = String.valueOf((long)(Math.random() * 1.0E8));
        String string2 = "00000000";
        string = string2.substring(string.length()) + string;
        if (GiftCardDAO.getInstance().hasBatchNo(string)) {
            return GiftCardGeneratorView.generateBatchNumber();
        }
        return string;
    }

    public void doGenerate() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.d()) {
                GiftCardDAO.getInstance().saveAsList(this.f);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardGeneratorView.29"));
                this.dispose();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean d() throws Exception {
        int n = this.a.getInteger();
        if (!(this.h || this.a.getText() != null && n != 0)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.30"));
            return false;
        }
        if (!this.h && n > 100000) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.303"));
            return false;
        }
        String string = this.i.getText();
        if (this.h) {
            if (string == null || string.isEmpty()) {
                POSMessageDialog.showError(this, Messages.getString("EnterCardNumber"));
                return false;
            }
            if ((string = POSUtil.formatGiftCardNo(string)).length() > 16) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.2"));
                return false;
            }
            GiftCard giftCard = GiftCardDAO.getInstance().get(string);
            if (giftCard != null) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.3"));
                return false;
            }
        }
        if (StringUtils.isEmpty((String)this.b.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.31"));
            return false;
        }
        if (this.b.getDoubleOrZero() < 0.0) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardAddBalanceView.0"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.c.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.32"));
            return false;
        }
        int n2 = this.c.getInteger();
        if (n2 == 0) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.33"));
            return false;
        }
        String string2 = (String)this.d.getSelectedItem();
        if (StringUtils.isEmpty((String)string2)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.34"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.e.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.35"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.g.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.36"));
            return false;
        }
        this.f = new ArrayList<GiftCard>();
        if (!this.h) {
            this.e();
        } else {
            this.a(string);
        }
        return true;
    }

    private void a(String string) throws Exception {
        GiftCard giftCard = new GiftCard();
        giftCard.setCardNumber(string);
        giftCard.setBalance(this.b.getDouble());
        giftCard.setFaceValue(this.b.getDouble());
        giftCard.setPinNumber(this.e.getText());
        giftCard.setIssueDate(new Date());
        int n = this.c.getInteger();
        giftCard.setDuration(n);
        String string2 = (String)this.d.getSelectedItem();
        giftCard.setDurationType(string2);
        giftCard.setBatchNo(this.g.getText());
        this.a(giftCard, n, string2);
        this.f.add(giftCard);
    }

    private void a(GiftCard giftCard, int n, String string) {
        Calendar calendar = Calendar.getInstance();
        if (string != null) {
            if (string.equals("DAY")) {
                calendar.add(5, n);
            } else if (string.equals("MONTH")) {
                calendar.add(2, n);
            } else {
                calendar.add(1, n);
            }
        }
        Date date = calendar.getTime();
        giftCard.setExpiryDate(DateUtil.endOfDay(date));
    }

    private void e() throws Exception {
        int n = this.a.getInteger();
        for (int i = 0; i < n; ++i) {
            GiftCard giftCard = new GiftCard();
            String string = String.valueOf((long)(Math.random() * 1.0E16));
            String string2 = "0000000000000000";
            string = string2.substring(string.length()) + string;
            giftCard.setCardNumber(string);
            giftCard.setBalance(this.b.getDouble());
            giftCard.setFaceValue(this.b.getDouble());
            giftCard.setPinNumber(this.e.getText());
            giftCard.setIssueDate(new Date());
            int n2 = this.c.getInteger();
            giftCard.setDuration(n2);
            String string3 = (String)this.d.getSelectedItem();
            giftCard.setDurationType(string3);
            giftCard.setBatchNo(this.g.getText());
            this.a(giftCard, n2, string3);
            this.f.add(giftCard);
        }
    }

    @Override
    public void doOk() {
        this.doGenerate();
    }
}

