/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.GiftCardInfo;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.GiftCardActivateView;
import com.floreantpos.ui.views.GiftCardAddBalanceView;
import com.floreantpos.ui.views.GiftCardEditPinNumberView;
import com.floreantpos.ui.views.GiftCardTransactionInfoView;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardManagementView
extends POSDialog {
    private PosButton a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private GiftCardProcessor h;

    public GiftCardManagementView() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.b();
        this.a();
    }

    private void a() {
        GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
        this.h = giftCardPaymentPlugin.getProcessor();
        if (giftCardPaymentPlugin != null) {
            if (!this.h.supportActivation()) {
                this.a.setEnabled(false);
            }
            if (!this.h.supportDeActivation()) {
                this.b.setEnabled(false);
            }
            if (!this.h.supportDisable()) {
                this.d.setEnabled(false);
            }
            if (!this.h.supportPinNumberChange()) {
                this.f.setEnabled(false);
            }
            if (!this.h.supportShowTransaction()) {
                this.g.setEnabled(false);
            }
        }
    }

    public GiftCardManagementView(JFrame jFrame) {
        this.b();
        this.a();
    }

    private void b() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardManagementView.0"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        GiftCardProcessAction giftCardProcessAction = new GiftCardProcessAction();
        this.a = new PosButton(Messages.getString("Activate"), giftCardProcessAction, GiftCardActionCommand.ACTIVATE.getKey());
        this.b = new PosButton(Messages.getString("GiftCardManagementView.5"), giftCardProcessAction, GiftCardActionCommand.DEACTIVATE.getKey());
        this.c = new PosButton(Messages.getString("AddBalance"), giftCardProcessAction, GiftCardActionCommand.ADDBALANCE.getKey());
        this.d = new PosButton(Messages.getString("Disable"), giftCardProcessAction, GiftCardActionCommand.DISABLE.getKey());
        this.e = new PosButton(Messages.getString("CardInfo"), giftCardProcessAction, GiftCardActionCommand.CARDINFO.getKey());
        this.f = new PosButton(Messages.getString("EditPinNumber"), giftCardProcessAction, GiftCardActionCommand.EDITPINNUMBER.getKey());
        this.g = new PosButton(Messages.getString("Transactions"), giftCardProcessAction, GiftCardActionCommand.TRANSACTIONS.getKey());
        jPanel.add((Component)this.a, "cell 0 0, growx");
        jPanel.add((Component)this.c, "cell 1 0, growx");
        jPanel.add((Component)this.b, "cell 0 1, growx");
        jPanel.add((Component)this.d, "cell 1 1, growx");
        jPanel.add((Component)this.e, "cell 0 2, growx");
        jPanel.add((Component)this.f, "cell 1 2, growx");
        jPanel.add((Component)this.g, "cell 0 3, growx");
        this.add((Component)jPanel, "Center");
        PosButton posButton = new PosButton(new CloseDialogAction(this, Messages.getString("Close")));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel2.add((Component)posButton, "alignx center");
        this.add((Component)jPanel2, "South");
        this.a.setAction(giftCardProcessAction);
        this.c.setAction(giftCardProcessAction);
        this.b.setAction(giftCardProcessAction);
        this.d.setAction(giftCardProcessAction);
        this.e.setAction(giftCardProcessAction);
        this.f.setAction(giftCardProcessAction);
        this.g.setAction(giftCardProcessAction);
    }

    private void c() {
        if (!this.a(UserPermission.GIFT_CARD_ACTIVATION).booleanValue()) {
            return;
        }
        GiftCardActivateView giftCardActivateView = new GiftCardActivateView(this.h);
        giftCardActivateView.setDefaultCloseOperation(2);
        giftCardActivateView.setSize(PosUIManager.getSize((int)800, (int)600));
        giftCardActivateView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardActivateView.setVisible(true);
    }

    private Boolean a(UserPermission userPermission) {
        User user = Application.getCurrentUser();
        User user2 = user.getUserRoleWithPermission(userPermission);
        if (user2 == null) {
            User user3 = PasswordEntryDialog.getUser(Application.getPosWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
            if (user3 == null) {
                return false;
            }
            user2 = user3.getUserRoleWithPermission(userPermission);
            if (user2 == null) {
                POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
                return false;
            }
        }
        return true;
    }

    private void d() {
        GiftCardEditPinNumberView giftCardEditPinNumberView = new GiftCardEditPinNumberView(this.h);
        giftCardEditPinNumberView.setDefaultCloseOperation(2);
        giftCardEditPinNumberView.setSize(PosUIManager.getSize((int)800, (int)600));
        giftCardEditPinNumberView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardEditPinNumberView.setVisible(true);
    }

    private void e() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            GiftCardInfo giftCardInfo = new GiftCardInfo(giftCard);
            giftCardInfo.setDefaultCloseOperation(2);
            giftCardInfo.setSize(PosUIManager.getSize((int)620, (int)600));
            giftCardInfo.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardInfo.setVisible(true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void f() {
        try {
            if (!this.a(UserPermission.GIFT_CARD_ACTIVATION).booleanValue()) {
                return;
            }
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DisableCard"), Messages.getString("Disable"));
            if (n == 0) {
                if (giftCard.isDisable().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.15"));
                    return;
                }
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.h.disable(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("DisabledSuccessfully"));
                this.dispose();
                ActionHistory actionHistory = ActionHistory.create(null, "Disabled giftcard", "GiftCard number: " + giftCard.getCardNumber() + " ,GiftCard balance: " + giftCard.getBalance());
                ActionHistoryDAO.getInstance().saveOrUpdate(actionHistory);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void g() {
        GiftCardAddBalanceView giftCardAddBalanceView = new GiftCardAddBalanceView(this.h);
        giftCardAddBalanceView.setDefaultCloseOperation(2);
        giftCardAddBalanceView.setSize(PosUIManager.getSize((int)800, (int)500));
        giftCardAddBalanceView.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardAddBalanceView.setVisible(true);
    }

    private void h() {
        try {
            if (!this.a(UserPermission.GIFT_CARD_ACTIVATION).booleanValue()) {
                return;
            }
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DeactivateCard"), Messages.getString("Deactivation"));
            if (n == 0) {
                if (!giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.16"));
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.h.deactivate(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("CardDeactivatedSuccessfully"));
                this.dispose();
                ActionHistory actionHistory = ActionHistory.create(null, "Deactivated giftcard", "GiftCard number: " + giftCard.getCardNumber() + " ,GiftCard balance: " + giftCard.getBalance());
                ActionHistoryDAO.getInstance().saveOrUpdate(actionHistory);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private GiftCard i() {
        String string = this.k();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        GiftCard giftCard = this.h.getCard(string);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardNotFound"));
            return null;
        }
        if (StringUtils.isEmpty((String)string)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return null;
        }
        return giftCard;
    }

    private void j() {
        try {
            GiftCard giftCard = this.i();
            if (giftCard == null) {
                return;
            }
            GiftCardTransactionInfoView giftCardTransactionInfoView = new GiftCardTransactionInfoView(giftCard, this.h);
            giftCardTransactionInfoView.setTitle(VersionInfo.getAppName());
            giftCardTransactionInfoView.setDefaultCloseOperation(2);
            giftCardTransactionInfoView.setSize(PosUIManager.getSize((int)900, (int)600));
            giftCardTransactionInfoView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardTransactionInfoView.setVisible(true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private String k() {
        GlobalInputDialog globalInputDialog = new GlobalInputDialog();
        globalInputDialog.setCaption(Messages.getString("GiftCardManagementView.1"));
        globalInputDialog.setBlankErrorMessage(Messages.getString("GiftCardCannotBeEmpty"));
        globalInputDialog.open();
        if (globalInputDialog.isCanceled()) {
            return null;
        }
        String string = globalInputDialog.getInput();
        return string;
    }

    public static enum GiftCardActionCommand {
        ACTIVATE("Activate"),
        DEACTIVATE("Deactivate"),
        ADDBALANCE("AddBalance"),
        DISABLE("Disable"),
        CARDINFO("CardInfo"),
        EDITPINNUMBER("EditPinNumber"),
        TRANSACTIONS("Transactions");

        private String a;

        private GiftCardActionCommand(String string2) {
            this.a = string2;
        }

        public String getKey() {
            return this.a;
        }
    }

    private class GiftCardProcessAction
    extends PosAction {
        @Override
        public void execute() {
            ActionEvent actionEvent = super.getActionEvent();
            String string = actionEvent.getActionCommand();
            if (string.equals(GiftCardActionCommand.ACTIVATE.getKey())) {
                GiftCardManagementView.this.c();
            } else if (string.equals(GiftCardActionCommand.DEACTIVATE.getKey())) {
                GiftCardManagementView.this.h();
            } else if (string.equals(GiftCardActionCommand.ADDBALANCE.getKey())) {
                if (!GiftCardProcessAction.doCheckPermission(UserPermission.MANAGE_GIFT_CARD)) {
                    return;
                }
                if (!POSUtil.checkDrawerAssignment()) {
                    return;
                }
                GiftCardManagementView.this.g();
            } else if (string.equals(GiftCardActionCommand.DISABLE.getKey())) {
                if (!GiftCardProcessAction.doCheckPermission(UserPermission.MANAGE_GIFT_CARD)) {
                    return;
                }
                GiftCardManagementView.this.f();
            } else if (string.equals(GiftCardActionCommand.EDITPINNUMBER.getKey())) {
                if (!GiftCardProcessAction.doCheckPermission(UserPermission.MANAGE_GIFT_CARD)) {
                    return;
                }
                GiftCardManagementView.this.d();
            } else if (string.equals(GiftCardActionCommand.CARDINFO.getKey())) {
                if (!GiftCardProcessAction.doCheckPermission(UserPermission.MANAGE_GIFT_CARD)) {
                    return;
                }
                GiftCardManagementView.this.e();
            } else if (string.equals(GiftCardActionCommand.TRANSACTIONS.getKey())) {
                if (!GiftCardProcessAction.doCheckPermission(UserPermission.MANAGE_GIFT_CARD)) {
                    return;
                }
                GiftCardManagementView.this.j();
            }
        }
    }
}

