/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.OrderTypeLoginButton;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PinEntryView;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.ClockInOutDialog3;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftException;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.util.UserNotFoundException;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.border.MatteBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LoginView
extends ViewPanel {
    public static final String VIEW_NAME = "LOGIN_VIEW";
    private PosButton a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private JPanel i = new JPanel();
    private static LoginView j;
    private JPanel k;
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel m = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel n = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private int o;
    private int p;
    private JPanel q;
    private JPanel r;
    private JLabel s;
    private ButtonGroup t = new ButtonGroup();
    private boolean u = DataProvider.get().getCurrentTerminal().isAutoLoginEnable();

    private LoginView() {
        this.b();
    }

    private void b() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.o = PosUIManager.getSize((int)600);
        this.p = PosUIManager.getSize((int)100);
        this.i.setLayout((LayoutManager)new MigLayout("hidemode 3, al center center", "sg fill", String.valueOf(this.p)));
        this.i.setOpaque(false);
        JLabel jLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        this.s = new JLabel();
        this.s.setOpaque(true);
        this.s.setFont(this.s.getFont().deriveFont(1, PosUIManager.getFontSize((int)16)));
        this.s.setHorizontalAlignment(0);
        this.s.setBackground(Color.WHITE);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("ins 0, fill, hidemode 3"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(String.format("fillx,align center,insets %s 0 0 %s", PosUIManager.getSize((int)5), PosUIManager.getSize((int)5)), "[25%][][25%]"));
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)jLabel, "align left");
        jPanel.add((Component)this.s, "align center");
        jPanel.add((Component)transparentPanel, "wrap, align right, growy");
        jPanel.add((Component)new JSeparator(0), String.format("growx, span, gaptop %s", PosUIManager.getSize((int)5)));
        this.add((Component)jPanel, "North");
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add(this.c());
        this.add(transparentPanel2);
        int n = PosUIManager.getSize((int)50);
        this.g.setToolTipText(this.g.getText());
        this.g.setText("");
        transparentPanel.add((Component)this.g, "w " + n + "!, h " + n + "!");
        this.b.setVisible(DataProvider.get().getStore().isKDSenabled() && DataProvider.get().getCurrentTerminal().isShowKDSOnLogInScreen());
        this.c.setVisible(DataProvider.get().getStore().isKDSenabled() && DataProvider.get().getCurrentTerminal().isShowKDSOnLogInScreen());
        this.e.setVisible(!TerminalConfig.isKioskMode() && DataProvider.get().getCurrentTerminal().isShowDbConfig() != false);
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3, center"));
        transparentPanel3.add((Component)this.b, "h " + n + "!");
        transparentPanel3.add((Component)this.c, "h " + n + "!");
        if (this.u) {
            transparentPanel3.add((Component)this.h, "h " + n + "!");
            transparentPanel3.add((Component)this.e, "h " + n + "!");
            transparentPanel3.add((Component)this.f, "h " + n + "!");
        } else {
            transparentPanel3.add((Component)this.e, "h " + n + "!");
        }
        transparentPanel2.add((Component)transparentPanel3, "South");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Store store = DataProvider.get().getStore();
        if (store == null) {
            return;
        }
        ImageIcon imageIcon = store.getLoginScreenBackground();
        if (imageIcon == null) {
            return;
        }
        Image image = imageIcon.getImage();
        Dimension dimension = this.getSize();
        graphics.drawImage(image, 0, 0, dimension.width, dimension.height, null);
    }

    private JPanel c() {
        OrderServiceExtension orderServiceExtension;
        this.k = new JPanel(new BorderLayout());
        this.k.setOpaque(false);
        this.a = new PosButton(POSConstants.ORDERS);
        this.b = new PosButton(POSConstants.KITCHEN_DISPLAY_BUTTON_TEXT);
        this.b.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.KITCHEN, (float)PosUIManager.getSize((int)25)));
        this.c = new PosButton(Messages.getString("KitchenDisplayDispatchWindow.0"));
        this.c.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.KITCHEN, (float)PosUIManager.getSize((int)25), (Color)Color.GREEN.darker()));
        this.d = new PosButton(Messages.getString("LoginView.7"));
        this.e = new PosButton(POSConstants.CONFIGURE_DATABASE);
        this.f = new PosButton(POSConstants.BACK_OFFICE_BUTTON_TEXT);
        this.a.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.VIEW_LIST, (float)PosUIManager.getSize((int)25)));
        this.e.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.SERVER, (float)PosUIManager.getSize((int)25)));
        this.d.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.TRUCK, (float)PosUIManager.getSize((int)25)));
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SETTINGS, (float)PosUIManager.getSize((int)25)));
        this.g = new PosButton(POSConstants.SHUTDOWN);
        this.h = new PosButton(new ClockInOutAction(true, true));
        this.f.setVisible(false);
        this.a.setVisible(false);
        this.b.setVisible(false);
        this.c.setVisible(false);
        this.h.setVisible(false);
        this.q = new JPanel(new GridLayout(1, 0, 5, 5));
        this.r = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
        this.i.add((Component)this.l, "cell 0 0, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.q.add(this.a);
        if (DataProvider.get().getCurrentTerminal().isShowKDSOnLogInScreen()) {
            this.q.add(this.b);
            this.q.add(this.c);
        }
        if ((orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class)) != null) {
            this.q.add(this.d);
            this.d.setVisible(false);
        }
        this.i.add((Component)this.q, "cell 0 2, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.i.add((Component)this.r, "cell 0 3, wrap, w " + this.o + "px, h " + this.p + "px, grow");
        this.e.setVisible(true);
        this.l.setOpaque(false);
        this.m.setOpaque(false);
        this.n.setOpaque(false);
        this.q.setOpaque(false);
        this.r.setOpaque(false);
        this.a();
        this.k.add((Component)this.i, "Center");
        return this.k;
    }

    public void initializeOrderButtonPanel() {
        if (!this.u) {
            Store store = DataProvider.get().getStore();
            StoreUtil storeUtil = new StoreUtil();
            if (store != null && StringUtils.isNotEmpty((String)storeUtil.getName(store))) {
                this.s.setText(storeUtil.getName(store));
            }
            this.d();
            return;
        }
        if (this.e()) {
            Dimension dimension = this.b.getPreferredSize();
            dimension.width = 300;
            this.b.setPreferredSize(dimension);
            this.c.setPreferredSize(dimension);
            this.i.removeAll();
            JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill,ins 0"));
            jPanel.add((Component)this.b, "grow");
            jPanel.add((Component)this.c, "grow");
            this.i.add((Component)jPanel, "wrap, span, grow");
            this.b.setVisible(true);
            this.c.setVisible(true);
            this.f.setVisible(true);
        } else {
            this.l.removeAll();
            this.m.removeAll();
            this.n.removeAll();
            Store store = DataProvider.get().getStore();
            StoreUtil storeUtil = new StoreUtil();
            if (store != null && StringUtils.isNotEmpty((String)storeUtil.getName(store))) {
                this.s.setText(storeUtil.getName(store));
            }
            List<OrderType> list = Application.getInstance().getOrderTypes();
            int n = 0;
            int n2 = (list = list.stream().filter(orderType -> orderType.isShowInLoginScreen() != false && orderType.isEnabled() != false && orderType.isDeleted() == false).collect(Collectors.toList())).size();
            int n3 = n2 < 10 ? 3 : 5;
            n = this.a(list, n, n3);
            int n4 = 1;
            this.i.add((Component)this.l, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
            if (n > n3) {
                this.i.add((Component)this.m, "cell 0 " + n4++ + ", wrap,w " + this.o + "px, h " + this.p + "px, grow");
            }
            if (n > n3 * 2) {
                this.i.add((Component)this.n, "cell 0 " + n4++ + ", wrap,w " + this.o + "px, h " + this.p + "px, grow");
            }
            this.a.setVisible(true);
            this.b.setVisible(true);
            this.c.setVisible(true);
            this.f.setVisible(true);
            this.h.setVisible(true);
            Outlet outlet = DataProvider.get().getOutlet();
            if (!outlet.getBooleanProperty("enable_login_derver_button", true).booleanValue()) {
                this.q.remove(this.d);
            } else {
                this.d.setVisible(true);
            }
            this.i.add((Component)this.q, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
            this.i.add((Component)this.r, "cell 0 " + n4++ + ", wrap, w " + this.o + "px, h " + this.p + "px, grow");
        }
        if (!TerminalConfig.isKioskMode() && DataProvider.get().getCurrentTerminal().isShowDbConfig().booleanValue()) {
            this.e.setVisible(true);
        } else {
            this.e.setVisible(false);
        }
        this.i.revalidate();
        this.i.repaint();
    }

    private int a(List<OrderType> list, int n, int n2) {
        for (OrderType orderType : list) {
            if (!orderType.isShowInLoginScreen().booleanValue() || !orderType.isEnabled().booleanValue()) continue;
            if (n < n2) {
                this.l.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else if (n < n2 * 2) {
                this.m.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else {
                this.n.add((Component)new OrderTypeLoginButton(orderType), "grow");
            }
            ++n;
        }
        return n;
    }

    private void d() {
        POSToggleButton pOSToggleButton;
        this.i.removeAll();
        this.i.setLayout((LayoutManager)new MigLayout("ins 0, center"));
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(1, 0, 0, 0));
        POSToggleButton pOSToggleButton2 = new POSToggleButton(this.a.getText());
        pOSToggleButton2.setIcon(this.a.getIcon());
        pOSToggleButton2.setActionCommand(SwitchboardView.VIEW_NAME);
        pOSToggleButton2.setSelected(true);
        this.t.add(pOSToggleButton2);
        transparentPanel.add((Component)pOSToggleButton2, "growx");
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        Outlet outlet = DataProvider.get().getOutlet();
        if (orderServiceExtension != null && outlet.getBooleanProperty("enable_login_derver_button", true).booleanValue()) {
            pOSToggleButton = new POSToggleButton(this.d.getText());
            pOSToggleButton.setIcon(this.d.getIcon());
            this.t.add(pOSToggleButton);
            transparentPanel.add((Component)pOSToggleButton, "growx");
        }
        this.a.setVisible(true);
        this.f.setVisible(true);
        this.h.setVisible(true);
        pOSToggleButton = new POSToggleButton(this.h.getText());
        pOSToggleButton.setIcon(this.h.getIcon());
        this.t.add(pOSToggleButton);
        transparentPanel.add((Component)pOSToggleButton, "growx");
        POSToggleButton pOSToggleButton3 = new POSToggleButton(this.f.getText());
        pOSToggleButton3.setIcon(this.f.getIcon());
        this.t.add(pOSToggleButton3);
        transparentPanel.add((Component)pOSToggleButton3, "growx");
        Color color = Color.GRAY.brighter();
        Component[] componentArray = transparentPanel.getComponents();
        if (componentArray.length > 1) {
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof JToggleButton)) continue;
                MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, color);
                if (i == componentArray.length - 1) {
                    matteBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, color);
                }
                ((JToggleButton)component).setBorder(matteBorder);
            }
        }
        PinEntryView pinEntryView = new PinEntryView(){

            @Override
            protected synchronized boolean checkLogin(String string) {
                boolean bl = super.checkLogin(string);
                if (bl && this.user != null) {
                    AbstractButton abstractButton2 = Collections.list(LoginView.this.t.getElements()).stream().filter(abstractButton -> abstractButton.isSelected()).findFirst().orElse(null);
                    this.doClearAll();
                    if (abstractButton2 == null) {
                        POSMessageDialog.showError(Messages.getString("LoginView.10"));
                        return bl;
                    }
                    String string2 = abstractButton2.getActionCommand();
                    if (StringUtils.isBlank((String)string2)) {
                        abstractButton2.doClick();
                    } else if (string2.equals(LoginView.this.d.getText())) {
                        LoginView.this.a(false);
                    } else {
                        if (string2.equals(LoginView.this.h.getText())) {
                            POSDialog pOSDialog = ClockInOutDialog3.getInstance(this.user, false);
                            pOSDialog.openUndecoratedFullScreen();
                            return bl;
                        }
                        if (string2.equals(LoginView.this.f.getText())) {
                            LoginView.this.doBackofficeLogin(this.user);
                            return bl;
                        }
                        TerminalConfig.setDefaultView(string2);
                    }
                    LoginView.this.doLogin(this.user);
                }
                return bl;
            }
        };
        pinEntryView.addTopButtons(componentArray);
        this.i.add((Component)pinEntryView, "newline, center, push");
        this.i.revalidate();
        this.i.repaint();
    }

    public void updateView() {
        this.k.repaint();
    }

    void a() {
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doBackofficeLogin();
            }
        });
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView("KD");
                RootView.getInstance().showDefaultView();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView("DISPATCH_KD");
                RootView.getInstance().showDefaultView();
            }
        });
        this.d.addActionListener(actionEvent -> this.a(true));
        this.g.setAction(new ShutDownAction(true, true));
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doLogin();
            }
        });
    }

    public synchronized void doLogin() {
        this.doLogin(null);
    }

    public synchronized void doLogin(User user) {
        try {
            Serializable serializable;
            if (user == null) {
                serializable = Application.getInstance().refreshAndGetTerminal();
                if (((Terminal)serializable).isAutoLoginEnable()) {
                    user = UserDAO.getInstance().get(((Terminal)serializable).getAutoLoginUserId());
                    if (user == null) {
                        user = PasswordEntryDialog.getUser(POSUtil.getFocusedWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
                    }
                } else {
                    user = PasswordEntryDialog.getUser(POSUtil.getFocusedWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
                }
                if (user == null) {
                    return;
                }
            }
            if (!user.isClockedIn().booleanValue()) {
                serializable = ClockInOutDialog3.getInstance(user, true);
                ((POSDialog)serializable).openUndecoratedFullScreen();
                if (!user.isClockedIn().booleanValue()) {
                    return;
                }
            }
            Application.getInstance().doLogin(user);
        }
        catch (UserNotFoundException userNotFoundException) {
            POSMessageDialog.showError(Messages.getString("LoginView.3"));
        }
        catch (ShiftException shiftException) {
            POSMessageDialog.showError(shiftException.getMessage());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.contains("Cannot open connection")) {
                POSMessageDialog.showError(Messages.getString("LoginView.4"), exception);
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
            POSMessageDialog.showError(Messages.getString("LoginView.5"), exception);
        }
    }

    public synchronized void doBackofficeLogin() {
        this.doBackofficeLogin(null);
    }

    public synchronized void doBackofficeLogin(User user) {
        if (user == null) {
            user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
        }
        if (user == null) {
            return;
        }
        User user2 = user.getUserRoleWithPermission(UserPermission.VIEW_BACK_OFFICE);
        if (user2 == null) {
            POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
            return;
        }
        Application.getInstance().setCurrentUser(user2);
        PosWindow posWindow = Application.getPosWindow();
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow == null) {
            backOfficeWindow = new BackOfficeWindow(user2, true);
        }
        backOfficeWindow.addWindowListener(new BackofficeWindowCloseListener(backOfficeWindow));
        posWindow.setVisible(false);
        backOfficeWindow.setVisible(true);
        backOfficeWindow.toFront();
    }

    public void setTerminalId(int n) {
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static LoginView getInstance() {
        if (j == null) {
            j = new LoginView();
        }
        return j;
    }

    public JPanel getCenterPanel() {
        return this.i;
    }

    public JPanel getMainPanel() {
        return this.k;
    }

    private boolean e() {
        Application application = Application.getInstance();
        OroLicense oroLicense = application.getLicense();
        return oroLicense.isKdsOnly();
    }

    private void a(boolean bl) {
        IView iView = OrderServiceFactory.getOrderService().getDriverView();
        if (iView == null) {
            return;
        }
        if (!RootView.getInstance().hasView(iView)) {
            RootView.getInstance().addView(iView);
        }
        TerminalConfig.setDefaultView(iView.getViewName());
        if (bl) {
            this.doLogin();
        }
    }

    class BackofficeWindowCloseListener
    extends WindowAdapter {
        private BackOfficeWindow b;

        public BackofficeWindowCloseListener(BackOfficeWindow backOfficeWindow) {
            this.b = backOfficeWindow;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            super.windowClosing(windowEvent);
            this.b.removeWindowListener(this);
            PosWindow posWindow = Application.getPosWindow();
            posWindow.setVisible(true);
        }
    }
}

