/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.MultipleNumberSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.actions.SplitItemSelectionListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketSplitView
extends TransparentPanel
implements TableModelListener {
    private Ticket a;
    public static final String VIEW_NAME = "TICKET_FOR_SPLIT_VIEW";
    private TicketSplitView b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private JScrollPane h;
    private JTextField i;
    private JTextField j;
    private JTextField k;
    private JTextField l;
    private TicketViewerTable m;
    private int n = 1;
    protected int splitNumber;
    private SplitItemSelectionListener o;
    private PosButton p;
    private int q;
    private int r;
    private List<Integer> s;
    private JPanel t;
    private JLabel u;
    private PosButton v;

    public TicketSplitView(SplitItemSelectionListener splitItemSelectionListener) {
        this.o = splitItemSelectionListener;
        this.a();
        this.setOpaque(true);
        this.setTicket(this.a);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, POSConstants.TICKET, 2, 0));
        this.setPreferredSize(PosUIManager.getSize((int)280, (int)463));
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        transparentPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        int n = PosUIManager.getSize((int)60) + 10;
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 " + n + " "));
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        JLabel jLabel = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel jLabel2 = new JLabel(POSConstants.TOTAL + ":");
        JLabel jLabel3 = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel jLabel4 = new JLabel(POSConstants.TAX + ":");
        this.j = new JTextField();
        this.j.setHorizontalAlignment(11);
        this.j.setColumns(10);
        this.k = new JTextField();
        this.k.setHorizontalAlignment(11);
        this.k.setColumns(10);
        this.i = new JTextField();
        this.i.setHorizontalAlignment(11);
        this.i.setColumns(10);
        this.l = new JTextField();
        this.l.setHorizontalAlignment(11);
        this.l.setColumns(10);
        this.d = new PosButton();
        this.c = new PosButton();
        this.e = new PosButton();
        this.h = new JScrollPane();
        this.m = new TicketViewerTable();
        jLabel.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel);
        this.j.setEditable(false);
        transparentPanel2.add(this.j);
        jLabel3.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel3);
        this.i.setEditable(false);
        transparentPanel2.add(this.i);
        jLabel4.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel4);
        this.k.setEditable(false);
        transparentPanel2.add(this.k);
        jLabel2.setHorizontalAlignment(4);
        transparentPanel2.add(jLabel2);
        this.l.setEditable(false);
        transparentPanel2.add(this.l);
        this.d.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.d.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.b(actionEvent);
            }
        });
        transparentPanel3.add((Component)this.d, "grow");
        this.c.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.c.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.a(actionEvent);
            }
        });
        transparentPanel3.add((Component)this.c, "grow");
        this.e.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.a(1);
            }
        });
        transparentPanel3.add((Component)this.e, "grow");
        this.f = new PosButton();
        this.f.setText("1/2");
        this.f.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.f.setFont(new Font("Tahoma", 1, PosUIManager.getSize((int)18)));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.a(0);
            }
        });
        transparentPanel3.add((Component)this.f, "grow");
        this.g = new PosButton(">>>");
        this.g.setFont(new Font("Tahoma", 1, PosUIManager.getSize((int)18)));
        this.g.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.a(2);
            }
        });
        transparentPanel3.add((Component)this.g, "grow");
        this.p = new PosButton("...");
        this.p.setFont(new Font("Tahoma", 1, PosUIManager.getSize((int)18)));
        this.p.setPreferredSize(PosUIManager.getSize((int)60, (int)50));
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.a(3);
            }
        });
        transparentPanel3.add((Component)this.p, "grow");
        this.h.setHorizontalScrollBarPolicy(31);
        this.h.setVerticalScrollBarPolicy(21);
        this.h.setViewportView(this.m);
        transparentPanel.add((Component)this.h, "Center");
        this.add((Component)transparentPanel3, "East");
        this.add((Component)transparentPanel2, "South");
        this.add((Component)transparentPanel, "Center");
    }

    private void b() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.red);
        this.v = new PosButton(Messages.getString("TicketSplitView.0"));
        this.u = new JLabel();
        this.t = new JPanel((LayoutManager)new MigLayout("", "", "grow"));
        JLabel jLabel = new JLabel(Messages.getString("TicketSplitView.4"));
        this.t.add(jLabel);
        this.t.add((Component)this.u, "grow");
        jPanel.add((Component)this.t, "Center");
        jPanel.add((Component)this.v, "East");
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSplitView.this.c();
            }
        });
        this.add((Component)jPanel, "North");
    }

    private void a(int n) {
        try {
            int n2;
            ITicketItem iTicketItem;
            if (this.b != null && this.b.isVisible() && (iTicketItem = this.m.get(n2 = this.m.getSelectedRow())) instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                double d = ticketItem.getQuantity();
                double d2 = 1.0;
                if (n == 1) {
                    if (d < 1.0) {
                        d2 = d;
                    }
                } else if (n == 0) {
                    d2 = d / 2.0;
                } else if (n == 3) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < this.r; ++i) {
                        arrayList.add(i + 1);
                    }
                    if (arrayList.size() < 2) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketSplitView.6"));
                        return;
                    }
                    MultipleNumberSelectionDialog multipleNumberSelectionDialog = new MultipleNumberSelectionDialog(arrayList);
                    multipleNumberSelectionDialog.pack();
                    multipleNumberSelectionDialog.open();
                    if (multipleNumberSelectionDialog.isCanceled()) {
                        return;
                    }
                    this.s = multipleNumberSelectionDialog.getViewNumbers();
                    if (this.s == null || this.s.isEmpty()) {
                        return;
                    }
                }
                if (ticketItem.isService().booleanValue()) {
                    POSMessageDialog.showMessage(Messages.getString("TicketSplitView.1"));
                    return;
                }
                this.o.itemSelected(ticketItem, this, this.b, n, d2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void allowCustomerSelection(boolean bl) {
        if (bl) {
            this.b();
        }
    }

    public int getNoOfCustomSplit() {
        return this.q;
    }

    public List<Integer> getViewNumbers() {
        return this.s;
    }

    private void a(ActionEvent actionEvent) {
        this.m.scrollDown();
    }

    private void b(ActionEvent actionEvent) {
        this.m.scrollUp();
    }

    public void updateModel() {
        this.a.calculatePrice();
    }

    public void updateView() {
        if (this.a == null || this.a.getTicketItems() == null || this.a.getTicketItems().size() <= 0) {
            this.j.setText("");
            this.i.setText("");
            this.k.setText("");
            this.l.setText("");
            if (this.a != null && this.t != null) {
                Customer customer = this.a.getCustomer();
                if (customer != null) {
                    this.a(customer);
                } else {
                    this.u.setText(this.a.getProperty("CUSTOMER_NAME"));
                }
            }
            return;
        }
        this.a.calculatePrice();
        if (this.t != null) {
            Customer customer = this.a.getCustomer();
            if (customer != null) {
                this.a(customer);
            } else {
                this.u.setText(this.a.getProperty("CUSTOMER_NAME"));
            }
        }
        this.j.setText(NumberUtil.formatNumber(this.a.getSubtotalAmount()));
        this.i.setText(NumberUtil.formatNumber(this.a.getDiscountAmount()));
        this.k.setText(NumberUtil.formatNumber(this.a.getTaxAmount()));
        this.l.setText(NumberUtil.formatNumber(this.a.getTotalAmountWithTips()));
    }

    public Ticket getTicket() {
        return this.a;
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
        this.m.setTicket(ticket);
        this.updateView();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.a == null || this.a.getTicketItems() == null || this.a.getTicketItems().size() <= 0) {
            this.j.setText("");
            this.i.setText("");
            this.k.setText("");
            this.l.setText("");
            return;
        }
        this.a.calculatePrice();
        this.j.setText(NumberUtil.formatNumber(this.a.getSubtotalAmount()));
        this.i.setText(NumberUtil.formatNumber(this.a.getDiscountAmount()));
        this.k.setText(NumberUtil.formatNumber(this.a.getTaxAmount()));
        this.l.setText(NumberUtil.formatNumber(this.a.getTotalAmountWithTips()));
    }

    public TicketSplitView getTicketView1() {
        return this.b;
    }

    public void setTicketView1(TicketSplitView ticketSplitView) {
        this.b = ticketSplitView;
    }

    public int getViewNumber() {
        return this.n;
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.m;
    }

    public void setViewNumber(int n) {
        this.n = n;
        if (n != 1) {
            this.g.setVisible(false);
            this.f.setVisible(false);
            this.p.setVisible(false);
        }
        String string = Messages.getString("TicketForSplitView.1") + n;
        if (n == 1) {
            string = Messages.getString("TicketSplitView.14");
        }
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setTitleJustification(2);
        this.setBorder(titledBorder);
        switch (n) {
            case 1: {
                this.e.setIcon(IconFactory.getIcon("next.png"));
                break;
            }
            case 2: {
                this.e.setIcon(IconFactory.getIcon("previous.png"));
            }
        }
    }

    public void setTotalTicketQuantity(int n) {
        this.r = n;
    }

    private void c() {
        try {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.a.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (this.a != null) {
                customerSelectorDialog.setTicket(this.a);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                this.a.setCustomer(customer);
                this.a(customer);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Customer customer) {
        String string = StringUtils.isNotEmpty((String)customer.getMemberId()) ? customer.getMemberId() + "/" : "";
        this.u.setText(string + customer.getName());
    }
}

