/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesigner2;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public class CategoryView
extends SelectionView {
    private Vector<CategorySelectionListener> a = new Vector();
    private ButtonGroup b;
    public static final String VIEW_NAME = "CATEGORY_VIEW";

    public CategoryView() {
        super(POSConstants.CATEGORIES, new GridLayout(0, 1, 5, 5), 100, 100);
        this.dataModel = new PaginatedListModel(5);
        this.b = new ButtonGroup();
    }

    public void initialize() {
        Ticket ticket;
        if (this.isInitialized()) {
            // empty if block
        }
        if ((ticket = OrderView.getInstance().getCurrentTicket()) == null) {
            return;
        }
        OrderType orderType = ticket.getOrderType();
        MenuCategoryDAO menuCategoryDAO = MenuCategoryDAO.getInstance();
        this.dataModel.setCurrentRowIndex(0);
        menuCategoryDAO.findCategoriesForCategoryView(this.dataModel, orderType);
        this.setDataModel(this.dataModel);
        if (this.dataModel.getSize() == 0) {
            this.a(null);
            return;
        }
        this.setInitialized(true);
        CategoryButton categoryButton = (CategoryButton)this.getFirstItemButton();
        if (categoryButton != null) {
            categoryButton.setSelected(true);
            this.a(categoryButton.a);
        }
        if (this.dataModel.getSize() <= 1) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuCategory menuCategory = (MenuCategory)object;
        CategoryButton categoryButton = new CategoryButton(menuCategory);
        this.b.add(categoryButton);
        return categoryButton;
    }

    public void addCategorySelectionListener(CategorySelectionListener categorySelectionListener) {
        this.a.add(categorySelectionListener);
    }

    public void removeCategorySelectionListener(CategorySelectionListener categorySelectionListener) {
        this.a.remove(categorySelectionListener);
    }

    private void a(MenuCategory menuCategory) {
        for (CategorySelectionListener categorySelectionListener : this.a) {
            categorySelectionListener.categorySelected(menuCategory);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuCategoryDAO.getInstance().findCategoriesForCategoryView(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuCategoryDAO.getInstance().findCategoriesForCategoryView(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new VerticalTouchScrollPanel();
    }

    @Override
    protected JScrollPane createScrollContainer() {
        return new VerticalSimpleScrollPane();
    }

    public void doSelectMenuCategory(MenuCategory menuCategory) {
        if (menuCategory == null || menuCategory.getId() == null) {
            return;
        }
        Arrays.asList(this.selectionButtonsPanel.getComponents()).stream().filter(component -> ((CategoryButton)component).a.getId().equals(menuCategory.getId())).findFirst().ifPresent(component -> {
            CategoryButton categoryButton = (CategoryButton)component;
            categoryButton.setSelected(true);
            this.a(menuCategory);
        });
    }

    public class CategoryButton
    extends POSToggleButton
    implements Transferable,
    ActionListener,
    MouseMotionListener {
        MenuCategory a;
        private DataFlavor d = new DataFlavor(MenuCategory.class, "foodCategory");
        private final DataFlavor[] e = new DataFlavor[]{this.d};
        boolean b = false;

        CategoryButton(MenuCategory menuCategory) {
            this.a = menuCategory;
            this.setText("<html><body><center>" + menuCategory.getDisplayName() + "</center></body></html>");
            Font font = DataProvider.get().getCategoryOrGroupViewFont();
            if (font != null) {
                this.setFont(font);
            }
            if (menuCategory.getButtonColor() != null) {
                this.setBackground(menuCategory.getButtonColor());
            }
            if (menuCategory.getTextColor() != null) {
                this.setForeground(menuCategory.getTextColor());
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.b) {
                this.b = false;
                return;
            }
            CategoryButton categoryButton = (CategoryButton)actionEvent.getSource();
            if (categoryButton.isSelected()) {
                CategoryView.this.a(categoryButton.a);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(PosUIManager.getSize((int)100), dimension.height);
        }

        public void setDragDropTransferHandler(MenuPageDesigner2.DragAndDropMenuCategoryTransferHandler dragAndDropMenuCategoryTransferHandler) {
            this.setTransferHandler(dragAndDropMenuCategoryTransferHandler);
            this.addMouseMotionListener(this);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.e;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.e.length; ++i) {
                if (!dataFlavor.equals(this.e[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.d)) {
                return this.a;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                this.b = true;
                CategoryButton categoryButton = (CategoryButton)mouseEvent.getSource();
                TransferHandler transferHandler = categoryButton.getTransferHandler();
                transferHandler.exportAsDrag(categoryButton, mouseEvent, 2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public DataFlavor getDataFlavor() {
            return this.d;
        }

        public void setFoodCategory(MenuCategory menuCategory) {
            this.a = menuCategory;
        }

        public MenuCategory getFoodCategory() {
            return this.a;
        }

        public void updateView() {
            if (this.a == null) {
                this.setText("");
                return;
            }
            this.setText("<html><body><center>" + this.a.getDisplayName() + "</center></body></html>");
            Font font = DataProvider.get().getCategoryOrGroupViewFont();
            if (font != null) {
                this.setFont(font);
            }
            if (this.a.getButtonColor() != null) {
                this.setBackground(this.a.getButtonColor());
            }
            if (this.a.getTextColor() != null) {
                this.setForeground(this.a.getTextColor());
            }
        }
    }
}

