/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class DemoOrderViewDialog
extends OkCancelOptionDialog
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener,
ActionListener {
    public int columns = 4;
    public int rows = 4;
    private List<MenuItem> a;
    private TransparentPanel b = new TransparentPanel(new BorderLayout(5, 5));
    private CategoryView c = new CategoryView();
    private GroupView d = new GroupView();
    private MenuItemView e = new MenuItemView();
    private MenuCategory f;
    private MenuGroup g;
    private HorizontalTouchScrollPanel h = new HorizontalTouchScrollPanel(new GridLayout(1, 0, 5, 5));
    private final String i = "NO_CATEGORY";
    private JCheckBox j;

    public DemoOrderViewDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.a();
    }

    private void a() {
        this.setCancelButtonVisible(false);
        this.setCaption(Messages.getString("DemoOrderViewDialog.0"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.c, "East");
        this.b.setOpaque(false);
        this.b.setBorder(null);
        this.b.add((Component)this.d, "North");
        this.b.add(this.e);
        jPanel.add((Component)this.b, "Center");
        this.c.addCategorySelectionListener(this);
        this.d.addGroupSelectionListener(this);
        this.e.addItemSelectionListener(this);
        for (ActionListener actionListener : this.e.btnNext.getActionListeners()) {
            this.e.btnNext.removeActionListener(actionListener);
        }
        for (ActionListener actionListener : this.e.btnPrev.getActionListeners()) {
            this.e.btnPrev.removeActionListener(actionListener);
        }
        this.e.btnNext.addActionListener(actionEvent -> this.c());
        this.e.btnPrev.addActionListener(actionEvent -> this.b());
        this.getContentPane().add(jPanel);
        this.j = new JCheckBox(Messages.getString("DemoOrderViewDialog.3"));
        this.j.addActionListener(actionEvent -> {
            this.d();
            this.groupSelected(this.g);
        });
        TransparentPanel transparentPanel = this.getButtonPanel();
        transparentPanel.removeAll();
        transparentPanel.setLayout((LayoutManager)new MigLayout("ins 5, fillx", "[20%][][20%]"));
        transparentPanel.add((Component)this.j, "left");
        transparentPanel.add((Component)this.btnOk, "center, pushx");
        SwingUtilities.invokeLater(() -> this.groupSelected(this.g));
    }

    private void b() {
        this.e.dataModel.setCurrentRowIndex(this.e.dataModel.getPreviousRowIndex());
        this.setMenuGroupPerviewMode(this.f, this.g);
    }

    private void c() {
        this.e.dataModel.setCurrentRowIndex(this.e.dataModel.getNextRowIndex());
        this.setMenuGroupPerviewMode(this.f, this.g);
    }

    @Override
    public void doOk() {
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(VersionInfo.getAppName());
        this.setCaption(string);
    }

    public List<MenuItem> getMenuItems() {
        return this.a;
    }

    public void setMenuItems(List<MenuItem> list) {
        this.a = list;
        this.d();
    }

    private void d() {
        Object object;
        ArrayList<MenuCategory> arrayList = new ArrayList<MenuCategory>();
        if (this.a != null && !this.a.isEmpty()) {
            object = new HashSet();
            for (MenuItem object2 : this.a) {
                String string = object2.getMenuCategoryName();
                if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                object.add(string);
            }
            Iterator<MenuItem> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)((Object)iterator.next());
                arrayList.add(new MenuCategory(null, string));
            }
        }
        if (this.a != null && !this.a.isEmpty()) {
            object = new MenuItemAnalyser(this.a);
            ((MenuItemAnalyser)object).dataAnalysis();
            this.initializeForDemo(new ArrayList<MenuCategory>(((MenuItemAnalyser)object).getCategoryMap().values()));
        } else {
            this.c.setVisible(false);
            this.d.setVisible(false);
            this.e.setVisible(false);
            object = new JLabel(Messages.getString("DemoOrderViewDialog.1"));
            ((JLabel)object).setHorizontalAlignment(0);
            ((JComponent)object).setFont(((Component)object).getFont().deriveFont(20.0f));
            this.b.add((Component)object);
            this.j.setVisible(false);
        }
    }

    public void setMenuPageItem(MenuCategory menuCategory, PaginatedListModel paginatedListModel) {
        this.setMenuPageItem(menuCategory, null, paginatedListModel);
    }

    public void setMenuPageItem(MenuCategory menuCategory, MenuGroup menuGroup, PaginatedListModel paginatedListModel) {
        int n = this.columns * this.rows;
        paginatedListModel.setPageSize(n);
        Supplier<Stream> supplier = null;
        supplier = menuCategory != null && menuGroup != null ? () -> this.a.stream().filter(menuItem -> menuCategory.getName().equals(menuItem.getMenuCategoryName()) && menuGroup.getName().equals(menuItem.getMenuGroupName())) : (menuCategory != null && menuGroup == null ? () -> this.a.stream().filter(menuItem -> menuCategory.getName().equals(menuItem.getMenuCategoryName())) : () -> this.e());
        paginatedListModel.setNumRows((int)supplier.get().count());
        List list = supplier.get().skip(paginatedListModel.getCurrentRowIndex()).limit(n).map(menuItem -> {
            MenuPageItem menuPageItem = new MenuPageItem();
            menuPageItem.setMenuItem((MenuItem)menuItem);
            return menuPageItem;
        }).collect(Collectors.toList());
        paginatedListModel.setData(list);
    }

    private Stream<MenuItem> e() {
        return this.a.stream().filter(menuItem -> menuItem.getMenuCategoryName() == null && menuItem.getMenuGroupName() == null);
    }

    @Override
    public void itemSelected(MenuItem menuItem) {
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        this.e.dataModel.setCurrentRowIndex(0);
        this.setMenuGroupPerviewMode(this.f, menuGroup);
        this.b(this.e.dataModel);
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        this.setMenuCategoryDemoMode(menuCategory);
        this.b(this.e.dataModel);
    }

    public void initializeForDemo(List list) {
        Serializable serializable;
        Object object2;
        if (this.e().count() > 0L) {
            list.add(0, new MenuCategory("NO_CATEGORY", Messages.getString("DemoOrderViewDialog.2")));
        }
        PaginatedListModel paginatedListModel = this.c.dataModel;
        paginatedListModel.getDataList().clear();
        if (this.j.isSelected()) {
            object2 = MenuCategoryDAO.getInstance();
            paginatedListModel.setCurrentRowIndex(0);
            ((MenuCategoryDAO)object2).findCategoriesForCategoryView(paginatedListModel, null);
        }
        list.addAll(paginatedListModel.getDataList());
        paginatedListModel.setNumRows(list.size());
        paginatedListModel.setPageSize(paginatedListModel.getNumRows());
        paginatedListModel.setData(new ArrayList(new HashSet(list)));
        object2 = paginatedListModel.getDataList().stream().filter(object -> "NO_CATEGORY".equals(((MenuCategory)object).getId())).findFirst();
        if (((Optional)object2).isPresent()) {
            serializable = (MenuCategory)((Optional)object2).get();
            paginatedListModel.getDataList().remove(serializable);
            paginatedListModel.getDataList().add(0, serializable);
        }
        this.c.setDataModel(paginatedListModel);
        if (paginatedListModel.getSize() == 0) {
            this.setMenuCategoryDemoMode(null);
            return;
        }
        serializable = (CategoryView.CategoryButton)this.c.getFirstItemButton();
        if (serializable != null) {
            ((AbstractButton)serializable).setSelected(true);
            this.setMenuCategoryDemoMode(((CategoryView.CategoryButton)serializable).a);
        }
        if (this.c.dataModel.getSize() < 1) {
            this.c.setVisible(false);
        } else {
            this.c.setVisible(true);
        }
    }

    public void setMenuCategoryDemoMode(MenuCategory menuCategory) {
        this.f = "NO_CATEGORY".equals(menuCategory.getId()) ? null : menuCategory;
        this.d.reset();
        try {
            this.d.dataModel.setCurrentRowIndex(0);
            List<MenuGroup> list = null;
            if (menuCategory.getId() == null || !this.j.isSelected()) {
                list = menuCategory.getMenuGroups();
            } else if (this.j.isSelected()) {
                list = MenuGroupDAO.getInstance().findByParent(menuCategory);
            }
            if (list != null && list.size() > 0) {
                this.d.dataModel.setNumRows(list.size());
                this.d.dataModel.setPageSize(this.d.dataModel.getNumRows());
                this.d.dataModel.setData(list);
                this.d.setVisible(true);
            } else {
                this.d.dataModel.setData(null);
                this.d.setVisible(false);
            }
            this.d.setDataModel(this.d.dataModel);
            if (this.d.dataModel.getSize() > 0) {
                MenuGroup menuGroup = (MenuGroup)this.d.dataModel.getElementAt(0);
                GroupView.GroupButton groupButton = (GroupView.GroupButton)this.d.getFirstItemButton();
                if (groupButton != null) {
                    groupButton.setSelected(true);
                    this.e.dataModel.setCurrentRowIndex(0);
                    this.setMenuGroupPerviewMode(menuCategory, menuGroup);
                }
            } else {
                this.setMenuGroupPerviewMode(this.f, null);
            }
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
        }
    }

    public void setMenuGroupPerviewMode(MenuCategory menuCategory, MenuGroup menuGroup) {
        this.g = menuGroup;
        this.f = menuCategory;
        this.e.reset();
        if (menuGroup != null) {
            this.setMenuPageItem(menuCategory, menuGroup, this.e.dataModel);
        } else {
            this.setMenuPageItem(menuCategory, this.e.dataModel);
        }
        this.a(this.e.dataModel);
    }

    private void a(PaginatedListModel paginatedListModel) {
        if (this.e.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        int n = this.rows;
        int n2 = this.columns;
        this.e.selectionButtonsPanel.setLayout(new GridLayout(n, n2, 5, 5));
        this.e.selectionButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        List list = this.e.dataModel.getDataList();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                MenuPageItem menuPageItem;
                AbstractButton abstractButton;
                if (n3 > list.size() - 1) {
                    this.e.selectionButtonsPanel.add(new JLabel());
                    continue;
                }
                if ((abstractButton = this.e.createItemButton(menuPageItem = (MenuPageItem)list.get(n3++))) == null) continue;
                abstractButton.setEnabled(menuPageItem.isVisible());
                this.a(abstractButton, menuPageItem.getMenuItem());
                this.e.selectionButtonsPanel.add(abstractButton);
            }
        }
        this.revalidate();
        this.repaint();
        this.e.btnNext.setVisible(false);
        this.e.btnPrev.setVisible(false);
    }

    private void b(PaginatedListModel paginatedListModel) {
        int n;
        this.h.removeAll();
        this.e.actionButtonPanel.removeAll();
        this.e.setTitle("Page 1");
        ButtonGroup buttonGroup = new ButtonGroup();
        int n2 = (int)Math.ceil(((double)this.e.dataModel.getNumRows() + 0.0) / (double)(this.rows * this.columns));
        int n3 = 0;
        List<Object> list = Collections.emptyList();
        if (this.j.isSelected()) {
            if (this.g == null && this.f != null && this.f.getId() != "NO_CATEGORY") {
                n = MenuItemDAO.getInstance().rowCount(this.f, true);
                n3 = (int)Math.ceil(((double)n + 0.0) / (double)(this.rows * this.columns));
            } else if (this.g != null) {
                list = MenuPageDAO.getInstance().getMenuPagesByMenuGroup(this.g);
                n3 = list.size();
            }
        }
        if (n2 + n3 > 1) {
            n = 0;
            for (int i = 1; i <= n2 + n3; ++i) {
                boolean bl;
                boolean bl2 = bl = i > n2;
                if (!bl) {
                    ++n;
                }
                String string = "";
                if (!bl) {
                    string = Messages.getString("DemoOrderViewDialog.5") + String.valueOf(i);
                } else if (list.size() > 0) {
                    int n4 = i - n - 1;
                    MenuPage menuPage = (MenuPage)list.get(n4);
                    string = menuPage.getName();
                } else {
                    string = Messages.getString("DemoOrderViewDialog.6") + i;
                }
                POSToggleButton pOSToggleButton = new POSToggleButton(string);
                pOSToggleButton.setActionCommand(!bl ? String.valueOf(-i) : String.valueOf(i - n));
                buttonGroup.add(pOSToggleButton);
                pOSToggleButton.addActionListener(this);
                this.h.add(pOSToggleButton);
                if (i != 1) continue;
                pOSToggleButton.doClick();
            }
        }
        this.e.actionButtonPanel.add((Component)((Object)new HorizontalSimpleScrollPane(this.h)));
        if (this.e.dataModel.getSize() == 0) {
            this.b(0);
        }
        this.revalidate();
        this.repaint();
    }

    private void a(AbstractButton abstractButton, MenuItem menuItem) {
        for (ActionListener actionListener : abstractButton.getActionListeners()) {
            abstractButton.removeActionListener(actionListener);
        }
        abstractButton.addActionListener(actionEvent -> this.itemSelected(menuItem));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof POSToggleButton) {
            String string = actionEvent.getActionCommand();
            int n = Integer.parseInt(string);
            if (n < 0) {
                this.a(n);
            } else {
                this.b(n - 1);
            }
            this.e.setTitle(((POSToggleButton)object).getText());
        }
    }

    private void a(int n) {
        n = Math.abs(n) - 1;
        int n2 = (int)Math.ceil(((double)this.e.dataModel.getNumRows() + 0.0) / (double)(this.rows * this.columns));
        this.e.dataModel.setCurrentRowIndex(n * this.e.dataModel.getPageSize());
        this.setMenuGroupPerviewMode(this.f, this.g);
    }

    private void b(int n) {
        this.e.dataModel.setCurrentRowIndex(n);
        if (this.g != null) {
            MenuPageDAO.getInstance().loadItems(null, this.g, null, (Boolean)false, this.e.dataModel);
        } else {
            this.e.dataModel.setCurrentRowIndex(n * this.e.dataModel.getPageSize());
            this.f();
        }
        this.e.setDataModel(this.e.dataModel);
    }

    private void f() {
        this.a(this.f, null);
    }

    private void a(MenuCategory menuCategory, MenuGroup menuGroup) {
        MenuPage menuPage = new MenuPage();
        menuPage.setCols(this.columns);
        menuPage.setRows(this.rows);
        menuPage.setFlixibleButtonSize(true);
        menuPage.setButtonHeight(100);
        menuPage.setButtonWidth(100);
        int n = 0;
        n = menuGroup != null ? MenuItemDAO.getInstance().rowCount(menuGroup, true) : MenuItemDAO.getInstance().rowCount(menuCategory, true);
        int n2 = menuPage.getCols();
        int n3 = menuPage.getRows();
        int n4 = n2 * n3;
        int n5 = (int)Math.ceil((double)n / (double)n4);
        int n6 = n5 == 0 ? 1 : n5;
        this.e.dataModel.setNumRows(n6);
        if (menuGroup != null) {
            MenuItemDAO.getInstance().loadItems(menuGroup, true, this.e.dataModel);
        } else {
            MenuItemDAO.getInstance().loadItems(menuCategory, true, this.e.dataModel);
        }
        List list = this.e.dataModel.getDataList();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<MenuPage> arrayList = new ArrayList<MenuPage>();
        ArrayList<MenuPageItem> arrayList2 = new ArrayList<MenuPageItem>();
        int n7 = 0;
        int n8 = 0;
        try {
            int n9 = (int)Math.ceil(((double)this.e.dataModel.getCurrentRowIndex() + 0.0) / (double)(this.rows * this.columns));
            MenuPage menuPage2 = null;
            if (menuPage2 == null) {
                menuPage2 = new MenuPage();
                if (menuGroup != null) {
                    menuPage2.setMenuGroupId(menuGroup.getId());
                }
                menuPage2.setRows(n3);
                menuPage2.setCols(n2);
                menuPage2.setSortOrder(n9 + 1);
                menuPage2.setFlixibleButtonSize(menuPage.isFlixibleButtonSize());
                menuPage2.setButtonHeight(menuPage.getButtonHeight());
                menuPage2.setButtonWidth(menuPage.getButtonWidth());
                arrayList.add(menuPage2);
            }
            int n10 = n2 * n3;
            if (list.size() < n10) {
                while (n7 < list.size()) {
                    MenuPageItem menuPageItem = new MenuPageItem();
                    menuPageItem.setMenuPage(menuPage2);
                    menuPageItem.setMenuItem((MenuItem)list.get(n7));
                    arrayList2.add(menuPageItem);
                    menuPage2.addTopageItems(menuPageItem);
                    ++n7;
                }
            } else {
                int n11 = 0;
                while (n11 < n10) {
                    MenuPageItem menuPageItem = new MenuPageItem();
                    menuPageItem.setMenuPage(menuPage2);
                    menuPageItem.setMenuItem((MenuItem)list.get(n7));
                    arrayList2.add(menuPageItem);
                    menuPage2.addTopageItems(menuPageItem);
                    ++n11;
                    ++n7;
                }
            }
            n -= n10;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2 && n8 <= arrayList2.size() - 1 && arrayList2.get(n8) != null; ++n8, ++j) {
                    ((MenuPageItem)arrayList2.get(n8)).setRow(i);
                    ((MenuPageItem)arrayList2.get(n8)).setCol(j);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        this.e.dataModel.setData(arrayList);
    }

    public static class MenuItemAnalyser {
        private List<MenuItem> a;
        private Map<String, MenuCategory> b = new HashMap<String, MenuCategory>();
        private Map<String, MenuGroup> c = new HashMap<String, MenuGroup>();

        public MenuItemAnalyser(List<MenuItem> list) {
            this.a = list;
        }

        public void dataAnalysis() {
            if (this.a != null && !this.a.isEmpty()) {
                for (MenuItem menuItem : this.a) {
                    List<MenuGroup> list;
                    MenuGroup menuGroup;
                    String string;
                    String string2 = menuItem.getMenuCategoryName();
                    if (!StringUtils.isNotBlank((CharSequence)string2)) continue;
                    MenuCategory menuCategory = this.b.get(string2);
                    if (menuCategory == null) {
                        menuCategory = new MenuCategory(menuItem.getMenuCategoryId(), string2);
                        string = menuItem.getMenuGroupName();
                        if (StringUtils.isNotBlank((CharSequence)string)) {
                            menuGroup = this.c.get(string);
                            if (menuGroup == null) {
                                menuGroup = new MenuGroup(null, string);
                                this.c.put(string, menuGroup);
                                list = menuCategory.getMenuGroups();
                                if (list == null) {
                                    list = new ArrayList<MenuGroup>();
                                }
                                list.add(menuGroup);
                                menuCategory.setMenuGroups(list);
                            }
                            menuGroup.setMenuCategory(menuCategory);
                        }
                        this.b.put(string2, menuCategory);
                        continue;
                    }
                    string = menuItem.getMenuGroupName();
                    menuGroup = this.c.get(string);
                    if (menuGroup == null && StringUtils.isNotBlank((CharSequence)string)) {
                        menuGroup = new MenuGroup(menuItem.getMenuGroupId(), string);
                        this.c.put(string, menuGroup);
                    }
                    if ((list = menuCategory.getMenuGroups()) == null) {
                        list = new ArrayList<MenuGroup>();
                        menuCategory.setMenuGroups(list);
                    }
                    if (menuGroup == null || list.contains(menuGroup)) continue;
                    list.add(menuGroup);
                    menuGroup.setMenuCategory(menuCategory);
                }
            }
        }

        public Map<String, MenuCategory> getCategoryMap() {
            return this.b;
        }

        public Map<String, MenuGroup> getGroupMap() {
            return this.c;
        }
    }
}

