/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesigner2;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public class GroupView
extends SelectionView {
    private Vector<GroupSelectionListener> a = new Vector();
    private MenuCategory b;
    public static final String VIEW_NAME = "GROUP_VIEW";
    private NoneSelectedButtonGroup c;

    public GroupView() {
        super(POSConstants.GROUPS, new GridLayout(1, 0, 5, 5), PosUIManager.getSize((int)100), PosUIManager.getSize((int)50));
        this.dataModel = new PaginatedListModel(4);
        this.remove(this.actionButtonPanel);
        this.btnPrev.setText("<<");
        this.btnNext.setText(">>");
        this.add((Component)this.btnPrev, "West");
        this.add((Component)this.btnNext, "East");
    }

    public MenuCategory getMenuCategory() {
        return this.b;
    }

    public void setMenuCategory(MenuCategory menuCategory) {
        this.b = menuCategory;
        this.reset();
        if (menuCategory == null) {
            this.a(null);
            return;
        }
        try {
            this.dataModel.setCurrentRowIndex(0);
            MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), menuCategory, this.dataModel);
            this.setDataModel(this.dataModel);
            if (this.dataModel.getSize() > 0) {
                MenuGroup menuGroup = (MenuGroup)this.dataModel.getElementAt(0);
                GroupButton groupButton = (GroupButton)this.getFirstItemButton();
                if (groupButton != null) {
                    groupButton.setSelected(true);
                    this.a(menuGroup);
                }
            } else {
                this.a(null);
            }
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
        }
    }

    @Override
    protected void renderItems() {
        this.c = new NoneSelectedButtonGroup();
        super.renderItems();
    }

    @Override
    protected int getFitableButtonCount() {
        Dimension dimension = this.selectionButtonsPanel.getSize();
        Dimension dimension2 = this.getButtonSize();
        int n = this.getButtonCount(dimension.width, dimension2.width);
        return n;
    }

    public void addGroupSelectionListener(GroupSelectionListener groupSelectionListener) {
        this.a.add(groupSelectionListener);
    }

    public void removeGroupSelectionListener(GroupSelectionListener groupSelectionListener) {
        this.a.remove(groupSelectionListener);
    }

    private void a(MenuGroup menuGroup) {
        for (GroupSelectionListener groupSelectionListener : this.a) {
            groupSelectionListener.groupSelected(menuGroup);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuGroup menuGroup = (MenuGroup)object;
        GroupButton groupButton = new GroupButton(menuGroup);
        this.c.add(groupButton);
        return groupButton;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.b, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuGroupDAO.getInstance().loadGroupsForGroupView(this.getOrderType(), this.b, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new HorizontalTouchScrollPanel();
    }

    @Override
    protected JScrollPane createScrollContainer() {
        return new HorizontalSimpleScrollPane();
    }

    public void doSelectMenuGroup(MenuGroup menuGroup) {
        if (menuGroup == null || menuGroup.getId() == null) {
            return;
        }
        Arrays.asList(this.selectionButtonsPanel.getComponents()).stream().filter(component -> ((GroupButton)component).a.getId().equals(menuGroup.getId())).findFirst().ifPresent(component -> {
            GroupButton groupButton = (GroupButton)component;
            groupButton.setSelected(true);
            this.a(menuGroup);
        });
    }

    private class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel buttonModel, boolean bl) {
            if (bl) {
                super.setSelected(buttonModel, bl);
            } else {
                this.clearSelection();
            }
        }
    }

    public class GroupButton
    extends POSToggleButton
    implements Transferable,
    ActionListener,
    MouseMotionListener {
        MenuGroup a;
        private DataFlavor c = new DataFlavor(MenuGroup.class, "menuGroup");
        private final DataFlavor[] d = new DataFlavor[]{this.c};
        private boolean e = false;

        GroupButton(MenuGroup menuGroup) {
            this.a = menuGroup;
            this.setText("<html><body><center>" + menuGroup.getDisplayName() + "</center></body></html>");
            Font font = DataProvider.get().getCategoryOrGroupViewFont();
            if (font != null) {
                this.setFont(font);
            }
            if (this.a.getButtonColorCode() != null) {
                this.setBackground(this.a.getButtonColor());
            }
            if (this.a.getTextColorCode() != null) {
                this.setForeground(this.a.getTextColor());
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.e) {
                this.e = false;
                return;
            }
            if (!this.isSelected()) {
                GroupView.this.a(null);
                return;
            }
            GroupView.this.a(this.a);
        }

        public void setDragDropTransferHandler(MenuPageDesigner2.DragAndDropMenuGroupTransferHandler dragAndDropMenuGroupTransferHandler) {
            this.setTransferHandler(dragAndDropMenuGroupTransferHandler);
            this.addMouseMotionListener(this);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.d;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.d.length; ++i) {
                if (!dataFlavor.equals(this.d[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.c)) {
                return this.a;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                this.e = true;
                GroupButton groupButton = (GroupButton)mouseEvent.getSource();
                TransferHandler transferHandler = groupButton.getTransferHandler();
                transferHandler.exportAsDrag(groupButton, mouseEvent, 2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public DataFlavor getDataFlavor() {
            return this.c;
        }

        public MenuGroup getMenuGroup() {
            return this.a;
        }

        public void setMenuGroup(MenuGroup menuGroup) {
            this.a = menuGroup;
        }

        public void updateView() {
            if (this.a == null) {
                this.setText("");
                return;
            }
            this.setText("<html><body><center>" + this.a.getDisplayName() + "</center></body></html>");
            Font font = DataProvider.get().getCategoryOrGroupViewFont();
            if (font != null) {
                this.setFont(font);
            }
            if (this.a.getButtonColorCode() != null) {
                this.setBackground(this.a.getButtonColor());
            }
            if (this.a.getTextColorCode() != null) {
                this.setForeground(this.a.getTextColor());
            }
        }
    }
}

