/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ProfileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class MemberView
extends JPanel
implements RefreshableView {
    private JLabel a;
    private JLabel b;
    private PosButton c;
    private Ticket d;
    private JLabel e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private TicketView l;
    private TicketViewerTableChangeListener m;

    public MemberView() {
        this.a();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill,hidemode 3, ins 0", "[][180]", ""));
        this.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(0, 0, 0, 0), BorderFactory.createTitledBorder(null, POSConstants.CUSTOMER, 2, 2)));
        this.setPreferredSize(PosUIManager.getSize((int)0, (int)134));
        this.e = new JLabel();
        this.e.setHorizontalAlignment(0);
        this.e.setVerticalAlignment(1);
        this.c = new PosButton(Messages.getString("MemberView.0"));
        this.c.setBackground(Color.WHITE);
        this.c.setVisible(true);
        this.c.setPreferredSize(PosUIManager.getSize((int)50, (int)0));
        this.c.addActionListener(actionEvent -> this.doAddEditCustomer());
        this.f = new JLabel();
        this.f.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize((int)10)));
        this.a = new JLabel();
        this.g = new JLabel();
        this.g.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize((int)10)));
        this.b = new JLabel();
        this.h = new JLabel();
        this.h.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize((int)10)));
        this.i = new JLabel();
        PosButton posButton = new PosButton("X");
        posButton.setToolTipText(Messages.getString("MemberView.1"));
        posButton.addActionListener(actionEvent -> this.c());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0 1 1 1"));
        jPanel.add((Component)this.c, "h 45!,growx,spanx,pushx,split 2");
        jPanel.add((Component)posButton, "h 45!,w 30!");
        jPanel.add((Component)this.f, "split 2");
        jPanel.add((Component)this.a, "grow");
        jPanel.add((Component)this.g, "newline,split 2");
        jPanel.add((Component)this.b, "grow");
        jPanel.add((Component)this.h, "gaptop 0,newline,split 2");
        jPanel.add(this.i);
        this.add((Component)jPanel, "grow");
        this.add((Component)this.e, "grow");
    }

    public void doAddEditCustomer() {
        try {
            Serializable serializable;
            if (this.d != null && StringUtils.isNotBlank((String)this.d.getCustomerId()) && (serializable = this.d.getItemWithRequiredCustomer()) != null) {
                throw new PosException(Messages.getString("OrderView.30") + " " + ((BaseTicketItem)serializable).getName() + " " + Messages.getString("OrderView.31"));
            }
            DataProvider.get().setTicketToBeCreated(this.d);
            serializable = CustomerSelectorFactory.createCustomerSelectorDialog(this.d.getOrderType(), Boolean.FALSE);
            ((CustomerSelectorDialog)serializable).setCreateNewTicket(false);
            ((CustomerSelectorDialog)serializable).updateView(true);
            if (this.d.getPaidAmount() > 0.0 && StringUtils.isNotEmpty((String)this.d.getCustomerId())) {
                throw new PosException(Messages.getString("OrderView.22"));
            }
            ((CustomerSelectorDialog)serializable).setTicket(this.d);
            ((POSDialog)serializable).openUndecoratedFullScreen();
            if (!((POSDialog)serializable).isCanceled()) {
                Customer customer = ((CustomerSelectorDialog)serializable).getSelectedCustomer();
                CustomerDAO.getInstance().refresh(customer);
                this.setCustomer(customer);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    public void setCustomer(Customer customer) {
        this.d.setCustomer(customer, true);
        if (customer != null) {
            this.b();
        }
        if (this.l != null) {
            this.l.updateView();
        }
        if (this.m != null) {
            this.m.ticketDataChanged();
        }
        this.revalidate();
        this.repaint();
    }

    private void a(Customer customer) {
        this.h.setText(Messages.getString("MemberView.2"));
        if (customer.isMember().booleanValue()) {
            this.i.setText(Messages.getString("MemberView.3"));
        } else {
            this.i.setText(Messages.getString("MemberView.4"));
        }
    }

    private void b(Customer customer) {
        if (customer.getImageId() != null) {
            ImageResource imageResource = ImageResourceDAO.getInstance().findById(customer.getImageId());
            if (imageResource != null) {
                this.e.setIcon(imageResource.getScaledImage(90, 90));
            } else {
                this.e.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png", PosUIManager.getSize((int)100, (int)90)));
            }
        }
    }

    private String c(Customer customer) {
        String string = "";
        if (customer != null) {
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension != null && ProfileUtil.shouldDisplayClubposSfControls()) {
                return orderServiceExtension.getCustomerName(customer);
            }
            string = customer.getName();
            if (StringUtils.isEmpty((String)string)) {
                string = "";
            }
        } else {
            string = this.d.getCustomerNameByProperty();
        }
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        return string;
    }

    private void b() {
        this.c.setVisible(DataProvider.get().getStore().isEnableCustomerBtnInOrder());
        String string = "<html><center>Select<br></center></html>";
        if (this.d == null) {
            this.d();
            this.c.setText(string);
            return;
        }
        Customer customer = this.d.getCustomer();
        if (customer != null) {
            String string2 = this.c(customer);
            if (StringUtils.isNotBlank((String)string2)) {
                string = "<html><center>" + string2 + "</center></html>";
            }
            this.c.setText(string);
            this.f.setText(Messages.getString("MemberView.5"));
            this.a.setText(NumberUtil.formatAmount(customer.getLoyaltyPoint()));
            this.g.setText(Messages.getString("MemberView.6"));
            this.b.setText(NumberUtil.formatAmount(customer.getBalance()));
            this.a(customer);
            this.b(customer);
            if (this.j != null) {
                this.k.setVisible(true);
                this.j.setVisible(true);
                this.j.setText(string2);
            }
            OrderView.getInstance().getOrderController().fireTicketEdited(this.d);
        } else {
            this.d();
        }
        this.revalidate();
        this.repaint();
    }

    private void c() {
        try {
            if (this.d != null) {
                if (this.d.getPaidAmount() > 0.0 && StringUtils.isNotEmpty((String)this.d.getCustomerId())) {
                    throw new PosException(Messages.getString("MemberView.7"));
                }
                if (StringUtils.isNotEmpty((String)this.d.getCustomerId())) {
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReportViewer.18"), Messages.getString("CONFIRM")) != 0) {
                        return;
                    }
                    this.setCustomer(null);
                    this.d();
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        this.f.setText("");
        this.g.setText("");
        this.a.setText("");
        this.b.setText("");
        this.e.setIcon(null);
        this.c.setText("Select");
        this.h.setText("");
        this.i.setText("");
        if (this.j != null) {
            this.j.setText("");
            this.k.setVisible(false);
            this.j.setVisible(false);
        }
        OrderView.getInstance().getOrderController().fireTicketEdited(this.d);
    }

    public void setTicket(Ticket ticket) {
        this.d = ticket;
        this.b();
    }

    @Override
    public void refresh() {
        Ticket ticket;
        if (this.d != null && this.d.getId() != null && (ticket = TicketDAO.getInstance().loadFullTicket(this.d.getId())) != null && ticket.getVersion() != ticket.getVersion()) {
            this.setTicket(ticket);
        }
    }

    public void updateCustomerName(JLabel jLabel, JLabel jLabel2) {
        this.j = jLabel2;
        this.k = jLabel;
    }

    public void setTicketView(TicketView ticketView) {
        this.l = ticketView;
    }

    public void setTicketViewerTableChangeListener(TicketViewerTableChangeListener ticketViewerTableChangeListener) {
        this.m = ticketViewerTableChangeListener;
    }
}

