/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.formdev.flatlaf.ui.FlatLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.JDBCConnectionException;

public class MenuItemView
extends SelectionView
implements ActionListener {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private Vector<ItemSelectionListener> a = new Vector();
    private MenuGroup b;
    private boolean c;
    private PaginatedListModel d;
    private boolean e;
    private MenuCategory f;
    private int g;
    private List<Attribute> h = new ArrayList<Attribute>();
    private ButtonGroup i = new ButtonGroup();
    private int j = 5;

    public MenuItemView() {
        super(POSConstants.ITEMS, new FlowLayout(), PosUIManager.getSize((int)TerminalConfig.getMenuItemButtonWidth()), PosUIManager.getSize((int)TerminalConfig.getMenuItemButtonHeight()));
        this.dataModel = new PaginatedListModel();
        this.btnPrev.setText("<< " + Messages.getString("MenuItemView.1"));
        this.btnNext.setText(Messages.getString("MenuItemView.2") + ">>");
        this.h();
    }

    public MenuGroup getMenuGroup() {
        return this.b;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.b = menuGroup;
        this.setQuickMenuMode(false);
        this.reset();
        if (menuGroup == null) {
            return;
        }
        this.h();
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            MenuPageDAO.getInstance().loadItems(terminal, menuGroup, this.getOrderType(), null, this.dataModel);
            if (this.dataModel.getNumRows() == 0) {
                this.d = new PaginatedListModel();
                this.d.setCurrentRowIndex(0);
                this.e();
                this.e = true;
            } else {
                this.e = false;
            }
            this.setDataModel(this.dataModel);
            this.a();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a() {
        this.actionButtonPanel.removeAll();
        if (this.c) {
            return;
        }
        this.actionButtonPanel.setLayout(new GridLayout(1, 0, 3, 0));
        this.addPreviousNextBtn();
        if (this.dataModel.getNumRows() > 1) {
            int n = this.dataModel.getNumRows();
            if (n > this.j) {
                n = this.j;
            }
            for (int i = 1; i <= n; ++i) {
                POSToggleButton pOSToggleButton = new POSToggleButton(this.c(i));
                pOSToggleButton.setActionCommand(String.valueOf(i));
                this.i.add(pOSToggleButton);
                pOSToggleButton.addActionListener(this);
                this.actionButtonPanel.add((Component)pOSToggleButton, i);
            }
            this.a(this.dataModel);
        }
    }

    public void setNoneMenuGroup(MenuCategory menuCategory) {
        this.setQuickMenuMode(false);
        this.reset();
        try {
            this.f = menuCategory;
            this.b = null;
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.getDataList().clear();
            this.d = new PaginatedListModel();
            this.d.setCurrentRowIndex(0);
            this.f();
            this.e = true;
            this.setDataModel(this.dataModel);
            this.a();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    protected void renderItems() {
        this.reset();
        if (this.c) {
            this.b();
        } else {
            this.d();
        }
    }

    private void b() {
        this.setTitle(Messages.getString("MenuItemView.0"));
        PosButton posButton = new PosButton(Messages.getString("MenuItemView.3"));
        VerticalTouchScrollPanel verticalTouchScrollPanel = new VerticalTouchScrollPanel(new GridLayout(0, 2, 5, 5));
        List list = this.dataModel.getDataList();
        for (MenuItem menuItem : list) {
            AbstractButton abstractButton = this.createItemButton(menuItem);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(PosUIManager.getSize((int)80, (int)120));
            verticalTouchScrollPanel.add(abstractButton);
        }
        Object object = new VerticalSimpleScrollPane(verticalTouchScrollPanel);
        this.selectionButtonsPanel.setBorder(null);
        this.selectionButtonsPanel.setLayout(new BorderLayout(5, 5));
        this.selectionButtonsPanel.add((Component)object);
        this.selectionButtonsPanel.add((Component)posButton, "South");
        posButton.addActionListener(actionEvent -> this.c());
        this.revalidate();
        this.repaint();
    }

    private void c() {
        Ticket ticket = OrderView.getInstance().getCurrentTicket();
        if (ticket == null) {
            return;
        }
        OrderType orderType = ticket.getOrderType();
        if (orderType == null) {
            return;
        }
        OrderTypeDAO.getInstance().refresh(orderType);
        this.setQuickMenus(MenuItemDAO.getInstance().getMenuItemByIDs(orderType.getQuickMenuIds()));
    }

    private void d() {
        if (this.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        this.btnPrev.setText("<< " + POSConstants.CAPITAL_PREV);
        MenuPage menuPage = (MenuPage)this.dataModel.getElementAt(0);
        this.setTitle(menuPage.getName());
        int n = menuPage.getRows();
        int n2 = menuPage.getCols();
        double d = 100.0 / (double)n;
        double d2 = 100.0 / (double)n2;
        VerticalTouchScrollPanel verticalTouchScrollPanel = new VerticalTouchScrollPanel();
        MigLayout migLayout = new MigLayout("hidemode 0, center,wrap " + n2);
        if (menuPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
            verticalTouchScrollPanel.setLayout(new GridLayout(n, n2, 5, 5));
            verticalTouchScrollPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    AbstractButton abstractButton;
                    MenuPageItem menuPageItem = menuPage.getItemForCell(j, i);
                    if (menuPageItem == null) {
                        verticalTouchScrollPanel.add(new JLabel());
                        continue;
                    }
                    if (!menuPageItem.isVisible().booleanValue() || (abstractButton = this.createItemButton(menuPageItem)) == null) continue;
                    verticalTouchScrollPanel.add(abstractButton);
                }
            }
            this.selectionButtonsPanel.setLayout(new BorderLayout());
            this.selectionButtonsPanel.add(verticalTouchScrollPanel);
        } else {
            verticalTouchScrollPanel.setLayout((LayoutManager)migLayout);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    AbstractButton abstractButton;
                    String string = String.format("cell %s %s", j, i);
                    string = menuPage.isFlixibleButtonSize() != false ? string + String.format(", w %s, h %s", d, d2) : string + String.format(", w %s!, h %s!", PosUIManager.getSize((int)menuPage.getButtonWidth()), PosUIManager.getSize((int)menuPage.getButtonHeight()));
                    MenuPageItem menuPageItem = menuPage.getItemForCell(j, i);
                    if (menuPageItem == null) {
                        verticalTouchScrollPanel.add((Component)new JLabel(), string);
                        continue;
                    }
                    if (!menuPageItem.isVisible().booleanValue() || (abstractButton = this.createItemButton(menuPageItem)) == null) continue;
                    verticalTouchScrollPanel.add((Component)abstractButton, string);
                }
            }
            this.selectionButtonsPanel.setLayout(new BorderLayout());
            this.selectionButtonsPanel.add(verticalTouchScrollPanel);
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext() || this.dataModel.hasPrevious());
        this.btnPrev.setVisible(this.dataModel.hasNext() || this.dataModel.hasPrevious());
        this.btnNext.setEnabled(this.dataModel.hasNext());
        this.btnPrev.setEnabled(this.dataModel.hasPrevious());
    }

    private void e() {
        this.a(null, this.b);
    }

    private void f() {
        this.a(this.f, null);
    }

    private void a(MenuCategory menuCategory, MenuGroup menuGroup) {
        MenuPage menuPage = new MenuPage();
        menuPage.setCols(4);
        menuPage.setRows(3);
        menuPage.setFlixibleButtonSize(true);
        menuPage.setButtonHeight(100);
        menuPage.setButtonWidth(100);
        int n = 0;
        n = menuGroup != null ? MenuItemDAO.getInstance().rowCount(menuGroup, true) : MenuItemDAO.getInstance().rowCount(menuCategory, true);
        int n2 = menuPage.getCols();
        int n3 = menuPage.getRows();
        int n4 = n2 * n3;
        int n5 = (int)Math.ceil((double)n / (double)n4);
        int n6 = n5 == 0 ? 1 : n5;
        this.dataModel.setNumRows(n6);
        this.d.setPageSize(n4);
        if (menuGroup != null) {
            MenuItemDAO.getInstance().loadItems(menuGroup, true, this.d);
        } else {
            MenuItemDAO.getInstance().loadItems(menuCategory, true, this.d);
        }
        List list = this.d.getDataList();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<MenuPage> arrayList = new ArrayList<MenuPage>();
        ArrayList<MenuPageItem> arrayList2 = new ArrayList<MenuPageItem>();
        int n7 = 0;
        int n8 = 0;
        try {
            int n9 = this.dataModel.getCurrentRowIndex();
            MenuPage menuPage2 = null;
            if (menuPage2 == null) {
                menuPage2 = new MenuPage();
                if (menuGroup != null) {
                    menuPage2.setMenuGroupId(menuGroup.getId());
                }
                menuPage2.setName(Messages.getString("MenuPageDesigner.48") + (n9 + 1));
                menuPage2.setRows(n3);
                menuPage2.setCols(n2);
                menuPage2.setSortOrder(n9 + 1);
                menuPage2.setFlixibleButtonSize(menuPage.isFlixibleButtonSize());
                menuPage2.setButtonHeight(menuPage.getButtonHeight());
                menuPage2.setButtonWidth(menuPage.getButtonWidth());
                arrayList.add(menuPage2);
            }
            int n10 = n2 * n3;
            if (list.size() < n10) {
                while (n7 < list.size()) {
                    MenuPageItem menuPageItem = new MenuPageItem();
                    menuPageItem.setMenuPage(menuPage2);
                    menuPageItem.setMenuItem((MenuItem)list.get(n7));
                    arrayList2.add(menuPageItem);
                    menuPage2.addTopageItems(menuPageItem);
                    ++n7;
                }
            } else {
                int n11 = 0;
                while (n11 < n10) {
                    MenuPageItem menuPageItem = new MenuPageItem();
                    menuPageItem.setMenuPage(menuPage2);
                    menuPageItem.setMenuItem((MenuItem)list.get(n7));
                    arrayList2.add(menuPageItem);
                    menuPage2.addTopageItems(menuPageItem);
                    ++n11;
                    ++n7;
                }
            }
            n -= n10;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2 && n8 <= arrayList2.size() - 1 && arrayList2.get(n8) != null; ++n8, ++j) {
                    ((MenuPageItem)arrayList2.get(n8)).setRow(i);
                    ((MenuPageItem)arrayList2.get(n8)).setCol(j);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        this.dataModel.setData(arrayList);
    }

    public void rendererVariants(MenuItem menuItem) {
        this.a(false);
        this.h.clear();
        MenuItemDAO.getInstance().initialize(menuItem);
        this.rendererVariants(menuItem, 0);
    }

    public void rendererVariants(MenuItem menuItem2, int n) {
        Object object;
        List<MenuItem> list = menuItem2.getVariants();
        List<Object> list2 = new ArrayList();
        if (list != null) {
            list2 = list.stream().filter(menuItem -> menuItem.isDeleted() == false).collect(Collectors.toList());
        }
        Dimension dimension = PosUIManager.getSize((int)120, (int)120);
        Dimension dimension2 = this.g();
        if (dimension2 != null) {
            dimension = dimension2;
        }
        this.reset();
        JPanel jPanel = new JPanel(new WrapLayout());
        this.selectionButtonsPanel.setLayout(new BorderLayout());
        if (!DataProvider.get().getStore().isShowVariantInHierarchyFormat()) {
            for (MenuItem menuItem3 : list2) {
                AbstractButton abstractButton = this.createItemButton(menuItem3);
                if (abstractButton == null) continue;
                abstractButton.setPreferredSize(dimension);
                jPanel.add(abstractButton);
            }
            this.setTitle(menuItem2.getName());
        } else {
            object = new ArrayList();
            if (!list2.isEmpty()) {
                object.addAll(((MenuItem)list2.get(0)).getAttributes().stream().map(attribute -> attribute.getGroup()).collect(Collectors.toList()));
            }
            if (n < object.size()) {
                AttributeGroup attributeGroup = (AttributeGroup)object.get(n);
                for (Attribute attribute2 : attributeGroup.getAttributes()) {
                    if (attribute2.isDeleted().booleanValue()) continue;
                    AbstractButton abstractButton = null;
                    if (n + 1 == object.size()) {
                        HashSet<Attribute> hashSet = new HashSet<Attribute>(this.h);
                        hashSet.add(attribute2);
                        Optional<MenuItem> optional = list2.stream().filter(menuItem -> hashSet.equals(new HashSet<Attribute>(menuItem.getAttributes()))).findFirst();
                        if (optional.isPresent()) {
                            MenuItem menuItem4 = optional.get();
                            menuItem4.setName(attribute2.getName());
                            menuItem4.setTranslatedName(attribute2.getName());
                            abstractButton = this.createItemButton(menuItem4);
                        }
                    } else {
                        abstractButton = new AttributeButton(attribute2, menuItem2, n + 1);
                    }
                    if (abstractButton == null) continue;
                    abstractButton.setPreferredSize(dimension);
                    jPanel.add(abstractButton);
                }
                Object object2 = "";
                if (!this.h.isEmpty()) {
                    for (int i = 0; i < this.h.size(); ++i) {
                        if (StringUtils.isNotBlank((String)object2)) {
                            object2 = (String)object2 + ", ";
                        }
                        object2 = (String)object2 + ((AttributeGroup)object.get(i)).getName() + ": " + this.h.get(i);
                    }
                }
                this.setTitle("Select " + menuItem2.getName() + " " + attributeGroup.getName() + (this.h.isEmpty() ? "" : " (" + (String)object2 + ")"));
            }
        }
        object = new PosScrollPane(jPanel);
        ((JComponent)object).setBorder(null);
        this.selectionButtonsPanel.add((Component)object);
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setEnabled(true);
        this.btnPrev.setText(Messages.getString("MenuItemView.10"));
    }

    private Dimension g() {
        for (int i = 0; i < this.selectionButtonsPanel.getComponentCount(); ++i) {
            Component component = this.selectionButtonsPanel.getComponent(i);
            if (!(component instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)component;
            int n = jScrollPane.getComponentCount();
            for (int j = 0; j < n; ++j) {
                Component component2 = jScrollPane.getComponent(j);
                if (!(component2 instanceof JViewport)) continue;
                JViewport jViewport = (JViewport)component2;
                int n2 = jViewport.getComponentCount();
                for (int k = 0; k < n2; ++k) {
                    Component component3;
                    int n3;
                    int n4;
                    JPanel jPanel;
                    Component component4 = jViewport.getComponent(k);
                    if (component4 instanceof VerticalTouchScrollPanel) {
                        jPanel = (VerticalTouchScrollPanel)component4;
                        n4 = jPanel.getComponentCount();
                        for (n3 = 0; n3 < n4; ++n3) {
                            component3 = jPanel.getComponent(n3);
                            if (!(component3 instanceof PageItemButton) && !(component3 instanceof ItemButton) && !(component3 instanceof AttributeButton)) continue;
                            return component3.getSize();
                        }
                        continue;
                    }
                    if (!(component4 instanceof JPanel)) continue;
                    jPanel = (JPanel)component4;
                    n4 = jPanel.getComponentCount();
                    for (n3 = 0; n3 < n4; ++n3) {
                        component3 = jPanel.getComponent(n3);
                        if (!(component3 instanceof PageItemButton) && !(component3 instanceof ItemButton) && !(component3 instanceof AttributeButton)) continue;
                        return component3.getSize();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        if (object instanceof MenuPageItem) {
            return new PageItemButton((MenuPageItem)object);
        }
        if (object instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)object;
            menuItem.setMenuGroup(this.b);
            ItemButton itemButton = new ItemButton(menuItem);
            return itemButton;
        }
        return null;
    }

    public void addItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.add(itemSelectionListener);
    }

    public void removeItemSelectionListener(ItemSelectionListener itemSelectionListener) {
        this.a.remove(itemSelectionListener);
    }

    private void a(MenuItem menuItem) {
        for (ItemSelectionListener itemSelectionListener : this.a) {
            itemSelectionListener.itemSelected(menuItem);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        if (!this.e) {
            MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        } else {
            this.d.setCurrentRowIndex(this.d.getNextRowIndex());
            if (this.b == null) {
                this.f();
            } else {
                this.e();
            }
        }
        this.setDataModel(this.dataModel);
        this.a(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.a(true);
        if (this.btnPrev.getText().equals(Messages.getString("MenuItemView.10"))) {
            this.renderItems();
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        if (!this.e) {
            MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        } else {
            this.d.setCurrentRowIndex(this.d.getPreviousRowIndex());
            if (this.b == null) {
                this.f();
            } else {
                this.e();
            }
        }
        this.setDataModel(this.dataModel);
        this.a(this.dataModel);
    }

    public void setQuickMenus(List<MenuItem> list) {
        this.dataModel.setData(list);
        this.dataModel.setCurrentRowIndex(0);
        this.dataModel.setPageSize(list.size());
        this.setQuickMenuMode(true);
        this.a();
        this.renderItems();
    }

    public boolean isQuickMenuMode() {
        return this.c;
    }

    public void setQuickMenuMode(boolean bl) {
        this.c = bl;
        this.h();
    }

    private void h() {
        JLabel jLabel = new JLabel("TEXT");
        Font font = DataProvider.get().getMenuFont();
        if (font != null) {
            jLabel.setFont(font);
        }
        this.g = jLabel.getPreferredSize().height * 2;
    }

    public void renderUnitWiseItem(MenuItem menuItem) {
        Optional<List<IUnit>> optional = Optional.ofNullable(menuItem.getUnits(false, false));
        List<Object> list = new ArrayList();
        if (optional.isPresent()) {
            list = optional.get().stream().map(iUnit -> {
                if (iUnit.hideFromSalesScreen()) {
                    return null;
                }
                MenuItem menuItem2 = new MenuItem();
                menuItem2.setId(menuItem.getId());
                String string = iUnit.getDisplayName();
                string = StringUtils.isNotBlank((String)string) ? string : iUnit.getName();
                menuItem2.setName(string);
                menuItem2.setShowChildUnits(false);
                menuItem2.setUnitWiseSelection(false);
                menuItem2.setUnit((InventoryUnit)iUnit);
                menuItem2.setUnitWiseItem(true);
                menuItem2.setPropertiesJson(menuItem.getPropertiesJson());
                menuItem2.setPrice(menuItem.getPrice());
                menuItem2.setVariant(menuItem.isVariant());
                menuItem2.setParentMenuItemId(menuItem.getParentMenuItemId());
                return menuItem2;
            }).collect(Collectors.toList());
        }
        this.reset();
        this.a(false);
        Dimension dimension = PosUIManager.getSize((int)120, (int)120);
        JPanel jPanel = new JPanel(new WrapLayout());
        this.selectionButtonsPanel.setLayout(new BorderLayout());
        for (MenuItem serializable : list) {
            AbstractButton abstractButton = this.createItemButton(serializable);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(dimension);
            jPanel.add(abstractButton);
        }
        PosScrollPane posScrollPane = new PosScrollPane(jPanel);
        posScrollPane.setBorder(null);
        this.selectionButtonsPanel.add(posScrollPane);
        if (this.isQuickMenuMode()) {
            PosButton posButton = new PosButton(Messages.getString("MenuItemView.10"));
            posButton.addActionListener(actionEvent -> this.c());
            this.selectionButtonsPanel.add((Component)posButton, "South");
        } else {
            this.btnNext.setVisible(false);
            this.btnPrev.setVisible(true);
            this.btnPrev.setEnabled(true);
            this.btnPrev.setText(Messages.getString("MenuItemView.10"));
        }
        this.setTitle(menuItem.getName());
        this.revalidate();
        this.repaint();
    }

    public static void setItemImage(PosButton posButton, MenuPageItem menuPageItem, MenuItem menuItem, int n) {
        MenuItemView.setItemImage(posButton, menuPageItem, menuItem, n, null, null);
    }

    public static void setItemImage(PosButton posButton, MenuPageItem menuPageItem, MenuItem menuItem, int n, JPanel jPanel, JLabel jLabel) {
        Dimension dimension = posButton.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        boolean bl = menuPageItem != null ? menuPageItem.isShowImageOnly() : menuItem.isShowImageOnly();
        boolean bl2 = menuItem.isEnable();
        String string = menuPageItem != null ? menuPageItem.getImageId() : menuItem.getImageId();
        ImageResource imageResource = DataProvider.get().getImageResource(string);
        if (imageResource != null) {
            int n2 = dimension.height;
            n2 = !bl ? (DataProvider.get().getStore().isEnablePriceOnMenuBtn() ? n2 - n - 30 : n2 - n - 10) : (DataProvider.get().getStore().isEnablePriceOnMenuBtn() ? (n2 -= 20) : (n2 -= 10));
            if (n2 > dimension.width) {
                n2 = dimension.width - 10;
            }
            ImageIcon imageIcon = imageResource.getImageOfHeight(n2);
            JLabel jLabel2 = new JLabel(imageIcon);
            jLabel2.setBorder(null);
            jLabel2.setEnabled(bl2);
            if (jPanel != null && jLabel != null) {
                jPanel.remove(jLabel);
                jPanel.add((Component)jLabel2, "newline,align center,gaptop 2,wrap");
                if (!bl) {
                    jPanel.add((Component)jLabel, "align center");
                }
            } else if (bl) {
                posButton.add((Component)jLabel2, "Center");
            } else {
                posButton.add((Component)jLabel2, "North");
            }
            posButton.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof POSToggleButton) {
            String string = actionEvent.getActionCommand();
            this.a(Integer.parseInt(string) - 1);
            this.a(this.dataModel, true);
        } else if (object instanceof PosButton) {
            String string = actionEvent.getActionCommand();
            this.a(string);
        }
    }

    private void a(String string) {
        int n = this.dataModel.getCurrentRowIndex();
        int n2 = this.actionButtonPanel.getComponentCount() - 2;
        for (int i = 1; i <= n2; ++i) {
            Component component = this.actionButtonPanel.getComponent(i + 1);
            if (!(component instanceof POSToggleButton)) continue;
            POSToggleButton pOSToggleButton = (POSToggleButton)component;
            pOSToggleButton.setText(this.c(i));
            pOSToggleButton.setActionCommand(String.valueOf(i));
        }
        this.a(n, n2);
        this.a(n);
    }

    private void a(int n) {
        this.dataModel.setCurrentRowIndex(n);
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        if (!this.e) {
            MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, orderType, (Boolean)false, this.dataModel);
        } else {
            this.d.setCurrentRowIndex(this.d.getPageSize() * n);
            this.a(this.f, this.b);
        }
        this.setDataModel(this.dataModel);
    }

    private int b(int n) {
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            POSToggleButton pOSToggleButton;
            Component component = this.actionButtonPanel.getComponent(i + 1);
            if (!(component instanceof POSToggleButton) || !(pOSToggleButton = (POSToggleButton)component).isSelected()) continue;
            n2 = Integer.parseInt(pOSToggleButton.getActionCommand());
            break;
        }
        return n2;
    }

    private void a(PaginatedListModel paginatedListModel) {
        this.a(paginatedListModel, false);
    }

    private void a(PaginatedListModel paginatedListModel, boolean bl) {
        boolean bl2;
        int n = paginatedListModel.getCurrentRowIndex();
        int n2 = this.actionButtonPanel.getComponentCount() - 2;
        if (n2 < 1 && !paginatedListModel.hasNext()) {
            return;
        }
        int n3 = n2;
        int n4 = Integer.parseInt(((POSToggleButton)this.actionButtonPanel.getComponent(1)).getActionCommand());
        int n5 = Integer.parseInt(((POSToggleButton)this.actionButtonPanel.getComponent(n2)).getActionCommand());
        int n6 = this.b(n3);
        boolean bl3 = n + 1 < n6;
        boolean bl4 = bl2 = n + 1 > n6;
        if (n + 1 < n4 + n3 / 2 && bl3 || n + 1 > n5 - n3 / 2 && bl2 || bl) {
            for (int i = 1; i <= n3; ++i) {
                boolean bl5;
                Component component = this.actionButtonPanel.getComponent(i);
                if (!(component instanceof POSToggleButton)) continue;
                POSToggleButton pOSToggleButton = (POSToggleButton)component;
                int n7 = n - n3 / 2 + i;
                boolean bl6 = bl5 = n + 1 + n3 / 2 >= paginatedListModel.getNumRows();
                if (bl5 && !bl) {
                    n7 -= n + 1 + n3 / 2 - paginatedListModel.getNumRows();
                } else if (bl5 && bl) {
                    n7 = paginatedListModel.getNumRows() - n3 + i;
                }
                if (n7 < i) {
                    n7 = i;
                }
                pOSToggleButton.setText(this.c(n7));
                pOSToggleButton.setActionCommand(String.valueOf(n7));
            }
        }
        this.a(n, n3);
    }

    private void a(int n, int n2) {
        for (int i = 1; i <= n2; ++i) {
            POSToggleButton pOSToggleButton;
            Component component = this.actionButtonPanel.getComponent(i);
            if (!(component instanceof POSToggleButton) || !(pOSToggleButton = (POSToggleButton)component).getActionCommand().equals(String.valueOf(n + 1))) continue;
            pOSToggleButton.setSelected(true);
            break;
        }
        this.i();
    }

    private void i() {
        int n = this.actionButtonPanel.getComponentCount();
        if (n > this.j + 2) {
            PosButton posButton = (PosButton)this.actionButtonPanel.getComponent(1);
            PosButton posButton2 = (PosButton)this.actionButtonPanel.getComponent(n - 1 - 1);
            int n2 = Integer.parseInt(((POSToggleButton)this.actionButtonPanel.getComponent(2)).getActionCommand());
            int n3 = Integer.parseInt(((POSToggleButton)this.actionButtonPanel.getComponent(n - 1 - 2)).getActionCommand());
            posButton.setEnabled(n2 != 1);
            posButton2.setEnabled(n3 != this.dataModel.getNumRows());
        }
    }

    private void a(boolean bl) {
        for (int i = 1; i < this.actionButtonPanel.getComponentCount(); ++i) {
            Component component = this.actionButtonPanel.getComponent(i);
            component.setVisible(bl);
        }
    }

    public void updateButtonStatus(ITicketItem iTicketItem) {
        TicketItem ticketItem;
        if (iTicketItem instanceof TicketItem && (ticketItem = (TicketItem)iTicketItem).isShowItemCountdown()) {
            Component[] componentArray;
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                return;
            }
            Ticket ticket = ticketItem.getTicket();
            MenuItem menuItem = ticketItem.getMenuItem();
            if (ticket == null || menuItem == null) {
                return;
            }
            MenuItemDAO.getInstance().refresh(menuItem);
            block0: for (Component component : componentArray = this.selectionButtonsPanel.getComponents()) {
                Component[] componentArray2;
                if (!(component instanceof VerticalTouchScrollPanel)) continue;
                VerticalTouchScrollPanel verticalTouchScrollPanel = (VerticalTouchScrollPanel)component;
                for (Component component2 : componentArray2 = verticalTouchScrollPanel.getComponents()) {
                    if (!(component2 instanceof PageItemButton)) continue;
                    PageItemButton pageItemButton = (PageItemButton)component2;
                    if (!pageItemButton.b.getMenuItem().equals(menuItem)) continue;
                    double d = ticket.getItemOnHandCount(menuItem);
                    pageItemButton.b(d);
                    continue block0;
                }
            }
        }
    }

    private String c(int n) {
        if (this.b == null) {
            return Messages.getString("MenuItemView.15") + n;
        }
        PaginatedListModel paginatedListModel = new PaginatedListModel(1);
        paginatedListModel.setCurrentRowIndex(n - 1);
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.b, this.getOrderType(), null, paginatedListModel);
        List list = paginatedListModel.getDataList();
        if (list.isEmpty()) {
            return Messages.getString("MenuItemView.15") + n;
        }
        return ((MenuPage)list.get(0)).getName();
    }

    private class AttributeButton
    extends PosButton
    implements ActionListener {
        Attribute a;
        MenuItem b;
        final int d;

        AttributeButton(Attribute attribute, MenuItem menuItem, int n) {
            this.a = attribute;
            this.b = menuItem;
            this.d = n;
            if (attribute == null) {
                this.setVisible(false);
                return;
            }
            this.setLayout(new BorderLayout());
            Font font = DataProvider.get().getMenuFont();
            String string = "<html><body><center>" + attribute.getName() + "</center></body></html>";
            JLabel jLabel = new JLabel(string);
            if (font != null && !OrderView.getInstance().getCurrentTicket().getOrderType().isRetailOrder().booleanValue()) {
                jLabel.setFont(font);
            }
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout((LayoutManager)new MigLayout("ins 0, fill"));
            jPanel.add((Component)jLabel, "align center");
            this.add((Component)jPanel, "Center");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuItemView.this.h.add(this.a);
            MenuItemView.this.rendererVariants(this.b, this.d);
        }
    }

    private class PageItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;
        MenuPageItem b;
        private JPanel e;
        private JLabel f;
        private JPanel g;
        private JLabel h;
        private JLabel i;

        PageItemButton(MenuPageItem menuPageItem) {
            Color color;
            Color color2;
            this.b = menuPageItem;
            if (menuPageItem == null) {
                this.setVisible(false);
                return;
            }
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            this.setLayout(new BorderLayout(0, 0));
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            Font font = DataProvider.get().getMenuFont();
            this.a = this.b.getMenuItem();
            if (DataProvider.get().getStore().isEnablePriceOnMenuBtn() && !this.a.isHasVariant().booleanValue()) {
                this.f = new JLabel(POSUtil.formatPriceDisplayWithHtmlBody(this.a.getVariantPrice()));
                this.f.setEnabled(this.a.isEnable());
                this.f.setHorizontalAlignment(0);
                this.add((Component)this.f, "South");
            }
            String string = "<html><body><center>" + menuPageItem.getDisplayName() + "</center></body></html>";
            this.h = new JLabel(string);
            this.h.setEnabled(this.a.isEnable());
            if (font != null) {
                this.h.setFont(font);
            }
            this.g = new JPanel(new BorderLayout());
            this.e = new JPanel();
            if (!menuPageItem.isShowImageOnly().booleanValue()) {
                this.e.setEnabled(this.a.isEnable());
                this.e.setOpaque(false);
                this.e.setLayout((LayoutManager)new MigLayout("ins 0, fill"));
                this.e.add((Component)this.h, "align center");
            }
            if ((color2 = menuPageItem.getButtonColor()) != null) {
                this.setBackground(color2);
                this.g.setBackground(color2);
                this.e.setBackground(color2);
            }
            if ((color = menuPageItem.getTextColor()) != null) {
                this.setForeground(color);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setEnabled(this.a.isEnable());
            this.g.add((Component)this.e, "Center");
            if (this.a.isShowItemCountdown()) {
                Ticket ticket = OrderView.getInstance().getCurrentTicket();
                this.a(ticket.getItemOnHandCount(this.a));
            }
            this.add(this.g);
        }

        private void a(double d) {
            if (d < 0.0) {
                d = 0.0;
            }
            this.i = new JLabel(Messages.getString("MenuItemView.8") + NumberUtil.formatNumber(d));
            this.i.setForeground(this.b.getTextColor());
            this.i.setHorizontalAlignment(0);
            this.g.add((Component)this.i, "South");
        }

        private void b(double d) {
            this.g.remove(this.i);
            this.a(d);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                if (this.a == null) {
                    this.a = new MenuItem(this.b.getMenuItemId());
                }
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItem menuItem;
                menuItem.setEnable((menuItem = this.b.getMenuItem()).isEnable() == false);
                this.setEnabled(menuItem.isEnable());
                MenuItemDAO.getInstance().update(menuItem);
                PageItemButton pageItemButton = this;
                for (int i = 0; i < pageItemButton.getComponentCount(); ++i) {
                    Component component = pageItemButton.getComponent(i);
                    if (component instanceof JPanel) {
                        JPanel jPanel = (JPanel)component;
                        for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                            jPanel.getComponent(j).setEnabled(menuItem.isEnable());
                        }
                    }
                    component.setEnabled(menuItem.isEnable());
                }
                if (menuItem.isEnable().booleanValue()) {
                    ActionHistoryDAO.saveHistory("Enable menuItem", "MenuItem name: " + menuItem.getName() + " ,MenuItem id: " + menuItem.getId());
                } else {
                    ActionHistoryDAO.saveHistory("Disable menuItem", "MenuItem name: " + menuItem.getName() + " ,MenuItem id: " + menuItem.getId());
                }
                return;
            }
            if (this.b.getMenuItem().isShowItemCountdown()) {
                Ticket ticket = OrderView.getInstance().getCurrentTicket();
                this.b(ticket.getItemOnHandCount(this.a));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setBackground(Color.LIGHT_GRAY);
            this.g.setBackground(Color.LIGHT_GRAY);
            this.e.setBackground(Color.LIGHT_GRAY);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setBackground(this.b.getButtonColor());
            this.g.setBackground(this.b.getButtonColor());
            this.e.setBackground(this.b.getButtonColor());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = super.getBounds();
            if (rectangle.x == n && rectangle.y == n2 && rectangle.width == n3 && rectangle.height == n4) {
                return;
            }
            super.setBounds(n, n2, n3, n4);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuItemView.setItemImage(PageItemButton.this, PageItemButton.this.b, PageItemButton.this.a, MenuItemView.this.g, PageItemButton.this.e, PageItemButton.this.h);
                }
            });
        }
    }

    private class ItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem a;
        private JLabel d;
        private JPanel e;

        ItemButton(MenuItem menuItem) {
            Serializable serializable;
            Object object;
            this.a = menuItem;
            if (menuItem == null) {
                this.setVisible(false);
                return;
            }
            this.setLayout(new BorderLayout());
            this.setBorder((Border)new FlatLineBorder(new Insets(0, 0, 5, 0), Color.LIGHT_GRAY));
            Font font = DataProvider.get().getMenuFont();
            if (DataProvider.get().getStore().isEnablePriceOnMenuBtn()) {
                object = menuItem.getVariantPrice();
                if (menuItem.isUnitWiseItem()) {
                    object = InventoryUnitConvertionUtil.calculateUnitBaseItemPrice(menuItem, menuItem.getUnit(), false);
                }
                this.d = new JLabel(POSUtil.formatPriceDisplayWithHtmlBody((Double)object));
                this.d.setEnabled(menuItem.isEnable());
                this.d.setHorizontalAlignment(0);
                this.add((Component)this.d, "South");
            }
            if (!menuItem.isShowImageOnly().booleanValue()) {
                object = "<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>";
                serializable = new JLabel((String)object);
                ((JComponent)serializable).setEnabled(menuItem.isEnable());
                if (font != null && !OrderView.getInstance().getCurrentTicket().getOrderType().isRetailOrder().booleanValue()) {
                    ((JComponent)serializable).setFont(font);
                }
                this.e = new JPanel();
                this.e.setEnabled(menuItem.isEnable());
                this.e.setOpaque(false);
                this.e.setLayout((LayoutManager)new MigLayout("ins 0, fill"));
                this.e.add((Component)serializable, "align center");
                this.add((Component)this.e, "Center");
            }
            if ((object = menuItem.getButtonColor()) != null) {
                this.setBackground((Color)object);
            }
            if ((serializable = menuItem.getTextColor()) != null) {
                this.setForeground((Color)serializable);
            }
            this.setEnabled(menuItem.isEnable());
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                MenuItemView.this.a(this.a);
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            try {
                if (this.a.isUnitWiseItem()) {
                    return;
                }
                if (OrderView.getInstance().is_86Mode()) {
                    this.a.setEnable(this.a.isEnable() == false);
                    this.setEnabled(this.a.isEnable());
                    MenuItemDAO.getInstance().update(this.a);
                    ItemButton itemButton = this;
                    for (int i = 0; i < itemButton.getComponentCount(); ++i) {
                        Component component = itemButton.getComponent(i);
                        if (component instanceof JPanel) {
                            JPanel jPanel = (JPanel)component;
                            for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                                jPanel.getComponent(j).setEnabled(this.a.isEnable());
                            }
                        }
                        component.setEnabled(this.a.isEnable());
                    }
                    return;
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = super.getBounds();
            if (rectangle.x == n && rectangle.y == n2 && rectangle.width == n3 && rectangle.height == n4) {
                return;
            }
            super.setBounds(n, n2, n3, n4);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuItemView.setItemImage(ItemButton.this, null, ItemButton.this.a, MenuItemView.this.g);
                }
            });
        }
    }
}

