/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class QuickMenuPanel
extends JPanel {
    private JCheckBox a;
    private JList<MenuItem> b;
    private PosButton c;
    private PosButton d;
    private OrderType e;

    public QuickMenuPanel(OrderType orderType) {
        this.e = orderType;
    }

    public void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("ins 5, fill", "", "[][grow][]"));
        this.a = new JCheckBox(Messages.getString("QuickMenuPanel.3"));
        this.b = new JList();
        this.b.setModel(new DefaultListModel());
        this.b.setSelectionMode(2);
        this.b.setFocusable(false);
        this.b.setSelectionBackground(new Color(38, 117, 191));
        this.b.setSelectionForeground(Color.WHITE);
        this.c = new PosButton(Messages.getString("QuickMenuPanel.4"));
        this.d = new PosButton(Messages.getString("QuickMenuPanel.0"));
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(new TitledBorder(Messages.getString("QuickMenuPanel.5")));
        this.add((Component)this.a, "wrap");
        this.add((Component)jScrollPane, "grow, wrap");
        this.add((Component)this.c, "split 2");
        this.add(this.d);
        this.a.addChangeListener(changeEvent -> this.b());
        this.c.addActionListener(actionEvent -> this.c());
        this.d.addActionListener(actionEvent -> this.a());
        this.d();
    }

    private void a() {
        List<MenuItem> list = this.b.getSelectedValuesList();
        DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
        int n = this.b.getSelectedIndex();
        for (MenuItem menuItem : list) {
            defaultListModel.removeElement(menuItem);
        }
        if (n != -1) {
            this.b.setSelectedIndex(n == 0 ? n : n - 1);
        }
        if (list.isEmpty()) {
            POSMessageDialog.showError(Messages.getString("QuickMenuPanel.1"));
        }
    }

    private void b() {
        this.b.setEnabled(this.a.isSelected());
        this.c.setEnabled(this.a.isSelected());
        this.d.setEnabled(this.a.isSelected());
    }

    private void c() {
        try {
            List<MenuItem> list = new ArrayList<MenuItem>();
            DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                list.add((MenuItem)defaultListModel.getElementAt(i));
            }
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(list);
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setIncludePizzaItem(Boolean.FALSE);
            menuItemSelectionDialog.setSize(PosUIManager.getSize((int)600, (int)515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            defaultListModel.removeAllElements();
            list = menuItemSelectionDialog.getSelectedItems();
            Collections.sort(list, new Comparator<MenuItem>(){

                @Override
                public int compare(MenuItem menuItem, MenuItem menuItem2) {
                    return menuItem.getName().compareToIgnoreCase(menuItem2.getName());
                }
            });
            for (MenuItem menuItem : list) {
                defaultListModel.addElement(menuItem);
            }
            this.b.setModel(defaultListModel);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public String getMenuIds() {
        StringBuffer stringBuffer = new StringBuffer();
        DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            stringBuffer.append(((MenuItem)defaultListModel.getElementAt(i)).getId());
            if (i == defaultListModel.getSize() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public boolean isQucikMenuEnable() {
        return this.a.isSelected();
    }

    private void d() {
        if (this.e == null) {
            return;
        }
        this.a.setSelected(this.e.isQuickMenuEnable());
        this.b.setEnabled(this.e.isQuickMenuEnable());
        this.c.setEnabled(this.e.isQuickMenuEnable());
        this.d.setEnabled(this.e.isQuickMenuEnable());
        DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
        List<String> list = this.e.getQuickMenuIds();
        if (list == null || list.isEmpty()) {
            return;
        }
        defaultListModel.removeAllElements();
        List<MenuItem> list2 = MenuItemDAO.getInstance().getMenuItemByIDs(list);
        for (MenuItem menuItem : list2) {
            defaultListModel.addElement(menuItem);
        }
    }
}

