/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public abstract class SelectionView
extends JPanel {
    private static final int a = 5;
    private static final int b = 5;
    protected PaginatedListModel dataModel;
    protected Dimension buttonSize;
    protected JPanel selectionButtonsPanel;
    protected TitledBorder border;
    protected JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3, ins 2", "sg, fill", ""));
    protected PosButton btnNext;
    protected PosButton btnPrev;
    protected JLabel lblGroupDescripton;
    private boolean c = false;

    public SelectionView(String string, LayoutManager layoutManager, int n, int n2) {
        this.selectionButtonsPanel = this.createButtonPanel();
        this.selectionButtonsPanel.setLayout(layoutManager);
        this.buttonSize = new Dimension(n, n2);
        this.setLayout(new BorderLayout(5, 5));
        this.border = new TitledBorder(string);
        this.border.setTitleJustification(2);
        this.setBorder(new CompoundBorder(this.border, new EmptyBorder(2, 2, 2, 2)));
        this.lblGroupDescripton = new JLabel("", 0);
        this.lblGroupDescripton.setFont(this.lblGroupDescripton.getFont().deriveFont(15.0f));
        this.add((Component)this.lblGroupDescripton, "North");
        JScrollPane jScrollPane = this.createScrollContainer();
        if (jScrollPane != null) {
            this.selectionButtonsPanel.setMaximumSize(new Dimension(PosUIManager.getSize((int)120, (int)100)));
            jScrollPane.setViewportView(this.selectionButtonsPanel);
            this.add((Component)jScrollPane, "Center");
        } else {
            this.add((Component)this.selectionButtonsPanel, "Center");
        }
        this.btnPrev = new PosButton();
        this.btnPrev.setText(POSConstants.CAPITAL_PREV);
        this.actionButtonPanel.add((Component)this.btnPrev, "grow, align center");
        this.btnNext = new PosButton();
        this.btnNext.setText(POSConstants.CAPITAL_NEXT);
        this.actionButtonPanel.add((Component)this.btnNext, "grow, align center");
        this.add((Component)this.actionButtonPanel, "South");
        ScrollAction scrollAction = new ScrollAction();
        this.btnPrev.addActionListener(scrollAction);
        this.btnNext.addActionListener(scrollAction);
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
    }

    public void setTitle(String string) {
        this.border.setTitle(string);
    }

    public void setDataModel(PaginatedListModel paginatedListModel) {
        this.dataModel = paginatedListModel;
        this.renderItems();
    }

    protected void updateButton() {
        boolean bl = this.dataModel.hasNext();
        boolean bl2 = this.dataModel.hasPrevious();
        this.btnNext.setVisible(bl || bl2);
        this.btnPrev.setVisible(bl || bl2);
        this.btnPrev.setEnabled(bl2);
        this.btnNext.setEnabled(bl);
    }

    public PaginatedListModel getDataModel() {
        return this.dataModel;
    }

    public Dimension getButtonSize() {
        return this.buttonSize;
    }

    public void setButtonSize(Dimension dimension) {
        this.buttonSize = dimension;
    }

    protected abstract AbstractButton createItemButton(Object var1);

    public void reset() {
        Component[] componentArray;
        for (Component component : componentArray = this.selectionButtonsPanel.getComponents()) {
            int n;
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            ActionListener[] actionListenerArray = abstractButton.getActionListeners();
            EventListener[] eventListenerArray = actionListenerArray;
            int n2 = eventListenerArray.length;
            for (n = 0; n < n2; ++n) {
                ActionListener actionListener = eventListenerArray[n];
                abstractButton.removeActionListener(actionListener);
            }
            EventListener[] eventListenerArray2 = eventListenerArray = abstractButton.getMouseListeners();
            n = eventListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                EventListener eventListener = eventListenerArray2[i];
                abstractButton.removeMouseListener((MouseListener)eventListener);
            }
        }
        this.selectionButtonsPanel.removeAll();
        this.selectionButtonsPanel.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
    }

    protected int getHorizontalButtonCount() {
        Dimension dimension = this.selectionButtonsPanel.getSize();
        Dimension dimension2 = this.getButtonSize();
        return this.getButtonCount(dimension.width, dimension2.width);
    }

    protected int getFitableButtonCount() {
        Dimension dimension = this.selectionButtonsPanel.getSize();
        Insets insets = this.selectionButtonsPanel.getInsets();
        Dimension dimension2 = this.getButtonSize();
        int n = this.getButtonCount(dimension.width - insets.left - insets.right, dimension2.width);
        int n2 = this.getButtonCount(dimension.height - 50 - insets.top - insets.bottom, dimension2.height);
        int n3 = n * n2;
        return n3;
    }

    protected void renderItems() {
        try {
            this.reset();
            if (this.dataModel == null || this.dataModel.getSize() == 0) {
                return;
            }
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Object e = this.dataModel.getElementAt(i);
                AbstractButton abstractButton = this.createItemButton(e);
                if (abstractButton == null) continue;
                this.selectionButtonsPanel.add(abstractButton);
            }
            this.btnNext.setVisible(this.dataModel.hasNext());
            this.btnPrev.setVisible(this.dataModel.hasPrevious());
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            this.c = false;
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    protected void scrollDown() {
    }

    protected void scrollUp() {
    }

    public JPanel getButtonsPanel() {
        return this.selectionButtonsPanel;
    }

    public AbstractButton getFirstItemButton() {
        int n = this.selectionButtonsPanel.getComponentCount();
        if (n == 0) {
            return null;
        }
        return (AbstractButton)this.selectionButtonsPanel.getComponent(0);
    }

    protected int getButtonCount(int n, int n2) {
        int n3 = n / (n2 + 10);
        return n3;
    }

    public boolean isInitialized() {
        return this.c;
    }

    public void setInitialized(boolean bl) {
        this.c = bl;
    }

    public OrderType getOrderType() {
        return OrderView.getInstance().getCurrentTicket().getOrderType();
    }

    protected JPanel createButtonPanel() {
        return new JPanel();
    }

    protected JScrollPane createScrollContainer() {
        return null;
    }

    protected void addPreviousNextBtn() {
        this.actionButtonPanel.add(this.btnPrev);
        this.actionButtonPanel.add(this.btnNext);
    }

    private class ScrollAction
    implements ActionListener {
        private ScrollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = actionEvent.getSource();
                if (object == SelectionView.this.btnPrev) {
                    SelectionView.this.scrollUp();
                } else if (object == SelectionView.this.btnNext) {
                    SelectionView.this.scrollDown();
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }
    }
}

