/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.CurrencyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class TicketSelectionDialog
extends OkCancelOptionDialog {
    private ScrollableFlowPanel a;
    private List<Ticket> b = new ArrayList<Ticket>();
    private POSToggleButton c;

    public TicketSelectionDialog() {
        super((Window)Application.getPosWindow(), Messages.getString("TicketSelectionDialog.0"));
        this.a();
        this.b();
    }

    public TicketSelectionDialog(List<Ticket> list) {
        this.a();
        this.a(list);
        this.setResizable(true);
    }

    private void a() {
        this.setOkButtonText(Messages.getString("DONE"));
        this.a = new ScrollableFlowPanel(3);
        this.c = new POSToggleButton(Messages.getString("TicketSelectionDialog.1"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketSelectionDialog.this.b.clear();
                for (Component component : TicketSelectionDialog.this.a.getContentPane().getComponents()) {
                    TicketButton ticketButton = (TicketButton)component;
                    if (TicketSelectionDialog.this.c.isSelected()) {
                        ticketButton.setSelected(true);
                        TicketSelectionDialog.this.b.add(ticketButton.getTicket());
                        continue;
                    }
                    ticketButton.setSelected(false);
                }
            }
        });
        this.getButtonPanel().add((Component)this.c, 0);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize((int)25, (int)0));
        this.getContentPanel().add((Component)posScrollPane, "Center");
        this.setSize(PosUIManager.getSize((int)1024, (int)600));
    }

    private void b() {
        TicketDAO ticketDAO = new TicketDAO();
        try {
            List<Ticket> list = ticketDAO.getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO);
            Dimension dimension = PosUIManager.getSize((int)130, (int)100);
            for (Ticket ticket : list) {
                if (ticket.getDueAmount() <= 0.0) continue;
                TicketButton ticketButton = new TicketButton(ticket);
                this.a.add(ticketButton);
                ticketButton.setPreferredSize(dimension);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
    }

    private void a(List<Ticket> list) {
        try {
            for (Ticket ticket : list) {
                this.a.add(new TicketButton(ticket));
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getLocalizedMessage(), posException);
        }
    }

    @Override
    public void doOk() {
        if (this.b.isEmpty()) {
            POSMessageDialog.showMessage(Messages.getString("TicketSelectionDialog.5"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.b.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return this.b;
    }

    private class TicketButton
    extends POSToggleButton
    implements ActionListener {
        private Ticket b;

        TicketButton(Ticket ticket) {
            this.b = ticket;
            Terminal terminal = Application.getInstance().getTerminal();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body><center>");
            if (!terminal.isShowTableNumber()) {
                stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize((int)11), Messages.getString("TicketSelectionDialog.4") + ticket.getTableNames()));
            } else if (ticket.getTableNumbers() != null && ticket.getTableNumbers().size() > 0) {
                stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize((int)11), Messages.getString("TicketSelectionDialog.4") + ticket.getTableNames()));
            }
            stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize((int)11), ticket.getNumberToDisplay()));
            stringBuilder.append(String.format("<h4 style='margin:0px; font-size: %spx;'>%s</h4>", PosUIManager.getSize((int)10), POSConstants.DUE + ": " + CurrencyUtil.getCurrencySymbol() + ticket.getDueAmount()));
            stringBuilder.append("</center></body></html>");
            this.setText(stringBuilder.toString());
            this.setPreferredSize(StyledTicketSelectionDialog.tokenSize);
            this.addActionListener(this);
        }

        public Ticket getTicket() {
            return this.b;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                TicketSelectionDialog.this.b.add(this.b);
            } else {
                TicketSelectionDialog.this.b.remove(this.b);
            }
        }
    }
}

