/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.ReturnTicketItemAction;
import com.floreantpos.actions.VoidTicketItemAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.ServiceType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.pricecalc.TicketItemCalcFactory;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemSearchDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.CookingInstructionSelectionDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.util.BarcodeUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketView
extends JPanel {
    private final Vector<OrderListener> a = new Vector();
    private Ticket b;
    private final PosButton c = new PosButton(IconFactory.getIcon("/ui_icons/", "page-up.png"));
    private final PosButton d = new PosButton(IconFactory.getIcon("/ui_icons/", "page-down.png"));
    private final PosButton e = new PosButton();
    private final PosButton f = new PosButton(IconFactory.getIcon("/ui_icons/", "edit.png"));
    private final PosButton g = new PosButton(IconFactory.getIcon("/ui_icons/", "add-multiple.png"));
    private PosButton h;
    private final PosButton i = new PosButton();
    private TransparentPanel j;
    private JScrollPane k;
    private PosButton l;
    private TicketViewerTable m;
    private JPanel n;
    private JTextField o;
    private final PosButton p = new PosButton(IconFactory.getIcon("/ui_icons/", "cooking-instruction.png"));
    private final TitledBorder q = new TitledBorder("");
    private final Border r = new CompoundBorder(this.q, new EmptyBorder(2, 2, 2, 2));
    private boolean s;
    private boolean t;
    public static final String VIEW_NAME = "TICKET_VIEW";

    public TicketView() {
        this.a();
    }

    private void a() {
        this.q.setTitleJustification(2);
        this.setBorder(this.r);
        this.setLayout(new BorderLayout(5, 5));
        this.n = new JPanel();
        this.j = new TransparentPanel();
        this.h = new PosButton();
        this.m = new TicketViewerTable();
        this.b();
        this.f.setEnabled(false);
        this.p.setEnabled(false);
        this.e();
        this.f();
        this.c();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JTableHeader jTableHeader = this.m.getTableHeader();
        jPanel.add((Component)jTableHeader, "North");
        jPanel.add(this.k);
        jPanel.setBorder(UIManager.getBorder("ScrollPane.border"));
        this.add((Component)this.n, "North");
        this.add(jPanel);
        this.add((Component)this.j, "East");
        this.m.getRenderer().setInTicketScreen(true);
        this.m.getSelectionModel().addListSelectionListener(new TicketItemSelectionListener());
        this.setPreferredSize(PosUIManager.getSize((int)320, (int)463));
    }

    private void b() {
        VerticalTouchScrollPanel verticalTouchScrollPanel = new VerticalTouchScrollPanel(new BorderLayout());
        verticalTouchScrollPanel.add(this.m);
        this.k = new JScrollPane(verticalTouchScrollPanel);
        this.k.getVerticalScrollBar().setUnitIncrement(50);
        this.k.setVerticalScrollBarPolicy(20);
        this.k.setPreferredSize(PosUIManager.getSize((int)180, (int)200));
    }

    private void c() {
        this.n.setLayout(new BorderLayout(5, 5));
        PosButton posButton = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        posButton.setPreferredSize(PosUIManager.getSize((int)50, (int)40));
        this.o = new FixedLengthTextField(255);
        this.o.requestFocusInWindow();
        this.o.addActionListener(actionEvent -> this.d());
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSearchDialog itemSearchDialog = ItemSearchDialog.getInstance();
                itemSearchDialog.updateFilterPanel(TicketView.this.b.getOrderType());
                itemSearchDialog.setResizable(true);
                itemSearchDialog.openFullScreen();
                if (itemSearchDialog.isCanceled()) {
                    return;
                }
                TicketView.this.o.requestFocus();
                if (itemSearchDialog.getMenuItem() == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.8"));
                    return;
                }
                OrderView.getInstance().getOrderController().itemSelected(itemSearchDialog.getMenuItem());
            }
        });
        this.n.add(this.o);
        this.n.add((Component)posButton, "East");
    }

    private boolean a(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            String string2 = string.trim();
            OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderServiceExtension == null || StringUtils.isBlank((String)string2)) {
                return false;
            }
            Customer customer = orderServiceExtension.getCustomerByMemberId(string2);
            if (customer == null) {
                return false;
            }
            if (customer.isDeleted().booleanValue()) {
                throw new PosException("This customer is deleted");
            }
            if (!customer.isActive().booleanValue()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.12"));
                return false;
            }
            if (this.b.isPaid().booleanValue() && StringUtils.isNotEmpty((String)this.b.getCustomerName())) {
                throw new PosException(Messages.getString("OrderView.22"));
            }
            this.o.setText("");
            POSMessageDialog.showMessage(POSConstants.CUSTOMER + ": " + customer.getName());
            this.fireCustomerSelected(customer);
        }
        return true;
    }

    private void d() {
        try {
            String string = this.o.getText();
            if (string.equals("")) {
                POSMessageDialog.showMessage(Messages.getString("TicketView.5"));
                return;
            }
            if (this.a(string)) {
                return;
            }
            if (DataProvider.get().getStore().isEnableVariablePriceBarcode() && BarcodeUtil.isVariableMeasureItem(string)) {
                MenuItem menuItem;
                String string2 = "";
                BigDecimal bigDecimal = null;
                Double d = null;
                string2 = BarcodeUtil.extractBarcodeFromVariableMeasureItem(string);
                if (BarcodeUtil.isVariableMeasureItemWithPrice(string)) {
                    bigDecimal = BarcodeUtil.extractPriceFromVariableMeasureItem(string);
                }
                if (BarcodeUtil.isVariableMeasureItemWithWeight(string)) {
                    d = BarcodeUtil.extractWeightFromVariableMeasureItem(string);
                }
                if ((menuItem = MenuItemDAO.getInstance().getMenuItemBySKU(this.b.getOrderType(), string2)) != null) {
                    OrderView.getInstance().getOrderController().variableMeasureItemSelected(menuItem, bigDecimal == null ? null : Double.valueOf(bigDecimal.doubleValue()), d);
                } else {
                    Double d2;
                    if (bigDecimal == null) {
                        d2 = NumberSelectionDialog2.takeDoubleInput("Price", Boolean.FALSE);
                        if (d2 == null) {
                            this.o.setText("");
                            return;
                        }
                    } else {
                        d2 = bigDecimal.doubleValue();
                    }
                    TicketItem ticketItem = new TicketItem();
                    ticketItem.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
                    ticketItem.setQuantity(d == null ? 1.0 : d);
                    ticketItem.setUnitPrice(d2);
                    ticketItem.setName(POSConstants.MISC_BUTTON_TEXT + "-" + string2);
                    ticketItem.setMenuItemId("0");
                    ticketItem.setCategoryName(POSConstants.MISC_BUTTON_TEXT);
                    ticketItem.setGroupName(POSConstants.MISC_BUTTON_TEXT);
                    ticketItem.setShouldPrintToKitchen(true);
                    MenuItem.setItemTaxes(ticketItem, null, this.b.getOrderType());
                    TicketView ticketView = OrderView.getInstance().getTicketView();
                    ticketView.addTicketItem(ticketItem, Boolean.TRUE);
                }
            } else {
                MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemByBarcodeOrSKU(this.b.getOrderType(), string);
                if (menuItem != null) {
                    OrderView.getInstance().getOrderController().itemSelected(menuItem);
                }
            }
            this.o.setText("");
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void e() {
        this.l = new PosButton(POSConstants.TOTAL.toUpperCase());
        this.l.setFont(this.l.getFont().deriveFont(1));
        this.l.addActionListener(actionEvent -> this.firePayOrderSelected());
        this.add((Component)this.l, "South");
    }

    private void f() {
        this.j.setLayout((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0", "sg, fill", ""));
        this.i.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.i.addActionListener(actionEvent -> this.l());
        this.c.addActionListener(actionEvent -> this.m());
        this.h.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.h.addActionListener(actionEvent -> this.k());
        this.d.addActionListener(actionEvent -> this.n());
        this.e.setText("");
        this.e.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png"));
        this.e.addActionListener(actionEvent -> this.i());
        this.f.addActionListener(actionEvent -> this.j());
        this.g.addActionListener(actionEvent -> this.g());
        this.p.addActionListener(actionEvent -> this.doAddCookingInstruction());
        this.j.add((Component)this.c, "grow, wrap");
        this.j.add((Component)this.i, "grow, wrap");
        this.j.add((Component)this.g, "grow, wrap");
        this.j.add((Component)this.e, "grow, wrap");
        this.j.add((Component)this.f, "grow, wrap");
        this.j.add((Component)this.p, "grow, wrap");
        this.j.add((Component)this.h, "grow, wrap");
        this.j.add((Component)this.d, "grow");
        this.j.setPreferredSize(PosUIManager.getSize((int)50, (int)0));
    }

    private void g() {
        try {
            ITicketItem iTicketItem = this.m.getSelected();
            if (iTicketItem == null) {
                return;
            }
            if (!(iTicketItem instanceof TicketItem) || ((TicketItem)iTicketItem).isTreatAsSeat().booleanValue()) {
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            OrderView.getInstance().getOrderController().doEditTicketItemQuantity(ticketItem);
            this.updateView();
            int n = this.m.getSelectedRow();
            this.m.getModel().fireTableRowsUpdated(n, n);
            this.m.fireTicketItemUpdated(this.getTicket(), ticketItem);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public void doVoidOrder() {
        this.a(false, true);
    }

    public synchronized void doFinishOrder() throws Exception {
        this.saveTicketIfNeeded();
        this.sendTicketToKitchen();
        this.a(false, true);
    }

    @Deprecated
    public synchronized void sendTicketToKitchenByOption(RefreshableView refreshableView) throws Exception {
        boolean bl = this.b.isKitchenPrintable();
        if (!bl) {
            throw new PosException(Messages.getString("TicketView.333"));
        }
        OrderController.saveOrder(this.b);
        if (this.b.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            if (this.b.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.b, true);
                POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
                ActionHistoryDAO.saveHistory(this.b, "Sent to kitchen", "");
            } else {
                POSMessageDialog.showMessage(Messages.getString("TicketView.333"));
            }
        }
        this.setAllowToLogOut(false);
    }

    public synchronized void sendTicketToKitchen() throws Exception {
        if (this.b.getOrderType().isShouldPrintToKitchen().booleanValue() && this.b.needsKitchenPrint()) {
            try {
                ReceiptPrintService.printToKitchen(this.b);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Messages.getString("TicketView.1"));
            }
            this.setCancelable(false);
            this.setAllowToLogOut(false);
        }
    }

    public void doHoldOrder() {
        this.doHoldOrder(true);
    }

    public synchronized void doHoldOrder(boolean bl) {
        if (!PosAction.checkPermission(Application.getCurrentUser(), UserPermission.HOLD, false, true)) {
            return;
        }
        this.h();
        String string = StringUtils.isBlank((String)this.b.getId()) ? " " : "Ticket id: " + this.b.getId();
        this.b.addEvent("Hold order", string);
        OrderController.saveOrder(this.b);
        this.a(false, bl);
    }

    public void saveTicketIfNeeded() {
        this.h();
        OrderController.saveOrder(this.b);
    }

    private void a(boolean bl, boolean bl2) {
        DataChangeListener dataChangeListener = RootView.getInstance().getHomeView().getDataChangeListener();
        if (dataChangeListener != null) {
            if (bl) {
                dataChangeListener.dataChangeCanceled(this.b);
            } else {
                dataChangeListener.dataChanged(this.b);
            }
        }
        if (bl2) {
            RootView.getInstance().showDefaultView();
        }
    }

    public void doCancelOrder() {
        this.doCancelOrder(true);
    }

    public void doCancelOrder(boolean bl) {
        this.a(true, bl);
    }

    private synchronized void h() {
        if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        this.b.calculatePrice();
    }

    private void i() {
        try {
            boolean bl;
            ITicketItem iTicketItem = this.m.getSelected();
            if (iTicketItem == null) {
                return;
            }
            if (!(iTicketItem instanceof TicketItem)) {
                this.m.deleteSelectedItem();
                this.updateView();
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            boolean bl2 = bl = ticketItem.getInventoryAdjustQty() > 0.0;
            if (ticketItem.isGiftCard() && ticketItem.getGiftCardPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.4"));
                return;
            }
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                this.e(ticketItem);
            } else if (iTicketItem.isPrintedToKitchen().booleanValue() || bl) {
                if (ticketItem.isService().booleanValue() && !ticketItem.isVoided().booleanValue() && !this.b.isPaid().booleanValue()) {
                    int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("TicketView.6"));
                    if (n != 0) {
                        return;
                    }
                    this.b.voidItem(ticketItem, Messages.getString("TicketView.10"), false, ticketItem.getQuantity());
                    this.m.updateView();
                    this.updateView();
                } else if (ticketItem.isVoided().booleanValue()) {
                    this.c(ticketItem);
                } else {
                    MenuItem menuItem = ticketItem.getMenuItem();
                    if (menuItem != null && !menuItem.isFractionalUnit().booleanValue() && ticketItem.isFractionalUnit().booleanValue() && ticketItem.isPaid().booleanValue()) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.19"));
                        return;
                    }
                    this.a(ticketItem);
                    this.m.fireDataRemoved(ticketItem);
                }
            } else if (!ticketItem.isItemReturned().booleanValue() && ticketItem.isVoided().booleanValue()) {
                this.d(ticketItem);
            } else {
                this.m.deleteSelectedItem();
                String string = "Item name: " + ticketItem.getNameDisplay();
                string = string + (StringUtils.isBlank((String)ticketItem.getMenuItemId()) ? " " : ", MenuItem id: " + ticketItem.getMenuItemId());
                this.b.addEvent("Item deleted", string);
                this.updateView();
            }
            PaymentView paymentView = OrderView.getInstance().getPaymentView();
            if (paymentView != null) {
                paymentView.setIsClearPreviousAmount(true);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(TicketItem ticketItem) {
        if (ticketItem.isPaid().booleanValue()) {
            ReturnTicketItemAction returnTicketItemAction = new ReturnTicketItemAction(this, this.b, ticketItem);
            returnTicketItemAction.actionPerformed(null);
            if (returnTicketItemAction.isDataChanged()) {
                if (ticketItem.isShowItemCountdown() && !ticketItem.isItemWasted().booleanValue()) {
                    this.b(ticketItem);
                }
                this.m.updateView();
                this.updateView();
            }
        } else {
            VoidTicketItemAction voidTicketItemAction = new VoidTicketItemAction(this.b, ticketItem);
            voidTicketItemAction.actionPerformed(null);
            if (voidTicketItemAction.isDataChanged()) {
                if (ticketItem.isShowItemCountdown() && !ticketItem.isItemWasted().booleanValue()) {
                    this.b(ticketItem);
                }
                this.m.updateView();
                this.updateView();
            }
        }
    }

    private void b(TicketItem ticketItem) {
        double d = this.b.getItemOnHandCount(ticketItem.getMenuItem());
        this.b.putItemOnHandCount(ticketItem.getMenuItemId(), d += Math.abs(ticketItem.getQuantity()));
    }

    private void c(TicketItem ticketItem) {
        if (!ticketItem.isItemReturned().booleanValue()) {
            this.d(ticketItem);
            return;
        }
        if (ticketItem.getId() == null) {
            this.m.deleteSelectedItem();
            this.updateView();
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        this.m.deleteSelectedItem();
        this.updateView();
    }

    private void d(TicketItem ticketItem) {
        if (POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        TicketItem ticketItem2 = this.b.undoVoidItem(ticketItem);
        if (ticketItem != ticketItem2) {
            this.m.deleteSelectedItem();
            this.m.getModel().fireTableRowsUpdated(ticketItem2.getTableRowNum(), ticketItem2.getTableRowNum());
        } else {
            if (ticketItem.isShowItemCountdown() && !ticketItem.isItemWasted().booleanValue()) {
                double d = this.b.getItemOnHandCount(ticketItem.getMenuItem()) - ticketItem.getQuantity();
                this.b.putItemOnHandCount(ticketItem.getMenuItemId(), d);
            }
            int n = this.m.getSelectedRow();
            this.m.getModel().fireTableRowsUpdated(n, n);
        }
        this.m.fireTicketItemUpdated(this.getTicket(), ticketItem);
        this.updateView();
    }

    private void e(TicketItem ticketItem) {
        TicketItem ticketItem2;
        if (ticketItem.isSaved() && POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) != 0) {
            return;
        }
        TicketItemSeat ticketItemSeat = null;
        Integer n = 0;
        List<TicketItem> list = this.getTicket().getTicketItems();
        int n2 = list.indexOf(ticketItem);
        if (n2 > 0) {
            TicketItem ticketItem3 = list.get(n2 - 1);
            ticketItemSeat = ticketItem3.getSeat();
            n = ticketItem3.getSeatNumber();
        }
        for (int i = n2 + 1; i < list.size() && !(ticketItem2 = list.get(i)).isTreatAsSeat().booleanValue(); ++i) {
            ticketItem2.setSeat(ticketItemSeat);
            ticketItem2.setSeatNumber(n);
        }
        this.m.deleteSelectedItem();
        String string = "Deleted seat number with table name: " + ticketItem.getNameDisplay();
        this.b.addRandomEvent("Seat deleted", string);
        this.updateView();
    }

    private void j() {
        ITicketItem iTicketItem = this.m.getSelected();
        if (iTicketItem == null) {
            return;
        }
        try {
            this.a(iTicketItem);
            if (iTicketItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    if (!OrderView.getInstance().updateSeat(ticketItem)) {
                        return;
                    }
                } else if (ticketItem.isService().booleanValue() && ticketItem.getServiceType().equals(ServiceType.ADD_CUSTOMER_BALANCE.name())) {
                    double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketView.11"), ticketItem.getSubtotalAmount());
                    if (d < 0.0) {
                        return;
                    }
                    ticketItem.setUnitPrice(d);
                } else if (ticketItem.isComboItem().booleanValue()) {
                    MenuItem menuItem = ticketItem.getMenuItem();
                    if (menuItem == null) {
                        throw new PosException(Messages.getString("TicketView.2") + ticketItem.getMenuItemId() + Messages.getString("TicketView.3"));
                    }
                    ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(menuItem, ticketItem);
                    comboTicketItemSelectionDialog.setTitle(Messages.getString("TicketView.47"));
                    comboTicketItemSelectionDialog.openFullScreen();
                    if (comboTicketItemSelectionDialog.isCanceled()) {
                        return;
                    }
                    TicketItemCalcFactory.getCalc(ticketItem).doCalculateComboItemPrice(ticketItem, true);
                } else {
                    OrderController.openModifierDialog(iTicketItem);
                }
                this.m.fireTicketItemUpdated(this.b, ticketItem);
            } else {
                OrderController.openModifierDialog(iTicketItem);
            }
            this.updateView();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void a(ITicketItem iTicketItem) {
        Comparable comparable;
        TicketItem ticketItem = null;
        if (iTicketItem instanceof TicketItem) {
            ticketItem = (TicketItem)iTicketItem;
        } else if (iTicketItem instanceof TicketItemModifier) {
            comparable = (TicketItemModifier)iTicketItem;
            ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
        }
        comparable = ticketItem.getMenuItem();
        if (comparable != null && ((BaseMenuItem)comparable).isDeleted().booleanValue()) {
            throw new PosException(Messages.getString("TicketView.0"));
        }
    }

    private void k() {
        this.m.scrollDown();
    }

    private void l() {
        this.m.scrollUp();
    }

    private void m() {
        this.m.scrollUpTen();
    }

    private void n() {
        this.m.scrollDownTen();
    }

    public Ticket getTicket() {
        return this.b;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
        this.m.setTicket(ticket);
        this.updateView();
        this.setCancelable(true);
        this.setAllowToLogOut(true);
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.addTicketItem(ticketItem, Boolean.FALSE);
    }

    public void addTicketItem(TicketItem ticketItem, boolean bl) {
        this.m.addTicketItem(ticketItem, bl);
        this.updateView();
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        ticketItemModifier.setItemQuantity(0.0);
        this.m.removeModifier(ticketItem, ticketItemModifier);
    }

    public void selectRow(int n) {
        this.m.selectRow(n);
    }

    public void updateView() {
        if (this.b == null) {
            this.l.setText(POSConstants.TOTAL.toUpperCase() + " " + CurrencyUtil.getCurrencySymbol() + "0.00");
            this.q.setTitle("[" + Messages.getString("NewTicket") + "]");
            return;
        }
        this.b.calculatePrice();
        if (this.b.getDueAmount() < 0.0) {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            String string2 = Messages.getString("TicketView.48") + CurrencyUtil.getCurrencySymbol() + string.replaceFirst("-", "");
            this.l.setText(string2);
        } else {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            this.l.setText(Messages.getString("TicketView.51") + CurrencyUtil.getCurrencySymbol() + string);
        }
        this.updateTicketTitle();
        this.a((Object)this.m.getSelected());
    }

    public void updateTicketTitle() {
        String string = this.b.getOrderType().toString();
        if (this.b.getId() == null) {
            this.q.setTitle(string + " [New Ticket]");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Messages.getString("TicketView.37");
            stringBuilder.append(string);
            stringBuilder.append(" [ " + string2 + " " + this.b.getTokenNo() + " ]");
            this.q.setTitle(stringBuilder.toString());
        }
        this.repaint();
    }

    public void addOrderListener(OrderListener orderListener) {
        this.a.add(orderListener);
    }

    public void removeOrderListener(OrderListener orderListener) {
        this.a.remove(orderListener);
    }

    public void firePayOrderSelected() {
        for (OrderListener orderListener : this.a) {
            orderListener.payOrderSelected(this.getTicket());
        }
    }

    public void fireCustomerSelected(Customer customer) {
        for (OrderListener orderListener : this.a) {
            orderListener.setCustomer(customer);
        }
    }

    public void setControlsVisible(boolean bl) {
        this.e.setEnabled(bl);
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.m;
    }

    public void setEnableActionButtons(boolean bl) {
        this.p.setEnabled(bl);
        this.g.setEnabled(bl);
        this.f.setEnabled(bl);
        this.e.setEnabled(bl);
    }

    private String a(ITicketItem iTicketItem, String string) {
        String string2;
        String string3;
        double d;
        String string4 = iTicketItem.getNameDisplay();
        string4 = string4.length() > 10 ? iTicketItem.getNameDisplay().substring(0, 10) : iTicketItem.getNameDisplay();
        String string5 = String.format("%-10s %9s", string4, NumberUtil.formatNumber(d = iTicketItem.getSubtotalAmount() == null ? 0.0 : iTicketItem.getSubtotalAmount(), true));
        if (string5.length() > 20) {
            string5 = string5.substring(0, 20);
        }
        if ((string3 = String.format("%-8s %11s", string2 = Messages.getString("TicketView.29") + CurrencyUtil.getCurrencySymbol(), string)).length() > 20) {
            string3 = string3.substring(0, 20);
        }
        return string5 + string3;
    }

    public boolean isCancelable() {
        return this.s;
    }

    public void setCancelable(boolean bl) {
        this.s = bl;
    }

    public boolean isAllowToLogOut() {
        return this.t;
    }

    public void setAllowToLogOut(boolean bl) {
        this.t = bl;
    }

    public boolean isStockAvailable(MenuItem menuItem, TicketItem ticketItem, double d) {
        if (!menuItem.isDisableWhenStockAmountIsZero().booleanValue()) {
            return true;
        }
        List<TicketItem> list = this.m.getTicketItems();
        if (menuItem.isFractionalUnit().booleanValue()) {
            if (list == null || list.isEmpty()) {
                return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
            }
            double d2 = 0.0;
            for (TicketItem ticketItem2 : list) {
                if (!menuItem.getName().equals(ticketItem2.getName())) continue;
                d2 += ticketItem2.getQuantity().doubleValue();
                if (!(menuItem.getAvailableUnit() < d2)) continue;
                return false;
            }
            if (d != -1.0) {
                d2 -= ticketItem.getQuantity().doubleValue();
                d2 += d;
            } else {
                d2 += ticketItem.getQuantity().doubleValue();
            }
            return !(menuItem.getAvailableUnit() < d2);
        }
        if (list == null || list.isEmpty()) {
            return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
        }
        int n = 0;
        for (TicketItem ticketItem3 : list) {
            if (!ticketItem3.getName().equals(menuItem.getName())) continue;
            n = (int)((double)n + ticketItem3.getQuantity());
            if (!(menuItem.getAvailableUnit() <= (double)n)) continue;
            return false;
        }
        return true;
    }

    protected void doAddCookingInstruction() {
        try {
            ITicketItem iTicketItem = this.m.getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (ticketItem.isPrintedToKitchen().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.21"));
                return;
            }
            CookingInstructionSelectionDialog cookingInstructionSelectionDialog = new CookingInstructionSelectionDialog();
            cookingInstructionSelectionDialog.setSize(PosUIManager.getSize((int)850, (int)600));
            cookingInstructionSelectionDialog.setLocationRelativeTo(Application.getPosWindow());
            cookingInstructionSelectionDialog.setVisible(true);
            if (cookingInstructionSelectionDialog.isCanceled()) {
                return;
            }
            List<TicketItemCookingInstruction> list = cookingInstructionSelectionDialog.getTicketItemCookingInstructions();
            ticketItem.addCookingInstructions(list);
            this.b.addEvent("Add cooking instructions", "Item name: " + ticketItem.getNameDisplay());
            this.m.updateView();
            this.m.fireTicketItemUpdated(this.b, ticketItem);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public void showSettleButton(boolean bl) {
        this.l.setVisible(bl);
        this.f.setVisible(bl);
        this.p.setVisible(bl);
    }

    private void a(Object object) {
        if (TerminalConfig.isActiveCustomerDisplay()) {
            TicketItem ticketItem = null;
            if (object instanceof TicketItemModifier) {
                ticketItem = ((TicketItemModifier)object).getTicketItem();
            } else if (object instanceof TicketItem) {
                ticketItem = (TicketItem)object;
            }
            if (ticketItem != null) {
                String string = this.a(ticketItem, NumberUtil.formatNumber(this.b.getTotalAmountWithTips(), true));
                DrawerUtil.setItemDisplay(TerminalConfig.getCustomerDisplayPort(), string);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.o.getParent() == null) {
                this.n.add(this.o);
            }
            this.o.requestFocus();
        } else {
            this.n.remove(this.o);
        }
    }

    private class TicketItemSelectionListener
    implements ListSelectionListener {
        private TicketItemSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ITicketItem iTicketItem = TicketView.this.m.getSelected();
            if (iTicketItem == null) {
                TicketView.this.setEnableActionButtons(false);
            }
            if (!(iTicketItem instanceof ITicketItem)) {
                return;
            }
            TicketView.this.setEnableActionButtons(true);
            ITicketItem iTicketItem2 = iTicketItem;
            if (iTicketItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                if (ticketItem.isVoided().booleanValue() || ticketItem.isGiftCard()) {
                    TicketView.this.setEnableActionButtons(false);
                    TicketView.this.setControlsVisible(StringUtils.isBlank((String)ticketItem.getProperty("voidId")) || !ticketItem.isInventoryAdjusted());
                } else if (ticketItem.isItemReturned().booleanValue()) {
                    if (ticketItem.isPrintedToKitchen().booleanValue() || ticketItem.getInventoryAdjustQty() > 0.0) {
                        TicketView.this.setEnableActionButtons(false);
                    } else {
                        TicketView.this.g.setEnabled(false);
                        TicketView.this.p.setEnabled(false);
                        TicketView.this.f.setEnabled(false);
                    }
                } else if (!(ticketItem instanceof ModifiableTicketItem || ticketItem.isComboItem().booleanValue() || ticketItem.isTreatAsSeat().booleanValue())) {
                    TicketView.this.f.setEnabled(false);
                }
                if (ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isService().booleanValue()) {
                    TicketView.this.p.setEnabled(false);
                    TicketView.this.g.setEnabled(false);
                }
                if (ticketItem.isService().booleanValue() && ticketItem.getServiceType().equals(ServiceType.ADD_CUSTOMER_BALANCE.name())) {
                    TicketView.this.f.setEnabled(ticketItem.isPaid() == false);
                    TicketView.this.e.setEnabled(ticketItem.isPaid() == false);
                } else if (ticketItem.isInventoryAdjusted()) {
                    TicketView.this.g.setEnabled(false);
                }
                if (ticketItem.isPaid().booleanValue()) {
                    TicketView.this.g.setEnabled(false);
                    TicketView.this.f.setEnabled(false);
                }
            }
            if (iTicketItem2.isPrintedToKitchen().booleanValue() || iTicketItem2 instanceof TicketItemCookingInstruction || iTicketItem2 instanceof TicketItemDiscount) {
                TicketView.this.p.setEnabled(false);
                TicketView.this.g.setEnabled(false);
                TicketView.this.f.setEnabled(false);
                if (iTicketItem2.isPrintedToKitchen().booleanValue() && iTicketItem instanceof TicketItemCookingInstruction) {
                    TicketView.this.e.setEnabled(false);
                }
                if (iTicketItem instanceof TicketItemModifier || iTicketItem instanceof TicketItemDiscount) {
                    TicketView.this.e.setEnabled(false);
                }
                if (iTicketItem2 instanceof TicketItem && ((TicketItem)iTicketItem2).isTreatAsSeat().booleanValue()) {
                    TicketView.this.f.setEnabled(true);
                }
            } else if (iTicketItem instanceof TicketItemModifier) {
                TicketView.this.f.setEnabled(true);
                TicketView.this.e.setEnabled(false);
                TicketView.this.p.setEnabled(false);
                TicketView.this.g.setEnabled(false);
            }
            TicketView.this.a(iTicketItem);
        }
    }
}

