/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.modifier.ModifierView;
import com.floreantpos.ui.views.order.modifier.ModifierViewerTable;
import com.floreantpos.ui.views.order.modifier.TicketItemModifierTableView;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierSelectionDialog
extends POSDialog
implements ModifierGroupSelectionListener,
ModifierSelectionListener {
    private ModifierSelectionModel a;
    private ModifierGroupView b;
    private ModifierView c;
    private TicketItemModifierTableView d;
    private JPanel e = new JPanel(new BorderLayout(5, 5));
    private TransparentPanel f;
    private PosButton g;
    private PosButton h;

    public ModifierSelectionDialog(ModifierSelectionModel modifierSelectionModel) {
        super((Frame)Application.getPosWindow(), true);
        this.a = modifierSelectionModel;
        this.b();
        this.a();
    }

    private void a() {
        MenuItem menuItem = this.a.getMenuItem();
        if (this.a.getTicketItem().getTicketItemModifiers() == null) {
            List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
            Multiplier multiplier = MultiplierDAO.getInstance().getDefaultMutltiplier();
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                List<DefaultMenuModifier> list2;
                if (!menuItemModifierSpec.isEnable().booleanValue() || (list2 = menuItemModifierSpec.getDefaultModifierList()) == null) continue;
                for (DefaultMenuModifier defaultMenuModifier : list2) {
                    MenuModifier menuModifier = defaultMenuModifier.getModifier();
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                    Multiplier multiplier2 = defaultMenuModifier.getMultiplier();
                    if (multiplier2 == null) {
                        multiplier2 = multiplier;
                    }
                    menuModifier.setMenuItemModifierSpec(menuItemModifierSpec);
                    this.a(menuModifier, multiplier2, NumberUtil.round(defaultMenuModifier.getQuantity(), 0), true);
                }
            }
        }
    }

    private void b() {
        this.setTitle(Messages.getString("ModifierSelectionDialog.0"));
        this.setLayout(new BorderLayout(PosUIManager.getSize((int)5), PosUIManager.getSize((int)5)));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ModifierSelectionDialog.12") + this.a.getMenuItem().getDisplayName());
        this.add((Component)titlePanel, "North");
        this.b = new ModifierGroupView(this.a);
        this.c = new ModifierView(this.a);
        this.d = new TicketItemModifierTableView(this.a);
        this.f = new TransparentPanel();
        this.f.setLayout((LayoutManager)new MigLayout("fill, ins 4", "fill", ""));
        this.e.add(this.d);
        this.add(this.c);
        boolean bl = DataProvider.get().getStore().getBooleanProperty("order_view.ticket_on_right", false);
        if (!bl) {
            this.add((Component)this.b, "East");
            this.add((Component)this.e, "West");
        } else {
            this.add((Component)this.b, "West");
            this.add((Component)this.e, "East");
        }
        this.createButtonPanel();
        Rectangle rectangle = Application.getPosWindow().getBounds();
        this.setBounds(new Rectangle((int)(rectangle.getWidth() - 40.0), (int)(rectangle.getHeight() - 40.0)));
        this.d.addModifierSelectionListener(this);
        this.b.addModifierGroupSelectionListener(this);
        this.c.addModifierSelectionListener(this);
        this.b.selectFirst();
    }

    public void createButtonPanel() {
        this.g = new PosButton(Messages.getString("DONE"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.c();
            }
        });
        this.h = new PosButton(POSConstants.CANCEL.toUpperCase());
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.setCanceled(true);
                ModifierSelectionDialog.this.dispose();
            }
        });
        this.f.add(this.h);
        this.f.add(this.g);
    }

    public ModifierGroupView getModifierGroupView() {
        return this.b;
    }

    public void setModifierGroupView(ModifierGroupView modifierGroupView) {
        this.b = modifierGroupView;
    }

    public ModifierView getModifierView() {
        return this.c;
    }

    public void setModifierView(ModifierView modifierView) {
        this.c = modifierView;
    }

    private void c() {
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        if (list == null) {
            this.dispose();
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            boolean bl = menuItemModifierSpec.isUseModifierGroupSettings() ? menuItemModifierSpec.getModifierGroup().isEnable() : menuItemModifierSpec.isEnable();
            if (!bl || ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) continue;
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
        }
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuItemModifierSpec) {
        this.c.setModifierGroup(menuItemModifierSpec, true);
    }

    @Override
    public void modifierSelected(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier);
    }

    private void a(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier, 1.0, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(MenuModifier menuModifier, Multiplier serializable, Double d, boolean bl) {
        Object object;
        void var2_4;
        int n;
        Object object2;
        Serializable serializable2;
        void var4_6;
        Object object3;
        TicketItem ticketItem = this.a.getTicketItem();
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierSpec();
        int n2 = ticketItem.countModifierFromGroup(menuItemModifierSpec);
        int n3 = 0;
        int n4 = 0;
        if (menuItemModifierSpec.isUseModifierGroupSettings()) {
            object3 = menuItemModifierSpec.getModifierGroup();
            n3 = ((BaseModifierGroup)object3).getMinQuantity();
            n4 = ((BaseModifierGroup)object3).getMaxQuantity();
        } else {
            n3 = menuItemModifierSpec.getMinQuantity();
            n4 = menuItemModifierSpec.getMaxQuantity();
        }
        if (n4 < n3) {
            n4 = n3;
        }
        if (n2 >= n4 && var4_6 == false) {
            object3 = DataProvider.get().getStore();
            if (((Store)object3).hasExtraMultiplier().booleanValue()) {
                serializable2 = ((Store)object3).getExtraMultiplier();
                String string = Messages.getString("ModifierSelectionDialog.4");
                n = POSMessageDialog.showYesNoQuestionDialog(this, string, (String)(object2 = Messages.getString("ModifierSelectionDialog.8")));
                if (n != 0) return;
                Serializable serializable3 = serializable2;
            } else {
                POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.3") + menuModifier.getMenuItemModifierSpec().getDisplayName());
                return;
            }
        }
        object3 = ticketItem.findTicketItemModifierFor(menuModifier, (Multiplier)var2_4);
        serializable2 = this.d.getTicketViewerTable();
        int n5 = ((JTable)serializable2).getRowCount();
        object2 = null;
        if (n5 > 0) {
            object2 = (TicketItemModifier)((ModifierViewerTable)serializable2).get(n5 - 1);
        }
        int n6 = n = object3 != null && object2 != null && ((BaseTicketItemModifier)object3).getName().equals(((BaseTicketItemModifier)object2).getName()) && ((BaseTicketItemModifier)object3).getGroupId().equals(((BaseTicketItemModifier)object2).getGroupId()) ? 1 : 0;
        if (n == 0) {
            void var3_5;
            object = ticketItem.getTicket().getOrderType();
            TicketItemModifier ticketItemModifier = ticketItem.addTicketItemModifier(menuModifier, 1, (OrderType)object, (Multiplier)var2_4);
            ticketItemModifier.setItemQuantity((Double)var3_5);
        } else {
            object3 = object2;
            ((BaseTicketItemModifier)object3).setItemQuantity(((TicketItemModifier)object3).getItemQuantity() + 1.0);
        }
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItem.updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.d();
        object = "Modifier name: " + menuModifier.getDisplayName();
        object = (String)object + (StringUtils.isBlank((String)menuModifier.getId()) ? " " : " ,Modifier id: " + menuModifier.getId());
        this.a.getTicket().addRandomEvent("Modifier item added", (String)object);
        if (n2 + 1 != n3) return;
        if (var4_6 != false && this.b.getModifierGroupPosition(menuModifier.getMenuItemModifierSpec()) != 0) {
            return;
        }
        this.modifierGroupSelectionDone(menuModifier.getMenuItemModifierSpec());
    }

    private void d() {
        this.a.getTicketItem().calculatePrice();
        this.c.updateView();
        this.d.updateView();
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec menuItemModifierSpec) {
        TicketItem ticketItem = this.a.getTicketItem();
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            Iterator<TicketItemModifier> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
        }
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItem.updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.d();
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec menuItemModifierSpec) {
        if (!ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) {
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
            return;
        }
        if (menuItemModifierSpec.isJumpGroup().booleanValue() && this.b.hasNextMandatoryGroup()) {
            this.b.selectNextGroup();
        }
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        boolean bl = false;
        for (MenuItemModifierSpec menuItemModifierSpec2 : list) {
            if (ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec2)) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        if (bl && !this.b.hasNextMandatoryGroup() && menuItemModifierSpec.isJumpGroup().booleanValue()) {
            this.setCanceled(false);
            this.dispose();
        }
    }

    @Override
    public void finishModifierSelection() {
        TicketItem ticketItem = this.a.getTicketItem();
        List list = this.a.getMenuItem().getMenuItemModiferSpecs().stream().filter(menuItemModifierSpec -> menuItemModifierSpec.isEnable()).collect(Collectors.toList());
        if (list == null) {
            this.setCanceled(false);
            this.dispose();
            return;
        }
        if (!list.isEmpty()) {
            for (MenuItemModifierSpec menuItemModifierSpec2 : list) {
                if (ticketItem.requiredModifiersAdded(menuItemModifierSpec2)) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), String.format(Messages.getString("ModifierSelectionDialog.7"), menuItemModifierSpec2.getMinQuantity(), menuItemModifierSpec2.getName()));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    public ModifierSelectionModel getModifierSelectionModel() {
        return this.a;
    }

    public void setModifierSelectionModel(ModifierSelectionModel modifierSelectionModel) {
        this.a = modifierSelectionModel;
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return ticketItem.requiredModifiersAdded(menuItemModifierSpec);
    }

    private void a(MenuItemModifierSpec menuItemModifierSpec) {
        String string = menuItemModifierSpec.getName();
        int n = menuItemModifierSpec.getMinQuantity();
        String string2 = n <= 1 ? Messages.getString("modifierArt") : Messages.getString("modifiersArt");
        POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.5") + " " + n + string2 + Messages.getString("ModifierSelectionDialog.6") + " " + string);
    }

    @Override
    public void modifierRemoved(TicketItemModifier ticketItemModifier) {
        MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
        MenuItemModifierSpecDAO.getInstance().initialize(menuItemModifierSpec);
        this.c.setModifierGroup(menuItemModifierSpec, false);
        this.b.setSelectedModifierGroup(menuItemModifierSpec);
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItemModifier.getTicketItem().updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        String string = "Modifier name: " + ticketItemModifier.getNameDisplay();
        string = string + (StringUtils.isBlank((String)ticketItemModifier.getId()) ? " " : " ,Modifier id: " + ticketItemModifier.getId());
        this.a.getTicket().addRandomEvent("Modifier Item deleted", string);
    }

    @Override
    public void modifierUpdated(TicketItemModifier ticketItemModifier, double d) {
        MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
        int n = (int)((double)ticketItemModifier.getTicketItem().countModifierFromGroup(menuItemModifierSpec) - ticketItemModifier.getItemQuantity() + d);
        int n2 = menuItemModifierSpec.getMinQuantity();
        int n3 = menuItemModifierSpec.getMaxQuantity();
        if (n3 < n2) {
            n3 = n2;
        }
        if (n > n3) {
            POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.3") + menuItemModifierSpec.getDisplayName());
            return;
        }
        ticketItemModifier.setItemQuantity(d);
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItemModifier.getTicketItem().updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.c.updateView();
    }
}

