/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierView
extends SelectionView {
    private Vector<ModifierSelectionListener> a = new Vector();
    private ModifierSelectionModel b;
    private MenuItemModifierSpec c;
    private PosButton d = new PosButton(POSConstants.CLEAR);
    private PosButton e = new PosButton();
    private PosButton f = new PosButton(POSConstants.CANCEL);
    private Multiplier g;
    private MultiplierButton h;
    private ButtonGroup i;
    private TitledBorder j;

    public ModifierView(ModifierSelectionModel modifierSelectionModel) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize((int)120), PosUIManager.getSize((int)80));
        this.b = modifierSelectionModel;
        this.j = new TitledBorder(null, Messages.getString("PizzaModifierView.0"), 2, 2);
        this.selectionButtonsPanel.setBorder(this.j);
        this.selectionButtonsPanel.setLayout(new BorderLayout(5, 5));
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.a();
        this.b();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        jPanel.setBorder(compoundBorder);
        jPanel.setOpaque(true);
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        this.i = new ButtonGroup();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierButton multiplierButton = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.g = multiplier;
                    this.h = multiplierButton;
                    multiplierButton.setSelected(true);
                }
                jPanel.add((Component)multiplierButton, "grow");
                this.i.add(multiplierButton);
            }
        }
        this.actionButtonPanel.add((Component)jPanel, "newline,span");
    }

    private void b() {
        this.actionButtonPanel.add((Component)this.d, "newline,grow");
        this.actionButtonPanel.add((Component)this.e, "grow");
        this.actionButtonPanel.add((Component)this.f, "grow");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.finishModifierSelection();
                }
            }
        };
        this.e.setAction(abstractAction);
        this.e.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), POSConstants.DONE);
        this.e.getActionMap().put(POSConstants.DONE, abstractAction);
        this.e.setText(Messages.getString("ModifierView.0"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.clearModifiers(ModifierView.this.c);
                }
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierView.this.a(true);
            }
        });
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void setModifierGroup(MenuItemModifierSpec menuItemModifierSpec, boolean bl) {
        try {
            this.c = menuItemModifierSpec;
            ModifierGroup modifierGroup = null;
            if (menuItemModifierSpec == null) {
                return;
            }
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(1);
            if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                modifierGroup = menuItemModifierSpec.getModifierGroup();
                ModifierGroupDAO.getInstance().initialize(modifierGroup);
                this.dataModel.setData(modifierGroup.getModifiers());
            } else {
                this.dataModel.setData(new ArrayList<MenuModifier>(menuItemModifierSpec.getModifiers()));
            }
            this.b(modifierGroup);
            if (bl) {
                this.a(modifierGroup);
            }
            this.setDataModel(this.dataModel);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, posException);
        }
    }

    private void a(ModifierGroup modifierGroup) {
        if (this.i.getButtonCount() < 1) {
            return;
        }
        boolean bl = this.c.isUseModifierGroupSettings() && modifierGroup != null ? !modifierGroup.isEnableGroupPricing() : !this.c.isEnableGroupPricing();
        Enumeration<AbstractButton> enumeration = this.i.getElements();
        while (enumeration.hasMoreElements()) {
            MultiplierButton multiplierButton = (MultiplierButton)enumeration.nextElement();
            multiplierButton.setEnabled(bl);
            Multiplier multiplier = multiplierButton.getMultiplier();
            if (!bl) {
                if (!multiplier.getTicketPrefix().equals("Regular")) continue;
                this.g = multiplier;
                this.h = multiplierButton;
                multiplierButton.setSelected(true);
                continue;
            }
            if (!multiplier.isDefaultMultiplier().booleanValue()) continue;
            this.g = multiplier;
            this.h = multiplierButton;
            multiplierButton.setSelected(true);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel paginatedListModel) {
        this.populateItems();
        super.setDataModel(paginatedListModel);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.updateView();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        Dimension dimension = null;
        JPanel jPanel = new JPanel(new WrapLayout());
        List list = this.dataModel.getDataList();
        for (MenuModifier menuModifier : list) {
            if (menuModifier == null) {
                jPanel.add(new JLabel());
                continue;
            }
            AbstractButton abstractButton = this.createItemButton(menuModifier);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(PosUIManager.getSize((int)150, (int)120));
            jPanel.add(abstractButton);
        }
        this.selectionButtonsPanel.add(jPanel);
        this.setButtonSize(dimension);
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
    }

    private void b(ModifierGroup modifierGroup) {
        String string;
        int n;
        int n2;
        String string2;
        if (this.c.isUseModifierGroupSettings() && modifierGroup != null) {
            string2 = modifierGroup.getName();
            n2 = modifierGroup.getMinQuantity();
            n = modifierGroup.getMaxQuantity();
            string = modifierGroup.getInstruction() == null ? "" : modifierGroup.getInstruction();
        } else {
            string2 = this.c.getName();
            n2 = this.c.getMinQuantity();
            n = this.c.getMaxQuantity();
            string = this.c.getInstruction() == null ? "" : this.c.getInstruction();
        }
        this.selectionButtonsPanel.setBorder(null);
        String string3 = " (" + Messages.getString("ModifierView.1") + ":" + n2 + Messages.getString("ModifierView.3") + n + ")";
        TitledBorder titledBorder = new TitledBorder(null, string2 + string3, 2, 2);
        this.setBorder(titledBorder);
        this.lblGroupDescripton.setHorizontalAlignment(0);
        this.lblGroupDescripton.setText(string);
        this.lblGroupDescripton.setFont(DataProvider.get().getMenuFont());
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuItemModifierPageItem menuItemModifierPageItem;
        Serializable serializable;
        if (object instanceof MenuModifier) {
            serializable = (MenuModifier)object;
            menuItemModifierPageItem = new MenuItemModifierPageItem();
            menuItemModifierPageItem.setMenuModifier((MenuModifier)serializable);
        } else {
            menuItemModifierPageItem = (MenuItemModifierPageItem)object;
        }
        serializable = new ModifierButton(menuItemModifierPageItem);
        return serializable;
    }

    public void addModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.add(modifierSelectionListener);
    }

    public void removeModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.remove(modifierSelectionListener);
    }

    public void updateView() {
        Component[] componentArray = ((Container)this.selectionButtonsPanel.getComponents()[0]).getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return;
        }
        TicketItem ticketItem = this.b.getTicketItem();
        HashMap<String, TicketItemModifier> hashMap = new HashMap<String, TicketItemModifier>();
        if (ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
            for (TicketItemModifier object : ticketItem.getTicketItemModifiers()) {
                hashMap.put(object.getItemId(), object);
            }
        }
        Boolean bl = DataProvider.get().getCurrentTerminal().isShowTranslatedName();
        for (Component component : componentArray) {
            String string;
            if (component instanceof JLabel) continue;
            ModifierButton modifierButton = (ModifierButton)component;
            MenuItemModifierPageItem menuItemModifierPageItem = modifierButton.d;
            TicketItemModifier ticketItemModifier = (TicketItemModifier)hashMap.get(menuItemModifierPageItem.getMenuModifierId());
            boolean bl2 = bl != false && StringUtils.isNotBlank((String)menuItemModifierPageItem.getTranslatedName());
            String string2 = string = bl2 ? menuItemModifierPageItem.getTranslatedName() : menuItemModifierPageItem.getMenuModifierName();
            if (ticketItemModifier != null) {
                MenuModifier menuModifier = MenuModifierDAO.getInstance().get(menuItemModifierPageItem.getMenuModifierId());
                MenuModifierDAO.getInstance().initialize(menuModifier);
                double d = ticketItem.findTicketItemModifierByMenuModifier(menuModifier, this.c.getId(), this.c.hasPriceRules());
                this.a(modifierButton, string, d);
            } else {
                this.a(modifierButton, string, 0.0);
            }
            if (ModifierSelectionDialog.isRequiredModifiersAdded(ticketItem, this.c)) {
                this.e.setBackground(Color.green);
                continue;
            }
            this.e.setBackground(UIManager.getColor("Control"));
        }
    }

    private void a(ModifierButton modifierButton, String string, double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><center>");
        stringBuilder.append(string);
        if (!NumberUtil.isZero(d)) {
            stringBuilder.append("<br/><span style='color:green;'>(");
            stringBuilder.append(d);
            stringBuilder.append(")</span>");
        }
        stringBuilder.append("</center></html>");
        modifierButton.setText(stringBuilder.toString());
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected JPanel createButtonPanel() {
        return new VerticalTouchScrollPanel();
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier b;

        public MultiplierButton(Multiplier multiplier) {
            Integer n;
            this.b = multiplier;
            String string = multiplier.getTicketPrefix();
            if (StringUtils.isBlank((String)string)) {
                string = multiplier.getId();
            }
            this.setText(string);
            Integer n2 = multiplier.getButtonColor();
            if (n2 != null) {
                this.setBackground(new Color(n2));
            }
            if ((n = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(n));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModifierView.this.g = this.b;
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private int b = PosUIManager.getSize((int)100);
        private MenuItemModifierPageItem d;
        private JLabel e;

        public ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            MenuModifier menuModifier;
            this.d = menuItemModifierPageItem;
            this.setFocusable(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setLayout(new BorderLayout());
            if (DataProvider.get().getStore().isEnablePriceOnMenuBtn()) {
                MenuModifier menuModifier2 = menuItemModifierPageItem.getMenuModifier();
                String string = POSUtil.formatPriceDisplayWithHtmlBody(menuModifier2.getPrice());
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5, fill"));
                jPanel.setOpaque(false);
                JLabel jLabel = new JLabel(string);
                jPanel.add((Component)jLabel, "align center");
                jLabel.setHorizontalAlignment(0);
                this.add((Component)jPanel, "South");
            }
            if (menuItemModifierPageItem.getImage() != null) {
                int n = this.b;
                int n2 = this.b;
                if (menuItemModifierPageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                } else {
                    n = PosUIManager.getSize((int)80);
                    n2 = PosUIManager.getSize((int)40);
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                    this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
            }
            if (menuItemModifierPageItem.getTextColor() != null) {
                this.setForeground(menuItemModifierPageItem.getTextColor());
            }
            if (menuItemModifierPageItem.getButtonColor() != null) {
                this.setBackground(menuItemModifierPageItem.getButtonColor());
            }
            if (!(menuModifier = menuItemModifierPageItem.getMenuModifier()).isEnable().booleanValue()) {
                this.setEnabled(false);
            }
            this.addActionListener(this);
        }

        @Override
        public void setText(String string) {
            if (this.e == null) {
                this.e = new JLabel();
                this.e.setHorizontalTextPosition(0);
                this.e.setHorizontalAlignment(0);
                Font font = DataProvider.get().getMenuFont();
                if (font != null) {
                    this.e.setFont(font);
                }
            }
            this.e.setText(string);
            this.add((Component)this.e, "Center");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = this.d.getMenuModifierId();
                MenuModifier menuModifier = MenuModifierDAO.getInstance().get(string);
                if (menuModifier == null) {
                    throw new PosException(String.format(Messages.getString("ModifierView.4"), new Object[0]));
                }
                MenuModifierDAO.getInstance().initialize(menuModifier);
                menuModifier.setMenuItemModifierSpec(ModifierView.this.c);
                menuModifier.setModifierGroup(ModifierView.this.c.getModifierGroup());
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.modifierSelected(menuModifier, ModifierView.this.g);
                }
                if (ModifierView.this.h != null) {
                    ModifierView.this.h.setSelected(true);
                    ModifierView.this.g = ModifierView.this.h.getMultiplier();
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        }
    }
}

