/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class PizzaModifierView
extends SelectionView
implements ModifierGroupSelectionListener {
    private ModifierSelectionListener a;
    private PosButton b = new PosButton(POSConstants.CLEAR);
    private Multiplier c;
    private MultiplierButton d;
    private ModifierGroupView e;
    private PizzaModifierSelectionDialog f;
    private MenuItemModifierSpec g;
    private TitledBorder h;
    private JLabel i = new JLabel();
    private List<Multiplier> j;

    public PizzaModifierView(Ticket ticket, TicketItem ticketItem, MenuItem menuItem, PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        super(Messages.getString("PosMessage.254"), new BorderLayout(), PosUIManager.getSize((int)120), PosUIManager.getSize((int)80));
        ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(ticket, ticketItem, menuItem);
        this.f = pizzaModifierSelectionDialog;
        if (menuItem.hasModifiers()) {
            this.h = new TitledBorder(null, Messages.getString("PizzaModifierView.0"), 2, 2);
            this.selectionButtonsPanel.setBorder(this.h);
        }
        this.e = new ModifierGroupView(modifierSelectionModel, true, false);
        this.add((Component)this.e, "North");
        this.selectionButtonsPanel.setLayout(new BorderLayout(5, 5));
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.a();
        this.e.addModifierGroupSelectionListener(this);
        this.e.selectFirst();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        jPanel.setBorder(compoundBorder);
        jPanel.setOpaque(true);
        this.j = DataProvider.get().getMultiplierList();
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.j != null) {
            for (Multiplier multiplier : this.j) {
                MultiplierButton multiplierButton = new MultiplierButton(multiplier);
                multiplierButton.setEnabled(this.f.d.isComboChild() == false);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.c = multiplier;
                    this.d = multiplierButton;
                    multiplierButton.setSelected(true);
                }
                jPanel.add((Component)multiplierButton, "grow");
                buttonGroup.add(multiplierButton);
            }
        }
        this.actionButtonPanel.add((Component)jPanel, "newline,span");
    }

    public Multiplier getMultiplier(String string) {
        for (Multiplier multiplier : this.j) {
            if (!multiplier.getTicketPrefix().equalsIgnoreCase(string)) continue;
            return multiplier;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuModifier menuModifier;
        Session session;
        block4: {
            AbstractButton abstractButton;
            session = null;
            try {
                menuModifier = (MenuModifier)object;
                if (menuModifier != null) break block4;
                abstractButton = null;
            }
            catch (Throwable throwable) {
                MenuModifierDAO.getInstance().closeSession(session);
                throw throwable;
            }
            MenuModifierDAO.getInstance().closeSession(session);
            return abstractButton;
        }
        session = MenuModifierDAO.getInstance().createNewSession();
        session.refresh((Object)menuModifier);
        menuModifier.setMenuItemModifierSpec(this.g);
        ModifierButton modifierButton = new ModifierButton(menuModifier, this.c, this.f.getSelectedSize());
        if (!menuModifier.isEnable().booleanValue()) {
            modifierButton.setEnabled(false);
        }
        ModifierButton modifierButton2 = modifierButton;
        MenuModifierDAO.getInstance().closeSession(session);
        return modifierButton2;
    }

    public void addModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a = modifierSelectionListener;
    }

    public void removeModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a = null;
    }

    public void updateView() {
        if (this.g == null) {
            return;
        }
        try {
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            if (this.g.isUseModifierGroupSettings()) {
                ModifierGroup modifierGroup = this.g.getModifierGroup();
                ModifierGroupDAO.getInstance().initialize(modifierGroup);
                this.dataModel.setData(modifierGroup.getModifiers());
                this.g.copyModifierGroupProperties();
            } else {
                this.dataModel.setData(new ArrayList<MenuModifier>(this.g.getModifiers()));
            }
            this.b();
            this.setDataModel(this.dataModel);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, posException);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel paginatedListModel) {
        super.setDataModel(paginatedListModel);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.populateItems();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        Dimension dimension = null;
        this.selectionButtonsPanel.removeAll();
        this.selectionButtonsPanel.add((Component)this.i, "North");
        JPanel jPanel = new JPanel(new WrapLayout());
        List list = this.dataModel.getDataList();
        for (MenuModifier menuModifier : list) {
            if (menuModifier == null) {
                jPanel.add(new JLabel());
                continue;
            }
            AbstractButton abstractButton = this.createItemButton(menuModifier);
            if (abstractButton == null) continue;
            abstractButton.setPreferredSize(PosUIManager.getSize((int)150, (int)120));
            jPanel.add(abstractButton);
        }
        this.selectionButtonsPanel.add(jPanel);
        this.setButtonSize(dimension);
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void b() {
        String string = this.g.getInstruction() == null ? "" : " " + this.g.getInstruction();
        int n = this.g.getMinQuantity();
        int n2 = this.g.getMaxQuantity();
        this.i.setHorizontalAlignment(0);
        this.i.setText(string);
        this.i.setFont(DataProvider.get().getMenuFont());
        this.h.setTitle(Messages.getString("ModifierView.22") + n + Messages.getString("ModifierView.3") + n2);
    }

    public void setActionButtonsVisible(boolean bl) {
        this.b.setVisible(bl);
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuItemModifierSpec) {
        if (menuItemModifierSpec == null) {
            return;
        }
        if (this.g != null && menuItemModifierSpec.getId().equals(this.g.getId())) {
            return;
        }
        this.g = menuItemModifierSpec;
        this.updateView();
    }

    public ModifierGroupView getModifierGroupView() {
        return this.e;
    }

    public Multiplier getSelectedMultiplier() {
        return this.c;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.g, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.g, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    public void resetDefaultMultiplierButton() {
        this.c = this.d.getMultiplier();
        this.d.setSelected(true);
        this.updateView();
        this.repaint();
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier b;

        public MultiplierButton(Multiplier multiplier) {
            Integer n;
            this.b = multiplier;
            this.setText(multiplier.getId());
            Integer n2 = multiplier.getButtonColor();
            if (n2 != null) {
                this.setBackground(new Color(n2));
            }
            if ((n = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(n));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PizzaModifierView.this.c = this.b;
            PizzaModifierView.this.updateView();
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private MenuModifier b;

        public ModifierButton(MenuModifier menuModifier, Multiplier multiplier, MenuItemSize menuItemSize) {
            this.b = menuModifier;
            this.setLayout(new BorderLayout());
            if (DataProvider.get().getStore().isEnablePriceOnMenuBtn()) {
                double d = menuModifier.getPriceForSizeAndMultiplier(menuItemSize, true, multiplier) * (double)PizzaModifierView.this.f.getMenuItem().getDefaultSellPortion().intValue() / 100.0;
                String string = POSUtil.formatPriceDisplayWithHtmlBody(d);
                JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5, fill"));
                jPanel.setOpaque(false);
                JLabel jLabel = new JLabel(string);
                jPanel.add((Component)jLabel, "align center");
                jLabel.setHorizontalAlignment(0);
                this.add((Component)jPanel, "South");
            }
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalTextPosition(0);
            jLabel.setHorizontalAlignment(0);
            jLabel.setText("<html><center>" + menuModifier.getDisplayName() + "</center></html>");
            this.add((Component)jLabel, "Center");
            Font font = DataProvider.get().getMenuFont();
            if (font != null) {
                jLabel.setFont(font);
            }
            if (menuModifier.getButtonColor() != null) {
                this.setBackground(new Color(menuModifier.getButtonColor()));
            }
            if (menuModifier.getTextColor() != null) {
                this.setForeground(new Color(menuModifier.getTextColor()));
            }
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PizzaModifierView.this.a.modifierSelected(this.b, PizzaModifierView.this.c);
            if (PizzaModifierView.this.c == null && !PizzaModifierView.this.j.isEmpty()) {
                PizzaModifierView.this.c = PizzaModifierView.this.d.getMultiplier();
            }
        }
    }
}

