/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.FixedLengthTextArea;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class CardBatchCloseDialog
extends POSDialog
implements Runnable {
    private JLabel a;
    private FixedLengthTextArea b;
    private PosButton c;
    private PosButton d;
    private List<PaymentGatewayPlugin> e;
    private User f;
    private Thread g;

    public CardBatchCloseDialog(List<PaymentGatewayPlugin> list, User user) {
        this.e = list;
        this.f = user;
        this.a();
        this.setTitle(Messages.getString("PaymentProcessWaitDialog.0"));
        this.setIconImage(Application.getPosWindow().getIconImage());
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.g = new Thread(this);
            this.g.start();
        }
        super.setVisible(bl);
    }

    @Override
    public void run() {
        for (PaymentGatewayPlugin paymentGatewayPlugin : this.e) {
            if (paymentGatewayPlugin == null || paymentGatewayPlugin.getProcessor() == null || paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin || !paymentGatewayPlugin.supportsBatchClose()) continue;
            List<Terminal> list = TerminalDAO.getInstance().findAll();
            for (Terminal terminal : list) {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(Messages.getString("Closing"));
                    stringBuffer.append(" " + paymentGatewayPlugin.getProductName() + " ");
                    stringBuffer.append(Messages.getString("CardBatchCloseDialog.0") + " " + terminal.getName());
                    this.b.append(stringBuffer.toString());
                    paymentGatewayPlugin.getProcessor().closeBatch(terminal, this.f);
                    this.b.append("... " + Messages.getString("PosRequestHandler.0"));
                }
                catch (Exception exception) {
                    this.b.append("... " + exception.getMessage() + "\n");
                }
            }
        }
        this.d.setVisible(false);
        this.c.setVisible(true);
    }

    private void a() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new BorderLayout());
        transparentPanel.setOpaque(true);
        this.a = new JLabel(Messages.getString("PaymentProcessWaitDialog.1"));
        this.a.setHorizontalAlignment(0);
        this.a.setFont(this.a.getFont().deriveFont(24).deriveFont(1));
        JLabel jLabel = new JLabel(Messages.getString("PaymentProcessWaitDialog.8") + CardConfig.getPaymentGateway().getProductName());
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(this.a.getFont().deriveFont(24).deriveFont(1));
        this.b = new FixedLengthTextArea();
        this.b.setEditable(false);
        this.b.setLineWrap(true);
        transparentPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(20, 30, 20, 30), jScrollPane.getBorder()));
        transparentPanel.add((Component)jScrollPane, "Center");
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout(new FlowLayout(1, 10, 5));
        this.c = new PosButton();
        this.c.setText(POSConstants.FINISH);
        this.c.setPreferredSize(new Dimension(140, 50));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CardBatchCloseDialog.this.a(actionEvent);
            }
        });
        this.c.setVisible(false);
        transparentPanel2.add(this.c);
        this.d = new PosButton();
        this.d.setText(POSConstants.CANCEL);
        this.d.setPreferredSize(new Dimension(140, 50));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("CardBatchCloseDialog.6"));
                if (n != 0) {
                    return;
                }
                CardBatchCloseDialog.this.g.interrupt();
                CardBatchCloseDialog.this.setCanceled(true);
                CardBatchCloseDialog.this.dispose();
            }
        });
        transparentPanel2.add(this.d);
        transparentPanel.add((Component)transparentPanel2, "South");
        this.getContentPane().add((Component)this.a, "North");
        this.getContentPane().add((Component)transparentPanel, "Center");
        this.setSize(PosUIManager.getSize((int)800, (int)600));
        this.setDefaultCloseOperation(0);
    }

    private void a(ActionEvent actionEvent) {
        this.dispose();
    }
}

