/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.AmountInputKeypad;
import com.floreantpos.swing.DefaultDocument;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GratuityInputDialog
extends OkCancelOptionDialog {
    private JTextField a;
    private Double b;

    public GratuityInputDialog() {
        this(0.0);
    }

    public GratuityInputDialog(Double d) {
        super(POSUtil.getFocusedWindow());
        this.b = d;
        this.setCaption(Messages.getString("GratuityInputDialog.0"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        this.a = new JTextField();
        this.a.setDocument(new DefaultDocument(this.a, false));
        this.a.setHorizontalAlignment(11);
        this.a.setFocusCycleRoot(true);
        this.a.setFont(this.a.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.a.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GratuityInputDialog.this.doOk();
                }
            }
        });
        jPanel.add((Component)this.a, "cell 0 0,alignx left,height 40px,aligny top");
        AmountInputKeypad amountInputKeypad = new AmountInputKeypad(this.a, true);
        jPanel.add((Component)amountInputKeypad, "cell 0 1");
        jPanel.add((Component)this.a(), "cell 0 2");
        this.getContentPanel().add(jPanel);
    }

    private JPanel a() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        Font font = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize((int)18));
        Store store = DataProvider.get().getStore();
        Map<String, Double> map = store.getGratuityPercentageConfig();
        this.a(jPanel, font, map);
        return jPanel;
    }

    private void a(JPanel jPanel, Font font, Map<String, Double> map) {
        PosButton posButton;
        Double d;
        int n;
        for (n = 0; n < map.size(); ++n) {
            d = map.get("gp" + (n + 1));
            posButton = new PosButton(NumberUtil.formatNumberIfNeeded(d) + "%");
            posButton.setFont(font);
            posButton.addActionListener(actionEvent -> this.setGratuity(this.a((double)d, false)));
            if (n == 2 || n == 5) {
                jPanel.add((Component)posButton, "wrap");
                continue;
            }
            jPanel.add(posButton);
        }
        for (n = 0; n < map.size(); ++n) {
            d = map.get("gp" + (n + 1));
            posButton = new PosButton(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberIfNeeded(this.a(d)));
            posButton.setFont(font);
            posButton.addActionListener(actionEvent -> this.setGratuity(this.a(d)));
            if (n == 2 || n == 5) {
                jPanel.add((Component)posButton, "wrap");
                continue;
            }
            jPanel.add(posButton);
        }
    }

    private double a(double d) {
        return this.a(d, true);
    }

    private double a(double d, boolean bl) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = this.b * (d / 100.0);
        }
        return bl ? (double)Math.round(d2) : d2;
    }

    @Override
    public void doOk() {
        if (StringUtils.isBlank((String)this.a.getText())) {
            POSMessageDialog.showError(Messages.getString("GratuityInputDialog.1"));
            return;
        }
        double d = this.getGratuityAmount();
        if (d < 0.0) {
            POSMessageDialog.showError(Messages.getString("SettleTicketProcessor.21"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void setGratuity(double d) {
        this.a.setText(NumberUtil.format(d));
    }

    public double getGratuityAmount() {
        return NumberUtil.parseOrGetZero(this.a.getText()).doubleValue();
    }

    public void setSubTotalAmount(Double d) {
        this.b = d;
    }
}

