/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.ManualGiftCardEntryDialog;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;

public class SwipeCardDialog
extends POSDialog
implements CardInputProcessor {
    private CardInputListener a;
    private JPasswordField b;
    private String c;
    private PosButton d;
    private PaymentType e;

    public SwipeCardDialog(CardInputListener cardInputListener, PaymentType paymentType) {
        this.a = cardInputListener;
        this.e = paymentType;
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setTitle(VersionInfo.getAppName());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("SwipeCardDialog.0"));
        this.getContentPane().add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 5, 5));
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add(jPanel2);
        this.d = new PosButton();
        jPanel2.add(this.d);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwipeCardDialog.this.openManualEntry();
            }
        });
        this.d.setText(Messages.getString("SwipeCardDialog.1"));
        PosButton posButton = new PosButton();
        jPanel2.add(posButton);
        posButton.addActionListener(actionEvent -> this.a());
        posButton.setText(Messages.getString("SwipeCardDialog.3"));
        PosButton posButton2 = new PosButton();
        jPanel2.add(posButton2);
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwipeCardDialog.this.setCanceled(true);
                SwipeCardDialog.this.dispose();
            }
        });
        posButton2.setText(Messages.getString("CANCEL"));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(20, 10, 20, 10));
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel3.setLayout(new BorderLayout(0, 0));
        this.b = new JPasswordField();
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwipeCardDialog.this.a();
            }
        });
        this.b.setColumns(50);
        jPanel3.add((Component)this.b, "North");
        if (Application.getInstance().isDevelopmentMode()) {
            this.b.setText("%B4111111111111111^SHAH/RIAR^2303101000000000020000831000000?;4111111111111111=2303101000020000831?");
        }
        if (!CardConfig.isManualEntrySupported()) {
            this.d.setEnabled(false);
        }
        this.setSize(PosUIManager.getSize((int)600, (int)200));
    }

    protected void openAuthorizationEntryDialog() {
        this.setCanceled(true);
        this.dispose();
        AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this.a, this.e);
        authorizationCodeDialog.setLocationRelativeTo(this);
        authorizationCodeDialog.pack();
        authorizationCodeDialog.open();
    }

    protected void openManualEntry() {
        this.setCanceled(true);
        this.dispose();
        if (this.e.equals((Object)PaymentType.GIFT_CERTIFICATE)) {
            ManualGiftCardEntryDialog manualGiftCardEntryDialog = new ManualGiftCardEntryDialog(this.a, this.e);
            manualGiftCardEntryDialog.setLocationRelativeTo(this);
            manualGiftCardEntryDialog.pack();
            manualGiftCardEntryDialog.open();
        } else {
            ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(this.a, this.e);
            manualCardEntryDialog.setLocationRelativeTo(this);
            manualCardEntryDialog.pack();
            manualCardEntryDialog.open();
        }
    }

    public String getCardString() {
        return this.c;
    }

    public void setCardString(String string) {
        this.c = string;
    }

    private void a() {
        this.c = new String(this.b.getPassword());
        if (StringUtils.isBlank((String)this.c)) {
            POSMessageDialog.showError(this, Messages.getString("POSUtil.1"));
            return;
        }
        try {
            this.a.cardInputted(this, this.e, null);
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public void setManualEntryVisible(boolean bl) {
        this.d.setVisible(bl);
    }
}

