/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.chart.ChartDuration;
import com.floreantpos.report.chart.LineChartService;
import com.floreantpos.report.chart.OroStandardCategorySeriesLabelGenerator;
import com.floreantpos.report.chart.OroStandardXYSeriesLabelGenerator;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.Session;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Rotation;

public class DashboardUtil {
    private JFreeChart a;
    private JFreeChart b;
    private JFreeChart c;
    private JFreeChart d;
    private int e = 5;

    public DashboardUtil() {
        this.a();
    }

    private void a() {
        TerminalDAO terminalDAO = new TerminalDAO();
        try (Session session = terminalDAO.createNewSession();){
            this.a = this.a(this.createTopItemBarChartDataSet(session));
            this.b = this.a((PieDataset)this.createTopPaymentTypePieChartDataSet(session));
            this.c = this.b(this.createTopEmployeesBarChartDataSet(session));
            this.d = this.a(this.createSalesReportLineChartDataSet(session));
        }
    }

    public JFreeChart getSalesReportLineChart() {
        return this.d;
    }

    public JFreeChart getTopItemBarChart() {
        return this.a;
    }

    public JFreeChart getTopPaymentTypePieChart() {
        return this.b;
    }

    public JFreeChart getTopEmployeesBarChart() {
        return this.c;
    }

    private JFreeChart a(DefaultCategoryDataset defaultCategoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)"", (String)Messages.getString("DashboardUtil.1"), (String)Messages.getString("DashboardUtil.2"), (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.a(jFreeChart);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        categoryPlot.setOutlineVisible(false);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setBackgroundPaint(null);
        jFreeChart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        this.a(categoryPlot);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis(0);
        categoryAxis.setVisible(false);
        return jFreeChart;
    }

    private JFreeChart a(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createRingChart((String)POSConstants.TOP_FIVE_PAYMENT_TYPES, (PieDataset)pieDataset, (boolean)true, (boolean)true, (boolean)false);
        this.a(jFreeChart);
        RingPlot ringPlot = (RingPlot)jFreeChart.getPlot();
        ringPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        ringPlot.setSectionDepth(0.35);
        ringPlot.setOutlineVisible(false);
        ringPlot.setLabelGenerator(null);
        ringPlot.setCircular(true);
        ringPlot.setShadowPaint(null);
        ringPlot.setSectionOutlinesVisible(false);
        ringPlot.setLabelGap(0.05);
        ringPlot.setStartAngle(60.0);
        ringPlot.setBackgroundPaint(null);
        ringPlot.setDirection(Rotation.CLOCKWISE);
        ringPlot.setSeparatorsVisible(false);
        ringPlot.setIgnoreZeroValues(true);
        ringPlot.setLegendItemShape((Shape)new Rectangle(8, 8));
        jFreeChart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator(CurrencyUtil.getCurrencySymbol() + "{1}", NumberUtil.getNumberformat(), NumberUtil.getNumberformat());
        ringPlot.setLabelGenerator((PieSectionLabelGenerator)standardPieSectionLabelGenerator);
        ringPlot.setLegendLabelToolTipGenerator((PieSectionLabelGenerator)standardPieSectionLabelGenerator);
        return jFreeChart;
    }

    private JFreeChart b(DefaultCategoryDataset defaultCategoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)"", (String)Messages.getString("DashboardUtil.3"), (String)(Messages.getString("DashboardUtil.4") + CurrencyUtil.getCurrencySymbolWithBracket()), (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.a(jFreeChart);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        categoryPlot.setOutlineVisible(false);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setBackgroundPaint(null);
        this.a(categoryPlot);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setVisible(false);
        return jFreeChart;
    }

    private void a(CategoryPlot categoryPlot) {
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(2.0, 13.0);
        stackedBarRenderer3D.setMaximumBarWidth(0.2);
        stackedBarRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER));
        stackedBarRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator(POSConstants.TOTAL + ": ({2}) {0}", NumberUtil.getNumberformat()));
        stackedBarRenderer3D.setLegendItemToolTipGenerator((CategorySeriesLabelGenerator)new OroStandardCategorySeriesLabelGenerator());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
    }

    private JFreeChart a(TimeSeriesCollection timeSeriesCollection) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)"", (String)"", (String)(POSConstants.SALES + CurrencyUtil.getCurrencySymbolWithBracket()), (XYDataset)timeSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.a(jFreeChart);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        xYPlot.setOutlineVisible(false);
        xYPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        xYPlot.setBackgroundPaint(null);
        DateAxis dateAxis = new DateAxis(Messages.getString("DashboardUtil.5"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateAxis.setDateFormatOverride((DateFormat)simpleDateFormat);
        xYPlot.setDomainAxis((ValueAxis)dateAxis);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setBaseShape((Shape)new CubicCurve2D.Double());
        xYLineAndShapeRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        xYLineAndShapeRenderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f));
        xYLineAndShapeRenderer.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f));
        xYLineAndShapeRenderer.setSeriesStroke(3, (Stroke)new BasicStroke(2.0f));
        xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)Color.magenta);
        xYLineAndShapeRenderer.setSeriesPaint(1, (Paint)Color.RED);
        xYLineAndShapeRenderer.setSeriesPaint(2, (Paint)Color.GREEN.darker());
        xYLineAndShapeRenderer.setSeriesPaint(3, (Paint)Color.BLUE);
        xYPlot.setOutlinePaint((Paint)Color.BLUE);
        xYPlot.setOutlineStroke((Stroke)new BasicStroke(5.0f));
        xYLineAndShapeRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: {2}", (DateFormat)simpleDateFormat, NumberUtil.getNumberformat()));
        xYLineAndShapeRenderer.setLegendItemToolTipGenerator((XYSeriesLabelGenerator)new OroStandardXYSeriesLabelGenerator());
        xYPlot.setRenderer((XYItemRenderer)xYLineAndShapeRenderer);
        TickUnits tickUnits = new TickUnits();
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 1, (DateFormat)simpleDateFormat));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 2, (DateFormat)simpleDateFormat));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 3, (DateFormat)simpleDateFormat));
        tickUnits.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 4, (DateFormat)simpleDateFormat));
        dateAxis.setStandardTickUnits((TickUnitSource)tickUnits);
        xYPlot.setRangeGridlinesVisible(true);
        xYPlot.setRangeGridlinePaint((Paint)Color.BLACK);
        xYPlot.setDomainGridlinesVisible(true);
        xYPlot.setDomainGridlinePaint((Paint)Color.BLACK);
        return jFreeChart;
    }

    public DefaultCategoryDataset createTopItemBarChartDataSet(Session session) {
        return this.createtopItemBarChartDataSet(session, ChartDuration.getFromDateBehind(ChartDuration.WEEK));
    }

    public DefaultCategoryDataset createtopItemBarChartDataSet(Session session, Date date) {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        List<TicketItem> list = TicketItemDAO.getInstance().findTopItems(session, date, date2, this.e);
        if (list != null) {
            Comparator<TicketItem> comparator = Comparator.comparing(BaseTicketItem::getName);
            Collections.sort(list, comparator);
            for (TicketItem ticketItem : list) {
                defaultCategoryDataset.addValue(NumberUtil.round(ticketItem.getQuantity()), (Comparable)((Object)ticketItem.getName()), (Comparable)((Object)ticketItem.getName()));
            }
        }
        return defaultCategoryDataset;
    }

    public DefaultPieDataset createTopPaymentTypePieChartDataSet(Session session) {
        return this.createtopPaymentTypePieChartDataSet(session, ChartDuration.getFromDateBehind(ChartDuration.WEEK));
    }

    public DefaultPieDataset createtopPaymentTypePieChartDataSet(Session session, Date date) {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        List<PosTransaction> list = PosTransactionDAO.getInstance().findTopByPaymentTypes(session, date, date2, this.e);
        if (list != null && !list.isEmpty()) {
            Comparator<PosTransaction> comparator = Comparator.comparing(BasePosTransaction::getPaymentTypeString);
            Collections.sort(list, comparator);
            for (PosTransaction posTransaction : list) {
                String string = posTransaction.getPaymentType().getDisplayString() + CurrencyUtil.getCurrencySymbolWithBracket();
                Double d = NumberUtil.round(posTransaction.getAmount());
                defaultPieDataset.setValue((Comparable)((Object)string), (Number)d);
            }
        }
        return defaultPieDataset;
    }

    public DefaultCategoryDataset createTopEmployeesBarChartDataSet(Session session) {
        return this.createtopEmployeesBarChartDataSet(session, ChartDuration.getFromDateBehind(ChartDuration.WEEK));
    }

    public DefaultCategoryDataset createtopEmployeesBarChartDataSet(Session session, Date date) {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        TreeMap<PosTransaction, User> treeMap = new TreeMap<PosTransaction, User>(new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getAmount().compareTo(posTransaction2.getAmount());
            }
        });
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Map<PosTransaction, User> map = UserDAO.getInstance().findTopSellers(session, date, date2, this.e);
        treeMap.putAll(map);
        if (treeMap != null) {
            ArrayList arrayList = new ArrayList(treeMap.keySet());
            for (int i = 0; i < treeMap.size(); ++i) {
                String string = ((User)treeMap.get(arrayList.get(i))).getFullName();
                defaultCategoryDataset.addValue((Number)((PosTransaction)arrayList.get(i)).getAmount(), (Comparable)((Object)string), (Comparable)((Object)string));
            }
        }
        return defaultCategoryDataset;
    }

    public DefaultCategoryDataset createSalesReportBarChartDataSet(Session session) {
        return this.createSalesReportBarChartDataSet(session, ChartDuration.getFromDateBehind(ChartDuration.WEEK));
    }

    public DefaultCategoryDataset createSalesReportBarChartDataSet(Session session, Date date2) {
        Calendar calendar = Calendar.getInstance();
        Date date3 = calendar.getTime();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Map<Date, Double> map = PosTransactionDAO.getInstance().findTransactionsAmntGroupByDate(date2, date3, session);
        if (map != null) {
            map.keySet().forEach(date -> {
                Double d = Math.round((Double)map.get(date));
                defaultCategoryDataset.addValue((Number)d, (Comparable)d, (Comparable)((Object)DateUtil.formatAsDefaultMonthDate(date)));
            });
        }
        return defaultCategoryDataset;
    }

    public TimeSeriesCollection createSalesReportLineChartDataSet(Session session) {
        return this.createSalesReportLineChartDataSet(session, ChartDuration.getFromDateBehind(ChartDuration.WEEK));
    }

    public TimeSeriesCollection createSalesReportLineChartDataSet(Session session, Date date) {
        LineChartService lineChartService = new LineChartService();
        lineChartService.updateAllLineData(session, date);
        return lineChartService.getLineDataCollection();
    }

    private void a(JFreeChart jFreeChart) {
        StandardChartTheme standardChartTheme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        standardChartTheme.setTickLabelPaint((Paint)Color.BLACK);
        standardChartTheme.setAxisLabelPaint((Paint)Color.BLACK);
        standardChartTheme.apply(jFreeChart);
    }
}

