/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.DayPart;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.Shift;
import com.floreantpos.model.util.DataProvider;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ShiftUtil {
    private static final String a = "DEFAULT SHIFT";
    private static final Calendar b = Calendar.getInstance();
    private static final Calendar c = Calendar.getInstance();
    private static final NumberFormat d = new DecimalFormat("00");
    private static Shift e;

    public static void reInitialize() {
        b.clear();
    }

    public static Date formatShiftTime(Date date) {
        b.clear();
        c.setTime(date);
        b.set(10, c.get(10));
        b.set(12, c.get(12));
        b.set(9, c.get(9));
        return b.getTime();
    }

    public static Date buildShiftStartTime(int n, int n2, int n3, int n4, int n5, int n6) {
        n = n == 12 ? 0 : n;
        b.clear();
        b.set(10, n);
        b.set(12, n2);
        b.set(9, n3);
        return b.getTime();
    }

    public static Date buildShiftEndTime(int n, int n2, int n3, int n4, int n5, int n6) {
        n4 = n4 == 12 ? 0 : n4;
        b.clear();
        b.set(10, n4);
        b.set(12, n5);
        b.set(9, n6);
        if (n3 == 1 && n6 == 0) {
            b.add(5, 1);
        }
        return b.getTime();
    }

    public static Date buildShiftWithoutAmPm(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        return calendar.getTime();
    }

    public static String buildShiftTimeRepresentation(Date date) {
        b.setTime(date);
        String string = "";
        string = d.format(b.get(10) == 0 ? 12L : (long)b.get(10));
        string = string + ":" + d.format(b.get(12));
        string = string + (b.get(9) == 0 ? " AM" : " PM");
        return string;
    }

    public static Shift getCurrentShift() {
        Calendar calendar = Calendar.getInstance();
        if (e != null && calendar.before(e.getEndTime())) {
            return e;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, calendar2.get(10));
        calendar.set(12, calendar2.get(12));
        calendar.set(9, calendar2.get(9));
        Date date = calendar.getTime();
        List<DayPart> list = DataProvider.get().getDaryPartShifts();
        e = ShiftUtil.a(date, list);
        if (e != null) {
            return e;
        }
        calendar.add(5, 1);
        date = calendar.getTime();
        e = ShiftUtil.a(date, list);
        if (e != null) {
            return e;
        }
        return e;
    }

    private static Shift a(Date date, List<? extends Shift> list) {
        Shift shift = null;
        if (list == null) {
            return null;
        }
        for (Shift shift2 : list) {
            Date date2 = new Date(shift2.getStartTime().getTime());
            Date date3 = new Date(shift2.getEndTime().getTime());
            if (!date.after(date2) || !date.before(date3)) continue;
            if (shift != null && shift2.getShiftLength() < shift.getShiftLength()) {
                shift = shift2;
                continue;
            }
            if (shift != null) continue;
            shift = shift2;
        }
        return shift;
    }

    public static List<PriceShift> getCurrentPriceShifts() {
        List<PriceShift> list = DataProvider.get().getPriceShifts();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, calendar2.get(10));
        calendar.set(12, calendar2.get(12));
        calendar.set(9, calendar2.get(9));
        Date date = calendar.getTime();
        ArrayList<PriceShift> arrayList = new ArrayList<PriceShift>();
        for (PriceShift priceShift : list) {
            Date date2 = new Date(priceShift.getStartTime().getTime());
            Date date3 = new Date(priceShift.getEndTime().getTime());
            String string = priceShift.getDaysOfWeek();
            if (string == null || !string.contains(String.valueOf(calendar2.get(7))) || !date.after(date2) || !date.before(date3)) continue;
            arrayList.add(priceShift);
        }
        arrayList.sort(new Comparator<PriceShift>(){

            @Override
            public int compare(PriceShift priceShift, PriceShift priceShift2) {
                return (int)(priceShift.getShiftLength() - priceShift2.getShiftLength());
            }
        });
        return arrayList;
    }

    public static PriceShift getCurrentPriceShift() {
        List<PriceShift> list = ShiftUtil.getCurrentPriceShifts();
        PriceShift priceShift2 = null;
        if (list != null && list.size() > 0) {
            priceShift2 = Collections.min(list, Comparator.comparing(priceShift -> priceShift.getPriority()));
        }
        return priceShift2;
    }

    public static List<MenuShift> getCurrentMenuShifts() {
        List<MenuShift> list = DataProvider.get().getMenuShifts();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, calendar2.get(10));
        calendar.set(12, calendar2.get(12));
        calendar.set(9, calendar2.get(9));
        Date date = calendar.getTime();
        ArrayList<MenuShift> arrayList = new ArrayList<MenuShift>();
        for (MenuShift menuShift : list) {
            Date date2 = new Date(menuShift.getStartTime().getTime());
            Date date3 = new Date(menuShift.getEndTime().getTime());
            String string = menuShift.getDaysOfWeek();
            if (string == null || !string.contains(String.valueOf(calendar2.get(7))) || !date.after(date2) || !date.before(date3)) continue;
            arrayList.add(menuShift);
        }
        return arrayList;
    }

    public static Date buildStartTime(int n, int n2, int n3, int n4) {
        b.clear();
        b.set(11, n);
        b.set(12, n2);
        return b.getTime();
    }

    public static Date buildEndTime(int n, int n2, int n3, int n4) {
        b.clear();
        b.set(11, n3);
        b.set(12, n4);
        return b.getTime();
    }

    static {
        b.clear();
    }
}

