/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.TicketIdSequence;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumericGlobalIdGenerator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class TicketIdGenerator
implements IdentifierGenerator {
    private static SimpleDateFormat a = new SimpleDateFormat("yyMMdd");
    private static SimpleDateFormat b = new SimpleDateFormat("yyww");

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        Class<?> clazz = object.getClass();
        Object object2 = null;
        try {
            Object object3;
            Method method = clazz.getMethod("getId", null);
            if (method != null && (object3 = method.invoke(object, (Object[])null)) != null) {
                object2 = (Serializable)object3;
            }
            if (object2 == null) {
                object2 = TicketIdGenerator.generateTicketId((Session)sessionImplementor);
            }
        }
        catch (Exception exception) {
            PosLog.error(TicketIdGenerator.class, exception);
        }
        return object2;
    }

    public static String generateTicketId(Session session) {
        TicketIdSequence ticketIdSequence = DataProvider.get().getTicketIdGeneratorFormat();
        String string = TicketIdGenerator.generateTicketId(ticketIdSequence, session);
        while (TicketDAO.getInstance().get(string, session) != null) {
            string = TicketIdGenerator.generateTicketId(ticketIdSequence, session);
        }
        return string;
    }

    public static String generateTicketId(TicketIdSequence ticketIdSequence, Session session) {
        String string = DataProvider.get().getTicketPrefix();
        if (ticketIdSequence == TicketIdSequence.SequenceNumber && StringUtils.isNotBlank((CharSequence)string)) {
            return string + TicketIdGenerator.a(session);
        }
        if (ticketIdSequence == TicketIdSequence.DateWithNumber && StringUtils.isNotBlank((CharSequence)string)) {
            return string + a.format(StoreDAO.getServerTimestamp()) + TicketIdGenerator.a(session);
        }
        if (ticketIdSequence == TicketIdSequence.WeekWithNumber && StringUtils.isNotBlank((CharSequence)string)) {
            return string + b.format(StoreDAO.getServerTimestamp()) + TicketIdGenerator.a(session);
        }
        return NumericGlobalIdGenerator.generateGlobalId();
    }

    private static String a(Session session) {
        if (session == null) {
            return "";
        }
        int n = SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_SEQUENCE_NUMBER", session);
        String string = DataProvider.get().getTicketIdSequenceFormat().format(n);
        return string;
    }
}

