/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.EnumDateFormat;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class OutletSelectionDialog
extends OkCancelOptionDialog {
    private JComboBox a;
    private Outlet b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private POSTextField g;
    private IntegerTextField h;
    private JComboBox<EnumDateFormat> i;
    private AutoCompletionComboBox j;
    private AutoCompletionComboBox k;
    private AutoCompletionComboBox l;
    private AddressUtil m = new AddressUtil();
    private JLabel n;
    private JLabel o;
    private JLabel p;
    private JLabel q;

    public OutletSelectionDialog(String string, List<Outlet> list) throws HeadlessException {
        Serializable serializable2;
        this.setTitle(Messages.getString("OutletSelectionDialog.0"));
        this.setCaption(Messages.getString("OutletSelectionDialog.1"));
        JPanel jPanel = new JPanel(new WrapLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Outlet outlet = null;
        this.a = new JComboBox();
        for (Serializable serializable2 : list) {
            if (serializable2.isDeleted().booleanValue()) continue;
            if (string != null && string.equals(serializable2.getId())) {
                outlet = serializable2;
            }
            this.a.addItem(serializable2);
        }
        this.a.setSelectedItem(null);
        this.a.addItemListener(itemEvent -> this.a());
        jPanel.add(new Label(Messages.getString("OutletSelectionDialog.2")));
        jPanel.add(this.a);
        this.getContentPanel().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][][grow]", ""));
        this.o = new JLabel(Messages.getString("StoreConfigurationView.0") + Messages.getString("StoreConfigurationView.1"));
        jPanel2.add((Component)this.o, "cell 0 2");
        this.c = new FixedLengthTextField();
        this.c.setLength(120);
        jPanel2.add((Component)this.c, "cell 1 2 3 1,growx");
        serializable2 = new JLabel(Messages.getString("RestaurantConfigurationView.7") + ":");
        jPanel2.add((Component)serializable2, "cell 0 3");
        this.d = new FixedLengthTextField();
        this.d.setLength(60);
        jPanel2.add((Component)this.d, "cell 1 3 3 1,growx");
        JLabel jLabel = new JLabel(Messages.getString("StoreConfigurationView.3") + ":");
        jPanel2.add((Component)jLabel, "cell 0 4");
        this.e = new FixedLengthTextField();
        this.e.setLength(60);
        jPanel2.add((Component)this.e, "cell 1 4 3 1,growx");
        JLabel jLabel2 = new JLabel(Messages.getString("StoreConfigurationView.4") + ":");
        jPanel2.add((Component)jLabel2, "cell 0 5");
        this.f = new FixedLengthTextField();
        this.f.setLength(60);
        jPanel2.add((Component)this.f, "cell 1 5 3 1,growx");
        JLabel jLabel3 = new JLabel(Messages.getString("StoreConfigurationView.5") + ":");
        jPanel2.add((Component)jLabel3, "cell 0 6");
        this.j = new AutoCompletionComboBox();
        this.j.setModel(new DefaultComboBoxModel<Object>(this.m.getCountryNames().toArray()));
        jPanel2.add((Component)this.j, "cell 1 6 3 1,growx");
        JLabel jLabel4 = new JLabel(Messages.getString("StoreConfigurationView.6") + ":");
        jPanel2.add((Component)jLabel4, "cell 0 7");
        this.k = new AutoCompletionComboBox();
        jPanel2.add((Component)this.k, "cell 1 7 3 1,growx");
        JLabel jLabel5 = new JLabel(Messages.getString("StoreConfigurationView.7") + ":");
        jPanel2.add((Component)jLabel5, "cell 0 8");
        this.l = new AutoCompletionComboBox();
        jPanel2.add((Component)this.l, "cell 1 8 3 1,growx");
        JLabel jLabel6 = new JLabel(Messages.getString("RestaurantConfigurationView.19"));
        jPanel2.add((Component)jLabel6, "cell 0 9");
        this.h = new IntegerTextField();
        jPanel2.add((Component)this.h, "cell 1 9,growx");
        this.h.setColumns(10);
        JLabel jLabel7 = new JLabel(Messages.getString("RestaurantConfigurationView.22"));
        jPanel2.add((Component)jLabel7, "cell 0 10");
        this.g = new POSTextField();
        jPanel2.add((Component)this.g, "cell 1 10,growx");
        this.q = new JLabel(Messages.getString("DATE_FORMAT"));
        jPanel2.add((Component)this.q, "cell 0 12");
        this.i = new JComboBox();
        jPanel2.add(this.i, "cell 1 12,growx");
        this.d();
        this.j.addActionListener(actionEvent -> this.b());
        this.k.addActionListener(actionEvent -> this.c());
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(null);
        this.getContentPanel().add(jScrollPane);
        this.setSize(PosUIManager.getSize((int)700, (int)580));
        try {
            this.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outlet != null) {
            this.a.setSelectedItem(outlet);
        } else {
            this.a.setSelectedIndex(0);
        }
        this.disableFields();
    }

    private void a() {
        Object object = this.a.getSelectedItem();
        this.b = object instanceof Outlet ? (Outlet)object : OutletDAO.getInstance().get(DataProvider.get().getCurrentOutletId());
        this.initialize();
    }

    private void b() {
        try {
            String string = (String)this.j.getSelectedItem();
            List<String> list = this.m.getStateNames(string);
            this.k.removeAllItems();
            this.l.removeAllItems();
            this.k.addItem(null);
            for (String string2 : list) {
                this.k.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            this.l.setEnabled(true);
            String string = (String)this.j.getSelectedItem();
            String string2 = (String)this.k.getSelectedItem();
            List<String> list = this.m.getCityNames(string, string2);
            this.l.removeAllItems();
            this.l.addItem(null);
            for (String string3 : list) {
                this.l.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void d() {
        LinkedList<EnumDateFormat> linkedList = new LinkedList<EnumDateFormat>();
        linkedList.addAll(Arrays.asList(EnumDateFormat.values()));
        this.i.setModel(new ComboBoxModel(linkedList));
    }

    public void initialize() {
        if (this.b == null) {
            return;
        }
        this.c.setText(this.b.getName());
        this.d.setText(this.b.getAddressLine1());
        this.e.setText(this.b.getAddressLine2());
        this.f.setText(this.b.getStreet());
        this.j.setSelectedItem((Object)this.b.getCountry());
        this.k.setSelectedItem((Object)this.b.getState());
        this.l.setSelectedItem((Object)this.b.getCity());
        this.h.setText(this.b.getZipCode() == null ? "" : this.b.getZipCode());
        this.g.setText(this.b.getTelephone());
        this.i.setSelectedItem((Object)EnumDateFormat.get(this.b.getDateFormat()));
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }

    public void disableFields() {
        this.c.setEditable(false);
        this.l.setEnabled(false);
        this.j.setEnabled(false);
        this.k.setEnabled(false);
        this.d.setEditable(false);
        this.e.setEditable(false);
        this.f.setEditable(false);
        this.g.setEditable(false);
        this.h.setEditable(false);
        this.i.setEnabled(false);
    }

    public Outlet getSelectedOutlet() {
        return (Outlet)this.a.getSelectedItem();
    }

    @Override
    public void doOk() {
        try {
            this.b = (Outlet)this.a.getSelectedItem();
            if (this.b == null) {
                POSMessageDialog.showError(Messages.getString("OutletSelectionDialog.4"));
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.btnOk.setFocusable(true);
        this.btnOk.setFocusPainted(true);
        this.btnOk.requestFocus();
    }

    public static Outlet getOutlet(String string, List<Outlet> list) {
        OutletSelectionDialog outletSelectionDialog = new OutletSelectionDialog(string, list);
        outletSelectionDialog.open();
        if (outletSelectionDialog.isCanceled()) {
            POSMessageDialog.showError(Messages.getString("OutletSelectionDialog.4"));
            return OutletSelectionDialog.getOutlet(string, list);
        }
        return outletSelectionDialog.getSelectedOutlet();
    }
}

