/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.licensing.ProductLicenseInfo;
import com.floreantpos.main.Application;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.OroCommonMessages;
import com.orocube.common.about.dialog.OroCommonLicenceActivationDialog;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.LicenseExpiredException;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class PluginsDialog
extends POSDialog {
    private Component a;
    private boolean b = true;
    private boolean c;
    private JXTable d;
    private PluginTableModel e;
    private JPanel f;
    private PosButton g;
    private JLabel h;
    private Image i;
    private JCheckBox j;

    public PluginsDialog(List<AbstractFloreantPlugin> list, Component component, String string) throws HeadlessException {
        super(POSUtil.getFocusedWindow());
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle(VersionInfo.getAppName());
        if (component instanceof JFrame) {
            this.i = ((JFrame)component).getIconImage();
            this.setIconImage(this.i);
        }
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[670]", "[][grow]"));
        this.h = new JLabel("Available plugins");
        this.h.setFont(this.h.getFont().deriveFont(1));
        this.h.setOpaque(true);
        jPanel.add((Component)this.h, "h 40!,growx,center,wrap");
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "growx,span");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,inset 10", "", ""));
        JLabel jLabel = new JLabel("Copyright \u00a9 Orocube LLC");
        jPanel2.add((Component)jLabel, "wrap");
        JTextField jTextField = new JTextField();
        jTextField.setText(string);
        jTextField.setEditable(false);
        jTextField.setBackground(Color.WHITE);
        jPanel2.add((Component)new JLabel("Terminal key:"), "gaptop 20, split 2");
        jPanel2.add((Component)jTextField, "gaptop 20, grow, wrap");
        this.j = new JCheckBox(Messages.getString("DoNotShowOnStartUp"));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,ins 0 5 5 5,right"));
        this.g = new PosButton(Messages.getString("ContinueButtonText"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginsDialog.this.b = true;
                PluginsDialog.this.c = PluginsDialog.this.j.isSelected();
                PluginsDialog.this.dispose();
            }
        });
        jPanel3.add((Component)new JSeparator(), "grow,gaptop 0px,span");
        jPanel3.add(this.j);
        jPanel3.add((Component)this.g, "right");
        this.e = new PluginTableModel(){};
        for (AbstractFloreantPlugin object2 : list) {
            this.e.addItem(object2);
        }
        this.d = new JXTable((TableModel)this.e);
        this.d.setSortable(false);
        this.d.setRowHeight(PosUIManager.getSize((int)40));
        this.d.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)PluginsDialog.this.e.getRowData(PluginsDialog.this.d.getSelectedRow());
                PluginsDialog.this.a(abstractFloreantPlugin);
            }
        });
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)PluginsDialog.this.e.getRowData(this.a);
                if (abstractFloreantPlugin == null) {
                    return;
                }
                PluginsDialog.this.doActivateWithLicense(abstractFloreantPlugin);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.d, posAction, 2){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)PluginsDialog.this.e.getRowData(n);
                if (abstractFloreantPlugin.getLicense() == null || !abstractFloreantPlugin.getLicense().isValid() || !abstractFloreantPlugin.isActivated()) {
                    posButton.setText(Messages.getString("Activate"));
                    posButton.setHorizontalAlignment(0);
                    jTable.setRowHeight(n, jTable.getRowHeight(0));
                    return posButton;
                }
                JLabel jLabel = new JLabel(Messages.getString("Activated"));
                jLabel.setOpaque(true);
                if (bl) {
                    jLabel.setBackground(jTable.getSelectionBackground());
                    jLabel.setForeground(jTable.getSelectionForeground());
                } else {
                    jLabel.setBackground(jTable.getBackground());
                    jLabel.setForeground(jTable.getForeground());
                }
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)PluginsDialog.this.e.getRowData(n);
                if (abstractFloreantPlugin.getLicense() == null || !abstractFloreantPlugin.getLicense().isValid() || !abstractFloreantPlugin.isActivated()) {
                    return super.getTableCellEditorComponent(jTable, object, false, n, n2);
                }
                JLabel jLabel = new JLabel(Messages.getString("Activated"));
                jLabel.setOpaque(true);
                if (bl) {
                    jLabel.setBackground(jTable.getSelectionBackground());
                    jLabel.setForeground(jTable.getSelectionForeground());
                } else {
                    jLabel.setBackground(jTable.getBackground());
                    jLabel.setForeground(jTable.getForeground());
                }
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.d.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(2, 2, 2, 2, this.d.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.g.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.g.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
        this.d.setCellSelectionEnabled(false);
        this.d.setRowSelectionAllowed(true);
        this.d.setFocusable(true);
        this.d.getColumnModel().getColumn(0).setMinWidth(PosUIManager.getSize((int)150));
        this.d.setSelectionMode(0);
        this.f = new JPanel();
        this.f.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setPreferredSize(PosUIManager.getSize((int)850, (int)550));
        int n = PosUIManager.getSize((int)10);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        jPanel4.add((Component)jPanel, "North");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("fill", "[60%][50%]"));
        JScrollPane jScrollPane = new JScrollPane((Component)this.d);
        jPanel5.add((Component)jScrollPane, "grow");
        jPanel5.add((Component)this.f, "top,grow");
        jPanel4.add(jPanel5);
        jPanel4.add((Component)jPanel3, "South");
        this.add(jPanel4);
        this.d.getSelectionModel().addSelectionInterval(0, 0);
    }

    public void setCancelButtonText(String string) {
        this.g.setText(string);
    }

    public void setCaption(String string) {
        this.h.setText(string);
    }

    private void a(AbstractFloreantPlugin abstractFloreantPlugin) {
        Object object;
        this.f.removeAll();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0 10 0 0,fillx", "[]", "[]"));
        JLabel jLabel = new JLabel(Messages.getString("PluginInfo"));
        Font font = jLabel.getFont().deriveFont(1, PosUIManager.getSize((int)16));
        Font font2 = jLabel.getFont();
        jLabel.setFont(font);
        jPanel.add((Component)jLabel, "wrap");
        jPanel.add((Component)new JSeparator(), "growx,span,wrap");
        JLabel jLabel2 = new JLabel(abstractFloreantPlugin.getProductName());
        jLabel2.setFont(font2);
        jPanel.add((Component)jLabel2, "wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("VersionText") + abstractFloreantPlugin.getProductVersion());
        jLabel3.setFont(font2);
        jPanel.add((Component)jLabel3, "gapbottom 20!,wrap");
        OroLicense oroLicense = abstractFloreantPlugin.getLicense();
        if (oroLicense != null) {
            if (StringUtils.isNotBlank((String)oroLicense.getDisplayName())) {
                jLabel2.setText(oroLicense.getDisplayName());
            }
            if (oroLicense.getLicenseMode() == LicenseMode.UNINILIZED) {
                object = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.4"));
                ((JComponent)object).setFont(((Component)object).getFont().deriveFont(1, PosUIManager.getSize((int)26)));
                jPanel.add((Component)object, "span, wrap, gaptop 30px");
            } else {
                JLabel jLabel4;
                JLabel jLabel5;
                if (StringUtils.isNotBlank((String)oroLicense.getIssuer())) {
                    object = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.5"));
                    jLabel5 = new JLabel(oroLicense.getIssuer());
                    jPanel.add((Component)object);
                    jPanel.add((Component)jLabel5, "wrap");
                }
                if (StringUtils.isNotBlank((String)oroLicense.getHolderName())) {
                    object = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.6"));
                    jLabel5 = new JLabel(oroLicense.getHolderName());
                    jPanel.add((Component)object);
                    jPanel.add((Component)jLabel5, "wrap");
                }
                if (StringUtils.isNotBlank((String)oroLicense.getHolderEmail())) {
                    object = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.7"));
                    jLabel5 = new JLabel(oroLicense.getHolderEmail());
                    jLabel5.setForeground(Color.blue);
                    jPanel.add((Component)object);
                    jPanel.add((Component)jLabel5, "wrap");
                }
                if (StringUtils.isNotBlank((String)(object = PluginsDialog.a(oroLicense)))) {
                    jLabel5 = new JLabel("Order No");
                    jLabel4 = new JLabel((String)object);
                    jLabel4.setForeground(Color.blue);
                    jPanel.add(jLabel5);
                    jPanel.add((Component)jLabel4, "wrap");
                }
                jLabel5 = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.8"));
                if (oroLicense.getIssueDate() != null) {
                    jLabel4 = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(oroLicense.getIssueDate()));
                    jPanel.add(jLabel5);
                    jPanel.add((Component)jLabel4, "wrap");
                }
                if (oroLicense.getExpiryDate() != null) {
                    jLabel4 = new JLabel(OroCommonMessages.getString((String)"PluginAboutDialog.9"));
                    long l = 86400000L;
                    long l2 = oroLicense.getExpiryDate().getTime() - new Date().getTime();
                    long l3 = Math.round((double)l2 / (double)l);
                    JLabel jLabel6 = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(oroLicense.getExpiryDate()) + " (" + l3 + (Math.abs(l3) > 1L ? OroCommonMessages.getString((String)"PluginAboutDialog.10") + ")" : OroCommonMessages.getString((String)"PluginAboutDialog.11") + ")"));
                    jPanel.add(jLabel4);
                    jPanel.add((Component)jLabel6, "wrap");
                    ProductLicenseInfo productLicenseInfo = new ProductLicenseInfo(oroLicense);
                    if (productLicenseInfo.isExpired()) {
                        JLabel jLabel7 = new JLabel("License Expired");
                        jLabel7.setFont(font);
                        jLabel7.setForeground(Color.RED);
                        jPanel.add((Component)jLabel7, "skip 1");
                    }
                }
            }
        }
        if (oroLicense != null && oroLicense.isValid() && abstractFloreantPlugin.isActivated()) {
            object = new JButton(OroCommonMessages.getString((String)"PluginAboutDialog.13"));
            ((AbstractButton)object).addActionListener(actionEvent -> this.b(abstractFloreantPlugin));
            jPanel.add((Component)object, "skip 1");
        }
        this.f.add(jPanel);
        this.f.revalidate();
        this.f.repaint();
    }

    private void b(AbstractFloreantPlugin abstractFloreantPlugin) {
        this.doActivateWithLicense(abstractFloreantPlugin);
    }

    private static String a(OroLicense oroLicense) {
        List list = oroLicense.getFeatureList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (String string : list) {
            String[] stringArray;
            if (string == null || !string.startsWith("orderId:") || (stringArray = string.split(":")).length <= 1) continue;
            return stringArray[1].trim();
        }
        return null;
    }

    protected void doActivateWithLicense(AbstractFloreantPlugin abstractFloreantPlugin) {
        this.a(abstractFloreantPlugin, this.a, abstractFloreantPlugin.getId(), abstractFloreantPlugin.getProductName(), abstractFloreantPlugin.getProductVersion());
    }

    private void a(AbstractFloreantPlugin abstractFloreantPlugin, Component component, String string, String string2, String string3) {
        String string4 = "Plugin activation";
        String string5 = Application.getInstance().getLicense() == null ? "" : Application.getInstance().getLicense().getHolderEmail();
        OroCommonLicenceActivationDialog oroCommonLicenceActivationDialog = new OroCommonLicenceActivationDialog(this.i, (LicenseSelectionListener)abstractFloreantPlugin, string4, string2, string3, string5);
        if (abstractFloreantPlugin.getLicense() == null || !abstractFloreantPlugin.getLicense().isValid() || !abstractFloreantPlugin.isActivated()) {
            try {
                LicenseUtil.loadAndValidate((String)string, (String)string2, (String)string3, (String)TerminalUtil.getSystemUID());
            }
            catch (LicenseExpiredException licenseExpiredException) {
                if (licenseExpiredException.getLicense() != null) {
                    oroCommonLicenceActivationDialog.setHolderEmailAndOrderNo(licenseExpiredException.getLicense().getHolderEmail(), PluginsDialog.a(licenseExpiredException.getLicense()));
                }
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception.getMessage());
            }
        }
        oroCommonLicenceActivationDialog.open();
        OroLicense oroLicense = oroCommonLicenceActivationDialog.getLicense();
        if (oroLicense != null && oroLicense.isValid()) {
            abstractFloreantPlugin.setLicense(oroLicense);
        }
        this.d.repaint();
        this.a(abstractFloreantPlugin);
    }

    @Override
    public void setVisible(boolean bl) {
        this.pack();
        this.setLocationRelativeTo((JFrame)this.a);
        super.setVisible(bl);
    }

    public boolean isDoNotPromptAgain() {
        return this.j.isSelected();
    }

    @Override
    public boolean isCanceled() {
        return this.b;
    }

    public void setDoNotPromtCheckBoxValue(boolean bl) {
        this.j.setSelected(bl);
    }

    public class PluginTableModel
    extends ListTableModel<AbstractFloreantPlugin> {
        public PluginTableModel() {
            super(new String[]{"Plugin", "Version", ""});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)this.rows.get(n);
            switch (n2) {
                case 0: {
                    if (abstractFloreantPlugin.getLicense() != null && StringUtils.isNotBlank((String)abstractFloreantPlugin.getLicense().getDisplayName())) {
                        return abstractFloreantPlugin.getLicense().getDisplayName();
                    }
                    return abstractFloreantPlugin.getProductName();
                }
                case 1: {
                    return abstractFloreantPlugin.getProductVersion();
                }
                case 2: {
                    return abstractFloreantPlugin.getLicense() == null || !abstractFloreantPlugin.getLicense().isValid() || !abstractFloreantPlugin.isActivated() ? Messages.getString("Activate") : Messages.getString("Activated");
                }
            }
            return null;
        }
    }
}

