/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.module.purchase.util;

import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class PurchaseOrderUtil {
    public static void doEmail(JasperPrint jasperPrint, PurchaseOrder purchaseOrder) {
        PurchaseOrderUtil.doEmail(jasperPrint, purchaseOrder, true);
    }

    public static void doEmail(JasperPrint jasperPrint, PurchaseOrder purchaseOrder, boolean bl) {
        Object object;
        String string = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        String string2 = "";
        Set<String> set = purchaseOrder.getEmailList();
        if (!bl) {
            if (set.isEmpty() && purchaseOrder.getVendor() != null) {
                string2 = purchaseOrder.getVendor().getEmail();
            } else {
                object = set.iterator();
                while (object.hasNext()) {
                    string2 = string2 + (String)object.next();
                    if (!object.hasNext()) continue;
                    string2 = string2 + ",";
                }
            }
        }
        if ((bl || StringUtils.isBlank((String)string2)) && (string2 = GlobalInputDialog.showInputDialog(VersionInfo.getAppName(), "Enter Email Address", string2, null, 20)) == null) {
            return;
        }
        object = new ByteArrayOutputStream();
        JRPdfExporter jRPdfExporter = new JRPdfExporter();
        jRPdfExporter.setParameter(JRPdfExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        jRPdfExporter.setParameter(JRPdfExporterParameter.OUTPUT_STREAM, object);
        try {
            jRPdfExporter.exportReport();
        }
        catch (JRException jRException) {
            PosLog.error(PurchaseOrderUtil.class, jRException);
        }
        byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (string2.contains(",")) {
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (StringUtils.isNotBlank((String)string3)) {
                    string3 = string3.trim();
                }
                PurchaseOrderUtil.a(jasperPrint, purchaseOrder, string, string3, byArray, true);
                purchaseOrder.addToEmailList(string3);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Purchase order successfully sent to vendor email.");
        } else {
            string2 = string2.trim();
            PurchaseOrderUtil.a(jasperPrint, purchaseOrder, string, string2, byArray, false);
            purchaseOrder.addToEmailList(string2);
        }
        PurchaseOrderDAO.getInstance().saveOrUpdate(purchaseOrder);
    }

    private static void a(JasperPrint jasperPrint, PurchaseOrder purchaseOrder, String string, String string2, byte[] byArray, boolean bl) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            String string3 = "PurchaseOrder_" + purchaseOrder.getOrderId() + ".pdf";
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            StringWriter stringWriter = new StringWriter();
            VelocityEngine velocityEngine = VelocityUtil.getVelocityEngine();
            String string4 = DataProvider.get().getStore().getName();
            InventoryVendor inventoryVendor = purchaseOrder.getVendor();
            String string5 = "";
            if (inventoryVendor != null) {
                string5 = inventoryVendor.getName();
            }
            hashMap.put("supplierName", string5);
            hashMap.put("storeName", string4);
            hashMap.put("orderNo", purchaseOrder.getOrderId());
            hashMap.put("currency", CurrencyUtil.getCurrencySymbol());
            List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
            hashMap.put("orderItems", list);
            hashMap.put("subtotal", purchaseOrder.getSubtotalAmount());
            hashMap.put("totalAmount", purchaseOrder.getTotalAmount());
            Date date = purchaseOrder.getExpectedDate();
            hashMap.put("expectedDate", DateUtil.formatDate(date == null ? new Date() : date));
            hashMap.put("posUserName", Application.getCurrentUser().getFullName());
            hashMap.put("companyName", string4);
            String string6 = "email/purchase-order-template.vm";
            if (NumberUtil.isZero(purchaseOrder.getDueAmount())) {
                string6 = "email/paid-purchase-order-template.vm";
            }
            Template template = velocityEngine.getTemplate(string6);
            VelocityContext velocityContext = new VelocityContext(hashMap);
            velocityContext.put("StringUtils", StringUtils.class);
            template.merge((Context)velocityContext, (Writer)stringWriter);
            String string7 = "Purchase Order " + purchaseOrder.getOrderId();
            String string8 = stringWriter.toString();
            MailService.sendMail(string2, string7, string8, string3, string3, byArray);
            if (!bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Purchase order successfully sent to vendor email");
            }
        } else if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Invalid email! Please enter valid email.");
            PurchaseOrderUtil.doEmail(jasperPrint, purchaseOrder);
        }
    }

    public static void doSendMail(PurchaseOrder purchaseOrder) {
        try {
            JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
            jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
            PurchaseOrderUtil.doEmail(jasperPrint, purchaseOrder, false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Sending failed.");
        }
    }
}

