/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttMessageReceiver;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONObject;

public class OroMqttClient
extends OroMqttMessageReceiver
implements MqttCallbackExtended {
    private static final String MQTT_SERVER_URL = "tcp://siiopa.com:1883";
    private MqttClient mqttClient;
    private int qos = 0;
    private static OroMqttClient instance;
    private String deviceId;

    private OroMqttClient() {
    }

    public static OroMqttClient getInstance() {
        if (instance == null) {
            instance = new OroMqttClient();
        }
        return instance;
    }

    public MqttClient getMqttClient() {
        return OroMqttClient.getInstance().mqttClient;
    }

    public boolean isConnectedToServer() {
        if (this.mqttClient == null) {
            return false;
        }
        return this.mqttClient.isConnected();
    }

    public void initMqttClient(String string) throws Exception {
        this.deviceId = string;
        final MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        try {
            this.mqttClient = new MqttClient(MQTT_SERVER_URL, this.deviceId, (MqttClientPersistence)new MemoryPersistence());
            mqttConnectOptions.setCleanSession(true);
            mqttConnectOptions.setAutomaticReconnect(true);
            mqttConnectOptions.setKeepAliveInterval(15);
            this.mqttClient.setCallback((MqttCallback)this);
            this.mqttClient.connect(mqttConnectOptions);
        }
        catch (MqttException mqttException) {
            PosLog.debug(this.getClass(), "Mqtt initialization failed. Scheduling a timer for next initialization");
            final Timer timer = new Timer();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    PosLog.debug(this.getClass(), "Mqtt initialization timer fired. Checking initialization");
                    if (OroMqttClient.this.mqttClient.isConnected()) {
                        PosLog.debug(this.getClass(), "Mqtt is already initialized. Cancelling timer.");
                        timer.cancel();
                        return;
                    }
                    try {
                        OroMqttClient.this.mqttClient.connect(mqttConnectOptions);
                        if (OroMqttClient.this.mqttClient.isConnected()) {
                            PosLog.debug(this.getClass(), "Mqtt initialization successfull from scheduler timer. Cancelling timer.");
                            timer.cancel();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(timerTask, 30000L, 30000L);
        }
    }

    public void disconnect() {
        try {
            this.mqttClient.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void subscribeToPublicTopic() throws Exception {
        this.subscribe(this.getStoreUuidAndOutletId() + "public", this.qos);
    }

    private void subscribeToCommandTopic() throws Exception {
        this.subscribe(this.getStoreUuid() + "MQTT-COMMAND", this.qos);
    }

    private void subscribeToStore(String string, int n) throws Exception {
        this.subscribe(this.getStoreUuidAndOutletId() + string, n);
    }

    private void subscribe(String string, int n) throws Exception {
        if (this.mqttClient == null || string == null) {
            return;
        }
        if (!this.mqttClient.isConnected()) {
            throw new PosException(Messages.getString("OroMqttClient.4"));
        }
        this.mqttClient.subscribe(string, 2, (IMqttMessageListener)this);
        PosLog.debug(this.getClass(), "subscribed to topic: " + string);
    }

    protected void showMqttNotification(String string) {
        PosLog.info(this.getClass(), string);
    }

    public void publishOnThread(String string, String string2) {
        this.publishData(string, string2);
    }

    public void publishData(String string, String string2) {
        this.publishData(string, string2, false);
    }

    public void publishData(String string, String string2, boolean bl) {
        try {
            if (this.mqttClient == null) {
                return;
            }
            if (!this.isConnectedToServer()) {
                return;
            }
            PosLog.debug(this.getClass(), "publishing to topic: " + this.getStoreUuidAndOutletId() + string);
            this.mqttClient.publish(this.getStoreUuidAndOutletId() + string, bl ? POSUtil.compress(string2) : string2.getBytes(), this.qos, false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Notification service error. " + exception.getMessage());
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private String getStoreUuid() {
        Store store = DataProvider.get().getStore();
        if (store != null) {
            return store.getUuid() + "/";
        }
        return UUID.randomUUID().toString() + "/";
    }

    private String getStoreUuidAndOutletId() {
        Store store = DataProvider.get().getStore();
        if (store != null) {
            return store.getUuid() + "/" + DataProvider.get().getCurrentOutletId() + "/";
        }
        return UUID.randomUUID().toString() + "/";
    }

    public void connectionLost(Throwable throwable) {
        this.fireConnectionLostEvent();
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public void connectComplete(boolean bl, String string) {
        try {
            this.subscribeToTerminalLicenseService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.subscribeToCommonTopics();
        this.fireMqttConnected();
    }

    public void subscribeToCommonTopics() {
        try {
            Store store = DataProvider.get().getStore();
            if (store == null) {
                return;
            }
            this.subscribeToPublicTopic();
            this.subscribeToCommandTopic();
            this.subscribeToStore("auto-update-service", 0);
            this.subscribeToStore("MQTT-COMMAND", 0);
            this.subscribeToStore("MQTT-COMMAND-REFRESH-CACHE", 0);
            this.subscribeToStore("MQTT-COMMAND-STORE-CLOSED", 0);
            this.subscribeToStore("MQTT-COMMAND-KIT-DIS-UPDATE", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void subscribeToTerminalLicenseService() throws Exception {
        this.subscribe(TerminalUtil.getSystemUID(), this.qos);
    }

    public void notifyDataUpdated(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        if (DataProvider.get().isCaching(clazz)) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
                OroMqttClient.getInstance().publishData("MQTT-COMMAND-REFRESH-CACHE", jSONObject.toString());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    public void notifyStoreClosed() {
        try {
            JSONObject jSONObject = new JSONObject();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("terminalName", (Object)terminal.getName());
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-STORE-CLOSED", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void sendUpdateNotification() {
        try {
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-UPDATE-NOTIFICATION", "Data updated");
        }
        catch (Exception exception) {
            PosLog.error(OroMqttMessageReceiver.class, exception);
        }
    }
}

