/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.TicketItemModifierDAO;
import com.floreantpos.model.dao.TicketItemSeatDAO;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class TicketDataServiceDao {
    private static TicketDataServiceDao instance;

    private TicketDataServiceDao() {
    }

    public static TicketDataServiceDao getInstance() {
        if (instance == null) {
            instance = new TicketDataServiceDao();
        }
        return instance;
    }

    public static TicketDataServiceDao get() {
        return TicketDataServiceDao.getInstance();
    }

    public void saveOrUpdateTicket(Ticket ticket, boolean bl, boolean bl2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TicketDAO ticketDAO = TicketDAO.getInstance();
        Ticket ticket2 = null;
        try (Session session = ticketDAO.createNewSession();){
            ticket2 = ticketDAO.loadFullTicket(ticket.getId());
            if (ticket2 != null) {
                ExistingItemMapBuilder.buildExistingItemMap(session, hashMap, ticket, ticket2);
                ticket.mergeTicket(ticket2);
            }
        }
        session = null;
        var8_8 = null;
        try {
            Object object;
            Object object2;
            session = ticketDAO.createNewSession();
            var8_8 = session.beginTransaction();
            Gratuity gratuity = ticket.getGratuity();
            List list = POSUtil.copyList(ticket.getTicketItems());
            Set set = POSUtil.copySet(ticket.getTransactions());
            ticket.setUpdateLastUpdateTime(bl);
            ticket.setUpdateSyncTime(bl2);
            ticket.setGratuity(null);
            POSUtil.clear(ticket.getTicketItems());
            POSUtil.clear(ticket.getTransactions());
            this.saveOrUpdateTicket(session, ticket, ticket2);
            this.saveOrUpdateTicketItems(session, ticket, list, hashMap);
            this.saveOrUpdatePosTransactions(session, ticket, set, hashMap);
            this.saveOrUpdateGratuity(session, ticket, gratuity, hashMap);
            List<TicketItem> list2 = ticket.getTicketItems();
            if (list2 != null) {
                list2.addAll(list);
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    object = (TicketItem)object2.next();
                    if (object != null) continue;
                    object2.remove();
                }
            }
            if ((object2 = ticket.getTransactions()) != null) {
                ticket.getTransactions().addAll(set);
                object = object2.iterator();
                while (object.hasNext()) {
                    PosTransaction posTransaction = (PosTransaction)object.next();
                    if (posTransaction != null) continue;
                    object.remove();
                }
            }
            ticket.setGratuity(gratuity);
            ticket.setShouldUpdateTableStatus(ticket2 == null);
            this.saveCustomerIfNotExists(session, ticket);
            object = new Date();
            if (bl) {
                ticket.setLastUpdateTime((Date)object);
            }
            if (bl2) {
                ticket.setLastSyncTime((Date)object);
            }
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            var8_8.commit();
        }
        catch (Exception exception) {
            var8_8.rollback();
            PosLog.error(this.getClass(), "Error saving ticket: " + ticket.getId(), exception);
            throw exception;
        }
        finally {
            ticketDAO.closeSession(session);
        }
    }

    private void saveOrUpdateTicket(Session session, Ticket ticket, Ticket ticket2) {
        if (ticket2 == null) {
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            if (ticket.getTokenNo() == 0) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            TicketDAO.getInstance().save(ticket, session);
        } else {
            ticket.setVersion(ticket2.getVersion());
        }
    }

    private void saveOrUpdateTicketItems(Session session, Ticket ticket, List<TicketItem> list, Map<String, Object> map) {
        HashMap<String, TicketItemSeat> hashMap = new HashMap<String, TicketItemSeat>();
        for (TicketItem ticketItem : list) {
            ticketItem.setTicket(ticket);
            this.saveOrUpdateTicketItem(session, ticket, ticketItem, map, hashMap);
        }
    }

    private void saveOrUpdatePosTransactions(Session session, Ticket ticket, Set<PosTransaction> set, Map<String, Object> map) {
        PosTransactionDAO posTransactionDAO = PosTransactionDAO.getInstance();
        for (PosTransaction posTransaction : set) {
            posTransaction.setTicket(ticket);
            PosTransaction posTransaction2 = (PosTransaction)map.get(posTransaction.getId());
            if (posTransaction2 == null) {
                posTransactionDAO.save(posTransaction, session);
                continue;
            }
            posTransaction.setVersion(posTransaction2.getVersion());
        }
    }

    private void saveCustomerIfNotExists(Session session, Ticket ticket) {
        Customer customer;
        if (StringUtils.isEmpty((String)ticket.getCustomerId())) {
            return;
        }
        Customer customer2 = CustomerDAO.getInstance().get(ticket.getCustomerId(), session);
        if (customer2 == null && (customer = ticket.getCustomer()) != null) {
            CustomerDAO.getInstance().save(customer, session);
        }
    }

    private void saveOrUpdateTicketItem(Session session, Ticket ticket, TicketItem ticketItem, Map<String, Object> map, Map<String, TicketItemSeat> map2) {
        TicketItemDAO ticketItemDAO = TicketItemDAO.getInstance();
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        TicketItemSeat ticketItemSeat = this.findSameTicketItemSeat(ticketItem, map2);
        List list = POSUtil.copyList(ticketItem.getTicketItemModifiers());
        List list2 = POSUtil.copyList(ticketItem.getComboItems());
        ticketItem.setSizeModifier(null);
        ticketItem.setSeat(null);
        POSUtil.clear(ticketItem.getTicketItemModifiers());
        POSUtil.clear(ticketItem.getComboItems());
        TicketItem ticketItem2 = (TicketItem)map.get(ticketItem.getId());
        if (ticketItem2 == null) {
            ticketItemDAO.save(ticketItem, session);
        } else {
            ticketItem.setVersion(ticketItem2.getVersion());
        }
        if (!list.isEmpty()) {
            for (PropertyContainer propertyContainer : list) {
                ((BaseTicketItemModifier)((Object)propertyContainer)).setTicketItem(ticketItem);
                this.saveTicketItemModifier(session, (TicketItemModifier)propertyContainer, map);
            }
            ticketItem.getTicketItemModifiers().addAll(list);
        }
        this.saveOrUpdateSizeModifier(session, ticketItem, ticketItemModifier, map);
        this.saveOrSetVersionTicketItemSeat(session, ticketItem, ticketItemSeat, map);
        if (!list2.isEmpty()) {
            for (PropertyContainer propertyContainer : list2) {
                ((BaseTicketItem)((Object)propertyContainer)).setTicket(null);
                ((TicketItem)propertyContainer).setParentTicketItem(ticketItem);
                this.saveOrUpdateTicketItem(session, ticket, (TicketItem)propertyContainer, map, map2);
            }
            ticketItem.getComboItems().addAll(list2);
        }
    }

    private TicketItemSeat findSameTicketItemSeat(TicketItem ticketItem, Map<String, TicketItemSeat> map) {
        TicketItemSeat ticketItemSeat = ticketItem.getSeat();
        if (ticketItemSeat != null) {
            TicketItemSeat ticketItemSeat2 = map.get(ticketItemSeat.getId());
            if (ticketItemSeat2 != null) {
                ticketItemSeat = ticketItemSeat2;
            } else {
                map.put(ticketItemSeat.getId(), ticketItemSeat);
            }
        }
        return ticketItemSeat;
    }

    private void saveOrSetVersionTicketItemSeat(Session session, TicketItem ticketItem, TicketItemSeat ticketItemSeat, Map<String, Object> map) {
        if (ticketItemSeat == null) {
            return;
        }
        TicketItemSeat ticketItemSeat2 = (TicketItemSeat)map.get(ticketItemSeat.getId());
        if (ticketItemSeat2 == null) {
            TicketItemSeatDAO.getInstance().save(ticketItemSeat, session);
        } else {
            ticketItemSeat.setVersion(ticketItemSeat2.getVersion());
        }
        ticketItem.setSeat(ticketItemSeat);
    }

    private void saveOrUpdateSizeModifier(Session session, TicketItem ticketItem, TicketItemModifier ticketItemModifier, Map<String, Object> map) {
        if (ticketItemModifier != null) {
            TicketItemModifier ticketItemModifier2 = (TicketItemModifier)map.get(ticketItemModifier.getId());
            if (ticketItemModifier2 == null) {
                TicketItemModifierDAO.getInstance().save(ticketItemModifier, session);
            } else {
                ticketItemModifier.setVersion(ticketItemModifier2.getVersion());
            }
            ticketItemModifier.setTicketItem(ticketItem);
            ticketItem.setSizeModifier(ticketItemModifier);
        }
    }

    private void saveTicketItemModifier(Session session, TicketItemModifier ticketItemModifier, Map<String, Object> map) {
        TicketItemModifier ticketItemModifier2 = (TicketItemModifier)map.get(ticketItemModifier.getId());
        if (ticketItemModifier2 == null) {
            TicketItemModifierDAO.getInstance().save(ticketItemModifier, session);
        } else {
            ticketItemModifier.setVersion(ticketItemModifier2.getVersion());
        }
    }

    private void saveOrUpdateGratuity(Session session, Ticket ticket, Gratuity gratuity, Map<String, Object> map) {
        if (gratuity == null || StringUtils.isEmpty((String)gratuity.getId())) {
            return;
        }
        gratuity.setTicketId(ticket.getId());
        gratuity.setUpdateLastUpdateTime(false);
        gratuity.setUpdateSyncTime(false);
        Gratuity gratuity2 = (Gratuity)map.get(gratuity.getClass() + gratuity.getId());
        if (gratuity2 == null) {
            GratuityDAO.getInstance().save(gratuity, session);
        } else {
            gratuity.setVersion(gratuity2.getVersion());
        }
    }

    static class ExistingItemMapBuilder {
        ExistingItemMapBuilder() {
        }

        private static void buildExistingItemMap(Session session, Map<String, Object> map, Ticket ticket, Ticket ticket2) {
            List<TicketItem> list = ticket2.getTicketItems();
            if (list != null) {
                for (TicketItem object2 : list) {
                    ExistingItemMapBuilder.buildExistingItemMap(map, object2);
                }
            }
            Set<PosTransaction> set = ticket2.getTransactions();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PosTransaction posTransaction = (PosTransaction)iterator.next();
                map.put(posTransaction.getId(), posTransaction);
            }
            Gratuity gratuity = ticket2.getGratuity();
            if (gratuity != null) {
                map.put(gratuity.getClass() + gratuity.getId(), gratuity);
            } else {
                Gratuity gratuity2;
                Gratuity gratuity3 = ticket.getGratuity();
                if (gratuity3 != null && (gratuity2 = GratuityDAO.getInstance().get(gratuity3.getId(), session)) != null) {
                    map.put(gratuity2.getClass() + gratuity2.getId(), gratuity2);
                }
            }
            ExistingItemMapBuilder.verifyAllItemsPopulated(session, map, ticket);
            ExistingItemMapBuilder.verifyAllTransactionsPopulated(session, ticket, map);
        }

        private static void verifyAllItemsPopulated(Session session, Map<String, Object> map, Ticket ticket) {
            List<TicketItem> list = ticket.getTicketItems();
            if (list != null) {
                for (TicketItem ticketItem : list) {
                    ExistingItemMapBuilder.verifyItemsPopulated(session, map, ticketItem);
                }
            }
        }

        private static void verifyAllTransactionsPopulated(Session session, Ticket ticket, Map<String, Object> map) {
            Set<PosTransaction> set = ticket.getTransactions();
            if (set != null) {
                for (PosTransaction posTransaction : set) {
                    PosTransaction posTransaction2 = (PosTransaction)map.get(posTransaction.getId());
                    if (posTransaction2 != null || (posTransaction2 = PosTransactionDAO.getInstance().get(posTransaction.getId(), session)) == null) continue;
                    map.put(posTransaction.getId(), posTransaction2);
                }
            }
        }

        private static void verifyItemsPopulated(Session session, Map<String, Object> map, TicketItem ticketItem) {
            PropertyContainer propertyContainer;
            Object object;
            Object object2;
            Object object3;
            TicketItemModifier ticketItemModifier;
            TicketItem ticketItem2 = (TicketItem)map.get(ticketItem.getId());
            if (ticketItem2 == null && (ticketItem2 = TicketItemDAO.getInstance().get(ticketItem.getId(), session)) != null) {
                map.put(ticketItem.getId(), ticketItem2);
            }
            if ((ticketItemModifier = ticketItem.getSizeModifier()) != null && (object3 = (TicketItemModifier)map.get(ticketItemModifier.getId())) == null && (object3 = TicketItemModifierDAO.getInstance().get(ticketItemModifier.getId(), session)) != null) {
                map.put(ticketItemModifier.getId(), object3);
            }
            if ((object3 = ticketItem.getTicketItemModifiers()) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (TicketItemModifier)object2.next();
                    propertyContainer = (TicketItemModifier)map.get(((BaseTicketItemModifier)object).getId());
                    if (propertyContainer != null || (propertyContainer = TicketItemModifierDAO.getInstance().get(((BaseTicketItemModifier)object).getId(), session)) == null) continue;
                    map.put(((BaseTicketItemModifier)object).getId(), propertyContainer);
                }
            }
            if ((object2 = ticketItem.getComboItems()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    propertyContainer = (TicketItem)object.next();
                    ExistingItemMapBuilder.verifyItemsPopulated(session, map, propertyContainer);
                }
            }
        }

        private static void buildExistingItemMap(Map<String, Object> map, TicketItem ticketItem) {
            Object object;
            Object object2;
            List<TicketItemModifier> list;
            TicketItemSeat ticketItemSeat;
            map.put(ticketItem.getId(), ticketItem);
            TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
            if (ticketItemModifier != null) {
                map.put(ticketItemModifier.getId(), ticketItemModifier);
            }
            if ((ticketItemSeat = ticketItem.getSeat()) != null) {
                map.put(ticketItemSeat.getId(), ticketItemSeat);
            }
            if ((list = ticketItem.getTicketItemModifiers()) != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (TicketItemModifier)object2.next();
                    map.put(((BaseTicketItemModifier)object).getId(), object);
                }
            }
            if ((object2 = ticketItem.getComboItems()) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    TicketItem ticketItem2 = (TicketItem)object.next();
                    ExistingItemMapBuilder.buildExistingItemMap(map, ticketItem2);
                }
            }
        }
    }
}

