/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryUnitFormTree
extends BeanEditor<InventoryUnit> {
    private static final String a = " ";
    private FixedLengthTextField b = new FixedLengthTextField(30);
    private JTextField c = new JTextField();
    private FixedLengthTextField d = new FixedLengthTextField(3);
    private DoubleTextField e = new DoubleTextField(10);
    private JComboBox<InventoryUnitConversionRule> f = new JComboBox();
    private JComboBox<InventoryUnitGroup> g = new JComboBox();
    private List<InventoryUnitGroup> h;
    private JButton i;
    private JCheckBox j;
    private JCheckBox k;
    private JLabel l;
    private JCheckBox m;

    public InventoryUnitFormTree() {
        this(new InventoryUnit());
    }

    public InventoryUnitFormTree(InventoryUnit inventoryUnit) {
        this.a();
        this.h = InventoryUnitGroupDAO.getInstance().findAll();
        if (this.h != null) {
            this.g.setModel(new ComboBoxModel(this.h));
        }
        this.setBean(inventoryUnit);
        this.g.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n != 1) {
                    return;
                }
                InventoryUnitFormTree.this.c();
            }
        });
        if (inventoryUnit.getId() != null) {
            this.d.setEnabled(false);
        }
        String string = inventoryUnit.getProperty("conversion.rule", InventoryUnitConversionRule.DIVISION.getName());
        this.f.setModel(new ComboBoxModel(Arrays.asList(InventoryUnitConversionRule.values())));
        InventoryUnitConversionRule inventoryUnitConversionRule = InventoryUnitConversionRule.fromName((String)string);
        this.f.setSelectedItem(inventoryUnitConversionRule);
        if (inventoryUnitConversionRule == InventoryUnitConversionRule.DIVISION) {
            this.e.setText(NumberUtil.format6DigitNumber(inventoryUnit.getConversionRate()));
        } else if (inventoryUnitConversionRule == InventoryUnitConversionRule.MULTIPLICATION) {
            this.e.setText(NumberUtil.format6DigitNumber(1.0 / inventoryUnit.getConversionRate()));
        }
        if (inventoryUnit.getId() != null) {
            this.c();
        }
    }

    private void a() {
        this.c.setDocument(new FixedLengthDocument(30));
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(Messages.getString("IVUFT.1")));
        this.add((Component)this.d, "grow, wrap");
        this.add(new JLabel(Messages.getString("IVUFT.3")));
        this.add((Component)this.b, "grow, wrap");
        this.add(new JLabel(Messages.getString("InventoryUnitFormTree.4")));
        this.add((Component)this.c, "grow, wrap");
        this.add(new JLabel(Messages.getString("IVUFT.5")));
        this.add((Component)this.e, "split 2");
        this.add((Component)new JLabel(Messages.getString("InventoryUnitFormTree.0")), "newline");
        this.add(this.f, "gapright 20, split 2");
        this.l = new JLabel();
        this.add((Component)this.l, "wrap");
        this.add(new JLabel(Messages.getString("IVUFT.7")));
        this.add(this.g, "split 2");
        this.i = new JButton(Messages.getString("IVUFT.9"));
        this.add((Component)this.i, "wrap");
        this.j = new JCheckBox(Messages.getString("IVUFT.16"));
        this.j.addItemListener(itemEvent -> this.b());
        this.add((Component)this.j, "skip 1,wrap");
        this.k = new JCheckBox(Messages.getString("HideFromSalesScreen"));
        this.add((Component)this.k, "skip 1,wrap");
        this.m = new JCheckBox(Messages.getString("StockCountable"));
        this.m.setSelected(true);
        this.add((Component)this.m, "skip 1,wrap");
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("IVUFT.10"));
                    if (string == null) {
                        return;
                    }
                    if (string.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("IVUFT.13"));
                        return;
                    }
                    InventoryUnitGroup inventoryUnitGroup = new InventoryUnitGroup();
                    GenericDAO.getInstance().checkIdOrNameExists(inventoryUnitGroup.getId(), string, InventoryUnitGroup.class);
                    inventoryUnitGroup.setName(string);
                    InventoryUnitGroupDAO.getInstance().saveOrUpdate(inventoryUnitGroup);
                    InventoryUnitFormTree.this.h.add(inventoryUnitGroup);
                    InventoryUnitFormTree.this.g.setModel(new ComboBoxModel(InventoryUnitFormTree.this.h));
                    InventoryUnitFormTree.this.g.setSelectedItem(inventoryUnitGroup);
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
                }
            }
        });
        this.e.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                InventoryUnitFormTree.this.c();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n != 1) {
                    return;
                }
                InventoryUnitFormTree.this.c();
            }
        });
    }

    private void b() {
        boolean bl = this.j.isSelected();
        if (bl) {
            this.e.setText("1");
            this.l.setText("");
        } else {
            this.c();
        }
        this.e.setEnabled(!bl);
        this.f.setEnabled(!bl);
        if (bl) {
            this.m.setSelected(true);
        }
        this.m.setEnabled(!bl);
    }

    private void c() {
        try {
            Object object;
            if (StringUtils.isEmpty((String)this.b.getText())) {
                POSMessageDialog.showError(Messages.getString("InventoryUnitFormTree.1"));
                this.e.setText(null);
                this.b.requestFocus();
                return;
            }
            String string = this.e.getText();
            if (StringUtils.isEmpty((String)string)) {
                this.l.setText(null);
                return;
            }
            Double d = NumberUtil.parseDouble(string);
            if (d == 0.0) {
                this.l.setText(null);
                return;
            }
            InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.g.getSelectedItem();
            InventoryUnitConversionRule inventoryUnitConversionRule = (InventoryUnitConversionRule)this.f.getSelectedItem();
            BaseInventoryUnit baseInventoryUnit = null;
            List<InventoryUnit> list = inventoryUnitGroup.getUnits();
            if (list != null) {
                for (InventoryUnit comparable2 : list) {
                    if (!comparable2.isBaseUnit().booleanValue()) continue;
                    baseInventoryUnit = comparable2;
                    break;
                }
            }
            if (baseInventoryUnit == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("(");
                ((StringBuilder)object).append(Messages.getString("InventoryUnitFormTree.2"));
                ((StringBuilder)object).append(a);
                ((StringBuilder)object).append(inventoryUnitGroup.getName());
                ((StringBuilder)object).append(".");
                ((StringBuilder)object).append(")");
                this.l.setText(((StringBuilder)object).toString());
                return;
            }
            if (baseInventoryUnit.getCode().equals(this.d.getText())) {
                this.l.setText(null);
                return;
            }
            object = 0.0;
            if (inventoryUnitConversionRule == InventoryUnitConversionRule.DIVISION) {
                object = ((InventoryUnit)baseInventoryUnit).getConversionRate() / d;
            } else if (inventoryUnitConversionRule == InventoryUnitConversionRule.MULTIPLICATION) {
                object = ((InventoryUnit)baseInventoryUnit).getConversionRate() * d;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append("1 ");
            stringBuilder.append(this.b.getText());
            stringBuilder.append(" = ");
            stringBuilder.append(NumberUtil.format6DigitNumber((Double)object));
            stringBuilder.append(a);
            stringBuilder.append(baseInventoryUnit.getName());
            stringBuilder.append(")");
            this.l.setText(stringBuilder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
            boolean bl = inventoryUnit.isBaseUnit();
            InventoryUnitGroup inventoryUnitGroup = InventoryUnitGroupDAO.getInstance().get(inventoryUnit.getUnitGroupId());
            if (bl) {
                if (inventoryUnitGroup.getUnits() != null) {
                    for (InventoryUnit serializable2 : inventoryUnitGroup.getUnits()) {
                        serializable2.setBaseUnit(false);
                    }
                }
                inventoryUnit.setBaseUnit(true);
            }
            InventoryUnitConversionRule inventoryUnitConversionRule = (InventoryUnitConversionRule)this.f.getSelectedItem();
            inventoryUnit.addProperty("conversion.rule", inventoryUnitConversionRule.getName());
            if (inventoryUnitConversionRule == InventoryUnitConversionRule.MULTIPLICATION) {
                inventoryUnit.setConversionRate(1.0 / inventoryUnit.getConversionRate());
            } else {
                inventoryUnit.setConversionRate(inventoryUnit.getConversionRate());
            }
            ArrayList<InventoryUnit> arrayList = new ArrayList<InventoryUnit>();
            List<InventoryUnit> list = inventoryUnitGroup.getUnits();
            if (list != null) {
                if (list.contains(inventoryUnit)) {
                    for (InventoryUnit inventoryUnit2 : list) {
                        if (inventoryUnit2.getId().equals(inventoryUnit.getId())) {
                            inventoryUnit2 = inventoryUnit;
                        }
                        arrayList.add(inventoryUnit2);
                    }
                    inventoryUnitGroup.setUnits(arrayList);
                } else {
                    inventoryUnitGroup.addTounits(inventoryUnit);
                }
            } else {
                inventoryUnitGroup.addTounits(inventoryUnit);
            }
            TerminalDAO.getInstance().performBatchSave(inventoryUnitGroup.getUnits().toArray());
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryUnit());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.b.setEnabled(bl);
        this.e.setEnabled(bl);
        this.g.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
    }

    @Override
    public void clearFields() {
        this.b.setText("");
        this.c.setText("");
        this.d.setText("");
        this.e.setText("");
    }

    @Override
    protected void updateView() {
        ComboBoxModel comboBoxModel;
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        if (inventoryUnit == null) {
            return;
        }
        this.b.setText(inventoryUnit.getName());
        this.c.setText(inventoryUnit.getDisplayName());
        String string = inventoryUnit.getCode();
        if (StringUtils.isNotBlank((String)string) && string.length() > 3) {
            this.d.setLength(string.length());
        }
        this.d.setText(string);
        this.e.setText(NumberUtil.format6DigitNumber(inventoryUnit.getConversionRate()));
        String string2 = inventoryUnit.getUnitGroupId();
        if (StringUtils.isNotEmpty((String)string2) && (comboBoxModel = (ComboBoxModel)this.g.getModel()).getSize() > 0) {
            for (InventoryUnitGroup inventoryUnitGroup : comboBoxModel.getDataList()) {
                if (!inventoryUnitGroup.getId().equals(string2)) continue;
                this.g.setSelectedItem(inventoryUnitGroup);
            }
        }
        this.j.setSelected(inventoryUnit.isBaseUnit());
        this.k.setSelected(inventoryUnit.hideFromSalesScreen());
        this.m.setSelected(inventoryUnit.isStockCountable());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        String string = this.d.getText().trim();
        String string2 = this.b.getText().trim();
        String string3 = this.c.getText();
        double d = this.e.getDouble();
        String string4 = this.e.getText();
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.g.getSelectedItem();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("IVUFT.23"));
            return false;
        }
        inventoryUnit.setCode(string);
        if (d == 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("IVUF.23"));
            return false;
        }
        if (Double.isNaN(d) || d < 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("IVUFT.25"));
            return false;
        }
        String[] stringArray = string4.split("\\" + String.valueOf(NumberUtil.getDecimalSeparator()));
        InventoryUnitConversionRule inventoryUnitConversionRule = (InventoryUnitConversionRule)this.f.getSelectedItem();
        if (inventoryUnitConversionRule == InventoryUnitConversionRule.DIVISION && Double.valueOf(stringArray[0]) > 1999999.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitFormTree.12"));
            return false;
        }
        if (stringArray.length >= 2 && stringArray[1].length() > 6) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryUnitFormTree.13"));
            return false;
        }
        if (inventoryUnitGroup == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("IVUFT.26"));
            return false;
        }
        if (this.j.isSelected() && d > 1.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("InventoryUnitFormTree.3"));
            return false;
        }
        inventoryUnit.setName(string2);
        inventoryUnit.setDisplayName(string3);
        if (StringUtils.isEmpty((String)inventoryUnit.getCode())) {
            inventoryUnit.setCode(string.replaceAll("[^\\p{Alnum}]", "_"));
        }
        GenericDAO.getInstance().checkIdOrNameExists(inventoryUnit.getId(), string2, InventoryUnit.class);
        if (this.j.isSelected()) {
            inventoryUnit.setStockCountable(true);
        } else {
            inventoryUnit.setStockCountable(this.m.isSelected());
        }
        inventoryUnit.setConversionRate(d);
        inventoryUnit.setUnitGroupId(inventoryUnitGroup.getId());
        inventoryUnit.setBaseUnit(this.j.isSelected());
        inventoryUnit.setHideFromSalesScreen(this.k.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
            if (inventoryUnit == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("IVUFT.29"), Messages.getString("IVUFT.30"));
            if (n != 0) {
                return false;
            }
            InventoryUnitDAO.getInstance().delete(inventoryUnit);
            this.clearFields();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("IVUFT.31");
    }
}

