/*
 * Decompiled with CFR 0.152.
 */
package io.github.escposjava;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import io.github.escposjava.print.Commands;
import io.github.escposjava.print.Printer;
import io.github.escposjava.print.exceptions.BarcodeSizeError;
import io.github.escposjava.print.exceptions.QRCodeException;
import io.github.escposjava.print.image.Image;
import io.github.escposjava.print.qrcode.QRCodeGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;

public class PrinterService {
    private static final String a = System.getProperty("line.separator");
    private final Printer b;
    private String c;

    public PrinterService(Printer printer) {
        this.b = printer;
        this.setCharsetName(CharacterCodeTable.CP437_USA_Standard_Europe.charsetName);
    }

    public void print(String string) {
        if (string == null) {
            return;
        }
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\u20ac') {
                    this.write(new byte[]{27, 116, 19});
                    this.write("\u20ac".getBytes("Cp858"));
                    continue;
                }
                if (c > '\u00f0') continue;
                this.write(String.valueOf(c).getBytes(this.c));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void a(byte[] byArray, int n) {
        if (byArray[n] == 63) {
            this.write(new byte[]{27, 116, 19});
            byArray[n] = -43;
        }
    }

    public void printLeft(String string) {
        this.write(Commands.TXT_ALIGN_LT);
        this.print(string);
    }

    public void printCentered(String string) {
        this.write(Commands.TXT_ALIGN_CT);
        this.print(string);
    }

    public void printRight(String string) {
        this.write(Commands.TXT_ALIGN_RT);
        this.print(string);
    }

    public void print(byte[] byArray, String string) {
        this.write(byArray);
        this.print(string);
    }

    public void printLn(byte[] byArray, String string) {
        this.write(byArray);
        this.printLn(string);
    }

    public void printLn(String string) {
        this.print(string + a);
    }

    public void lineBreak() {
        this.lineBreak(1);
    }

    public void lineBreak(int n) {
        for (int i = 0; i < n; ++i) {
            this.write(Commands.CTL_LF);
        }
    }

    public void printQRCode(String string) throws QRCodeException {
        this.printQRCode(string, 150);
    }

    public void printQRCode(String string, int n) throws QRCodeException {
        QRCodeGenerator qRCodeGenerator = new QRCodeGenerator();
        this.printImage(qRCodeGenerator.generate(string, n));
    }

    public void setTextSizeNormal() {
        this.a(1, 1);
    }

    public void setTextSize2H() {
        this.a(1, 2);
    }

    public void setTextSize2W() {
        this.a(2, 1);
    }

    public void setText4Square() {
        this.a(2, 2);
    }

    private void a(int n, int n2) {
        if (n2 == 2 && n == 2) {
            this.write(Commands.TXT_NORMAL);
            this.write(Commands.TXT_4SQUARE);
        } else if (n2 == 2) {
            this.write(Commands.TXT_NORMAL);
            this.write(Commands.TXT_2HEIGHT);
        } else if (n == 2) {
            this.write(Commands.TXT_NORMAL);
            this.write(Commands.TXT_2WIDTH);
        } else {
            this.write(Commands.TXT_NORMAL);
        }
    }

    public void setTextTypeBold() {
        this.a("B");
    }

    public void setTextTypeUnderline() {
        this.a("U");
    }

    public void setTextType2Underline() {
        this.a("U2");
    }

    public void setTextTypeBoldUnderline() {
        this.a("BU");
    }

    public void setTextTypeBold2Underline() {
        this.a("BU2");
    }

    public void setTextTypeNormal() {
        this.a("NORMAL");
    }

    private void a(String string) {
        if (string.equalsIgnoreCase("B")) {
            this.write(Commands.TXT_BOLD_ON);
            this.write(Commands.TXT_UNDERL_OFF);
        } else if (string.equalsIgnoreCase("U")) {
            this.write(Commands.TXT_BOLD_OFF);
            this.write(Commands.TXT_UNDERL_ON);
        } else if (string.equalsIgnoreCase("U2")) {
            this.write(Commands.TXT_BOLD_OFF);
            this.write(Commands.TXT_UNDERL2_ON);
        } else if (string.equalsIgnoreCase("BU")) {
            this.write(Commands.TXT_BOLD_ON);
            this.write(Commands.TXT_UNDERL_ON);
        } else if (string.equalsIgnoreCase("BU2")) {
            this.write(Commands.TXT_BOLD_ON);
            this.write(Commands.TXT_UNDERL2_ON);
        } else if (string.equalsIgnoreCase("NORMAL")) {
            this.write(Commands.TXT_BOLD_OFF);
            this.write(Commands.TXT_UNDERL_OFF);
        }
    }

    public void cutPart() {
        this.b("PART");
    }

    public void cutFull() {
        this.b("FULL");
    }

    private void b(String string) {
        for (int i = 0; i < 5; ++i) {
            this.write(Commands.CTL_LF);
        }
        if (string.toUpperCase().equals("PART")) {
            this.write(Commands.PAPER_PART_CUT);
        } else {
            this.write(Commands.PAPER_FULL_CUT);
        }
    }

    public void printBarcode(String string, String string2, int n, int n2, String string3, String string4) throws BarcodeSizeError {
        this.write(Commands.CTL_LF);
        switch (string2.toUpperCase()) {
            case "UPC-A": {
                this.write(Commands.BARCODE_UPC_A);
                break;
            }
            case "UPC-E": {
                this.write(Commands.BARCODE_UPC_E);
                break;
            }
            default: {
                this.write(Commands.BARCODE_EAN13);
                break;
            }
            case "EAN8": {
                this.write(Commands.BARCODE_EAN8);
                break;
            }
            case "CODE39": {
                this.write(Commands.BARCODE_CODE39);
                break;
            }
            case "ITF": {
                this.write(Commands.BARCODE_ITF);
                break;
            }
            case "NW7": {
                this.write(Commands.BARCODE_NW7);
                break;
            }
            case "CODE128": {
                this.write(new byte[]{29, 104, 64});
                this.write(new byte[]{29, 119, 2});
                this.d(string4);
                this.setTextAlignCenter();
                this.write(new byte[]{29, 107, 73, 15});
                this.write(new byte[]{123, 66});
                this.write(string.getBytes());
                this.write(Commands.CTL_LF);
                return;
            }
        }
        if (string.equals("")) {
            throw new BarcodeSizeError("Incorrect Value");
        }
        this.write(string.getBytes());
        this.write(Commands.CTL_LF);
    }

    public void printBarcode(String string, int n, int n2, int n3, int n4, int n5) throws IOException {
        this.a(29);
        this.c("H");
        this.a(n5);
        this.a(29);
        this.c("f");
        this.a(n4);
        this.a(29);
        this.c("h");
        this.a(n2);
        this.a(29);
        this.c("w");
        this.a(n3);
        this.a(29);
        this.c("k");
        this.a(n);
        this.a(string.length());
        this.c(string);
        this.a(0);
    }

    private void c(String string) {
        this.write(string.getBytes());
    }

    private void a(int n) {
        this.write(new byte[]{(byte)n});
    }

    public void setTextFontA() {
        this.d("A");
    }

    public void setTextFontB() {
        this.d("B");
    }

    private void d(String string) {
        if (string.equalsIgnoreCase("B")) {
            this.write(Commands.TXT_FONT_B);
        } else {
            this.write(Commands.TXT_FONT_A);
        }
    }

    public void setTextAlignCenter() {
        this.e("CENTER");
    }

    public void setTextAlignRight() {
        this.e("RIGHT");
    }

    public void setTextAlignLeft() {
        this.e("LEFT");
    }

    private void e(String string) {
        if (string.equalsIgnoreCase("CENTER")) {
            this.write(Commands.TXT_ALIGN_CT);
        } else if (string.equalsIgnoreCase("RIGHT")) {
            this.write(Commands.TXT_ALIGN_RT);
        } else {
            this.write(Commands.TXT_ALIGN_LT);
        }
    }

    public void setTextDensity(int n) {
        switch (n) {
            case 0: {
                this.write(Commands.PD_N50);
                break;
            }
            case 1: {
                this.write(Commands.PD_N37);
                break;
            }
            case 2: {
                this.write(Commands.PD_N25);
                break;
            }
            case 3: {
                this.write(Commands.PD_N12);
                break;
            }
            case 4: {
                this.write(Commands.PD_0);
                break;
            }
            case 5: {
                this.write(Commands.PD_P12);
                break;
            }
            case 6: {
                this.write(Commands.PD_P25);
                break;
            }
            case 7: {
                this.write(Commands.PD_P37);
                break;
            }
            case 8: {
                this.write(Commands.PD_P50);
            }
        }
    }

    public void setTextNormal() {
        this.setTextProperties("LEFT", "A", "NORMAL", 1, 1, 9);
    }

    public void setTextProperties(String string, String string2, String string3, int n, int n2, int n3) {
        this.e(string);
        this.d(string2);
        this.a(string3);
        this.a(n, n2);
        this.setTextDensity(n3);
    }

    public void printImage(String string) throws IOException {
        File file = new File(string);
        this.printImage(ImageIO.read(file));
    }

    public void printImage(BufferedImage bufferedImage) {
        Image image = new Image();
        int[][] nArray = image.getPixelsSlow(bufferedImage);
        for (int i = 0; i < nArray.length; i += 24) {
            this.write(Commands.TXT_ALIGN_CT);
            this.write(Commands.LINE_SPACE_24);
            this.write(Commands.SELECT_BIT_IMAGE_MODE);
            this.write(new byte[]{(byte)(0xFF & nArray[i].length), (byte)((0xFF00 & nArray[i].length) >> 8)});
            for (int j = 0; j < nArray[i].length; ++j) {
                this.write(image.recollectSlice(i, j, nArray));
            }
            this.write(Commands.CTL_LF);
        }
        this.write(Commands.LINE_SPACE_60);
    }

    public void setCharCode(String string) {
        switch (string) {
            case "USA": {
                this.write(Commands.CHARCODE_PC437);
                break;
            }
            case "JIS": {
                this.write(Commands.CHARCODE_JIS);
                break;
            }
            case "MULTILINGUAL": {
                this.write(Commands.CHARCODE_PC850);
                break;
            }
            case "PORTUGUESE": {
                this.write(Commands.CHARCODE_PC860);
                break;
            }
            case "CA_FRENCH": {
                this.write(Commands.CHARCODE_PC863);
                break;
            }
            default: {
                this.write(Commands.CHARCODE_PC865);
                break;
            }
            case "WEST_EUROPE": {
                this.write(Commands.CHARCODE_WEU);
                break;
            }
            case "GREEK": {
                this.write(Commands.CHARCODE_GREEK);
                break;
            }
            case "HEBREW": {
                this.write(Commands.CHARCODE_HEBREW);
                break;
            }
            case "WPC1252": {
                this.write(Commands.CHARCODE_PC1252);
                break;
            }
            case "CIRILLIC2": {
                this.write(Commands.CHARCODE_PC866);
                break;
            }
            case "LATIN2": {
                this.write(Commands.CHARCODE_PC852);
                break;
            }
            case "EURO": {
                this.write(Commands.CHARCODE_PC858);
                break;
            }
            case "THAI42": {
                this.write(Commands.CHARCODE_THAI42);
                break;
            }
            case "THAI11": {
                this.write(Commands.CHARCODE_THAI11);
                break;
            }
            case "THAI13": {
                this.write(Commands.CHARCODE_THAI13);
                break;
            }
            case "THAI14": {
                this.write(Commands.CHARCODE_THAI14);
                break;
            }
            case "THAI16": {
                this.write(Commands.CHARCODE_THAI16);
                break;
            }
            case "THAI17": {
                this.write(Commands.CHARCODE_THAI17);
                break;
            }
            case "THAI18": {
                this.write(Commands.CHARCODE_THAI18);
            }
        }
    }

    public void init() {
        if (!this.b.isConnected()) {
            throw new PosException(Messages.getString("COULD_NOT_CONNECT_TO_PRINTER"));
        }
        this.write(Commands.HW_INIT);
    }

    public void openCashDrawerPin2() {
        this.write(Commands.CD_KICK_2);
    }

    public void openCashDrawerPin5() {
        this.write(Commands.CD_KICK_5);
    }

    public void open() {
        this.b.open();
    }

    public void close() throws Exception {
        this.b.close();
    }

    public void beep() {
        this.write(Commands.BEEPER);
    }

    public void write(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.b.write(byArray);
    }

    public void setTextColor(byte[] byArray) {
        this.write(byArray);
    }

    public final PrinterService setCharsetName(String string) {
        this.c = string;
        return this;
    }

    public static enum CharacterCodeTable {
        CP437_USA_Standard_Europe(0, "cp437"),
        Katakana(1),
        CP850_Multilingual(2, "cp850"),
        CP860_Portuguese(3, "cp860"),
        CP863_Canadian_French(4, "cp863"),
        CP865_Nordic(5, "cp865"),
        CP851_Greek(11),
        CP853_Turkish(12),
        CP857_Turkish(13, "cp857"),
        CP737_Greek(14, "cp737"),
        ISO8859_7_Greek(15, "iso8859_7"),
        WPC1252(16, "cp1252"),
        CP866_Cyrillic_2(17, "cp866"),
        CP852_Latin2(18, "cp852"),
        CP858_Euro(19, "cp858"),
        KU42_Thai(20),
        TIS11_Thai(21),
        TIS18_Thai(26),
        TCVN_3_1_Vietnamese(30),
        TCVN_3_2_Vietnamese(31),
        PC720_Arabic(32),
        WPC775_BalticRim(33),
        CP855_Cyrillic(34, "cp855"),
        CP861_Icelandic(35, "cp861"),
        CP862_Hebrew(36, "cp862"),
        CP864_Arabic(37, "cp864"),
        CP869_Greek(38, "cp869"),
        ISO8859_2_Latin2(39, "iso8859_2"),
        ISO8859_15_Latin9(40, "iso8859_15"),
        CP1098_Farsi(41, "cp1098"),
        CP1118_Lithuanian(42),
        CP1119_Lithuanian(43),
        CP1125_Ukrainian(44),
        WCP1250_Latin2(45, "cp1250"),
        WCP1251_Cyrillic(46, "cp1251"),
        WCP1253_Greek(47, "cp1253"),
        WCP1254_Turkish(48, "cp1254"),
        WCP1255_Hebrew(49, "cp1255"),
        WCP1256_Arabic(50, "cp1256"),
        WCP1257_BalticRim(51, "cp1257"),
        WCP1258_Vietnamese(52, "cp1258"),
        KZ_1048_Kazakhstan(53),
        User_defined_page(255);

        public int value;
        public String charsetName;

        private CharacterCodeTable(int n2) {
            this.value = n2;
            this.charsetName = "cp437";
        }

        private CharacterCodeTable(int n2, String string2) {
            this.value = n2;
            this.charsetName = string2;
        }
    }
}

