/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.dom.Element;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractComponentDataGenerator<T>
implements DataGenerator<T> {
    private final Map<String, Component> renderedComponents = new HashMap<String, Component>();

    @Override
    public void refreshData(T item) {
        String itemKey = this.getItemKey(item);
        Component oldComponent = this.getRenderedComponent(itemKey);
        if (oldComponent != null) {
            int newId;
            Component recreatedComponent = this.createComponent(item);
            int oldId = oldComponent.getElement().getNode().getId();
            if (oldId != (newId = recreatedComponent.getElement().getNode().getId()) && !oldComponent.equals(recreatedComponent)) {
                this.getContainer().removeChild(new Element[]{oldComponent.getElement()});
                this.registerRenderedComponent(itemKey, recreatedComponent);
            }
        }
    }

    @Override
    public void destroyData(T item) {
        String itemKey = this.getItemKey(item);
        Component renderedComponent = this.renderedComponents.remove(itemKey);
        if (renderedComponent != null) {
            renderedComponent.getElement().removeFromParent();
        }
    }

    @Override
    public void destroyAllData() {
        this.renderedComponents.values().forEach(component -> component.getElement().removeFromParent());
        this.renderedComponents.clear();
    }

    protected abstract Element getContainer();

    protected abstract Component createComponent(T var1);

    protected abstract String getItemKey(T var1);

    protected void registerRenderedComponent(String itemKey, Component component) {
        Element element = component.getElement();
        this.getContainer().appendChild(new Element[]{element});
        this.renderedComponents.put(itemKey, component);
    }

    protected Component getRenderedComponent(String itemKey) {
        return this.renderedComponents.get(itemKey);
    }
}

