/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public class RendererUtil {
    private RendererUtil() {
    }

    public static <T> void registerEventHandlers(Renderer<T> renderer, Element contentTemplate, Element templateDataHost, ValueProvider<String, T> keyMapper) {
        Map eventHandlers = renderer.getEventHandlers();
        if (!eventHandlers.isEmpty()) {
            templateDataHost.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(templateDataHost.getNode(), (SerializableConsumer & Serializable)context -> RendererUtil.processTemplateRendererEventHandlers(context.getUI(), templateDataHost, eventHandlers, keyMapper)));
            contentTemplate.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(templateDataHost.getNode(), (SerializableConsumer & Serializable)context -> context.getUI().getPage().executeJavaScript("$0.__dataHost = $1;", new Serializable[]{contentTemplate, templateDataHost})));
        }
    }

    private static <T> void processTemplateRendererEventHandlers(UI ui, Element colElement, Map<String, SerializableConsumer<T>> eventConsumers, Function<String, T> keyMapper) {
        eventConsumers.forEach((handlerName, consumer) -> RendererUtil.setupTemplateRendererEventHandler(ui, colElement, handlerName, consumer, keyMapper));
    }

    private static <T> void setupTemplateRendererEventHandler(UI ui, Element eventOrigin, String handlerName, Consumer<T> consumer, Function<String, T> keyMapper) {
        ui.getPage().executeJavaScript(String.format("$0.%s = function(e) {Vaadin.Flow.sendEventMessage(%d, '%s', {key: e.model ? e.model.__data.item.key : e.target.__dataHost.__data.item.key})}", handlerName, eventOrigin.getNode().getId(), handlerName), new Serializable[]{eventOrigin});
        eventOrigin.addEventListener(handlerName, (DomEventListener & Serializable)event -> RendererUtil.processEventFromTemplateRenderer(event, handlerName, consumer, keyMapper));
    }

    private static <T> void processEventFromTemplateRenderer(DomEvent event, String handlerName, Consumer<T> consumer, Function<String, T> keyMapper) {
        if (event.getEventData() != null) {
            String itemKey = event.getEventData().getString("key");
            T item = keyMapper.apply(itemKey);
            if (item != null) {
                consumer.accept(item);
            } else {
                LoggerFactory.getLogger((String)RendererUtil.class.getName()).info("Received an event for the handler '{}' with item key '{}', but the item is not present in the KeyMapper. Ignoring event.", (Object)handlerName, (Object)itemKey);
            }
        } else {
            LoggerFactory.getLogger((String)RendererUtil.class.getName()).info("Received an event for the handler '{}' without any data. Ignoring event.", (Object)handlerName);
        }
    }
}

