/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.function.ValueProvider;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

public class LocalDateRenderer<SOURCE>
extends BasicRenderer<SOURCE, LocalDate> {
    private DateTimeFormatter formatter;
    private String nullRepresentation;

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider) {
        this(valueProvider, DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), "");
    }

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider, String formatPattern) {
        this(valueProvider, formatPattern, Locale.getDefault());
    }

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider, String formatPattern, Locale locale) {
        this(valueProvider, formatPattern, locale, "");
    }

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider, String formatPattern, Locale locale, String nullRepresentation) {
        super(valueProvider);
        if (formatPattern == null) {
            throw new IllegalArgumentException("format pattern may not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale may not be null");
        }
        this.formatter = DateTimeFormatter.ofPattern(formatPattern, locale);
        this.nullRepresentation = nullRepresentation;
    }

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider, DateTimeFormatter formatter) {
        this(valueProvider, formatter, "");
    }

    public LocalDateRenderer(ValueProvider<SOURCE, LocalDate> valueProvider, DateTimeFormatter formatter, String nullRepresentation) {
        super(valueProvider);
        if (formatter == null) {
            throw new IllegalArgumentException("formatter may not be null");
        }
        this.formatter = formatter;
    }

    @Override
    protected String getFormattedValue(LocalDate date) {
        try {
            return date == null ? this.nullRepresentation : this.formatter.format(date);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not format input date '" + date + "' using formatter '" + this.formatter + "'", e);
        }
    }
}

