/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.dom.Element;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class ElementUtil {
    private static Pattern tagNamePattern = Pattern.compile("^[a-zA-Z0-9-]+$");

    private ElementUtil() {
    }

    public static boolean isValidTagName(String tag) {
        return tag != null && tagNamePattern.matcher(tag).matches();
    }

    public static boolean isValidAttributeName(String attribute) {
        char[] illegalCharacters;
        if (attribute == null || attribute.isEmpty()) {
            return false;
        }
        assert (attribute.equals(attribute.toLowerCase(Locale.ENGLISH)));
        for (char c : illegalCharacters = new char[]{'\u0000', ' ', '\"', '\'', '>', '/', '='}) {
            if (attribute.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static void validateStylePropertyName(String name) {
        String reason = ElementUtil.getInvalidStylePropertyNameError(name);
        if (reason != null) {
            throw new IllegalArgumentException(reason);
        }
    }

    private static String getInvalidStylePropertyNameError(String name) {
        if (name == null || name.trim().isEmpty()) {
            return "A style property name cannot be null or empty";
        }
        if (name.startsWith(" ") || name.endsWith(" ")) {
            return String.format("Invalid style property name '%s': a style property name cannot start or end in whitespace", name);
        }
        if (name.contains(":")) {
            return String.format("Invalid style property name '%s': a style property name cannot contain colons", name);
        }
        return null;
    }

    public static boolean isValidStylePropertyName(String name) {
        return ElementUtil.getInvalidStylePropertyNameError(name) == null;
    }

    public static boolean isValidStylePropertyValue(String value) {
        return ElementUtil.getInvalidStylePropertyValueError(value) == null;
    }

    public static void validateStylePropertyValue(String value) {
        String reason = ElementUtil.getInvalidStylePropertyValueError(value);
        if (reason != null) {
            throw new IllegalArgumentException(reason);
        }
    }

    private static String getInvalidStylePropertyValueError(String value) {
        if (value.endsWith(";")) {
            return "A style value cannot end in semicolon";
        }
        return null;
    }

    public static void setComponent(Element element, Component component) {
        if (element == null) {
            throw new IllegalArgumentException("Element must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        Optional<Component> currentComponent = element.getComponent();
        if (currentComponent.isPresent()) {
            boolean isCompositeReplacingItsContent;
            boolean bl = isCompositeReplacingItsContent = component instanceof Composite && component.getChildren().findFirst().get() == currentComponent.get();
            if (!isCompositeReplacingItsContent) {
                throw new IllegalStateException("A component of type " + currentComponent.get().getClass().getName() + " is already attached to this element");
            }
        }
        element.getStateProvider().setComponent(element.getNode(), component);
    }

    public static Node toJsoup(Document document, Element element) {
        if (element.isTextNode()) {
            return new TextNode(element.getText(), document.baseUri());
        }
        org.jsoup.nodes.Element target = document.createElement(element.getTag());
        if (element.hasProperty("innerHTML")) {
            target.html((String)((Object)element.getPropertyRaw("innerHTML")));
        }
        element.getAttributeNames().forEach(name -> {
            String attributeValue = element.getAttribute((String)name);
            if ("".equals(attributeValue)) {
                target.attr(name, true);
            } else {
                target.attr(name, attributeValue);
            }
        });
        element.getChildren().forEach(child -> target.appendChild(ElementUtil.toJsoup(document, child)));
        return target;
    }

    public static boolean isCustomElement(Element element) {
        return !element.isTextNode() && element.getTag().contains("-");
    }

    public static boolean isScript(Element element) {
        return !element.isTextNode() && "script".equalsIgnoreCase(element.getTag());
    }
}

